<?php
// https://codex.wordpress.org/Plugin_API/Filter_Reference/cron_schedules
add_filter('cron_schedules', array('WPBooked_WC_WP_Crons', 'cron_schedules'));

class WPBooked_WC_WP_Crons {

	private function __construct() {

		if ( WPBooked_WC_Settings::get_option('enable_auto_cleanup') === 'enable' ) {
			$this->activate_scheduler();
		}
	}

	public static function setup(){
		return new self();
	}

	public static function cron_schedules( $schedules ) {
		$schedules['weekly'] = array(
			'interval' => 60 * 60 * 24 * 7,
			'display' => esc_html__('Weekly', 'wpbooked')
		);

		$schedules['twiceweekly'] = array(
			'interval' => 60 * 60 * 24 * 3.5,
			'display' => esc_html__('Twice Weekly', 'wpbooked')
		);

		$schedules['monthly'] = array(
			'interval' => 60 * 60 * 24 * 30.5,
			'display' => esc_html__('Monthly', 'wpbooked')
		);

		$schedules['twicemonthly'] = array(
			'interval' => 60 * 60 * 24 * 15,
			'display' => esc_html__('Twice Monthly', 'wpbooked')
		);

		$schedules['twicehourly'] = array(
			'interval' => 60 * 30,
			'display' => esc_html__('Every 30 Minutes', 'wpbooked')
		);

		$schedules['everyfifteen'] = array(
			'interval' => 60 * 15,
			'display' => esc_html__('Every 15 Minutes', 'wpbooked')
		);

		$schedules['everyfive'] = array(
			'interval' => 60 * 5,
			'display' => esc_html__('Every 5 Minutes', 'wpbooked')
		);

		return $schedules;
	}

	protected function activate_scheduler() {
		$mode = WPBooked_WC_Settings::get_option('cleanup_mode');

		$recurrence = $mode;
		$schedule_name = WPBOOKED_WC_PLUGIN_PREFIX . 'cron_' . $recurrence;

		if ($recurrence && !wp_next_scheduled( $schedule_name) ) {
			wp_schedule_event(time(), $recurrence, $schedule_name);
		}

		add_action($schedule_name, array($this, 'execute_cron'), 20 );
	}

	public function execute_cron() {
		WPBooked_WC_Cleanup::start();
	}
}