<?php

class WPBooked_WC_Appointment_Payment_Status {
	public $app_id;
	public $order_id;
	public $order_obj = null;

	public $is_paid;
	public $payment_status;
	public $payment_status_text;

	public function __construct($app_id) {
		if (!is_integer($app_id)) {
			$message = sprintf(
				/* translators: %1$s: Name Of Class Function  , %2$s: varibale type */
				esc_html__('%1$s integer expected when %2$s given.', 'wpbooked'),
				'new WPBooked_WC_Appointment_Payment_Status::get($app_id)',
				gettype($app_id)
			);
			throw new Exception(esc_html($message));
		} else if ($app_id === 0) {
			$message = sprintf(
				/* translators: 1: WPBooked_WC_Appointment_Payment_Status::get($app_id), 2: $app_id value */
			esc_html__('%1$s invalid ID is given. %2$s', 'wpbooked'),
			'new WPBooked_WC_Appointment_Payment_Status::get($app_id)',
			'$app_id=0'
		);
			throw new Exception(esc_html($message));
		}
		

		$this->app_id = $app_id;

		// set default status values
		$this->is_paid = false;
		$this->payment_status = 'awaiting_checkout';
		$this->payment_status_text = esc_html__('Awaiting Payment', 'wpbooked');

		$this->get_order();
		$this->set_statuses();
	}

	public function get_order() {
		$this->order_id = get_post_meta($this->app_id, '_' . WPBOOKED_WC_PLUGIN_PREFIX . 'appointment_order_id', true);
		if ( $this->order_id && $this->order_id != 'manual') {
			$this->order_id = (int) $this->order_id;
			$this->order_obj = WPBooked_WC_Order::get($this->order_id);
		}

		return $this;
	}

	public function set_statuses() {

		if ( $this->order_id && $this->order_id === 'manual' || $this->order_id && $this->order_obj->order->get_status() === 'wc-completed' || $this->order_id && $this->order_obj->order->get_status() === 'completed' ) {
			$this->is_paid = true;
			$this->payment_status = 'paid';
			$this->payment_status_text = esc_html__('Order Paid', 'wpbooked');
		} elseif ( $this->order_id ) {
			$this->is_paid = ( $this->order_obj->order->get_status() === 'wc-completed' || $this->order_obj->order->get_status() === 'completed' );
			$this->payment_status = $this->order_obj->order->get_status();
			$this->payment_status_text = esc_html__('Order ', 'wpbooked') . $this->order_obj->order->post_status_text;
		}

		return $this;

	}
}
