<?php

if ( !isset($appointment_id) || !is_numeric($appointment_id) ) {
	return;
}

$appointment = WPBooked_WC_Appointment::get($appointment_id);

// if there are no products then do not show payment info
if ( !$appointment->products ) {
	return;
}

$payment_class = 'wpbooked_wc_payment_pending';

// if order is available then pull the status from it
if ( $appointment->order_id ) {
	if ( $appointment->is_paid ) {
		$payment_class = 'wpbooked_wc_payment_completed';
	}
	$status_text = $appointment->payment_status_text;
} else if ( !$appointment->order_id || $appointment->order_id && !$appointment->is_paid ) {
	$status_text = esc_html__('Awaiting Payment', 'wpbooked');
}
?>

<br><i class="fa-solid fa-cart-shopping"></i><span class="<?php echo esc_html($payment_class) ?>"><?php echo esc_html($status_text) ?></span>
