<?php

$appt_id = intval($appt_id);
$appointment = WPBooked_WC_Appointment::get($appt_id);
$post_status = $appointment->post->post_status;
$awaiting_status = WPBOOKED_WC_PLUGIN_PREFIX . 'awaiting';

if ( !$appointment->order_id || $appointment->order_id == 'manual' ): ?>

	<a href="#" class="delete" <?php echo esc_html($calendar_id) ? ' data-calendar-id="'.esc_attr($calendar_id).'"' : '' ?> ><i class="fa-solid fa-xmark"></i></a>

<?php endif; ?>

<?php if ($post_status != 'publish' && $post_status != 'future'): ?>
	<button data-appt-id="<?php echo esc_attr($appt_id) ?>" class="approve button button-primary"><?php echo esc_html__('Approve Appointment', 'wpbooked') ?></button>
<?php endif; ?>

<?php if ( !$appointment->is_paid ): ?>

	<span class="wpbooked-wc_status-text awaiting">
		<?php
		if ( $appointment->order_id ) {

			if (current_user_can('manage_booked_options')) :
				echo '<button data-appt-id="'.esc_attr($appt_id).'" class="mark-paid button">'.esc_html__('Mark as Paid', 'wpbooked').'</button>';
				echo '<a target="_blank" href="' . esc_url(admin_url('/post.php?post=' . $appointment->order_id . '&action=edit')) . '">' . esc_html($appointment->payment_status_text) . '</a>';
			else :
				echo '<span>' . esc_html($appointment->payment_status_text) . '</span>';
			endif;

		} else {

			if (current_user_can('manage_booked_options')) :
				echo '<button data-appt-id="'.esc_attr($appt_id).'" class="mark-paid button">'.esc_html__('Mark as Paid', 'wpbooked').'</button>';
			endif;
			echo '<span>' . esc_html__('Awaiting Payment', 'wpbooked') . '</span>';

		}
		?>
	</span>

<?php else:

	echo '<span class="wpbooked-wc_status-text paid">';

		if (current_user_can('manage_booked_options') && $appointment->order_id != 'manual') :
			echo '<a target="_blank" href="' . esc_url(admin_url('/post.php?post=' . $appointment->order_id . '&action=edit')) . '"><i class="fa-solid fa-pencil"></i>&nbsp;&nbsp;' . esc_html__('Paid', 'wpbooked') . '</a>';
		else :
			echo '<span>' . esc_html__('Paid', 'wpbooked') . '</span>';
		endif;

	echo '</span>';

endif;
