<?php

// Deactivate the original add-on plugin.
add_action('init', 'wpbooked_deactivate_booked_fea');
function wpbooked_deactivate_booked_fea()
{
    require_once ABSPATH . 'wp-admin/includes/plugin.php';
    if (
        in_array(
            'wpbooked-frontend-agents/wpbooked-frontend-agents.php',
            apply_filters('active_plugins', get_option('active_plugins'))
        )
    ) {
        deactivate_plugins(
            plugin_basename('wpbooked-frontend-agents/wpbooked-frontend-agents.php')
        );
    }
}

add_action('plugins_loaded', 'wpbooked_init_booked_fea');
function wpbooked_init_booked_fea()
{
    define('WPBOOKEDFEA_PLUGIN_DIR', dirname(__FILE__));
    define('WPBOOKEDFEA_PLUGIN_URL', WPBOOKED_PLUGIN_URL . '/includes/add-ons/frontend-agents');
    $bookedfea_plugin = new WPBooked_FEA_Plugin();
}

class WPBooked_FEA_Plugin
{
    public function __construct()
    {
        add_action('init', [$this, 'wpbooked_fea_init']);
        add_action('wp_enqueue_scripts', [$this, 'front_end_scripts']);

        require_once sprintf('%s/includes/functions.php', WPBOOKEDFEA_PLUGIN_DIR);
        require_once sprintf(
            '%s/includes/shortcodes.php',
            WPBOOKEDFEA_PLUGIN_DIR
        );
        require_once sprintf('%s/includes/ajax.php', WPBOOKEDFEA_PLUGIN_DIR);

        $bookedfea_ajax = new WPBookedFEA_Ajax();
    }

    public function wpbooked_fea_init()
    {
        if (
            is_user_logged_in() &&
            current_user_can('edit_booked_appointments')
        ):
            add_filter(
                'wpbooked_profile_tab_content',
                [$this, 'wpbooked_fea_tabs'],
                1
            );
            add_filter('wpbooked_profile_tabs', [$this, 'wpbooked_fea_tabs'], 1);
        endif;
    }

    public static function front_end_scripts()
    {
        wp_register_script(
            'booked-fea-js',
            WPBOOKEDFEA_PLUGIN_URL . '/js/functions.js',
            [],
            WPBOOKED_VERSION,
            true
        );
        $booked_fea_vars = [
            'ajax_url' => admin_url('admin-ajax.php'),
            'i18n_confirm_appt_delete' => esc_html__(
                'Are you sure you want to cancel this appointment?',
                'wpbooked'
            ),
            'i18n_confirm_appt_approve' => esc_html__(
                'Are you sure you want to approve this appointment?',
                'wpbooked'
            ),
        ];
        wp_localize_script(
            'booked-fea-js',
            'wpbooked_fea_vars',
            $booked_fea_vars
        );
        wp_enqueue_script('booked-fea-js');
    }

    public function wpbooked_fea_tabs($custom_tabs)
    {
        $custom_tabs = [
            'fea_appointments' => [
                'title' => esc_html__(
                    'Upcoming Appointments',
                    'wpbooked'
                ),
                'fa-icon' => 'calendar-days',
                'class' => false,
            ],
            'fea_pending' => [
                'title' =>
                    esc_html__('Pending Appointments', 'wpbooked') .
                    '<div class="counter"></div>',
                'fa-icon' => 'clock',
                'class' => false,
            ],
            'fea_history' => [
                'title' => esc_html__('Appointment History', 'wpbooked'),
                'fa-icon' => 'calendar-days',
                'class' => false,
            ],
            'edit' => [
                'title' => esc_html__('Edit Profile', 'wpbooked'),
                'fa-icon' => 'pencil',
                'class' => 'edit-button',
            ],
        ];

        return $custom_tabs;
    }
}
