;(function($, window, document, undefined) {

	var $win = $(window);

	$win.on('load', function() {
		
		var ajaxRequests = [];
		
		// Add Pending Count to Tab
		$('.wpbooked-tabs').find('li a div.counter').each(function(){
			var thisCounter = $(this),
				thisTabName = $(this).parent().attr('href');
				thisTabName = thisTabName.split('#');
				thisTabName = thisTabName[1];
				totalAppointments = $('#profile-'+thisTabName).find('.appt-block').length;
			
			if (totalAppointments > 0){
				thisCounter.html(totalAppointments).css({'display':'flex'});
			}
		});
		
		// User Info Click
		$('.wpbooked-fea-appt-list').on('click', '.user', function(e) {

			e.preventDefault();

			var $thisLink 		= $(this),
				user_id			= $thisLink.attr('data-user-id'),
				appt_id			= $thisLink.parent().attr('data-appt-id'),
 wpbooked_ajaxURL	= wpbooked_fea_vars.ajax_url;

			create_booked_modal();
			
			$.ajax({
				url: wpbooked_ajaxURL,
				type: 'post',
				data: {
					action: 'wpbooked_fea_user_info_modal',
					user_id: user_id,
					appt_id: appt_id
				},
				success: function( html ) {
					
					$('.bm-window').html( html );
					
					var wpbookedModal = $('.wpbooked-modal');
					var bmWindow = wpbookedModal.find('.bm-window');
					bmWindow.css({'visibility':'hidden'});
 wpbookedModal.removeClass('bm-loading');
					resize_booked_modal();
					bmWindow.hide();
					
					setTimeout(function(){
						bmWindow.css({'visibility':'visible'});
						bmWindow.show();
					},50);
					
				}
			});
			
			return false;

		});
		
		// Show Additional Information
		$('.wpbooked-fea-appt-list').on('click', '.wpbooked-show-cf', function(e) {
		
			e.preventDefault();
			var hiddenBlock = $(this).parent().find('.cf-meta-values-hidden');
		
			if(hiddenBlock.is(':visible')){
				hiddenBlock.hide();
			} else {
				hiddenBlock.show();
			}
		
			return false;
		
		});
		
		// Approve Appointment from Appointment List
		$('.wpbooked-fea-appt-list').on('click', '.appt-block .approve', function(e) {

			e.preventDefault();

			var $button 		= $(this),
				$thisParent		= $button.parents('.appt-block'),
				appt_id			= $thisParent.attr('data-appt-id'),
 				wpbooked_ajaxURL	= wpbooked_fea_vars.ajax_url;

			var confirm_appt_approve = confirm(wpbooked_fea_vars.i18n_confirm_appt_approve);
			if (confirm_appt_approve == true){

				var currentApptCount = parseInt($button.parents('.wpbooked-fea-appt-list').find('h4 span.count').html());
				currentApptCount = parseInt(currentApptCount - 1);
				$button.parents('.wpbooked-fea-appt-list').find('h4 span.count').html(currentApptCount);
				
				if ($button.parents('#profile-fea_pending').length){
					if (currentApptCount < 1){
						$('.wpbooked-tabs').find('li a[href="#fea_pending"] .counter').remove();
					} else {
						$('.wpbooked-tabs').find('li a[href="#fea_pending"] .counter').html(currentApptCount);
					}
				}
				
				$('.appt-block').animate({'opacity':0.4},0);
				$button.remove();

		  		$.ajax({
					'method' : 'post',
					'url' : wpbooked_ajaxURL,
					'data': {
						'action'     	: 'wpbooked_fea_approve_appt',
						'appt_id'     	: appt_id
					},
					success: function(data) {
						$('.appt-block').animate({'opacity':1},150);
					}
				});

			}

			return false;

		});
		
		// Delete Appointment from Appointment List
		$('.wpbooked-fea-appt-list').on('click', '.appt-block .delete', function(e) {

			e.preventDefault();

			var $button 		= $(this),
				$thisParent		= $button.parents('.appt-block'),
				appt_id			= $thisParent.attr('data-appt-id'),
 wpbooked_ajaxURL	= wpbooked_fea_vars.ajax_url;

			var confirm_appt_delete = confirm(wpbooked_fea_vars.i18n_confirm_appt_delete);
			if (confirm_appt_delete == true){

				var currentApptCount = parseInt($button.parents('.wpbooked-fea-appt-list').find('h4 span.count').html());
				currentApptCount = parseInt(currentApptCount - 1);
				$button.parents('.wpbooked-fea-appt-list').find('h4 span.count').html(currentApptCount);
				
				if ($button.parents('#profile-fea_pending').length){
					if (currentApptCount < 1){
						$('.wpbooked-tabs').find('li a[href="#fea_pending"] .counter').remove();
					} else {
						$('.wpbooked-tabs').find('li a[href="#fea_pending"] .counter').html(currentApptCount);
					}
				}
				
				$('.appt-block').animate({'opacity':0.4},0);
								
				$thisParent.slideUp('fast',function(){
					$(this).remove();
				});

				$.ajax({
					'method' : 'post',
					'url' : wpbooked_ajaxURL,
					'data': {
						'action'     	: 'wpbooked_fea_delete_appt',
						'appt_id'     	: appt_id
					},
					success: function(data) {
						$('.appt-block').animate({'opacity':1},150);
					}
				});

			}

			return false;

		});
		
	});
	
})(jQuery, window, document);