<?php
	
if(!class_exists('WPBookedFEA_Ajax')) {
	class WPBookedFEA_Ajax {
		
		public function __construct() {
			
			// Ajax Actions
			add_action('wp_ajax_wpbooked_fea_delete_appt', array($this,'wpbooked_fea_delete_appt'));
			add_action('wp_ajax_wpbooked_fea_approve_appt', array($this,'wpbooked_fea_approve_appt'));
			
			// Ajax Loaders
			add_action('wp_ajax_wpbooked_fea_user_info_modal', array($this,'wpbooked_fea_user_info_modal'));
		
		}
			
		// Delete an Appointment
		public function wpbooked_fea_delete_appt(){
			
			if ( isset($_POST['appt_id']) && current_user_can('edit_booked_appointments') ):
		
				$appt_id = esc_html( $_POST['appt_id'] );
				$post_type = get_post_type( $appt_id );
				
				if ( $post_type == 'booked_appointments' ):
		
			
					// Send an email to the user?
					$email_content = get_option('wpbooked_cancellation_email_content');
					$email_subject = get_option('wpbooked_cancellation_email_subject');
					
					if ($email_content && $email_subject):

						$token_replacements = wpbooked_get_appointment_tokens( $appt_id );
						$email_content = wpbooked_token_replacement( $email_content,$token_replacements );
						$email_subject = wpbooked_token_replacement( $email_subject,$token_replacements );

					wpbooked_mailer( $token_replacements['email'], $email_subject, $email_content );

					endif;
			
					wp_delete_post($appt_id,true);
					wp_die();
				
				endif;
			
			endif;
			
		}
		
		// Approve an Appointment
		public function wpbooked_fea_approve_appt(){
			
			if (isset($_POST['appt_id'])):
		
				$appt_id = esc_html( $_POST['appt_id'] );
		
				// Send an email to the user?
				$email_content = get_option('wpbooked_approval_email_content');
				$email_subject = get_option('wpbooked_approval_email_subject');

				$token_replacements = wpbooked_get_appointment_tokens( $appt_id );

				if ($email_content && $email_subject):

					$email_content = wpbooked_token_replacement( $email_content,$token_replacements );
					$email_subject = wpbooked_token_replacement( $email_subject,$token_replacements );
					
 					wpbooked_mailer( $token_replacements['email'], $email_subject, $email_content );
					
				endif;
		
				wp_publish_post( $appt_id );
				wp_die();
				
			endif;
			
		}
		
		// Display the Appointment/User Info Modal
		public function wpbooked_fea_user_info_modal(){
			
			if (isset($_POST['user_id'])):
			
				ob_start();
				
				echo '<div class="wpbooked-scrollable">';
					echo '<p class="wpbooked-title-bar"><small>' . esc_html__('Appointment Information','wpbooked') . '</small></p>';
			
					if (!$_POST['user_id'] && isset($_POST['appt_id'])):
					
						$guest_name = get_post_meta($_POST['appt_id'], '_appointment_guest_name',true);
						$guest_email = get_post_meta($_POST['appt_id'], '_appointment_guest_email',true);
					
						echo '<p class="fea-modal-title">'.esc_html__('Contact Information','wpbooked').'</p>';
						echo '<p><strong class="wpbooked-left-title">'.esc_html__('Name','wpbooked').':</strong> '.esc_html($guest_name).'<br>';
						if ($guest_email) : echo '<strong class="wpbooked-left-title">'.esc_html__('Email','wpbooked').':</strong> <a href="mailto:'.esc_url($guest_email).'">'.esc_html($guest_email).'</a>'; endif;
						echo '</p>';
						
					else :
			
						// Customer Information
						$user_info = get_userdata($_POST['user_id']);
						$display_name = wpbooked_get_name($_POST['user_id']);
						$email = $user_info->user_email;
						$phone = get_user_meta($_POST['user_id'], 'wpbooked_phone', true);
				
						echo '<p class="fea-modal-title">'.esc_html__('Contact Information','wpbooked').'</p>';
						echo '<p><strong class="wpbooked-left-title">'.esc_html__('Name','wpbooked').':</strong> '.esc_html($display_name).'<br>';
						if ($email) : echo '<strong class="wpbooked-left-title">'.esc_html__('Email','wpbooked').':</strong> <a href="mailto:'.esc_url($email).'">'.esc_html($email).'</a><br>'; endif;
						if ($phone) : echo '<strong class="wpbooked-left-title">'.esc_html__('Phone','wpbooked').':</strong> <a href="tel:'.esc_url(preg_replace('/[^0-9+]/', '', $phone)).'">'.esc_html($phone).'</a>'; endif;
						echo '</p>';
			
					endif;
			
					// Appointment Information
					if (isset($_POST['appt_id'])):
			
						$time_format = get_option('time_format');
						$date_format = get_option('date_format');
						$appt_id = $_POST['appt_id'];
			
						$timestamp = get_post_meta($appt_id, '_appointment_timestamp',true);
						$timeslot = get_post_meta($appt_id, '_appointment_timeslot',true);
						$cf_meta_value = get_post_meta($appt_id, '_cf_meta_value',true);
			
						$date_display = date_i18n($date_format,$timestamp);
						$day_name = date_i18n('l',$timestamp);
			
						$timeslots = explode('-',$timeslot);
						$time_start = date($time_format,strtotime($timeslots[0]));
						$time_end = date($time_format,strtotime($timeslots[1]));
			
						if ($timeslots[0] == '0000' && $timeslots[1] == '2400'):
							$timeslotText = 'All day';
						else :
							$timeslotText = $time_start.' '.esc_html__('to','wpbooked').' '.$time_end;
						endif;
						
						$cf_meta_value = apply_filters('wpbooked_fea_cf_metavalue',$cf_meta_value);
			
						echo '<p class="fea-modal-title fea-bordered">'.esc_html__('Appointment Information','wpbooked').'</p>';
						do_action('wpbooked_before_appointment_information_admin');
						echo '<p><strong class="wpbooked-left-title">'.esc_html__('Date','wpbooked').':</strong> '.esc_html($day_name).', '.esc_html($date_display).'<br>';
						echo '<strong class="wpbooked-left-title">'.esc_html__('Time','wpbooked').':</strong> '.esc_html($timeslotText).'</p>';
						echo ($cf_meta_value ? '<div class="cf-meta-values">'.wp_kses_post($cf_meta_value).'</div>' : '');
						do_action('wpbooked_after_appointment_information_admin');
			
					endif;
			
					// Close button
					echo '<a href="#" class="close"><i class="fa-solid fa-xmark"></i></a>';
				echo '</div>';
				
				echo wp_kses_post(ob_get_clean());
				wp_die();
				
			endif;
			
		}
	}
}