<?php
if (!defined('ABSPATH'))
    die('No direct access allowed');
?>

<div class="woobe-admin-preloader">
    <div class="cssload-loader">
        <div class="cssload-inner cssload-one"></div>
        <div class="cssload-inner cssload-two"></div>
        <div class="cssload-inner cssload-three"></div>
    </div>
</div>

<?php
?>
<!----------------------------- Filters ------------------------------------->

<?php WOOBE_HELPER::render_html_e(WOOBE_PATH . 'views/parts/top_panel.php'); ?>

<!----------------------------- Filters end ------------------------------------->

<div class="wrap nosubsub" style="margin-top: 0;">
    <?php if (isset($_GET['settings_saved'])): ?>
        <div id="message" class="updated"><p><strong><?php esc_html_e("Your settings have been saved.", 'woo-bulk-editor') ?></strong></p></div>
    <?php endif; ?>

    <section class="woobe-section">


        <div class="woobe-header">
            <div>

                <h3 class="bear-plugin-name"><?php printf('BEAR - WooCommerce Bulk Editor Professional %s', '<span>v.' . esc_html(WOOBE_VERSION) . '</span>') ?> <svg viewBox="-57 161.9 480 519" fill="#2f55d4" xmlns="http://www.w3.org/2000/svg">
                        <g>

                            <path d="m191.6 648.5c-1.1-0.1-7-0.4-13.1-0.6-8-0.2-11.4-0.5-12-0.8-0.4-0.2-1.5-0.5-2.3-0.7-0.8-0.1-1.8-0.5-2.2-0.8s-0.9-0.6-1.1-0.6-1.1-0.5-2-1.1-1.8-1.1-2-1.2-2.1-1.8-4.2-3.9c-4-4-5.8-6.6-5.8-8.8 0-0.8-0.2-1.1-1.8-1.9s-1.9-1.1-1.9-2c-0.1-0.7-0.5-1.5-1.1-2.1-0.8-0.8-0.9-1.2-0.7-1.9 0.1-0.5 0.3-1.7 0.4-2.6 0.1-1 0.4-2.1 0.7-2.5s0.6-1.7 0.6-2.9c0.1-1.8 0-2.5-0.5-3.7-0.4-1-0.7-2.2-0.7-3.3s-0.3-2.3-0.6-3.2c-0.4-0.8-0.6-2.1-0.6-3s-0.3-2.2-0.6-3-0.6-2-0.6-2.8-0.3-2-0.6-2.7c-0.4-0.7-0.6-1.9-0.6-2.6 0-0.8-0.3-1.8-0.6-2.4-0.4-0.6-0.6-1.6-0.6-2.3s-0.3-2-0.6-2.9c-0.4-0.9-0.6-2.1-0.7-2.7 0-0.6-0.3-1.6-0.6-2.3s-0.6-1.8-0.6-2.3c0-0.6-0.3-1.6-0.7-2.3s-0.6-1.7-0.6-2.4c0-0.6-0.3-1.7-0.6-2.5s-0.6-2-0.6-2.7-0.3-1.9-0.6-2.5-0.6-1.8-0.6-2.4-0.3-1.8-0.6-2.6-0.6-1.9-0.6-2.5-0.3-1.7-0.6-2.4c-0.4-0.7-0.6-1.7-0.6-2.3s-0.2-1.4-0.5-1.8-0.6-1.4-0.7-2.3-0.4-1.8-0.7-2.1-0.5-1.1-0.6-1.8-0.4-1.5-0.6-1.7-0.5-0.8-0.6-1.3c-0.2-0.9-0.9-2.5-1.8-4.2-0.3-0.7-0.6-1.4-0.6-1.6s-0.4-1.1-0.8-2-0.8-1.8-0.8-2-0.2-0.5-0.5-0.8c-0.3-0.2-0.5-0.7-0.5-1.2s-0.3-1-0.6-1.3c-0.4-0.3-0.6-0.8-0.6-1.1s-0.3-0.9-0.6-1.3-0.6-1.1-0.6-1.4-0.3-1-0.6-1.4-0.6-1.2-0.6-1.6-0.3-1.2-0.6-1.6-0.6-1.2-0.6-1.6-0.3-1.2-0.6-1.7-0.6-1.3-0.6-1.8c0-0.4-0.3-1.2-0.6-1.8s-0.6-1.3-0.6-1.8-0.3-1.3-0.7-1.9c-0.6-1-0.9-1.1-2.5-1.3-1-0.1-2-0.3-2.3-0.4-0.4-0.2-0.7 0.1-1.3 0.8-1.2 1.6-3.9 4.2-5.2 5-0.7 0.4-1.9 1.3-2.6 1.9s-1.6 1.2-2.1 1.4-1.4 0.8-2.2 1.4-1.6 1.1-1.8 1.1c-0.5 0-3 2.9-3.5 4.1-0.2 0.6-0.6 1-0.7 1s-0.5 0.5-0.8 1c-0.3 0.6-1.4 2.1-2.5 3.4-2.4 2.9-2.6 3.3-2.6 6.1 0 1.8-0.1 2.3-0.6 2.9-0.9 0.9-1.8 0.8-2.9-0.2-1.6-1.3-2.7-0.9-2.6 1 0.1 3.1-1.3 4.4-3.1 2.9-1.7-1.4-2.8-1.2-5.7 1.5-1.4 1.3-2.6 2.5-2.6 2.8s-0.3 0.9-0.6 1.3c-0.6 0.7-0.6 1.2-0.6 6.4 0 4.9 0.1 5.8 0.6 6.9 0.3 0.7 1.8 3.7 3.2 6.6s2.6 5.5 2.6 5.7 0.3 0.8 0.6 1.2 0.6 1.1 0.6 1.5 0.2 0.9 0.5 1.1 0.6 0.8 0.7 1.4 0.5 1.5 0.8 2 0.6 1.3 0.6 1.7 0.2 1 0.5 1.5c0.9 1.3 1.2 5 0.6 7.1-0.7 2.7-0.3 3.8 3.1 7.6 1.6 1.8 3 3.7 3.3 4.2 0.2 0.6 0.6 1.1 0.8 1.2s0.4 0.5 0.4 0.8 0.3 0.9 0.6 1.3 0.7 1.1 0.8 1.6c0.1 0.4 1 1.7 2 2.7 0.9 1 1.7 2.1 1.7 2.4s0.3 0.8 0.6 1.1c0.3 0.4 0.8 1.6 1 2.7 0.3 1.7 0.3 2.1-0.1 3.1-0.8 1.7-1.4 1.9-3.1 1-0.8-0.4-1.8-1-2.2-1.3s-1-0.5-1.2-0.5c-0.3 0-0.7-0.2-1-0.5s-1.2-0.6-1.9-0.7c-1.1-0.1-1.4-0.1-1.8 0.4-0.6 0.8-0.5 1.2 0.4 2.2 0.7 0.8 0.8 1.1 0.7 2.3-0.1 0.8-0.3 1.6-0.6 1.9-0.5 0.6-2.5 0.6-3.3 0-0.3-0.3-0.9-0.5-1.2-0.5s-1-0.3-1.6-0.6c-0.6-0.4-1.3-0.6-1.6-0.6s-1.1-0.3-1.8-0.7c-1-0.5-1.4-0.6-1.9-0.3-0.4 0.2-0.7 0.5-0.7 0.7s-0.3 1-0.6 1.7-0.6 1.5-0.6 1.8c0 0.6-1 1.6-1.6 1.6-0.3 0-0.7-0.2-1.1-0.5-0.3-0.3-0.9-0.5-1.3-0.5s-1-0.2-1.5-0.6c-0.9-0.6-3.4-1.1-6.2-1.1-3.4-0.1-10.8 0.7-12.3 1.2-1.1 0.4-2.9 0.5-8.9 0.5-6.9 0-7.6-0.1-8.7-0.6-0.7-0.4-1.5-0.6-1.9-0.6-0.3 0-0.9-0.3-1.2-0.6-0.3-0.4-0.8-0.6-1.1-0.6s-0.9-0.3-1.3-0.6c-0.4-0.4-0.9-0.6-1-0.6-1 0-7.1-6.1-8.5-8.6-2-1.4-2.6-2.3-2.8-2.4s-0.3-0.4-0.3-0.7-0.3-1.1-0.6-1.8c-0.4-0.8-0.6-2-0.6-3.1 0-1-0.3-3.1-0.6-4.8-0.5-2.4-0.6-4.3-0.7-9.2 0-4-0.2-7.2-0.5-8.8-0.3-1.4-0.6-3.9-0.7-5.4-0.1-2-0.4-3.2-0.8-3.9-0.3-0.5-0.6-1.4-0.6-1.8s-0.3-1.2-0.6-1.6c-0.4-0.4-0.6-1-0.6-1.3s-0.7-1.4-1.6-2.4-2-2.6-2.5-3.6l-1-1.7-0.2-8.5c-0.1-6.3-0.3-9-0.7-10.4-0.3-1.1-0.5-3-0.5-4.4 0-1.5-0.2-3.2-0.6-4.4-0.4-1.3-0.6-2.9-0.6-4.6 0-1.5-0.3-3.6-0.6-5-0.3-1.3-0.6-3-0.6-3.7s-0.3-2-0.6-2.7c-0.3-0.8-0.6-1.9-0.6-2.6 0-0.6-0.2-1.3-0.5-1.6-0.3-0.2-0.6-0.9-0.7-1.6-0.1-0.6-0.5-1.8-0.8-2.5s-0.6-1.5-0.6-1.7-0.2-0.7-0.5-0.9-0.6-1.2-0.8-2c-0.1-0.8-0.5-1.8-0.8-2.2s-0.5-1.1-0.5-1.6-0.3-1.4-0.6-2.1-0.6-1.8-0.6-2.4-0.2-1.4-0.5-1.8-0.6-1.5-0.7-2.6-0.5-2.7-0.8-3.7-0.6-2.3-0.6-2.9-0.2-1.3-0.5-1.7-0.6-1.6-0.7-2.7-0.4-2.4-0.6-2.9-0.5-2.1-0.6-3.7-0.4-3.2-0.6-3.7c-0.2-0.4-0.5-2-0.6-3.5s-0.4-3.4-0.7-4.2c-0.5-1.2-0.5-3.3-0.6-14.7-0.1-15.7 0.2-30.9 0.7-33 0.2-0.8 0.4-4.3 0.5-7.8 0.1-3.7 0.4-7.1 0.6-8.2 0.2-1 0.5-3.6 0.7-5.9 0.1-2.3 0.4-4.7 0.6-5.3s0.5-2.2 0.6-3.4 0.4-2.6 0.6-3 0.5-2.2 0.6-4 0.4-3.6 0.7-4.1c0.8-1.5 0.8-12.5 0-14-0.3-0.6-0.6-1.9-0.7-2.9s-0.4-2.2-0.7-2.8c-0.7-1.4-0.7-20.7 0.1-23.1 0.3-0.9 0.6-3 0.7-4.7s0.4-3.5 0.6-4c0.3-0.5 0.5-1.7 0.6-2.7s0.4-2.2 0.7-2.6 0.5-1.1 0.5-1.5 0.3-1.3 0.6-1.9c0.4-0.6 0.6-1.3 0.6-1.6s0.3-1 0.6-1.6c0.4-0.6 0.6-1.3 0.6-1.5 0-0.3 0.3-1 0.6-1.7s0.9-1.8 1.2-2.5c0.9-1.9 2.3-4.4 2.6-4.8 0.2-0.2 0.8-1.2 1.3-2.3 0.6-1 1.4-2.4 1.8-3.1 0.5-0.7 1.3-1.9 1.8-2.8s1.2-1.8 1.5-2.1 0.5-0.7 0.5-0.9 0.5-1 1.2-1.9 1.3-1.8 1.4-2.1 1.3-2.1 2.6-4.1 2.4-3.8 2.4-4 0.3-0.6 0.6-0.9c0.4-0.4 0.6-0.9 0.6-1.7 0-0.6 0.2-1.4 0.5-1.8s0.6-1.4 0.7-2.9c0.1-1.3 0.4-2.6 0.6-2.8 0.2-0.3 0.5-1.2 0.6-2 0.2-1.5 2.2-5.4 3.4-6.6 0.3-0.3 0.6-0.7 0.6-0.9s0.8-1.3 1.8-2.5 1.8-2.3 1.8-2.5 0.6-1 1.3-1.9 1.3-1.7 1.3-1.9 0.6-1 1.3-1.9 1.3-1.7 1.3-1.9 0.5-0.9 1.1-1.7 1.3-1.8 1.6-2.4 0.9-1.4 1.4-1.9 1.3-1.6 1.8-2.4c1.1-1.7 8.4-9 10.3-10.2 0.7-0.5 2.3-1.8 3.5-3s3.9-3.5 5.9-5.1 3.8-3.1 3.8-3.2c0.1-0.1 0.8-0.6 1.6-1.1s2.1-1.4 2.9-2c1.5-1.2 1.7-1.3 4.7-3 1.1-0.6 2.1-1.3 2.4-1.6s0.6-0.5 0.8-0.5c0.4 0 4.1-2.3 5.2-3.2 0.2-0.2 0.8-0.5 1.4-0.8s1.5-0.8 2-1.1 1.4-0.9 1.9-1.1c0.5-0.3 1.5-0.9 2.2-1.3s1.8-1 2.4-1.3 1.7-0.9 2.4-1.4 1.6-1 2-1.1 0.8-0.4 1-0.7 0.7-0.5 1-0.5 0.8-0.3 1.2-0.6c0.3-0.3 1-0.7 1.4-0.8 0.5-0.1 1-0.4 1.2-0.7s0.5-0.4 0.6-0.4c0.4 0 1.6-0.6 3-1.4 0.7-0.4 2.2-1.2 3.4-1.8 1.1-0.6 2.3-1.1 2.6-1.3s1.8-0.9 3.5-1.8 3.6-1.8 4.2-2.1c0.7-0.3 1.5-0.6 1.8-0.6 0.4 0 1.4-0.3 2.2-0.6 1.4-0.6 2.6-0.6 11-0.7 8-0.1 9.6-0.2 10.6-0.7s2.3-0.6 7.3-0.6c5.6 0 6.1 0.1 6.9 0.6 0.6 0.5 1.3 0.6 3 0.6 1.5 0 2.6 0.2 3.6 0.6 0.9 0.4 2.1 0.6 3.3 0.6s2.2 0.2 2.7 0.5 1.9 0.6 3.8 0.8c1.7 0.2 3.9 0.5 4.8 0.8s2.7 0.5 3.8 0.5c1.2 0 2.4 0.2 2.9 0.5s2.1 0.6 3.6 0.8 3.5 0.5 4.4 0.8c1 0.3 2.2 0.5 2.8 0.5s1.6 0.3 2.4 0.6 2 0.6 2.6 0.6c0.7 0 1.5 0.2 1.8 0.5s1.3 0.6 2.3 0.8c0.9 0.1 2.1 0.5 2.7 0.8s1.4 0.5 1.8 0.5c0.5 0 1.4 0.3 2.1 0.6 0.7 0.4 1.6 0.6 2 0.6s1.4 0.3 2.1 0.6c0.7 0.4 1.6 0.6 2.1 0.6s1.1 0.2 1.5 0.5 1.4 0.6 2.2 0.7 1.8 0.4 2 0.6c0.3 0.2 1.4 0.5 2.5 0.6s2.2 0.4 2.4 0.7 0.9 0.4 1.7 0.4 1.9 0.3 2.6 0.6 2.1 0.7 3 0.8 2 0.4 2.4 0.7 1.2 0.5 1.8 0.5 1.8 0.3 2.5 0.6c0.8 0.3 1.9 0.6 2.6 0.6 0.6 0 1.8 0.3 2.6 0.6s1.8 0.6 2.2 0.6c0.5 0 1.3 0.2 1.8 0.5s1.7 0.6 2.7 0.8c0.9 0.1 2 0.5 2.3 0.8s0.8 0.5 1.2 0.5c0.3 0 1.2 0.3 2 0.6s1.7 0.6 2.1 0.6 1.1 0.3 1.6 0.6 1.3 0.6 1.6 0.6c0.4 0 1 0.3 1.5 0.6 0.4 0.4 1.2 0.6 1.6 0.6s1.2 0.3 1.6 0.6c0.4 0.4 1.2 0.6 1.6 0.6s1 0.3 1.4 0.6 0.9 0.6 1.3 0.6 1.1 0.3 1.5 0.6 1.1 0.6 1.4 0.6 1 0.3 1.5 0.6 1.2 0.6 1.5 0.6 0.9 0.3 1.3 0.6c0.4 0.4 1.1 0.6 1.4 0.6s1 0.3 1.4 0.6c0.4 0.4 1.1 0.6 1.4 0.6s1 0.3 1.4 0.6 0.9 0.6 1.2 0.6 0.8 0.3 1.3 0.6c0.4 0.4 1 0.6 1.2 0.6s1.5 0.6 2.9 1.2c1.4 0.7 4.4 2.1 6.7 3.2 6.1 2.9 7.2 3.5 8.7 4.5 0.8 0.5 1.5 0.9 1.7 0.9s1 0.6 1.9 1.3 1.8 1.3 2.1 1.3c0.2 0 0.8 0.3 1.3 0.6 0.4 0.4 0.9 0.6 1 0.6s0.7 0.2 1.3 0.5c1.1 0.5 1.6 0.4 3.3-0.6 0.3-0.2 0.9-0.5 1.4-0.8s1.7-1.1 2.6-1.8 1.7-1.2 1.9-1.2c0.1 0 1-0.5 1.8-1.1 0.9-0.6 1.9-1.2 2.4-1.3s0.9-0.3 1-0.5 0.8-0.4 1.5-0.6 1.6-0.5 1.8-0.8c0.3-0.2 1-0.5 1.6-0.6s1.3-0.4 1.6-0.7 0.9-0.5 1.6-0.5c0.6 0 1.6-0.3 2.1-0.6s1.4-0.6 1.9-0.6 1.5-0.3 2.2-0.6c0.7-0.4 1.7-0.6 2.4-0.6s1.7-0.3 2.3-0.6c2.2-1.2 11.7-1.2 12.9 0 0.3 0.3 0.8 0.6 1.1 0.6s0.8 0.3 1.1 0.6 0.7 0.6 0.9 0.6c1.1 0 8.3 8.1 9.1 10.4 0.2 0.4 0.4 0.8 0.6 0.9 0.4 0.2 2 3.3 2 3.8 0 0.2 0.3 1 0.7 1.8 0.7 1.3 0.7 1.9 0.7 6.8 0 4.7-0.1 5.4-0.7 6.6-0.4 0.7-0.8 1.8-0.9 2.4s-0.4 1.3-0.7 1.6c-0.3 0.2-0.5 0.6-0.5 0.9s-0.3 0.9-0.6 1.3-0.7 1.2-0.8 1.6c-0.1 0.5-0.3 0.9-0.5 0.9s-0.8 0.9-1.4 2c-1.1 2-5.3 6.6-9.7 10.5-1.6 1.4-2.3 2.4-2.4 3-0.1 0.5-0.3 1.8-0.6 2.8s-0.3 2.3-0.1 2.7c0.1 0.5 0.3 2.5 0.3 4.5 0.2 6.8 0.6 11.4 1.2 12.3 0.3 0.5 0.5 1.4 0.5 2 0 0.7 0.3 1.6 0.6 2.2 0.3 0.5 0.6 1.4 0.6 2s0.3 1.5 0.6 2.1c0.4 0.6 0.6 1.6 0.6 2.2 0 0.7 0.3 1.7 0.6 2.2 0.4 0.6 0.6 1.4 0.6 1.8s0.3 1.2 0.6 1.8c0.3 0.5 0.6 1.3 0.6 1.8 0 0.4 0.3 1.2 0.6 1.8 0.3 0.5 0.6 1.3 0.6 1.8 0 0.4 0.3 1.2 0.6 1.8 0.3 0.5 0.6 1.4 0.6 1.9s0.3 1.3 0.6 1.7c0.4 0.4 0.6 1.2 0.6 1.7s0.3 1.3 0.6 1.8 0.6 1.2 0.6 1.6 0.3 1.1 0.6 1.6 0.6 1.3 0.6 1.7 0.3 1.3 0.6 1.9c0.4 0.7 0.6 1.5 0.6 1.9s0.3 1.3 0.6 1.9c0.4 0.7 0.6 1.5 0.6 1.9s0.3 1.3 0.6 1.9c0.4 0.7 0.6 1.6 0.6 2s0.2 1.1 0.5 1.5 0.6 1.3 0.7 2.1 0.4 1.8 0.6 2.2c0.2 0.5 0.5 1.6 0.6 2.6s0.4 1.9 0.6 2.2 0.5 1.4 0.6 2.6c0.1 1.1 0.4 2.4 0.6 2.9 0.2 0.4 0.5 1.9 0.6 3.2s0.4 2.9 0.7 3.4c0.4 0.7 0.5 2.7 0.7 9.4 0.1 4.6 0.3 9.8 0.5 11.3 0.2 1.6 0.4 4.8 0.6 7.1 0.2 2.7 0.5 4.6 0.8 5.2 0.3 0.5 0.5 1.8 0.5 2.8 0 1.1 0.2 2.2 0.6 3 0.3 0.7 0.7 2.2 0.8 3.4s0.4 2.4 0.6 2.7 0.5 1.7 0.6 3.3c0.1 1.8 0.4 3.1 0.7 3.5 0.3 0.5 0.5 1.4 0.5 2.5 0 1 0.3 2.9 0.6 4.3s0.6 3 0.6 3.7 0.3 1.7 0.6 2.4c0.4 0.8 0.6 1.8 0.6 3 0 1.1 0.2 2.2 0.6 3s0.6 1.9 0.6 3 0.2 2.2 0.6 3c0.4 0.7 0.6 1.7 0.6 2.2s0.3 1.6 0.6 2.2c0.4 0.7 0.6 1.8 0.6 2.5s0.3 1.8 0.6 2.4c0.4 0.7 0.6 1.7 0.6 2.4s0.3 1.7 0.6 2.2c0.4 0.6 0.6 1.6 0.6 2.4 0 0.7 0.3 1.9 0.6 2.6s0.6 1.8 0.6 2.4 0.3 1.8 0.6 2.6 0.6 2 0.6 2.7 0.3 1.8 0.6 2.5c0.4 0.7 0.6 1.8 0.6 2.6 0 0.7 0.3 2 0.6 2.8 0.4 0.8 0.6 2.1 0.6 3.1 0 1.1 0.2 2.1 0.6 2.9 0.4 0.7 0.6 1.8 0.6 2.7 0 0.8 0.3 2.6 0.6 3.8 0.4 1.3 0.6 3.1 0.6 4.1s0.3 2.6 0.6 3.7c0.8 2.4 0.9 8.6 0.1 10.6-0.3 0.7-0.6 2.8-0.7 4.6-0.1 2.1-0.4 3.7-0.8 4.4-0.8 1.5-0.8 10.4 0 12.1s0.7 11.2 0 15.1c-0.3 1.5-0.5 3.8-0.5 5.3 0 1.9-0.2 3-0.6 4-0.4 0.9-0.6 2.1-0.6 3.2 0 1.2-0.2 2.2-0.6 3-0.4 0.7-0.6 1.7-0.6 2.4s-0.3 1.7-0.6 2.4c-0.4 0.7-0.6 1.7-0.6 2.2 0 0.6-0.3 1.4-0.6 1.8s-0.6 1.3-0.6 1.9-0.3 1.4-0.6 1.9-0.6 1.2-0.6 1.7-0.3 1.5-0.6 2.1c-0.4 0.7-0.6 1.6-0.6 2.1s-0.3 1.5-0.6 2.2c-0.4 0.7-0.6 1.8-0.6 2.6s-0.2 1.8-0.5 2.5c-0.4 0.8-0.6 2.7-0.7 6.1-0.2 3.5-0.4 5.3-0.8 6.1-0.3 0.8-0.5 2-0.5 3.6 0 1.8-0.2 2.7-0.6 3.6-0.4 0.7-0.6 1.6-0.6 2.1s-0.3 1.3-0.6 1.7c-0.4 0.4-0.6 1.1-0.6 1.5s-0.2 0.9-0.5 1.1-0.5 0.5-0.5 0.7c0 0.4-1.7 3.8-2.7 5.5-0.4 0.7-0.9 1.6-1.2 2.1-0.2 0.4-0.6 1-0.8 1.3s-0.7 1.1-1.1 1.9-1.1 1.8-1.5 2.3-0.7 1.1-0.7 1.4c0 0.6-6.5 7.1-7.4 7.4-0.4 0.1-1.1 0.5-1.5 0.8s-1.2 0.6-1.7 0.6-1.3 0.3-1.8 0.7c-0.9 0.6-1.2 0.7-8.1 0.6-6-0.1-7.3-0.2-8.2-0.7-0.6-0.3-1.6-0.6-2.4-0.6s-2-0.2-2.7-0.5-1.9-0.6-2.6-0.7-1.7-0.5-2.2-0.7c-2.4-1.2-3.9-1.9-4.3-1.9-0.3 0-0.7-0.2-1-0.5s-1.2-0.8-1.9-1.2c-3.3-1.8-9.6-7.3-10.7-9.5-0.2-0.5-0.9-1.4-1.6-2.1-0.6-0.7-1.2-1.5-1.4-1.9-0.1-0.4-0.7-1.3-1.3-2s-1.1-1.6-1.1-1.8-0.3-0.8-0.6-1.1c-0.4-0.3-0.7-1-0.8-1.6s-0.4-1.2-0.6-1.4-0.4-0.5-0.4-0.8c0-0.2-0.3-0.7-0.6-1.2-0.3-0.4-0.7-1.2-0.8-1.8s-0.4-1.2-0.7-1.4-0.5-0.6-0.5-0.9-0.3-1-0.6-1.5c-1-1.7-1.4-4.1-1-7 0.2-1.4 0.5-2.9 0.7-3.2s0.5-1.3 0.8-2.2c0.5-1.7 2.8-4.3 4.6-5.2 1.3-0.7 1.5-1.2 1.7-5.2 0.1-2 0.4-4.2 0.7-4.9 0.4-1.1 0.4-1.4-0.3-3.4-0.4-1.2-1-2.5-1.3-3-0.3-0.4-0.6-1.4-0.6-2.1s-0.2-1.6-0.5-1.9-0.5-1.2-0.5-1.8-0.2-1.3-0.5-1.6c-0.4-0.3-0.7-0.2-1.5 0.8-0.6 0.6-1.3 1.1-1.6 1.1-0.8 0-1.6-1.4-1.6-2.8 0-1.5-0.6-2-2-2h-1.5c-0.6 0-0.5-2 0.1-2.6 0.9-1 0.4-1.5-1.8-1.5-1.4 0-2.2-0.2-2.8-0.7-0.8-0.6-2.4-2.7-2.4-3.2 0-0.1-0.6-0.8-1.3-1.5s-1.3-1.6-1.3-2c0-0.9-0.8-1.4-2.1-1.2-1.2 0.2-1.6-0.2-2.4-2.8-0.6-1.8-0.6-2.9-0.6-9.2 0-4.3-0.1-7.4-0.3-7.8-0.3-0.5-0.7-0.6-2.5-0.6-3.2 0-3.4-0.2-3.4-3.9 0-1.6-0.1-3.2-0.3-3.4-0.1-0.2-0.6-0.4-1-0.4-0.5 0-0.9-0.3-1.2-0.8-0.4-0.9-0.4-0.9 1.7-5 0.3-0.7 0.6-1.4 0.6-1.8 0-0.3 0.3-1 0.6-1.5s0.6-1.4 0.6-1.9 0.3-1.4 0.6-1.9 0.6-1.4 0.6-2 0.3-1.8 0.7-2.6c0.8-1.8 0.7-2.7-0.1-2.8-0.8-0.2-1.7 0.7-1.9 1.9-0.1 0.7-0.4 0.9-0.9 0.9-0.4 0-1.3 0.3-2.1 0.6-1.7 0.8-2.3 0.5-3.2-1-0.3-0.5-0.7-1-0.8-1s-0.6-0.9-1.1-1.9c-1.3-2.6-1.9-2.5-2 0.4-0.1 1.8-0.2 2.2-0.8 2.5-0.5 0.3-0.8 0.2-1.6-0.3-1.1-0.8-2.1-0.9-2.3-0.2-0.1 0.3-0.5 0.5-0.8 0.5s-0.7-0.2-0.8-0.5-0.6-0.5-1.1-0.5-1.1 0.2-1.3 0.5-0.5 0.5-0.7 0.5c-0.5 0-2.9-2.8-3.2-3.7-0.4-1.1-1.5-1.3-2.1-0.5-1.2 1.8-2.4 2.9-2.9 2.9-0.3 0-1.1-0.6-1.6-1.3-3.9-4.7-7.2-7.6-8.1-7.2-0.3 0.1-0.7 0.7-0.9 1.2-0.4 0.9-0.4 1.2 0 2.3 0.6 1.7 0.6 6.1 0 8.1-0.3 0.9-0.5 2.1-0.5 2.7 0 1.4 0.9 3.8 1.6 4.7 0.3 0.4 0.6 1 0.6 1.3s0.3 0.9 0.6 1.2c0.4 0.3 0.6 0.9 0.6 1.3 0 1-2.8 3.6-4 3.8-0.9 0.1-1 0.2-1.1 1.5-0.1 1-0.4 1.7-1.1 2.3-0.6 0.6-0.8 1.1-0.7 1.4s0.4 1.6 0.5 2.9c0.3 2.3 0.3 2.4-0.5 3.2-0.7 0.8-0.8 1.1-0.8 3.1 0 1.7-0.2 2.5-0.6 3.2-0.3 0.5-0.6 1.2-0.6 1.4s-0.3 0.8-0.6 1.2c-0.4 0.4-0.6 1.3-0.6 1.9s-0.3 1.6-0.7 2.2c-0.6 1.1-0.7 1.5-0.6 7.3l0.1 6.1-1 0.3c-0.5 0.2-1.3 0.4-1.8 0.5-1 0.3-1.2 1.6-0.5 3.2 0.3 0.7 0.5 1.7 0.4 2.4-0.1 1.2-0.2 1.3-1.4 1.4-1.3 0.2-1.3 0.2-1.2 1.4 0 0.7 0.4 1.7 0.7 2.2s0.8 1.2 1 1.6 0.5 1 0.7 1.3c0.3 0.5 0.3 0.7-0.3 1.3-0.4 0.4-0.7 0.9-0.7 1s-0.8 1.2-1.8 2.4-1.8 2.3-1.8 2.4c0 0.2-0.4 1-0.8 1.9s-0.8 2-0.8 2.5-0.2 1.3-0.4 1.8-0.5 1.8-0.6 2.9c-0.1 1.2-0.4 2.3-0.7 2.6-0.3 0.4-0.5 1.1-0.5 2.2 0 1.4 0.2 1.8 1.1 2.9 0.6 0.7 1.3 1.3 1.6 1.3 0.2 0 0.7 0.3 1 0.6s0.8 0.6 1 0.6c0.8 0 3.9 2.7 8.9 7.8 3.9 4 5.3 5.6 6 7.1 0.7 1.4 0.9 2.2 0.8 2.7-0.1 0.4-1.1 1.6-2.1 2.7-1.7 1.8-1.9 2.1-1.9 3.3 0 1.7 0.9 3.2 2.8 4.5 1.4 0.9 1.6 1 3.6 0.8 1.1-0.1 3.4-0.1 5 0.1 2.3 0.2 3.1 0.4 4 1 2.4 1.7 3.8 3.8 3.8 5.8 0 1.3-0.5 1.9-1.7 1.9-0.6 0-1.4 0.5-2.6 1.7-1 1-2.6 2.2-3.9 2.8-1.2 0.6-2.8 1.5-3.6 2-1.6 1.1-1.8 1.2-5.3 3-1 0.5-2.1 1-2.4 1s-0.8 0.2-1.1 0.5-0.8 0.5-1.1 0.5-1 0.3-1.7 0.6-1.9 0.7-2.7 0.8-1.8 0.4-2.2 0.7-1.1 0.5-1.6 0.5-1.7 0.2-2.7 0.5-3 0.6-4.5 0.8-3.2 0.5-3.8 0.8-2.5 0.5-4.2 0.6-3.8 0.4-4.8 0.7c0.5 2.7-9.8 2.7-13.4 2.3zm32.6-5.1c0.7-0.4 1.8-0.6 2.6-0.6 0.7 0 2-0.3 2.8-0.6s1.8-0.6 2.2-0.6c0.5 0 1.3-0.3 1.9-0.6 0.6-0.4 1.4-0.6 1.9-0.6s1.3-0.3 1.8-0.6 1.2-0.6 1.4-0.6c0.3 0 1.3-0.5 2.2-1.2s2.1-1.3 2.6-1.4c0.9-0.2 1.2-1.4 0.6-2.1-0.2-0.2-1.2-0.5-2.3-0.7s-2-0.3-2.1-0.5-0.5-0.3-1-0.3c-0.6 0-0.8 0.2-0.8 0.8 0 1.1-0.8 1.3-1.8 0.6-1.3-0.9-6.2-0.8-7.9 0.1-1.1 0.6-1.6 0.7-3.5 0.5-1.3-0.1-2.5-0.4-2.8-0.7-0.6-0.5-1.5-0.3-1.5 0.4 0 0.2 0.2 0.6 0.5 0.8s0.5 0.7 0.5 1.2c0 0.6-0.2 0.8-0.8 0.8-0.4 0-0.9-0.2-1.2-0.5-0.5-0.7-4.8-0.7-6.1 0-0.6 0.3-2.5 0.5-6 0.7l-5.1 0.2-1-1.1c-1.8-1.9-1.7-5.1 0.1-7.1 0.5-0.5 1.1-0.9 1.4-0.9s0.8-0.3 1.2-0.6c0.3-0.4 0.8-0.6 1.1-0.6s1.2-0.3 2.1-0.7c1.7-0.8 3.7-0.7 4.6 0.2 0.3 0.3 0.9 0.5 1.2 0.5s1 0.3 1.5 0.6 1 0.6 1.1 0.6 0.5 0.2 0.7 0.5 0.7 0.5 1 0.5c0.4 0 0.6-0.2 0.6-0.9 0-0.5 0.3-1.2 0.6-1.5 0.4-0.3 0.6-0.9 0.7-1.2 0-0.4 0.5-1.1 1.2-1.6 1.1-0.9 1.3-0.9 4-0.8 2.1 0.1 2.9 0.2 3.4 0.7 0.3 0.3 0.9 0.6 1.3 0.6s1 0.3 1.4 0.6 1.4 0.9 2.1 1.4c0.7 0.4 1.8 1.4 2.3 2.1 1.5 1.9 1.6 2.1 2 2.1 0.2 0 0.3-0.7 0.3-1.5 0-1.3 0.2-1.6 1.8-3.3l1.8-1.9-1.4-1.4c-4.2-4.3-4.5-5.4-2.3-9.1 0.7-1.2 1.6-2.6 2-3.1 0.7-0.9 0.8-0.7-0.7-3.4-0.8-1.5-10.9-11.5-11.5-11.5-0.3 0-0.9-0.3-1.3-0.6s-1.1-0.7-1.6-1c-0.4-0.2-1.1-0.6-1.4-0.8-0.4-0.2-1.1-0.7-1.7-1-0.6-0.4-1.5-1.3-2-2.1-0.9-1.3-1-1.7-1.1-5.1-0.1-2-0.4-4.4-0.6-5.3s-0.4-2.3-0.4-3.1c0-1-0.2-1.8-0.6-2.3-0.4-0.4-0.6-1.2-0.6-1.6s-0.3-1.4-0.6-2.1c-0.3-0.8-0.6-2-0.6-2.7 0-0.8-0.3-1.7-0.6-2.3-0.3-0.5-0.6-1.2-0.6-1.5s-0.3-1-0.6-1.4c-0.4-0.4-0.6-1-0.6-1.3s-0.3-0.9-0.6-1.5-0.6-1.5-0.6-2.1-0.2-1.5-0.5-1.9-0.6-1.6-0.7-2.7-0.4-2.5-0.8-3.2c-0.3-0.7-0.6-1.8-0.6-2.5s-0.3-1.8-0.6-2.5c-0.4-0.7-0.6-1.7-0.6-2.4s-0.3-1.8-0.6-2.5c-0.4-0.7-0.6-1.8-0.6-2.4s-0.3-1.7-0.6-2.3c-0.4-0.7-0.6-1.7-0.6-2.3s-0.3-1.6-0.6-2.1-0.6-1.3-0.6-1.8-0.2-1-0.5-1.2-0.5-0.8-0.7-1.3c-0.1-0.5-0.4-1.1-0.7-1.3s-0.5-0.9-0.7-1.5c-0.1-0.6-0.4-1.4-0.6-1.6s-0.5-0.9-0.6-1.4-0.7-1.5-1.3-2.3c-1.3-1.6-1.4-2.4-0.4-3.1 0.7-0.4 0.7-0.6 0.3-1.9-0.5-1.7-0.2-2.2 1.2-1.7 0.8 0.3 1 0.3 1-0.1 0-0.6-1.2-2.6-1.6-2.6-0.1 0-0.4-0.3-0.5-0.7-0.3-0.9-1.7-2.7-4.8-5.9-1.3-1.4-2.8-3.3-3.4-4.2-0.5-0.9-1.2-1.8-1.4-2-0.3-0.2-0.5-0.7-0.5-1s-0.3-1.1-0.6-1.6-0.7-1.5-0.8-2-0.4-1.2-0.7-1.4-0.5-0.8-0.5-1.2-0.3-1.4-0.6-2c-0.4-0.7-0.6-1.8-0.6-2.5 0-1.7-0.7-2.3-2.3-2.2-1.3 0.1-1.3 0.1-1.9-1.7-0.4-1-0.8-3-0.9-4.5s-0.5-3.2-0.8-3.7-0.5-1.4-0.5-2-0.3-1.6-0.6-2.2c-0.4-0.7-0.6-1.6-0.6-2s-0.3-1.2-0.6-1.8-0.6-1.4-0.6-1.9-0.3-1.3-0.6-1.7c-0.4-0.4-0.6-1.2-0.6-1.7s-0.3-1.3-0.6-1.8-0.6-1.3-0.6-1.8-0.2-1-0.5-1.2-0.6-0.8-0.7-1.4-0.5-1.5-0.8-2-0.6-1.3-0.6-1.6-0.2-0.8-0.5-1-0.6-0.9-0.7-1.6c-0.1-0.6-0.5-1.5-0.8-1.9s-0.6-1-0.6-1.3-0.3-0.9-0.6-1.5c-0.3-0.5-0.6-1.3-0.6-1.6 0-0.4-0.2-0.9-0.5-1.1s-0.5-0.6-0.5-0.8-0.4-1.1-0.8-2-0.8-1.7-0.8-1.9-0.3-0.9-0.7-1.6-0.6-1.6-0.6-2.1-0.2-1-0.5-1.2-0.6-1-0.7-1.7-0.4-1.6-0.6-2-0.5-1.2-0.6-1.9-0.4-1.6-0.6-1.9c-0.2-0.4-0.5-1.4-0.6-2.2-0.1-0.9-0.4-1.8-0.6-2.1s-0.5-1.1-0.6-1.9-0.4-1.9-0.6-2.4c-0.3-0.6-0.5-2.5-0.6-5.1-0.1-2.7-0.3-4.6-0.7-5.3-0.3-0.7-0.5-2.1-0.5-3.8 0-2-0.2-3-0.8-4.6-0.9-2.3-1.6-2.7-2.8-1.8-0.9 0.7-1.5 0.8-1.5 0.2v-3.1c0.1-2.9-0.7-5.6-1.7-6.2-0.6-0.4-1.1 0.2-1.1 1.3 0 0.4-0.2 1.1-0.5 1.6s-0.5 1.3-0.6 1.8c-0.2 0.9-1.1 1.2-1.2 0.5v-5.9c0.1-5.2 0-5.5-0.5-5.5-0.3 0-0.9 0.3-1.2 0.7-0.9 1-1.3 0.5-1-1.6 0.2-2.1-0.1-2.7-1.2-1.6-1.4 1.3-2.4 0.7-2.4-1.6 0-0.6-0.2-0.9-0.6-1-0.5-0.2-3.2-3.1-3.2-3.5 0-0.1-0.5-1-1-2-0.6-1-1.4-2.7-1.8-3.7-0.7-1.8-0.7-1.9-0.2-3 0.3-0.6 0.5-1.4 0.5-1.8s0.6-2 1.4-3.6 1.4-3.1 1.4-3.3 0.2-0.5 0.5-0.7 0.5-0.7 0.5-1 0.3-1.2 0.6-1.9c0.4-0.7 0.9-1.8 1.3-2.5s0.6-1.5 0.7-1.7c0-0.2 0.3-1 0.6-1.7 0.4-0.8 0.6-2 0.6-3.2 0-1.3 0.2-2.5 0.6-3.4 0.4-0.8 0.6-2.1 0.6-3 0-1 0.2-1.9 0.6-2.6 0.5-0.7 0.6-1.5 0.6-2.8 0-1.7-0.1-1.9-1-2.8-1-0.9-1-0.9-0.6-2.1 0.2-0.7 0.7-1.5 1.2-1.9 0.9-0.8 1-1.9 0.3-2.2-0.3-0.1-0.8 0.1-1.1 0.4-0.7 0.6-1.3 0.4-1.3-0.4 0-0.3 0.5-1.2 1.2-2s1.6-2.1 2.1-2.8c1.3-2 3.9-4.6 4.5-4.6s0.7 0.8 0.2 1.6c-0.4 0.7-0.1 1.3 0.7 1.3 0.4 0 1.4 0.7 2.2 1.5 1.2 1.1 1.5 1.7 1.5 2.5 0 0.5 0.3 1.5 0.6 2.1 0.4 0.8 0.6 2.1 0.8 4.9 0.1 2.2 0.4 4.1 0.6 4.6s0.5 1.6 0.6 2.6 0.4 2 0.7 2.4 0.5 1.1 0.5 1.6 0.3 1.2 0.6 1.7c0.4 0.4 0.6 1.2 0.6 1.7s0.3 1.3 0.6 1.9 0.7 1.3 0.8 1.8 0.7 1.5 1.3 2.3 1.1 1.6 1.1 1.7c0 0.3 4.5 5.7 5.1 6 0.3 0.2 1.2 0.9 2.1 1.6s2 1.6 2.6 1.9c0.5 0.3 1.6 1.1 2.5 1.7 2.8 2.1 3.8 2.6 5.3 2.6 0.8 0 1.9 0.2 2.4 0.5 1.3 0.7 4 1 4.3 0.5 0.1-0.2-0.1-0.7-0.5-1.2s-1.3-1.7-2-2.8c-0.9-1.5-1.2-2.3-1.2-3.5 0-1-0.2-1.9-0.6-2.5-0.3-0.5-0.6-1.4-0.6-1.9s-0.2-1.2-0.5-1.5-0.6-1-0.7-1.6c-0.2-0.9-0.4-1.1-1.5-1.2-1.3-0.2-1.3-0.2-1.2-1.4 0.1-0.7 0.4-1.7 0.7-2.1 0.8-1.1 0.8-1.6-0.2-2.5-0.7-0.6-0.9-0.7-1.4-0.4-0.3 0.2-0.8 0.4-1.1 0.4-0.7 0-0.6-2.2 0.2-3.2 0.3-0.4 0.6-1.1 0.6-1.5s0.3-1.1 0.6-1.6c0.4-0.4 0.6-1 0.6-1.3s0.3-0.8 0.7-1.2c1-1 0.6-1.8-0.7-1.6-1.3 0.3-1.5-0.5-0.6-1.9 0.7-1.1 0.7-1.2 0.2-1.7s-0.6-0.4-1.7 0.3c-2.4 1.6-2.9 1.9-4.2 2.1-1 0.2-1.4 0.2-1.8-0.2-0.6-0.6-0.6-0.8-0.1-1.3 0.2-0.2 0.3-0.5 0.2-0.6s-0.7 0.4-1.4 1.1-1.4 1.3-1.6 1.3c-0.6 0-0.5-1.9 0.2-3 0.3-0.6 0.7-1.5 0.7-2.1 0.1-1.6-0.7-1.6-2.3 0-0.7 0.7-1.6 1.3-1.8 1.3-0.7 0-0.5-1 0.3-2.2 0.9-1.3 1-1.5 0.3-2.3-0.6-0.6-0.4-2.2 0.4-2.9 0.3-0.2 0.5-0.5 0.5-0.8s0.3-0.9 0.6-1.6 0.7-1.6 0.8-2.1 0.4-1.1 0.7-1.3 0.5-0.6 0.5-0.9 0.3-0.9 0.6-1.4c0.4-0.4 0.6-1 0.6-1.1 0-0.6 3.8-5 6-7 1.2-1.1 2.7-2.7 3.3-3.5s2.1-2.7 3.3-4.2c1.3-1.5 2.5-3.1 2.7-3.5 0.6-1.2 4.8-5.3 6.4-6.4 0.8-0.5 1.8-0.9 2.1-0.9s1-0.3 1.4-0.7c1-0.9 2.7-0.7 2.8 0.2 0.1 0.4-0.2 1.1-0.7 1.6-0.4 0.5-0.8 1.2-0.8 1.5s-0.2 0.9-0.5 1.2-0.6 1.1-0.7 1.8c-0.2 1.4-1.7 3.3-2.6 3.3-0.3 0-0.9-0.3-1.4-0.6-1.1-0.9-1.9-0.8-3 0.3-0.8 0.8-0.9 1.3-1 2.6 0 0.9-0.1 1.8-0.1 2.1-0.1 0.6-1.3 0.5-2-0.1-0.8-0.8-1.2-0.3-1.2 1.5 0 1.2-0.1 1.6-0.6 1.8-1.2 0.4-2 1.5-2.2 2.9-0.1 0.8-0.4 1.8-0.7 2.1-0.6 0.9-0.6 4.3 0.1 5 0.3 0.3 0.6 1.2 0.7 1.9 0.1 0.8 0.4 1.7 0.8 2.1s0.6 1 0.6 1.3c0 0.7 2.7 3.5 3.7 3.7 1.7 0.4 2.2-0.8 2.4-5.8 0.2-4.3 0.1-4 2.8-6.3 1.3-1 2.9-1.2 3.6-0.4 0.2 0.3 1.4 1.2 2.5 1.9 4.5 3 6.4 4.6 6.4 5.3 0 0.2-0.3 0.7-0.6 1.2-0.5 0.7-0.6 1.3-0.6 3.5 0 2.1-0.1 3-0.7 3.9-0.4 0.7-0.7 2-0.7 3 0 1.4 0.1 2 0.9 3.2 1.1 1.7 1.5 2.6 2 3.7 0.2 0.4 0.5 1 0.6 1.3 0.5 0.9 1.6 3.4 1.8 4.1 0.2 0.8 1.1 1.4 1.7 1.1 0.2-0.1 0.4-0.6 0.5-1.1 0.2-0.7 0.4-0.9 1-0.9 0.4 0 0.9 0.1 1 0.3s0.7 0.5 1.2 0.8c1.5 0.7 2.4 1.3 3.1 1.9 0.5 0.4 0.8 0.5 1.1 0.3 2.4-1.8 2.6-1.8 2.9 0.2 0.2 1 0.3 1.3 0.8 1.2 0.3-0.1 0.6-0.5 0.7-0.9 0.2-1.1 0.6-1.4 2-1.5 0.9 0 1.4-0.2 1.8-0.7 0.4-0.6 0.7-0.7 2.6-0.6 1.7 0.1 2.1 0 2.4-0.5 0.2-0.3 0.6-0.6 0.9-0.6s0.9-0.3 1.3-0.6 1.2-0.7 1.7-0.9 1.1-0.7 1.3-1.1 0.5-0.9 0.7-1.1c0.8-0.8 0.1-2.7-2.1-5.7-0.8-1.1-1.1-1.9-1.2-3.3-0.1-1.7-0.3-2-1.3-2.9-0.6-0.6-1.3-1.1-1.5-1.1s-1.3 0.9-2.4 1.9c-2.1 2.1-2.7 2.3-3.7 1.3-0.3-0.3-0.9-0.7-1.4-0.8-0.9-0.2-3.5-2.6-3.5-3.2 0-0.2 0.4-1.2 0.9-2.1 0.6-1.3 1.1-1.8 1.8-2.1 0.5-0.2 1.3-0.6 1.7-0.9 1.2-0.8 5.3-0.8 6.6 0.1 1 0.7 2.9 0.9 3.2 0.3 0.1-0.2-0.1-0.8-0.5-1.3-0.6-0.8-0.7-1.1-0.4-1.9 0.3-0.7 0.2-1-0.1-1.5-0.6-0.8-0.6-1.7 0.1-1.7 0.3 0 1.1 0.6 1.9 1.4 1.5 1.7 2 1.8 2.5 0.6 0.5-1.1 1.6-1.3 2.5-0.5 0.8 0.8 1.2 0.8 2.2 0.1 1.1-0.7 1.9-0.2 3.3 1.9 0.6 1 1.3 1.8 1.5 1.8s1.1-0.5 1.8-1.2c2.2-1.9 3.2-2.6 3.8-2.6 0.3 0 0.9-0.4 1.5-0.8 0.7-0.6 1-1.1 1-1.9 0-0.7 0.3-1.3 0.8-1.8 1-0.9 1-1.7 0.1-3-0.8-1.1-1.6-2.5-2.2-3.7-0.9-2 1.4-1.3 2.4 0.7 0.5 1 2.3 3.3 3.4 4.5 0.3 0.3 0.6 0.8 0.6 1.1s0.3 0.9 0.6 1.3c0.4 0.4 0.6 1.1 0.6 1.4s0.2 1.1 0.5 1.6c0.6 1.1 0.5 2.6-0.3 4.5-0.4 1-0.7 1.2-1.5 1.2s-1 0.2-1.3 1c-0.4 1.2-0.8 1.2-1.4 0.1-0.6-1.2-1.7-2.1-2.1-1.8-0.2 0.2-0.3 0.7-0.2 1.6 0.2 1.5 0.2 1.5-1.9 1.8-0.4 0.1-0.7 0.4-0.8 1-0.1 0.7-0.5 1.1-1.3 1.6-2.3 1.3-6.5 4.3-7.7 5.6-0.7 0.7-1.2 1.6-1.2 2s-0.3 1.3-0.6 1.9c-0.4 0.7-0.6 1.7-0.6 2.1 0 0.5-0.6 1.9-1.3 3.2s-1.3 2.6-1.3 2.8-0.3 0.9-0.6 1.3c-0.4 0.4-0.6 1-0.6 1.3s-0.3 0.9-0.6 1.5c-0.3 0.5-0.6 1.3-0.6 1.7s-0.3 1.3-0.7 2c-0.4 0.9-0.6 1.7-0.6 2.6 0.1 1.3 0.1 1.4 1.3 1.5l1.2 0.1v8h-2c-1.1 0-1.5 0.4-1.5 1.8 0 0.5-0.2 0.8-0.5 0.8-0.4 0-0.9-0.9-2.8-5-0.4-0.9-0.9-1.7-1.2-1.7-0.6 0-0.9 1.4-0.6 2.5 0.4 1.6 0.8 6.2 1.1 11.9 0.2 4.3 0.4 5.8 0.8 6.6 0.3 0.6 0.5 1.4 0.5 1.9s0.3 1.3 0.6 1.9c0.3 0.5 0.7 1.5 0.8 2.1s0.4 1.3 0.7 1.6 0.5 0.6 0.5 0.9c0 0.5 0.6 1.4 3.4 5.1 1.7 2.2 8.2 8.9 10.2 10.4 1 0.8 2.2 1.4 2.5 1.4s1.2 0.3 1.9 0.6c1.2 0.6 1.7 0.6 10.9 0.4 6.8-0.1 10.6-0.4 13.1-0.7 3.3-0.5 3.5-0.6 4.8-1.9 0.8-0.7 1.8-2.2 2.2-3.2 0.5-1 1.1-2.2 1.3-2.7s0.4-1.1 0.4-1.5c0-0.3 0.3-1 0.6-1.4 0.4-0.4 0.6-1.1 0.6-1.4s0.3-0.9 0.6-1.4c0.4-0.4 0.6-1.1 0.6-1.4s0.2-0.7 0.3-0.8c0.2-0.1 0.6-0.8 1-1.5 0.3-0.7 1.2-2.1 1.9-3.1 2.3-3.1 3.2-4.6 3.2-5.4 0-0.4 0.3-1.3 0.7-2 0.6-1.1 0.7-1.7 0.5-4.1-0.1-1.5-0.4-3.3-0.7-4s-0.5-2.1-0.5-3.4c0-1.2-0.3-3.3-0.6-4.6s-0.6-3.1-0.6-4.1-0.3-2.2-0.6-2.9c-0.4-0.7-0.6-1.8-0.6-2.4s-0.3-1.7-0.6-2.4c-0.4-0.7-0.6-1.6-0.6-2s-0.3-1.2-0.6-1.7-0.6-1.3-0.6-1.8-0.3-1.2-0.6-1.7c-0.4-0.5-0.6-1.3-0.6-2s-0.3-1.7-0.6-2.2-0.6-1.2-0.6-1.5c0-0.5-0.4-1.4-1.6-3.7-0.1-0.3-0.7-1.4-1.3-2.6-2.4-5.1-2.5-5.4-1.6-6.8 0.4-0.6 0.7-1.3 0.7-1.5 0-0.6 1.9-2.5 2.6-2.5 0.3 0 0.8-0.3 1.1-0.6 0.3-0.4 1-0.6 1.4-0.7 0.5 0 1.2-0.2 1.6-0.5 1-0.6 2.2-0.6 3.6 0 0.6 0.3 1.7 0.5 2.4 0.5 1.3 0 2.1 0.5 4.1 2.4 1.2 1.1 1.3 1.8 0.4 2.6-0.3 0.3-0.7 0.9-0.8 1.4s-0.6 1.3-1 1.8c-1.1 1.2-2.1 1.1-2.6-0.4-0.2-0.7-0.7-1.3-1.4-1.7-1-0.6-1-0.6-2.1 0.1-1.4 0.9-1.8 1.5-1.8 3.3 0 1.5-0.4 2-1.6 2.2-1.4 0.2-1.2 1.4 0.4 3.2 0.8 0.9 1.8 2 2.2 2.6 0.7 0.9 0.9 1 1.4 0.7s0.8-0.2 1.3 0.3c0.7 0.7 1.4 0.6 1.4-0.3 0-1 1.2-3.3 1.7-3.3 0.7 0 0.9 1.3 0.7 4.7-0.1 1.7-0.1 3.3 0.1 3.5 0.5 0.7 1.3 0.2 1.3-0.9 0-0.5 0.2-1.4 0.5-1.9s0.6-1.6 0.7-2.6c0.2-1.5 0.3-1.7 0.9-1.5 0.4 0.1 1.1 0.2 1.6 0.3 0.8 0 1 0.2 1 0.8 0.2 1.6 0.4 2.2 0.8 2.2 0.2 0 0.5-0.2 0.6-0.5 0.4-1 0.2-5.1-0.3-6.4-0.8-2-0.9-3.4-0.3-3.4 0.3 0 0.7 0.4 1 0.8 0.8 1.2 1.5 0.5 1.3-1.2-0.2-1.4 0.5-2.8 1.5-2.8 0.3 0 1 0.4 1.5 0.8 1.3 1.2 3 0.9 3-0.5 0-0.3 0.3-1.1 0.7-1.7l0.7-1.2-0.7-1.5c-0.4-0.8-0.7-1.8-0.7-2.2s-0.2-0.7-0.4-0.8c-0.6-0.2-1.6-2.2-1.4-2.8 0.2-0.4 0.4-0.5 1-0.2 1.2 0.5 2.6 0.4 3.1-0.2 0.3-0.3 0.8-0.6 1.3-0.8 0.9-0.4 1.1-1.4 0.3-2-0.3-0.2-0.8-0.7-1.2-1.1s-1.1-0.9-1.5-1.2c-0.5-0.3-2.8-2.3-5.1-4.4-2.5-2.3-4.6-3.9-5.1-4s-1.2-0.5-1.6-1c-0.6-0.7-0.7-0.9-0.3-1.4 0.6-0.9 0.5-1.3-0.6-2.6-0.7-0.9-0.9-1.4-1-2.6 0-1.6-0.8-2.9-2.4-4.2-0.7-0.6-1.5-0.8-3.6-0.9l-2.7-0.2-0.1-1c-0.1-1.1-1.5-2.7-2.3-2.7-0.3 0-0.9-0.3-1.4-0.6-0.4-0.4-1.3-0.6-1.9-0.6s-1.5-0.3-2-0.6-1.3-0.6-1.7-0.6-1.2-0.3-1.8-0.6c-0.6-0.4-1.4-0.6-1.7-0.6-0.4 0-1-0.3-1.5-0.6-0.4-0.4-1-0.6-1.3-0.6s-0.8-0.3-1.3-0.6c-0.4-0.4-0.9-0.6-1.1-0.6s-0.6-0.3-0.9-0.6-0.8-0.6-1-0.6-0.6-0.2-0.7-0.4c-0.2-0.3-1.6-0.5-4.3-0.6-3-0.2-4-0.3-4.3-0.7-0.5-0.6-0.2-1.4 0.8-2.3 0.7-0.6 1.2-0.7 3.9-0.7 2.2 0 3.2 0.1 3.7 0.5 0.8 0.6 4.8 0.7 5.1 0.1 0.1-0.2 0.2-1.2 0.2-2.2s0.1-1.9 0.2-2c0.2-0.1 1.6-0.2 3.1-0.3 2.8-0.1 2.9-0.1 4.5 1.1 3.4 2.4 4.6 2.7 5.7 1.1 0.3-0.4 0.7-0.8 1-0.8 0.2 0 2.3 1.9 4.6 4.3 2.7 2.8 4.5 4.4 5.1 4.5 0.5 0.1 1.2 0.4 1.5 0.7s1.1 0.4 1.7 0.4 1.6 0.2 2.2 0.5c0.7 0.3 2.2 0.6 3.5 0.8 1.3 0.1 2.7 0.5 3.3 0.8 0.5 0.3 1.5 0.5 2.1 0.5s1.5 0.3 1.9 0.6c0.4 0.4 1.2 0.6 1.7 0.6 1.4 0 3.1 1 3.1 1.8 0 0.4-0.2 0.7-0.6 0.7-0.4 0.1-1.2 0.4-1.9 0.7s-1.7 0.7-2.1 0.9c-0.5 0.2-0.9 0.6-1 1-0.1 0.6 0.1 0.8 1.3 1.5 0.8 0.5 1.9 1.2 2.3 1.6 0.7 0.6 1.3 0.7 3.3 0.7 3 0 3.5 0.5 1.7 2.1-0.6 0.5-1.2 1.2-1.2 1.5 0 0.5 0.3 0.9 3.8 3.8 0.9 0.8 2.2 1.9 2.9 2.5 0.6 0.6 1.7 1.3 2.3 1.7 1.5 0.8 1.8 1.6 0.9 2.2s-0.8 1 0.5 1.5c0.6 0.3 1.1 0.6 1.1 0.7s0.6 0.7 1.3 1.2c1.8 1.3 1.7 2.1-0.2 2.1-1.2 0-1.4 0.1-1.4 0.6 0 0.4 0.6 1.4 1.4 2.4 3.8 4.8 6.1 10.1 5.4 12.1-0.2 0.5-0.3 1.4-0.3 2 0 0.9 0.1 1.1 0.6 1.1 0.4 0 0.8-0.4 1-0.9s0.8-1.4 1.3-1.9c1.3-1.4 1.8-4.3 1.1-6-0.6-1.4-0.6-2.4-0.1-2.4 0.4 0 4.3 3.9 6.4 6.3 1 1.2 1.3 1.3 1.8 1 0.5-0.2 0.7-0.7 0.7-1.4 0-0.6 0.3-1.9 0.6-2.9 0.5-1.4 0.6-2.6 0.6-5 0-2.6-0.1-3.4-0.6-4.4-0.4-0.7-0.6-1.6-0.6-2.1s-0.3-1.4-0.6-2.1c-0.4-0.7-0.6-1.6-0.6-2.2s-0.3-1.6-0.6-2.4c-0.6-1.3-0.6-2.1-0.6-10.6 0-7.7-0.1-9.2-0.5-9.2-0.5 0-2.1 1.8-2.1 2.3 0 0.2-0.7 1.2-1.6 2.1-2.3 2.5-3.2 3.9-3.5 6-0.3 1.6-1 3-1.4 2.6-0.3-0.3-0.3-3.7-0.1-5 0.2-1.1 0.1-1.5-0.4-2.2-0.4-0.5-0.7-1-0.7-1.2s-0.5-1-1.1-1.8-1.2-1.8-1.3-2.2c-0.3-0.8-5.1-5.5-6.2-5.9-0.5-0.2-1.2-0.7-1.6-1-0.8-0.7-3.1-2.1-4.7-2.9-0.5-0.3-1.2-0.7-1.4-1-0.5-0.6-1.3-0.6-1.5 0-0.1 0.3 0.6 1.4 1.8 2.8 1.8 2.2 2.3 3.1 1.7 3.1-0.1 0-0.5-0.3-0.8-0.6s-0.7-0.6-0.9-0.6-1.4-0.9-2.6-2-3.1-2.7-4.2-3.6c-1-0.9-2.8-2.6-4-3.7-2.2-2.2-4.8-4.2-6.1-4.6-0.4-0.1-1-0.4-1.2-0.5-0.6-0.5-1-0.1-1.2 1.2-0.1 0.6-0.3 1.1-0.5 1.1-0.4 0-2-2.6-2-3.2s-2.7-3.2-3.4-3.2c-0.6 0-0.5 0.4 0.2 2 0.5 1 0.6 1.4 0.3 1.7s-0.8-0.1-2-1.4c-0.9-1-2.3-2.2-3-2.6-1.2-0.7-1.4-0.8-2.3-0.5-1.2 0.4-1.7 0.1-2.6-1.7-0.3-0.6-1.3-1.9-2.2-2.7-1.7-1.7-2.1-2.7-0.9-2.7 0.4 0 1 0.2 1.3 0.5 0.8 0.7 3.4 1.2 4 0.7 0.8-0.7 0.5-2.4-0.8-4.1-0.8-1.1-1.2-1.7-0.9-1.8 0.2-0.1 0.5 0 0.7 0.3s0.8 0.6 1.4 0.7 1.1 0.4 1.2 0.7 0.6 0.4 1.1 0.4c1.2 0 1.2-0.9 0-1.3-0.5-0.2-1-0.5-1.1-0.7s-0.5-0.5-1-0.6c-0.4-0.1-1.6-0.7-2.5-1.3s-2-1.1-2.3-1.1c-0.5 0-0.6 0.2-0.4 1.2 0.1 0.9 0.1 1.4-0.3 1.6-0.7 0.6-1.6 0-3.7-2.2-1.7-1.8-2.2-2-2.6-0.9-0.2 0.6-1.3 0.5-2.3-0.4-0.4-0.3-1.3-0.9-2.1-1.4s-2.1-1.3-2.9-1.9-1.6-1.1-1.7-1.1-0.6-0.3-0.9-0.5c-0.3-0.3-0.8-0.4-1.1-0.3-0.4 0.2-0.3 0.5 0.5 2 0.5 1 1.1 2 1.3 2.2 0.4 0.4 0.4 1.4 0 1.6-0.2 0.1-0.9-0.4-1.7-1.1s-1.5-1.3-1.7-1.3-1-0.6-1.8-1.3-1.6-1.3-1.7-1.3c-0.2 0-2.1-1.3-3.7-2.6-0.8-0.6-1.9-1.4-2.4-1.7s-1.6-1.1-2.4-1.8-1.6-1.2-1.8-1.2-1-0.6-1.9-1.2c-0.9-0.7-1.9-1.3-2.4-1.5-0.4-0.1-1-0.4-1.3-0.7-0.3-0.2-1.3-0.5-2.2-0.6s-2.3-0.5-3-0.8-1.8-0.6-2.4-0.6c-1.2 0-3.3-1.2-3.1-1.7 0.1-0.2 0.9-0.4 1.8-0.5s1.8-0.3 1.8-0.5c0.2-0.5-2-1.9-3.5-2.1-0.6-0.1-1.3-0.4-1.6-0.7s-0.6-0.5-0.9-0.5-1-0.3-1.5-0.6-1.2-0.6-1.5-0.6-1-0.3-1.4-0.6c-0.4-0.4-1-0.6-1.3-0.6-0.2 0-1.1-0.3-1.8-0.7s-1.6-0.8-1.9-1c-0.3-0.1-0.8-0.4-1.1-0.5s-1.2-0.6-1.9-1-1.6-0.7-2-0.7-0.9-0.3-1.2-0.6c-0.3-0.4-0.9-0.6-1.4-0.6-0.4 0-1.1-0.3-1.6-0.6-0.4-0.4-1.1-0.6-1.4-0.6s-0.9-0.3-1.4-0.6c-0.4-0.4-1-0.6-1.2-0.6s-0.9-0.5-1.5-1-1.6-1.2-2.2-1.4-1.1-0.6-1.2-0.9c-0.3-0.8-2.8-0.7-3.6 0.1-0.6 0.7-1.9 0.9-2.3 0.3-0.1-0.2-0.8-0.6-1.5-1-1.8-0.8-3.3-1.8-4.7-2.9-1.2-0.9-2.6-1.2-3-0.6-0.1 0.2 0.4 0.9 1.1 1.7 1.2 1.3 2.5 3.7 2.1 4-0.1 0.1-0.5 0-0.9-0.2-1.6-1-4.6-1.7-8.6-1.9-1.8-0.1-3.7-0.3-4.1-0.5-0.9-0.3-1 0.4-0.2 1.6 0.4 0.6 0.4 0.9 0.1 1.2-0.5 0.6-2.7 0.3-4.1-0.5-1.3-0.8-1.8-0.8-2.2 0.1-0.3 0.7-0.5 0.7-2.7 0.6-1.5-0.1-2.8-0.3-3.5-0.7-0.6-0.3-2.2-0.7-3.8-0.8-2.3-0.2-2.6-0.1-2.6 0.3 0 0.3 0.3 0.8 0.7 1.1s1.2 1 1.7 1.4l1 0.8-0.9 0.3c-0.5 0.2-0.9 0.5-0.9 0.7s0.7 1.1 1.6 2 1.7 2 1.8 2.3 0.5 0.9 0.8 1.3c0.5 0.6 0.9 1.8 1.1 3.2 0.1 0.9-1.1 1-1.8 0.2-0.3-0.4-0.7-0.7-0.9-0.7s-0.7-0.4-1.3-0.8c-1.7-1.5-3-0.9-2 0.9 0.7 1.2 0.5 2.6-0.5 3.1-0.5 0.3-0.9 0.2-1.8-0.3-0.7-0.4-1.3-0.6-1.5-0.6s-0.8-0.5-1.5-1.1-1.4-1.1-1.7-1.1c-0.2 0-0.7-0.3-1-0.6s-0.9-0.6-1.4-0.6-1.3-0.3-1.9-0.7c-1.1-0.7-3-0.8-3.2-0.1-0.1 0.3 4.7 4.6 8.1 7.2 1.3 1 2.4 1.1 4.7 0.5 1.1-0.3 1.6-0.3 2.3 0 0.5 0.2 2 0.5 3.3 0.6 1.4 0.1 2.9 0.5 3.6 0.8 0.6 0.3 1.5 0.6 2 0.6s1.4 0.3 2.1 0.6c0.7 0.4 1.5 0.6 1.8 0.6s1 0.3 1.4 0.6c0.4 0.4 1.1 0.6 1.3 0.6 0.3 0 0.8 0.3 1.1 0.6 0.3 0.4 0.8 0.6 1 0.6 0.3 0 0.9 0.3 1.4 0.6 1.5 1 2.1 1.3 3.4 2 1.2 0.6 8.6 6.3 11.2 8.8 0.7 0.7 1.9 1.6 2.7 2s1.5 1 1.6 1.1c0.2 0.4 2.5 1.9 2.8 1.9 0.1 0 0.8 0.5 1.5 1.1s1.5 1.2 1.9 1.3 1.6 1 2.7 2.1c1.2 1 2.3 1.9 2.6 1.9 0.2 0 0.9 0.4 1.4 0.8 1.6 1.4 0.2 2.5-1.4 1.1-0.8-0.6-1.3-0.8-2.1-0.7-0.7 0.1-0.5 0.7 0.6 1.8 0.5 0.6 1 1.2 1 1.3 0 0.7-1.6 1.6-3.3 1.8-1.8 0.2-2 0.3-3.9 2.2-1.1 1.1-2.1 2.4-2.3 2.8-0.1 0.4-0.8 1.4-1.4 2.2-0.7 0.8-1.3 1.8-1.4 2.2-0.2 0.6-0.4 0.7-1.1 0.6-0.6-0.1-0.9-0.3-1.1-1.1-0.2-0.7-0.5-1-0.9-1-0.5 0-0.6 0.2-0.6 1.6 0 0.9-0.1 1.7-0.3 1.8-0.5 0.3-1.9-1.3-1.9-2.2 0-0.5-0.2-0.9-0.5-1-0.6-0.2-1.9 1-2.2 2-0.3 1.1-1.6 3-1.9 2.9-0.2 0-0.4-0.5-0.6-1.1-0.3-1.2-1.1-1.3-1.4-0.2-0.1 0.4-0.4 1-0.6 1.2s-0.4 0.8-0.4 1.3c0 1.5-0.4 2.9-0.8 2.9s-1.1-1.5-1.7-3.3c-0.2-0.5-0.4-1-0.6-1-0.2-0.1-1 0.9-1.8 2.2s-1.9 2.8-2.4 3.4-1.2 1.5-1.4 2.1c-0.8 1.6-1.9 2.5-2.9 2.3-0.7-0.2-1.1 0-2 0.7-0.7 0.5-1.5 1.1-2 1.3-0.9 0.5-1.5 0.8-3.4 2-1.5 1-4 3.6-4 4.2 0 0.2-0.2 0.6-0.4 0.8s-0.9 1.2-1.4 2.2-1.1 1.9-1.3 1.9c-0.2 0.1-0.5 0.6-0.6 1.2-0.1 0.8-0.4 1.1-0.8 1.1-0.8 0-1.6-1.9-1.6-4 0-0.9-0.2-2.2-0.5-2.9s-0.6-1.8-0.7-2.5-0.5-1.5-0.8-1.9c-0.6-0.6-3.2-2.5-3.5-2.5-0.4 0-3.3-3.1-3.3-3.5 0-0.3-0.2-0.8-0.5-1.3-0.3-0.4-0.9-1.4-1.3-2.2-2.7-5-3.3-6.2-3.3-6.9 0-0.4-0.3-1.1-0.6-1.7-0.3-0.5-0.6-1.5-0.6-2.2s-0.3-1.7-0.6-2.2c-0.4-0.7-0.6-1.6-0.6-2.7 0-0.9-0.3-2.5-0.6-3.6-0.5-1.7-0.6-2.9-0.6-7.2 0-4.4 0.1-5.4 0.6-6.6 0.3-0.8 0.6-1.9 0.6-2.5s0.3-1.5 0.6-1.9c0.4-0.4 0.6-1.1 0.6-1.4s0.3-1 0.6-1.4 0.6-1 0.6-1.3c0-0.4 1.3-2.4 3.3-4.7 0.5-0.6 1.6-1.5 2.4-2s1.7-1.1 1.9-1.3 0.7-0.4 1.1-0.4c1 0 2.8-1.2 2.8-1.9 0-0.4-0.3-0.7-0.9-0.8-0.5-0.1-1.7-0.7-2.6-1.3-1-0.6-2.2-1.2-2.8-1.3s-1.2-0.4-1.4-0.7-0.6-0.5-0.9-0.5-0.9-0.3-1.4-0.6c-0.4-0.4-1.2-0.6-1.7-0.6s-1.5-0.3-2.1-0.6c-1.4-0.7-2.2-0.8-2.7-0.3-0.7 0.7-0.4 1.2 1.1 2.6 2.1 2 1.7 2.3-2.4 1.8-3-0.4-3.2-0.4-4.6 0.3-1.1 0.6-1.5 0.6-2.1 0.3-0.4-0.2-1-0.3-1.3-0.3-0.9 0.2-0.9 0.9 0.1 1.2 0.5 0.2 1 0.4 1.1 0.6 0.3 0.4 2.8 2 3.2 2 0.6 0 1.2 1.5 0.8 2-0.2 0.2-0.7 0.1-1.6-0.3-0.7-0.4-1.7-0.7-2.2-0.7s-1.6-0.2-2.5-0.5c-1.5-0.5-1.6-0.5-2.7 0-0.7 0.3-1.9 0.5-3.1 0.5-3.3 0-3.8 0.7-2.3 3.5 0.9 1.8 0.8 2.9-0.3 2.9-0.4 0-2 0.1-3.6 0.1-2.4 0-2.9 0.1-3 0.6-0.1 0.4 0.2 0.6 1.2 0.9 0.7 0.2 1.4 0.5 1.5 0.7s0.5 0.3 0.8 0.3c0.4 0 0.9 0.2 1.3 0.4 0.6 0.3 0.6 0.4 0.1 0.8-0.4 0.3-1.3 0.4-3.2 0.2-2.7-0.2-2.7-0.2-5 1.2-1.3 0.7-2.6 1.5-2.8 1.6s-0.9 0.5-1.5 0.8c-0.5 0.3-1.2 0.7-1.4 1s-0.7 0.5-1.1 0.5-1 0.3-1.3 0.6c-0.3 0.4-0.8 0.6-1.1 0.6s-1.3 0.6-2.2 1.3-1.8 1.3-2.1 1.3-0.7 0.3-1 0.6c-0.7 0.7-1.8 0.9-1.8 0.2 0-0.6 0.6-1.2 2.7-2.7 0.9-0.7 2.1-1.7 2.6-2.2s1-1 1.2-1 0.9-0.4 1.7-1c2.2-1.5 3.4-3.2 4.1-5.8 0.3-1.2 0.8-2.5 1-2.7 0.6-0.7 3-1.7 4.2-1.7 0.6 0 1.8-0.4 2.8-0.9l1.8-0.9-0.1-1.5c-0.1-2.1 0.2-2.3 4-2.1 1.7 0.1 3.3 0.1 3.5 0 0.8-0.3 0.4-1.6-0.9-2.8-1.3-1.3-1.6-2.3-0.9-3 0.3-0.3 1.7-0.4 4.2-0.4 3.3 0 4-0.1 5.1-0.7 1.5-0.8 1.7-1.1 1.8-2.3v-0.9l5.5-0.1c5.1-0.1 5.5-0.1 5.6-0.7 0.1-0.3-0.2-0.9-0.6-1.3s-0.6-1-0.6-1.3c0.1-0.5 0.4-0.6 1.5-0.5 0.8 0.1 1.9 0.4 2.4 0.7 0.6 0.3 1.4 0.6 1.8 0.6s1.2 0.3 1.7 0.6 1.4 0.7 2 0.8c0.9 0.2 1 0.1 1-0.4 0-0.8-4.8-5.3-7.2-6.6-0.5-0.3-1.5-0.9-2.1-1.4-1.1-0.8-1.2-0.8-5.1-0.7-3.7 0.1-4.8 0.3-8.9 1.1-2.5 0.5-2.9-0.2-1-1.5 3.4-2.2 3.2-2.3-3.6-2.3-4.3 0-5.9-0.1-7.1-0.5-1.3-0.4-3.3-0.6-10.4-0.7l-8.8-0.1-1 1.2c-0.6 0.6-1 1.4-1 1.6 0 0.3-0.6 1.5-1.3 2.8s-1.3 2.7-1.3 3.1-0.2 1.1-0.5 1.7-0.6 2.3-0.8 4.2c-0.2 3.1-0.7 5.7-1.3 7.2-0.3 0.8-0.3 0.8-0.8 0.2-0.2-0.3-0.5-1.3-0.5-2.2s-0.2-2-0.5-2.4-0.5-1.4-0.5-2.2c0-1.7-0.4-2.4-1.1-2.1-0.3 0.1-0.5 0.6-0.5 1.3 0 0.6-0.3 1.8-0.6 2.7-0.4 1-0.7 2.8-0.8 5.2-0.1 2-0.4 4.1-0.6 4.6s-0.5 3-0.6 5.4c-0.2 4.5-0.2 4.5-1 4.5-0.4 0-0.9-0.2-1-0.5s-0.5-1.1-0.9-1.9-0.7-1.7-0.7-2.1-0.3-1-0.6-1.5-0.6-1.3-0.6-1.9-0.3-1.6-0.6-2.3-0.6-1.4-0.6-1.8c0-0.3-0.1-0.8-0.3-1-0.6-0.9-1.3 0.6-1.3 3 0 1.2-0.2 2.6-0.4 3.1s-0.5 1.8-0.6 2.9-0.4 2.3-0.6 2.7-0.5 1.7-0.6 3-0.4 2.7-0.7 3.3c-0.3 0.5-0.5 1.6-0.5 2.4 0 2.5-1.5 4.9-2.3 3.7-0.2-0.2-0.3-3.1-0.3-6.4 0-3.9-0.2-6.8-0.5-8.6-0.3-1.5-0.6-4.7-0.7-7-0.2-4.5-0.5-5.8-1.7-5.8-0.9 0-1.1 1.1-0.5 3.1 0.8 2.7 0.8 14.8 0 17.3-0.3 1-0.6 2.8-0.6 4.3 0 1.9-0.2 2.8-0.6 3.8-0.4 0.7-0.6 1.9-0.6 2.8 0 0.8-0.2 1.8-0.4 2.2-0.2 0.3-0.6 1.2-0.8 1.8s-0.6 1.2-0.8 1.1c-0.6-0.2-0.6-3.7 0-8.3 0.5-3.8 0.5-4.5 0.1-5.3-0.3-0.5-0.5-2.5-0.6-4.6-0.1-2.6-0.3-3.7-0.6-3.7-0.6 0-2 2.1-2 3 0 0.4-0.3 1.3-0.6 1.9-0.3 0.7-0.9 1.9-1.3 2.8s-1 2.1-1.3 2.8-0.6 1.6-0.6 2.1-0.2 1.1-0.5 1.3-0.6 0.8-0.7 1.3c-0.2 1.1-0.7 1.5-1.2 1-0.3-0.3-0.1-4.7 0.5-8.8 0.1-0.8-1-1.1-1.6-0.3-0.2 0.3-0.4 0.9-0.4 1.3s-0.3 1.3-0.6 1.9c-0.4 0.7-0.6 1.7-0.6 2.4s-0.3 1.7-0.6 2.2c-0.4 0.6-0.6 1.4-0.6 1.9s-0.3 1.4-0.6 2.1c-0.4 0.7-0.6 1.8-0.6 2.6 0 0.9-0.2 1.8-0.6 2.2-0.3 0.4-0.6 1.7-0.8 2.9-0.3 2.7-1 4.6-1.8 4.6-0.5 0-0.6-0.4-0.8-3.8-0.1-2.1-0.4-4.2-0.6-4.7s-0.4-1.4-0.4-2.1c0-0.8-0.3-1.5-0.7-2.1-0.6-0.8-0.8-0.8-2.5-0.8-1.7 0.1-1.8 0.1-2.1 1.2-0.2 0.6-0.5 1.2-0.7 1.3s-0.5 0.8-0.6 1.5-0.4 1.6-0.7 1.9c-0.2 0.4-0.5 1-0.5 1.5 0 0.4-0.3 1.4-0.6 2.2s-0.6 1.7-0.6 2.1-0.3 1.2-0.6 1.9c-0.4 0.8-0.6 1.8-0.6 3.1 0 1-0.2 2.9-0.5 4.2s-0.6 3.2-0.7 4.3c-0.2 1.4-0.4 1.9-0.7 1.9-0.6 0-0.8-3.5-0.6-10.7 0.1-3.1 0.1-5.8 0-6-0.3-0.8-1.1-0.2-1.4 0.9-0.4 1.4-1 2.1-1.7 1.8-0.4-0.2-0.5-0.6-0.5-2.3 0-1.2-0.1-2.3-0.3-2.4-0.6-0.6-1.3 0-1.5 1.3-0.1 0.7-0.4 1.4-0.7 1.7-0.3 0.2-0.5 0.8-0.5 1.2s-0.3 1.2-0.6 1.6c-0.5 0.6-0.6 1.3-0.7 2.9 0 2.2-1.1 5.8-1.8 6-0.6 0.2-0.9-2.5-0.6-5.4 0.2-2.5-0.1-4.1-0.7-4.1-0.2 0-0.4 0.4-0.5 0.9s-0.5 1.4-0.8 2.1-0.6 1.7-0.6 2.3-0.3 1.7-0.6 2.5-0.6 1.8-0.6 2.4c0 0.5-0.3 1.3-0.6 1.8-0.4 0.6-0.6 1.7-0.7 5.1-0.2 4.5-0.5 5.3-1.3 3.5-0.9-2-2.5-1.2-2.5 1.1 0 1.3 0.8 4.2 1.9 6.5 0.3 0.7 0.7 1.6 0.9 2.1s0.5 1 0.6 1.3 0.5 0.9 0.7 1.3c0.2 0.5 0.9 1.4 1.3 2.1 0.5 0.8 0.8 1.5 0.7 1.8-0.4 1.1-0.4 1.1-4.9-3.9-1.5-1.6-2.9-2.9-3.1-2.9-0.6 0-0.6 0.5 0 1 0.3 0.2 0.5 0.7 0.5 1.1s0.3 1.1 0.6 1.5c0.4 0.4 0.7 1.3 0.8 1.9s0.4 1.6 0.6 2.2 0.5 2 0.7 3c0.1 1.1 0.4 2.3 0.7 2.8 0.2 0.5 0.4 1.7 0.4 2.6 0 2.3-0.4 2.3-3.1-0.1-1.2-1.1-2.4-1.9-2.7-1.9-0.8 0-0.7 1.3 0.1 2.3 0.4 0.4 0.6 0.9 0.6 1 0 0.3 1 2.5 1.9 4.3 0.3 0.6 0.7 1.5 0.8 2s0.4 1.1 0.7 1.4 0.5 0.7 0.5 1.1c0 0.3 0.4 1.3 0.8 2.1 0.9 1.6 1 2.9 0.4 3.1-0.2 0.1-2.6-2.1-5.4-4.9-9.2-9.2-10.2-10.1-10.7-9.6-0.3 0.2-0.5 0.5-0.5 0.7s1.1 1.4 2.4 2.8c2.4 2.5 3.2 3.5 7.4 9.9 0.4 0.6 0.7 1.3 0.7 1.5s0.3 0.7 0.6 1 0.6 0.9 0.6 1.2 0.5 1.1 1.1 1.9 1.1 1.6 1.1 1.8 0.3 0.9 0.6 1.5c0.4 0.6 0.6 1.2 0.6 1.5s0.3 0.8 0.6 1.2 0.6 1.2 0.6 1.6 0.3 1.1 0.6 1.6c0.3 0.4 0.7 1.5 0.8 2.4 0.2 1.4 0.1 1.7-0.3 1.7-0.6 0-1.4-1-3-4.1-0.7-1.3-1.5-2.8-1.8-3.4s-1.9-2.5-3.6-4.2c-1.7-1.8-3.4-3.6-3.8-4.1-0.7-0.8-0.9-0.9-1.3-0.5-0.7 0.6-0.7 1.2 0.1 2.4 0.3 0.5 0.7 1.9 0.8 3s0.4 2.4 0.6 2.9 0.5 1.5 0.6 2.4 0.4 1.9 0.7 2.3c0.6 0.9 0.8 4.3 0.2 4.5-0.2 0.1-0.7-0.4-1-1.1-2.7-5.2-3.9-7-4.7-6.7-0.5 0.2-0.5 0.5-0.4 1.5 0.1 0.7 0.5 1.7 0.8 2.3s0.6 1.4 0.6 1.9c0 0.4 0.2 1.1 0.5 1.5s0.6 1.3 0.7 2.1 0.4 1.6 0.6 1.9 0.5 1 0.6 1.7 0.4 1.3 0.7 1.5c0.2 0.2 0.5 1 0.6 1.8s0.4 1.6 0.7 1.8c0.2 0.2 0.4 0.6 0.4 0.9s0.5 1.6 1.2 2.8c1.1 2.3 1.3 3.4 0.3 3.1-0.4-0.2-4.4-4.5-7.2-7.8-0.9-1.1-1.2-1.3-2.4-1.3-1 0-1.5 0.2-2.2 1-0.9 0.9-0.9 1.1-0.8 2.8 0.1 1 0.4 2.3 0.7 2.8s0.5 1.4 0.5 1.9 0.3 1.3 0.6 1.7c0.4 0.5 0.6 1.3 0.6 2.2 0 0.8 0.1 1.5 0.3 1.6s0.5 0.7 0.7 1.4c0.5 1.6 3.1 6.9 4.4 8.9 1.1 1.7 1.3 2.4 0.6 2.4-0.6 0-2.5-2.2-3.3-3.6-0.3-0.6-1-1.7-1.6-2.5s-1.1-1.6-1.1-1.8-0.2-0.6-0.5-0.8-0.8-1.1-1.2-1.9c-0.7-1.4-2.6-3.2-2.9-2.8-0.1 0.1 0 0.8 0.3 1.5 0.9 2.6 1.3 4.1 1.1 4.3-0.5 0.5-1.7-0.4-2.7-2-0.8-1.2-1.3-1.7-1.7-1.6-0.3 0.1-0.5 0.4-0.5 0.7 0.1 1.9 0.8 5 1.2 5.9 0.3 0.5 0.5 1.2 0.5 1.5 0 0.5 1.2 2.9 3 6 0.8 1.3 0.8 1.5 0.3 1.7-0.7 0.3-2.1-1.1-4.2-4.2-1.6-2.5-2.4-3.2-2.8-2.8s-0.2 1.9 0.4 2.8c0.3 0.5 0.6 1.4 0.6 1.9s0.3 1.4 0.6 1.9 0.6 1.3 0.6 1.8 0.3 1.2 0.6 1.7c0.4 0.4 0.6 1.2 0.6 1.6s0.6 1.6 1.3 2.7 1.3 2 1.3 2.2 0.5 0.8 1.1 1.5c1.3 1.4 1.4 2.2 0.4 2.2-0.4 0-1.3-0.5-2.1-1.4-1.5-1.5-4.1-5.3-4.4-6.4-0.1-0.4-0.4-0.9-0.6-1.2s-0.5-0.9-0.6-1.4c-0.1-0.6-0.4-0.9-0.8-0.9-0.9 0-0.8 2.4 0 3.7 0.4 0.6 0.6 1.5 0.6 2.2s0.3 1.7 0.6 2.2 0.6 1.4 0.6 2 0.3 1.4 0.6 1.9c1.1 1.4 0.7 3.9-0.6 3.5-1-0.3-4.9-4.7-5.1-5.7-0.2-1.1-1.5-2.3-2.2-2.1-0.4 0.1-0.5 0.7-0.5 1.9 0 0.9-0.2 2.5-0.5 3.5-0.3 1.2-0.5 3.9-0.7 8.3-0.1 4-0.4 7.5-0.6 8.9-0.3 1.6-0.5 4.6-0.5 9.8-0.1 6.6 0 7.6 0.5 8.4 0.3 0.5 0.6 1.4 0.6 2s0.3 1.7 0.6 2.6c0.3 0.8 0.7 1.8 0.8 2.1 0.5 1.6 2.4-0.4 2.4-2.5 0-2.5 0.7-3.1 1.9-1.5 0.4 0.6 0.7 1.3 0.7 2.3 0 0.9 0.3 1.8 0.7 2.6 0.7 1.1 0.7 1.4 0.6 7.1 0 4 0 6.1 0.3 6.2 0.4 0.2 2.2-1.4 2.2-2 0-0.5 1.5-2.4 2-2.4 0.4 0 0.1 7.4-0.3 8.3-0.6 1.1-0.3 6.3 0.3 6.3 0.3 0 0.6-0.7 0.8-2.2 0.4-2.4 1.1-4.4 1.6-5 1-1 1.7 2.7 1.7 9.1v4.5c-0.1 1.4 0.5 6.1 0.8 6.7 0.2 0.4 0.5 1 0.6 1.5 0.1 0.6 0.4 0.9 0.8 0.8s0.6-0.5 0.7-1.7c0.1-0.9 0.4-2 0.7-2.4 0.3-0.5 0.6-1.4 0.6-2.2 0-2.6 2-1.9 2.4 0.8 0.1 0.8 0.5 2.1 0.8 2.8s0.6 1.6 0.6 2 0.2 1 0.4 1.4 0.5 1.4 0.7 2.1c0.1 0.8 0.4 1.7 0.7 2.1 0.2 0.4 0.5 1.5 0.7 2.4s0.4 2 0.6 2.4 0.5 1.2 0.6 2c0.1 0.7 0.4 1.5 0.6 1.7s0.5 0.8 0.6 1.5c0.1 0.8 0.5 1.3 1.1 1.6 0.5 0.3 1.2 0.8 1.7 1.2 0.8 0.8 0.8 0.9 1 6.3 0.2 4.7 0.3 5.6 0.8 6 0.8 0.6 0.9 0.6 2.9-1.3 1-0.9 3-2.7 4.4-3.8 3.2-2.6 9.4-8.5 9.4-9.1 0-0.8-0.7-0.8-2.4 0.2-1 0.5-1.9 0.9-2.1 0.8-0.6-0.3-0.4-2.7 0.3-4 0.4-0.7 0.6-1.7 0.6-2.2s0.3-1.3 0.6-1.7c0.4-0.4 0.6-1.1 0.6-1.3 0-0.8 1.5-3.3 2.8-4.7 1.1-1.1 1.2-1.9 0.3-1.9-0.2 0-0.6 0.2-0.8 0.5-0.4 0.5-1.6 0.7-1.6 0.2 0-0.1 0.4-1.2 1-2.2 0.5-1.1 1-2.2 1-2.6s0.3-1.3 0.7-2.1c1.1-2.6 0.1-2.9-2-0.6-1.6 1.7-5.2 6.5-6.7 8.8-1.1 1.7-2.4 2.5-2.8 1.8-0.2-0.3-0.1-0.7 0.2-1.2 0.3-0.4 0.5-1 0.5-1.3s0.3-1.1 0.6-1.8 0.6-1.5 0.6-1.8 0.3-0.9 0.6-1.3c0.4-0.4 0.6-1.1 0.6-1.4s0.2-0.8 0.5-1 0.9-1.2 1.5-2.1c0.5-0.9 1.2-1.8 1.4-2 0.2-0.1 0.7-0.8 1.2-1.5 0.4-0.7 1-1.6 1.4-2 1.3-1.5-0.3-2.3-1.9-0.9-1.1 0.9-3.3 1.3-3.5 0.7-0.1-0.3 0.1-0.7 0.3-1 0.3-0.3 0.5-0.9 0.5-1.2 0-0.5-0.2-0.7-1-0.6-1.8 0.1-1.9-0.7-0.2-3.2 2.1-3.2 2.1-3.3 0.3-5.4-0.9-1-1.8-2.1-2.1-2.3s-0.5-0.6-0.5-0.8-0.6-1.2-1.4-2.3-1.4-2-1.4-2.1-0.3-0.7-0.6-1.1c-0.4-0.4-0.6-1.1-0.6-1.4s-0.2-0.7-0.5-0.9-0.6-0.8-0.7-1.4-0.4-1.4-0.7-1.8c-0.7-1.1-0.7-12.2 0-13.6 0.3-0.5 0.6-1.7 0.7-2.7s0.4-2.1 0.7-2.5 0.4-1.1 0.4-1.6 0.3-1.5 0.6-2.2 0.6-1.5 0.6-1.8c0-0.7 1.5-4 2.2-4.8 0.3-0.3 0.7-0.6 1-0.6 0.6 0 1.9 1.6 1.9 2.4 0 0.3 0.3 1 0.6 1.7 1.5 2.7 3.2 6.6 3.2 7.2 0 0.3 0.3 1 0.6 1.4 0.4 0.5 0.6 1.3 0.6 2 0 0.6 0.3 1.6 0.6 2.1s0.6 1.3 0.6 1.7 0.3 1.3 0.6 2c0.4 0.7 0.6 1.7 0.6 2.3s0.3 1.5 0.6 2 0.6 1.4 0.6 2 0.2 1.2 0.5 1.4 0.6 1.1 0.7 2 0.5 2.1 0.8 2.6 0.6 1.4 0.6 1.9 0.3 1.4 0.6 2.1 0.6 1.6 0.6 2.1 0.3 1.4 0.6 2.1c0.4 0.7 0.6 1.7 0.6 2.3s0.2 1.4 0.5 1.8 0.6 1.4 0.7 2.2 0.4 1.8 0.6 2c0.2 0.3 0.5 0.9 0.6 1.3s0.4 1 0.7 1.2c0.2 0.2 0.4 0.5 0.4 0.7 0 0.5 3.2 6.9 3.5 7.1 0.2 0.1 0.3 0.5 0.3 0.8s0.3 0.9 0.6 1.2 0.7 1 0.8 1.5c0.2 1 1.5 2.7 2 2.7 0.4 0 0.7-0.8 0.7-2.1 0-1.5 0.9-4.2 1.5-4.4 0.5-0.2 1.1 0.7 1.1 1.8 0 0.4 0.2 1 0.5 1.4 0.3 0.3 0.5 1 0.5 1.6 0 1 1.2 4.9 1.7 5.6 0.5 0.6 0.9 0 1.1-1.4 0.1-0.8 0.4-1.2 0.8-1.3 1.1-0.2 1.5 0.5 1.5 2.7 0 1.3 0.2 2.5 0.6 3.4 0.3 0.8 0.6 1.9 0.6 2.4 0 0.6 0.2 1.1 0.4 1.2 0.6 0.4 1.2-0.8 1.2-2.2 0-0.8 0.2-1.3 0.5-1.4 0.8-0.3 1.7 1 1.7 2.6 0 2.5 0.7 2.8 6.2 2.9l4.3 0.1 1-0.9c1.4-1.4 3.9-5.1 3.9-5.9 0-0.4 0.3-1.3 0.6-2 0.4-0.7 0.9-1.8 1.3-2.5s0.6-1.5 0.6-1.7 0.2-0.6 0.5-0.8 0.6-0.8 0.7-1.4 0.5-1.5 0.8-2.1 0.6-1.3 0.6-1.5 0.3-0.8 0.6-1.2c0.4-0.4 0.6-1 0.6-1.2 0-0.4 1.5-2 3.7-4 1.5-1.3 3.7-4.2 3.7-4.8 0-0.2 0.2-0.8 0.5-1.4 0.3-0.5 0.7-1.6 1-2.5 0.3-0.8 0.6-1.6 0.8-1.7s0.3-0.9 0.3-1.8c0-1.8-0.5-2.3-1.8-1.4-0.4 0.3-0.9 0.5-1.1 0.5-0.3 0-2.9-5.2-3.4-6.9-0.5-1.6-1.2-1.2-1.3 0.8-0.1 2.3-0.5 2.8-1.5 1.9-0.5-0.5-0.7-1.1-0.9-2.7-0.1-1.1-0.4-2.5-0.7-3-0.4-0.8-0.5-2.1-0.5-7.5 0-5.1-0.1-6.6-0.5-7.1-0.4-0.6-0.5-0.6-0.8 0.3-0.2 0.5-0.3 1.4-0.4 2.1 0 0.6-0.2 1.5-0.5 2-0.3 0.4-0.5 1.1-0.5 1.5s-0.3 1.2-0.7 1.9-0.6 1.5-0.6 1.8-0.4 1-0.8 1.6-0.8 1.3-0.8 1.5c0 0.6-3.2 3.3-3.9 3.3-0.3 0-0.9-0.4-1.4-1-0.8-0.9-0.8-1.1-0.6-3.4 0.1-1.4 0.1-2.4-0.1-2.4-0.6 0-1.4 0.8-1.7 1.8-0.2 0.8-0.4 1-1.4 1-0.6 0-1.4-0.1-1.7-0.4-0.6-0.5-0.6-0.8-0.5-6.8 0.1-4.7 0.2-6.8 0.6-8.1 0.3-1.2 0.5-3.1 0.5-5.6 0-3.4 0-3.8-0.5-3.9-0.8-0.2-1.9 1.1-1.9 2.3 0 0.6-0.2 1.3-0.5 1.7-0.3 0.3-0.6 1.1-0.8 1.7-0.4 1.4-1.7 3.1-2.2 2.8-0.2-0.1-0.4-0.6-0.4-1.1s-0.3-1.7-0.6-2.7c-0.5-1.6-0.6-2.6-0.6-7.6 0-4-0.1-5.8-0.4-6-0.4-0.3-1.8 1.3-2.1 2.4-0.1 0.4-0.5 1.1-0.8 1.6-0.3 0.4-0.6 1-0.6 1.3 0 0.8-0.9 1.9-1.6 1.9-0.3 0-0.6 0-0.6-0.1-0.3-0.9-0.2-8.7 0-10.5 0.4-2.5 0.3-3.5-0.8-5.9-0.2-0.5-0.6-1.4-0.8-1.8-0.3-0.8-1.7-1.5-2.1-1.2-0.1 0.1-0.2 2.3-0.3 4.9s-0.3 4.9-0.5 5.1-0.6-0.2-1.1-0.8c-0.6-0.8-0.8-1.5-0.8-2.5 0-0.8-0.3-1.8-0.6-2.5-0.5-0.8-0.6-1.6-0.6-3.7 0-1.4-0.1-2.8-0.3-3.1-0.5-0.8-1.2 0.2-1.5 2.2-0.1 1-0.3 2.4-0.5 3-0.2 0.7-0.4 3.7-0.6 6.8-0.2 4.3-0.4 5.7-0.8 6.1-0.9 0.9-1.5 0.3-1.5-1.5 0-0.9-0.3-2.4-0.6-3.5-0.4-1.2-0.7-3.1-0.8-5.5s-0.3-4.1-0.7-4.9c-0.7-1.7-0.8-15.2 0-16.6 0.3-0.5 0.6-1.8 0.7-2.9 0.1-1.3 0.5-2.4 1-3.1 0.9-1.4 1-2.3 0.1-2.3-0.4 0-1.4 0.8-2.5 2-1.4 1.5-2 1.9-2.4 1.8-0.4-0.2-0.5-0.4-0.3-0.9 0.1-0.4 0.3-1.9 0.5-3.3 0.1-1.4 0.5-3.1 0.7-3.8 0.3-0.7 0.5-2.1 0.5-3.1s0.3-2.5 0.7-3.5c0.4-0.9 0.6-2.3 0.6-3.2s0.2-2.1 0.5-2.6c0.3-0.6 0.6-1.9 0.8-2.9s0.4-2.6 0.6-3.4 0.4-1.8 0.5-2.3c0.3-1.3-0.6-1.4-2.1-0.2-1.8 1.4-2.3 1.2-1.8-0.9 0.2-0.9 0.6-1.9 0.9-2.3s0.5-1 0.5-1.5 0.3-1.2 0.7-1.7c0.7-1 0.6-1.9-0.2-1.9-0.2 0-1.8 1.3-3.4 2.9s-3.1 2.9-3.4 2.9c-0.9 0-0.5-1.2 1-3.2 2.5-3.2 3.7-5 4-5.6 0.1-0.3 1-1.5 1.8-2.6 0.9-1.1 1.6-2.1 1.6-2.3s0.3-0.7 0.6-1.1 0.7-1.2 0.9-1.7c0.1-0.5 0.5-1.4 0.8-2 0.5-0.8 0.6-1.6 0.5-3.6-0.1-3.1 0.1-3.5 1.3-2.7 0.8 0.5 1 0.5 1.5 0.1 1.1-0.9 2.1-2.9 2.3-4.6 0.1-0.9 0.4-1.9 0.6-2.1 0.2-0.3 0.5-1.6 0.6-3s0.4-3.1 0.6-3.7 0.5-2.2 0.6-3.5c0.3-3.1 1.4-5 1.9-3.1 0.1 0.4 0.2 3.3 0.2 6.4s0.1 5.9 0.2 6.2c0.3 0.9 1 0.5 2.2-1.2 2-3 2.3-3.3 2.9-2.8s0.4 2.9-0.5 5.6c-0.3 1-0.6 2.6-0.6 3.6 0 1.5 0.1 1.8 0.6 1.7 0.3-0.1 0.7-0.5 0.9-1.1 0.4-1 1-2.2 2.6-4.7 0.6-0.9 1-1.8 1-2.1s0.3-1 0.6-1.5 0.7-1.4 0.8-2c0.1-0.5 0.4-1.2 0.7-1.4s0.5-0.7 0.5-1 0.3-1 0.6-1.4c0.4-0.4 0.6-1.1 0.6-1.4s0.2-0.7 0.4-0.8 0.6-0.7 0.8-1.2c0.2-0.6 1.4-2.3 2.5-3.9s2.3-3.3 2.6-3.8 1-1.6 1.7-2.5 1.7-2.3 2.4-3.3 1.5-1.8 1.7-1.8c0.8 0 0.8 1 0.2 2.4-1 2-2.3 4.9-2.3 5.3 0 0.2-0.2 0.5-0.4 0.7s-0.5 0.9-0.6 1.4c-0.1 0.6-0.4 1.3-0.7 1.5s-0.5 0.6-0.5 0.9-0.3 0.9-0.6 1.3-0.7 1.2-0.8 1.6c-0.1 0.5-0.4 1-0.7 1.2-0.2 0.2-0.4 0.8-0.5 1.2 0 0.5-0.3 1.3-0.6 1.8s-0.6 1.3-0.6 1.7-0.3 1.4-0.6 2.1c-1 2.3-2 4.8-2 5.5 0 0.3-0.2 1.2-0.5 1.9-0.3 0.8-0.6 3.3-0.8 7-0.2 3.2-0.5 6.8-0.8 8s-0.5 3.3-0.5 4.6c0 1.8-0.2 2.7-0.6 3.6-0.4 0.7-0.6 1.5-0.6 2 0 0.8 0.8 1.3 1.3 1 0.4-0.3 3.8-4.8 3.8-5.2 0-0.1 0.5-0.8 1.1-1.5 0.7-0.9 1.2-1.2 1.6-1.1 0.5 0.2 0.5 0.3 0.1 1.5-0.3 0.7-0.5 1.6-0.5 1.9s-0.2 0.9-0.4 1.3-0.5 1.4-0.7 2.3-0.4 1.8-0.7 2.1c-0.3 0.4-0.4 0.6-0.1 0.8 0.2 0.1 1.3-0.7 2.7-2.3 1.7-1.9 2.5-2.4 2.9-2.3 0.5 0.2 0.5 0.4 0.3 1.3-0.6 2.3 0 11 0.8 12.6 0.4 0.7 0.5 1.9 0.5 4.5 0 4.9 0.5 5.6 1.9 2.4 0.6-1.3 1-1.9 1.4-1.9 0.6 0 1.1 1.2 0.8 2.1-0.1 0.3 0 1.1 0.2 1.9s0.5 2.9 0.6 4.9c0.2 3.2 0.3 3.5 0.8 3.5 0.4 0 0.7-0.3 0.8-0.9 0.3-1.2 1.6-2.9 1.9-2.6 0.1 0.1 0.4 5.2 0.5 11.3 0.2 11.9 0.3 13.1 0.8 14 0.2 0.3 0.3 1 0.3 1.5s0.3 1.3 0.6 1.9c0.3 0.5 0.6 1.2 0.6 1.6s0.3 1.1 0.6 1.6 0.6 1.3 0.6 1.8 0.4 1.3 0.8 1.8c0.9 1 1.1 2.3 0.4 2.3-0.2 0-1-0.5-1.6-1.1-0.7-0.7-1.4-1.1-1.6-1-0.6 0.2-0.6 1.7 0.2 3.2 0.4 0.7 0.6 2 0.6 2.9s0.3 2.4 0.7 3.3c0.4 1.1 0.6 2.4 0.6 4.2s0.2 3 0.6 4.2c0.4 0.9 0.6 2.2 0.6 2.8 0 0.7 0.3 1.7 0.6 2.2 0.4 0.6 0.6 1.6 0.6 2.4 0 0.9 0.2 1.7 0.6 2.2 0.3 0.4 0.7 1.6 0.8 2.6s0.4 2.3 0.7 2.8 0.5 1.7 0.5 2.7 0.3 2.5 0.6 3.4c0.4 0.9 0.6 2.3 0.6 3.2s0.3 2.3 0.6 3.2 0.6 2.3 0.6 3.2 0.3 2.3 0.6 3.2c0.4 1 0.6 2.4 0.6 3.5s0.2 2.3 0.5 2.9c0.3 0.5 0.6 2.2 0.7 3.6 0.1 1.7 0.4 2.9 0.8 3.6 0.3 0.6 0.6 1.6 0.6 2.3s0.3 1.9 0.6 2.6 0.6 1.9 0.6 2.6c0 0.8 0.2 1.6 0.5 1.9s0.6 1.3 0.7 2.1c0.1 0.9 0.5 1.9 0.8 2.4 0.3 0.4 0.5 1.2 0.5 1.8s0.3 1.5 0.6 2.1c0.4 0.6 0.6 1.4 0.6 1.8s0.2 1 0.5 1.3 0.6 1.2 0.7 1.9c0.1 0.8 0.4 1.8 0.8 2.3 0.3 0.5 0.6 1.2 0.6 1.6s0.2 1 0.5 1.4 0.9 1.7 1.3 2.8c0.5 1.1 1.2 2.3 1.5 2.7s0.6 1 0.6 1.3 0.2 0.7 0.4 0.8 0.9 1.1 1.5 2.1 1.4 2.4 1.7 2.9c0.4 0.6 1.1 1.9 1.7 2.8 0.6 1 1.8 2.6 2.8 3.6 0.9 1 2.7 2.9 3.9 4.3 3.8 4.2 5.1 5.5 7.7 7.7 5.3 4.5 6 5.3 5.8 5.9-0.2 0.4-0.4 0.5-1.1 0.3-0.5-0.1-1.6-0.3-2.5-0.3-1.2 0-1.6 0.1-1.6 0.4s0.7 0.9 1.6 1.3 1.8 1 2 1.2 0.9 0.5 1.5 0.8 1.2 0.6 1.3 0.8 0.5 0.4 0.8 0.4 0.9 0.3 1.4 0.6c0.4 0.4 1.2 0.6 1.6 0.7 0.9 0 3.9 1.6 4 2.2 0.2 0.7-4.7 0.5-6.1-0.3s-3.8-0.9-3.8-0.2c0 0.8 8.2 6 9.6 6 0.8 0 1.1 0.8 0.5 1.3-0.4 0.3-1.1 0.3-3.3 0-1.6-0.2-3.1-0.3-3.3-0.2-0.8 0.3-0.2 1.1 1.4 2 0.8 0.5 2.1 1.3 2.8 1.9s1.7 1.1 2.1 1.3 1 0.4 1.2 0.7c0.2 0.2 0.5 0.4 0.7 0.4 0.3 0 3.4 1.3 4.8 2.1 0.5 0.3 1 0.5 1.3 0.5s1 0.3 1.7 0.6 1.4 0.6 1.6 0.6 0.7 0.3 1.2 0.6c0.4 0.4 1.1 0.6 1.4 0.6s1 0.3 1.4 0.6c0.4 0.4 1.2 0.6 1.8 0.6 0.5 0 1.2 0.3 1.5 0.6 0.3 0.4 0.9 0.6 1.3 0.6s1.3 0.3 1.9 0.8c0.6 0.4 1.3 0.8 1.5 0.9 0.3 0.1 0.3 0.2 0 0.6s-0.7 0.3-2.4-0.2c-1.1-0.3-2.9-0.7-3.9-0.8s-2.5-0.5-3.1-0.8c-1.3-0.6-3.6-0.7-3.9-0.2s0.3 1.1 1.9 1.9c0.7 0.4 2 1.2 2.8 1.8s1.7 1.1 2 1.1c0.6 0 2.5 1.5 2.5 2 0 0.6-1.6 0.6-2.8 0-0.9-0.5-1.9-0.7-3.4-0.7-1.6 0-2.2-0.2-2.9-0.6-0.4-0.4-1.2-0.6-1.6-0.6s-1.2-0.2-1.7-0.5c-1.8-0.9-2.4-0.4-1.1 0.9 0.9 0.9 2.7 2.2 3.2 2.2 0.2 0 1 0.6 1.8 1.3s1.7 1.3 2 1.3 0.9 0.4 1.4 0.9c0.8 0.8 0.8 1 0.4 1.3s-0.8 0.3-2.1-0.3c-1.7-0.7-3.4-0.9-3.7-0.3-0.2 0.4 1.7 2.2 2.3 2.2 0.2 0 1.2 0.6 2.2 1.3s2 1.3 2.2 1.3 0.6 0.3 0.9 0.6c0.3 0.4 0.8 0.6 1 0.6s1.2 0.6 2.1 1.3 1.7 1.3 1.9 1.3 1 0.5 1.9 1.1 1.7 1.1 1.9 1.1c0.5 0 2.3 1.6 2.3 2.1 0 0.7-1.9 0.6-3.4-0.2-2-1-4.3-0.7-4.3 0.5 0 1 9.1 9.1 10.3 9.1 0.2 0 0.9 0.3 1.5 0.6 0.7 0.3 1.4 0.7 1.8 0.8 0.3 0.1 0.5 0.4 0.5 0.7-0.1 0.5-0.5 0.5-3.3 0.4-2.4-0.1-3.4-0.3-4.2-0.7-0.5-0.3-1.3-0.6-1.6-0.6s-1-0.2-1.4-0.5-1.4-0.9-2.2-1.3-1.8-1.1-2.1-1.4c-0.4-0.3-0.9-0.6-1.2-0.6s-1.3-0.6-2.1-1.3-1.7-1.3-2-1.3c-0.2 0-0.8-0.2-1.1-0.5-1.7-1.2-0.8 0.3 2 3.5 1.9 2.1 3 3.6 2.9 4-0.1 0.8-2.2 1-2.6 0.3-0.2-0.3-0.4-0.4-0.6-0.3-0.4 0.2 1.4 2.1 2.8 2.8 1.3 0.7 4.4 2.8 6.8 4.6 0.8 0.6 1.6 1.1 1.8 1.1s0.6 0.3 0.9 0.7 0.8 0.6 1.1 0.6 0.9 0.3 1.3 0.6c0.4 0.4 1.1 0.6 1.7 0.6s1.4 0.3 2.1 0.6c1.5 0.8 3.5 0.8 4.8 0 0.6-0.4 1.3-0.6 1.6-0.6s0.8-0.2 1-0.5 1.1-0.9 2-1.4c1.8-1 7.2-6.4 8.8-8.7 1.9-2.7 2.7-1.7 1 1.4-1.4 2.7-2.9 5.7-2.9 6s-1.4 3-2 4c-0.7 1-0.7 2.5 0 2.5 0.3 0 1.1-0.4 1.8-0.8 1.2-0.8 2.6-1.1 2.6-0.5 0 0.5-1.1 2.5-2.1 3.7-0.6 0.7-1.2 1.6-1.4 1.9s-1.1 1.2-2.1 1.8c-2.7 1.7-4.4 2.8-7.2 5l-2.6 2-0.9-0.9c-0.5-0.5-0.9-1.3-1-1.8s-0.3-1-0.5-1.1c-0.6-0.2-2 2.2-2 3.3 0 1.5-0.3 2-1.1 2-0.9 0-1.4-0.8-1.4-2.2 0-0.5-0.2-1.1-0.5-1.3-0.6-0.5-1.7-0.2-1.9 0.6-0.1 0.3-0.5 1-1 1.5s-1 1.4-1.4 2c-0.3 0.6-0.8 1.5-1.1 1.9-0.8 1.1-0.8 5.1 0 6.2 0.3 0.4 0.7 1.1 0.8 1.5s0.8 1.1 1.6 1.5c1.3 0.8 1.7 0.8 5.4 0.8h4l2.2 2.4c1.2 1.3 2.5 3 2.9 3.8 2 4 1.9 3.9 4 4.1 1.1 0.1 2.3 0.4 2.7 0.6 0.6 0.4 2.9 0.5 10.1 0.6 7.6 0.1 9.5 0.3 10.6 0.7 1 0.4 2.4 0.5 6.1 0.5 6.8-1.9 7.6-2 8.6-2.5zm36.1-252.1c-0.6-0.1-2.1-0.3-3.4-0.6-2.2-0.5-4.6-0.5-6.6 0-1.2 0.3-2.5-0.3-3.5-1.6-0.9-1.1-0.9-1.2-0.9-4.9 0-2.1-0.1-4-0.1-4.3-0.1-0.3-0.7-0.8-1.3-1.2l-1.1-0.7v-6l-1.3-1.5c-0.7-0.9-1.3-1.8-1.3-2.1s-0.2-0.7-0.5-1-0.6-0.9-0.7-1.6-0.4-1.6-0.7-2.1c-0.5-0.8-0.4-1 0.7-2.9 1.4-2.3 2.3-3.4 2.9-3.4 0.5 0 0.5 0.9-0.1 1.9-0.7 1.2-0.6 1.6 1 4 1.8 2.8 3.9 5 4.8 5 0.4 0 1.2-0.5 1.8-1.1 0.9-0.9 1.3-1.1 2.4-1.1 0.7 0 1.7-0.2 2.3-0.4 0.8-0.3 1.1-0.3 2 0 0.6 0.2 1.3 0.4 1.5 0.4 0.3 0 1.3 0.7 2.3 1.6 2.3 2.1 2.9 2.3 3.9 1.9 2.3-1 4.2-2.4 7.1-5 1.6-1.5 2.9-1.8 4.4-0.9 0.4 0.3 1.2 0.6 1.6 0.9 0.4 0.2 1.1 0.6 1.4 0.9 0.5 0.4 0.7 0.4 1.6-0.5 1-0.9 1-1 0.8-3.2-0.1-1.2-0.4-2.8-0.7-3.4s-0.5-1.7-0.5-2.3-0.3-1.6-0.6-2.2c-0.7-1.2-0.9-4.1-0.2-4.1 1 0 4.1 3.7 5 6.1 0.5 1.4 0.7 2.5 0.7 5.3 0 4-0.5 5.6-2.4 8-0.6 0.7-1.1 1.5-1.1 1.7s-0.3 0.7-0.6 1.2c-0.4 0.5-0.6 1.3-0.6 1.9s-0.3 1.5-0.6 1.9c-0.4 0.4-0.6 1.2-0.6 1.6s-0.3 1.3-0.6 2c-0.9 1.6-1.9 4.1-1.9 4.6 0 0.2-0.3 0.7-0.6 1.2-0.4 0.4-0.6 1-0.6 1.2s-1 1.4-2.2 2.7l-2.2 2.3-4.6-0.1c-2.9 0.1-5.5 0-6.1-0.1zm8.1-4.2c0.6-0.3 1.5-1.1 2.1-1.7 1.3-1.4 1.2-2.6-0.2-2.9-0.5-0.1-1.3-0.3-1.8-0.5-1.7-0.6-3.2-0.7-4.5-0.1-1.6 0.7-8 1-11.3 0.5-2.2-0.3-2.5-0.3-3 0.3-0.6 0.6-0.6 0.6 0 1.8 0.4 0.8 1.2 1.5 2.2 2.2l1.6 1 6.9 0.1c6.5-0.1 7-0.1 8-0.7zm-148-20.6c0-0.6-0.2-1.9-0.5-2.8s-0.6-1.9-0.6-2.1c-0.2-0.5-1.2-0.5-1.7 0-0.5 0.6-1.4 0.8-2 0.5-0.4-0.3-0.4-0.4 0.3-4.7 0.5-2.7 0.3-3.5-0.7-3-0.8 0.4-1.1 0.2-1.9-1.3-0.5-1-0.6-1.9-0.6-5.2 0-2.2-0.1-4.2-0.2-4.5-0.3-0.8-1-0.6-1.6 0.4-1 1.8-2 1.5-2-0.6 0-0.6-0.2-1.6-0.5-2.2-0.6-1.4-0.6-2 0-3.2 0.3-0.5 0.5-1.7 0.5-2.6 0-1.4-0.1-1.7-0.6-1.9-0.4-0.1-0.6-0.4-0.6-0.7s-0.5-1.3-1-2.3c-0.9-1.6-1.1-2.3-1.4-5.2l-0.3-3.4-1-0.1c-0.9-0.1-1.1 0-1.4 0.8-0.2 0.5-0.8 1.6-1.4 2.4s-1.1 1.6-1.1 1.8c0 0.4-1.9 2.2-2.1 2s1.1-3.8 1.6-4.6c0.3-0.4 0.5-0.9 0.5-1.2s0.3-0.9 0.6-1.3c0.4-0.4 0.6-1 0.6-1.3s0.3-0.8 0.6-1.3 0.6-1 0.6-1.3 0.6-1.2 1.3-2 1.3-1.7 1.3-1.9 0.2-0.6 0.5-0.9 0.7-0.9 1-1.5c1.4-2.9 1.8-3.4 2.6-2.7 0.4 0.4 0.5 0.9 0.4 1.8-0.1 0.7-0.3 3.4-0.4 6.1s-0.2 5.5-0.3 6.3c-0.3 2.8 0.9 3 2.3 0.3 0.4-0.8 1-1.6 1.2-1.9 0.3-0.3 0.5-0.6 0.5-0.8 0-0.1 0.5-1.1 1.2-2.2 1.7-2.8 1.9-3.1 2.6-4.3 0.3-0.6 1.1-1.7 1.6-2.4s1-1.4 1-1.7 0.2-0.6 0.4-0.8c0.4-0.4 1.2-1.7 3.7-5.9 0.6-0.9 1.2-1.7 1.5-1.7 0.8 0 0.5 1.5-0.7 3.9-0.6 1.3-1.5 3-1.9 3.8s-0.8 1.9-0.8 2.3-0.3 1-0.6 1.3-0.6 0.9-0.6 1.3-0.2 0.9-0.5 1.1-0.6 0.9-0.7 1.6c-0.1 0.6-0.5 1.6-0.8 2.2-0.3 0.5-0.6 1.2-0.6 1.4s-0.3 0.8-0.6 1.2c-0.4 0.4-0.6 1.1-0.6 1.4s-0.3 1-0.6 1.4c-0.4 0.4-0.6 1-0.6 1.3s-0.3 0.7-0.6 1.1c-0.7 0.7-0.8 1.2-0.3 1.9 0.2 0.4 0.5 0.3 1.6-0.8 1.8-1.8 2.6-1.1 1.3 1.3-0.4 0.7-0.6 1.4-0.6 1.7s-0.2 0.7-0.5 0.9-0.6 0.8-0.7 1.4-0.4 1.3-0.6 1.7-0.5 1.1-0.6 1.6-0.5 1.3-0.9 1.8c-1.1 1.4-0.1 3.1 1 1.8 1.2-1.4 2.2 0.3 2.2 3.6 0 1.4 0.1 2.8 0.2 3.1 0.4 0.9 1.1 0.5 1.4-0.8 0.2-0.7 0.5-1.4 0.6-1.5 0.2-0.1 0.5-0.7 0.6-1.4 0.3-1.3 0.9-1.7 1.8-1.4 0.6 0.2 0.6 2.7 0 4-0.3 0.5-0.6 2.1-0.7 3.4-0.1 1.4-0.5 3-0.8 3.6-0.8 1.5-0.7 2.3 0.2 3.2 1.1 1 1.7 2.3 1.7 3.4 0 0.5 0.1 1.1 0.3 1.3 0.4 0.7 1.8 0.2 2.2-0.9 0.2-0.5 0.8-1.4 1.4-2s2.1-2.5 3.4-4.2c3.1-4.2 4.4-4.9 3.2-1.8-1.1 2.9-2.4 5.2-3.9 7.1-0.8 1-1.5 2-1.5 2.2s-0.6 1-1.3 1.9-1.3 1.6-1.3 1.7c0 0.3-1.4 2.2-1.8 2.5-0.2 0.1-0.6 0.2-1 0.2-0.7 0.3-0.9 0.2-0.9-0.7zm127.6-87.7c-0.5-0.6-0.9-1.3-0.9-1.5s-0.5-1.1-1.2-1.9-1.5-1.9-1.8-2.4c-0.7-1-1.6-1-2.3 0-0.7 1.1-1.7 1-2.2-0.1-0.8-1.9-1.9-3.3-2.6-3.3-0.9 0-1.3 0.5-1.5 1.8-0.1 1.3-1 1.4-2 0.3-1-1-1.3-1-1.8-0.2-0.5 0.9-0.8 0.8-2.2-0.4-1.2-1.1-3.6-2.6-3.6-2.3 0 0.1 0.1 0.4 0.3 0.7 0.2 0.4 0.2 0.7-0.1 1.1s-0.7 0.4-2 0.2c-2-0.4-2.4-0.4-4.9-0.1-1.1 0.1-2.2 0.4-2.6 0.7-2.8 2.2-4.2 2.5-5.6 1.4-0.6-0.5-1.3-0.6-2.5-0.6s-1.7-0.1-1.8-0.5c-0.2-0.6 1.2-2 2-2 0.3 0 0.9-0.3 1.3-0.6 0.4-0.4 1.2-0.6 1.6-0.6s1.1-0.2 1.4-0.5 1.4-0.6 2.4-0.7c2.1-0.2 3.5-1.2 3.7-2.6 0.2-1.2 1.8-2 3.1-1.6 0.5 0.2 1.6 0.3 2.4 0.2 1.3-0.1 1.5-0.2 2-1.3 0.7-1.4 1.4-1.5 2.3-0.5s2.3 1.6 2.6 1.2c0.4-0.7 0.2-2.2-0.5-3-0.7-0.9-0.9-1.9-0.3-2.2 0.2-0.1 1.7 1 3.4 2.5s3.2 2.7 3.3 2.7c0.7 0 1-1.3 0.7-2.7-0.5-1.8-0.4-2.4 0.1-2.6 0.6-0.2 3.3 1.6 3.8 2.5 0.2 0.4 0.8 1.2 1.4 1.8s1.3 1.7 1.7 2.6 1 2 1.3 2.7 0.6 1.5 0.6 2 0.2 1 0.5 1.2 0.6 0.9 0.7 1.6c0.1 0.6 0.5 1.8 0.8 2.6s0.6 2.4 0.7 3.5c0.2 2.2-0.3 2.5-1.7 0.9zm111 354.5c0.3-0.3 1.1-0.6 1.7-0.8s1.9-0.9 2.8-1.7l1.7-1.4v-2.1c0-1.4-0.2-2.5-0.6-3.4-0.4-0.8-0.6-2-0.6-3.4 0-1.1-0.2-2.7-0.5-3.4s-0.6-1.8-0.7-2.4-0.4-1.5-0.8-1.9c-0.3-0.4-0.6-1.2-0.6-1.6s-0.3-1.2-0.6-1.7c-0.4-0.4-0.6-1-0.6-1.2s-0.5-1.1-1.1-1.9c-2-2.7-1.2-3.6 1.2-1.2 0.8 0.7 2 2.2 2.8 3.2s1.6 1.8 1.8 1.7c0.6-0.2 0.6-1.2-0.1-2-0.4-0.5-0.7-1.1-0.7-1.4s-0.3-0.8-0.6-1.1c-0.4-0.3-0.6-0.9-0.6-1.3s-0.3-0.9-0.6-1.2c-0.4-0.3-0.6-0.8-0.6-1.1s-0.2-0.9-0.5-1.2c-0.8-1-2.7-4-3.2-5.2-0.3-0.6-0.9-1.5-1.3-1.9-0.4-0.5-1.1-1.4-1.4-2-0.8-1.5-5-5.7-7.2-7.1-1.9-1.3-2.5-1.9-2.2-2.4s2.6-0.4 3 0.1c0.2 0.3 0.9 0.5 1.7 0.5 2.3 0 6.9 3.6 8.5 6.7 2.3 4.3 6.5 8.7 7.9 8.2 0.4-0.2 0.4-0.4-0.5-2-0.5-1-1-2-1-2.2s-0.3-0.8-0.6-1.3c-0.4-0.4-0.6-1.1-0.6-1.4s-0.3-1-0.6-1.4c-0.4-0.4-0.6-1.1-0.6-1.4s-0.2-0.9-0.4-1.2c-0.8-1.1-1.3-3.3-0.9-3.7 0.3-0.3 1.9 1.2 6.9 6.1 5.2 5.1 6.7 6.5 7.3 6.4 0.4-0.1 0.8-0.3 0.8-0.4 0.1-0.2-0.9-1.3-2.1-2.6-1.2-1.2-2.6-2.7-3-3.3s-1.7-2.6-2.9-4.4-2.1-3.3-2.1-3.4-0.5-0.9-1.1-1.8-1.1-1.8-1.1-1.9-0.3-0.7-0.6-1.2c-0.4-0.4-0.6-1-0.6-1.3s-0.3-0.9-0.6-1.5-0.6-1.2-0.6-1.6-0.3-1.1-0.6-1.6c-0.7-1.1-0.9-3-0.2-3 0.5 0 2.1 2.2 2.1 2.9 0 0.3 0.2 0.7 0.5 0.9s0.9 1.2 1.5 2.1c1.3 2.3 7.1 8.3 7.7 8 0.7-0.3 0.6-1.6-0.1-2.5-0.5-0.6-0.6-1.3-0.6-2.5s-0.2-2-0.6-2.7c-0.3-0.5-0.6-1.5-0.6-2.1s-0.3-1.7-0.6-2.5c-0.7-1.5-0.8-2.8-0.3-3.1 0.3-0.2 1 0.9 2.5 3.5 0.4 0.7 1 1.6 1.3 1.9 0.3 0.4 0.7 1 0.8 1.4 0.3 1 1.3 0.8 1.4-0.3 0.1-0.5-0.2-1.3-0.5-1.8s-0.7-1.5-0.8-2.3-0.4-1.6-0.6-1.9c-0.3-0.3-0.5-1.2-0.6-1.9-0.1-0.8-0.4-1.6-0.7-1.9s-0.5-0.9-0.5-1.2-0.3-1-0.6-1.5c-0.4-0.4-0.6-1.2-0.6-1.8 0-0.5-0.3-1.3-0.6-1.8-0.4-0.4-0.6-1.1-0.6-1.4s-0.3-0.9-0.6-1.2c-0.8-0.8-1-1.6-0.5-2.3 0.4-0.5 0.5-0.5 1.5 0.5 4.6 5.2 6.5 7.1 7.2 7.2 0.4 0.1 1.3-0.1 2-0.4 1-0.5 1.3-0.8 1.3-1.7 0.1-0.6-0.1-1.2-0.2-1.4-0.2-0.2-0.3-0.8-0.3-1.3s-0.3-1.5-0.6-2.2-0.7-1.8-0.8-2.6-0.5-1.9-0.8-2.5-0.6-1.5-0.6-1.9-0.2-1.1-0.4-1.4-0.5-1-0.7-1.4c-0.1-0.4-0.8-1.5-1.5-2.4s-1.2-1.7-1.3-1.9c0-0.2-0.4-0.9-1-1.5-1-1.2-1.2-1.9-0.5-1.9 0.8 0 2 1 2.8 2.2 0.4 0.6 1.4 2 2.2 3s1.5 2 1.5 2.2c0 0.6 2.6 4.4 3.1 4.6 0.7 0.3 0.8-0.7 0.3-1.6-0.6-0.9-0.7-2-0.2-2.3 0.2-0.1 1 0.5 1.9 1.5 1.1 1.2 1.7 1.6 2.1 1.5 0.7-0.3 0.6-0.9-0.1-2.2-0.4-0.6-0.6-1.6-0.6-2.2 0-1.1-0.3-1.8-2.6-6-1.1-2.1-1.2-2.6-0.3-2.6 0.6 0 3.2 2.9 3.9 4.4 0.4 0.9 1.2 1.2 1.6 0.7 0.3-0.5 0-1.9-0.6-2.5-0.3-0.3-0.6-1.1-0.7-1.7s-0.5-1.7-0.8-2.3-0.6-1.4-0.6-1.8c0-0.3-0.3-1-0.6-1.4-0.4-0.4-0.6-1.1-0.6-1.4s-0.3-0.8-0.6-1.1c-0.4-0.3-0.6-0.8-0.6-1.1s-0.5-1-1.1-1.7c-1.3-1.4-1.4-1.7-0.6-2 0.7-0.3 3.8 3 5.3 5.8 0.1 0.2 0.4 0.7 0.6 1s0.5 1 0.8 1.6c0.6 1.2 1.4 1.4 1.5 0.3 0.1-1.3-0.1-2-0.7-3.2-0.3-0.7-0.6-1.7-0.6-2.4s-0.3-1.5-0.6-2c-0.4-0.4-0.6-1.3-0.6-1.9 0-0.7-0.4-1.7-1.3-3-1.3-1.9-1.4-2.6-0.3-2.6 0.7 0 5.6 5.4 6.3 7.1 0.3 0.8 0.8 1.2 1.1 1.2 0.5 0 0.6-0.3 0.6-2.2 0-1.5 0.2-2.8 0.6-3.9 0.4-1 0.6-2.5 0.6-3.5s0.3-2.8 0.7-4c0.6-2 0.7-2.7 0.5-8-0.1-4.4-0.3-6-0.7-7-0.3-0.7-0.5-2-0.5-3.2 0-1.4-0.2-2.5-0.6-3.5-0.4-0.8-0.6-2.1-0.6-3.1 0-0.9-0.2-2.2-0.5-2.7-0.3-0.6-0.6-2-0.7-3.3-0.1-1.4-0.4-2.6-0.8-3.2-0.3-0.5-0.6-1.6-0.6-2.3s-0.3-1.9-0.6-2.5c-0.4-0.7-0.6-1.8-0.6-2.5s-0.3-2-0.6-2.7c-0.3-0.8-0.6-2-0.6-2.8 0-0.7-0.3-1.9-0.6-2.6s-0.6-1.7-0.6-2.3-0.3-1.7-0.6-2.4c-0.4-0.7-0.6-1.7-0.6-2.2s-0.2-1.3-0.5-1.8-0.6-1.7-0.8-2.6c-0.3-1.7-1-4.5-1.7-7.2-0.2-0.7-0.5-2.2-0.6-3.3-0.2-1.1-0.5-2.4-0.8-2.9s-0.5-1.5-0.5-2.3c0-1.6-1-2.8-1.9-2.3-0.3 0.2-0.7 0.5-0.8 0.6s-0.5 0.3-0.9 0.3-1.1 0.3-1.5 0.6-1.1 0.8-1.6 1-1.4 0.8-2.1 1.2-1.6 0.9-1.9 1.1c-0.4 0.2-0.8 0.5-1.1 0.8-0.2 0.3-0.7 0.5-1 0.5s-0.9 0.3-1.4 0.6c-0.4 0.4-1 0.6-1.3 0.6s-0.8 0.3-1.3 0.6c-0.4 0.4-1.1 0.6-1.4 0.6s-0.9 0.3-1.4 0.6c-0.4 0.3-1.1 0.6-1.5 0.6s-1 0.3-1.5 0.6c-0.4 0.4-1.2 0.6-1.6 0.6s-1 0.2-1.2 0.4-1.2 0.8-2.1 1.3c-1 0.5-2 1.1-2.3 1.5-0.3 0.3-0.7 0.6-0.9 0.6s-2.1 1.6-4.2 3.6l-3.8 3.6 0.1 1.7c0.1 2.6 0.3 2.6 5.6 2.7h4.6l0.1 0.8c0.1 0.6-0.7 1.6-3.8 4.8-2.1 2.2-3.8 4.1-3.8 4.3s-0.6 1-1.3 1.9l-1.3 1.6 0.1 7.6c0.1 6.7 0.2 7.7 0.7 8.3 0.4 0.4 0.6 1.1 0.6 2.3s0.2 1.9 0.6 2.5c0.4 0.4 0.6 1.1 0.6 1.5s0.3 1.2 0.6 1.9c0.5 0.8 0.5 1.2 0.3 1.4-0.5 0.3-3.9-3.4-4.5-4.8-0.6-1.3-1.6-2.3-2.3-2s-0.6 1.4 0.2 3c0.3 0.8 0.6 1.6 0.6 1.9s0.6 1.5 1.3 2.7 1.3 2.3 1.3 2.4 0.3 0.6 0.6 0.9c0.4 0.3 0.6 0.8 0.6 1.1s0.4 1 0.8 1.6c0.9 1.2 1 2.2 0.3 2.2-0.3 0-2.5-2-4.8-4.3-2.6-2.6-4.5-4.3-4.8-4.2-0.6 0.2-0.5 1.2 0.2 3.1 0.4 0.9 0.6 2 0.6 2.5s0.3 1.3 0.6 1.7c0.4 0.4 0.6 1 0.6 1.3 0 0.2 0.4 0.9 0.8 1.5s0.8 1.2 0.8 1.4 0.6 1 1.3 1.9 1.3 1.7 1.3 1.9 0.6 1 1.2 1.8c0.7 0.8 1.6 2.1 2 2.9s0.9 1.5 1.1 1.5c0.2 0.1 0.5 0.5 0.6 0.9s0.7 1.3 1.2 2c0.6 0.7 1.4 1.9 1.8 2.6s1.3 2 2 2.8c1.2 1.5 1.4 2.5 0.5 2.5-0.2 0-3.4-3-7-6.6-3.7-3.7-6.8-6.6-7.1-6.6-0.6 0-0.4 2.8 0.2 3.7 0.5 0.8 0.7 2.8 0.2 2.8-0.2 0-0.9-0.7-1.6-1.5-1.2-1.4-1.3-1.5-1.6-0.8-0.3 0.6-0.3 1 0.3 2 0.3 0.7 0.7 2 0.8 2.8s0.4 1.9 0.8 2.4 0.7 1.2 0.7 1.7 0.2 1.2 0.4 1.6c1.1 2.1 2.1 4.4 2.1 4.8 0 0.2 0.1 0.4 0.3 0.4s0.5 0.5 0.7 1.1 0.6 1.3 0.8 1.5 0.5 0.7 0.6 1.2 0.4 1.1 0.6 1.3c0.6 0.7 0.8 1.5 0.5 1.9s-0.4 0.3-0.7-0.2c-0.2-0.3-0.9-1.2-1.5-1.9s-1.6-2-2.1-2.9-1.1-1.7-1.3-1.9-1.2-1.4-2.2-2.8c-2-2.7-3-3.5-3.3-2.6-0.1 0.3 0 1 0.3 1.5s0.6 1.5 0.7 2.3c0.1 0.7 0.4 1.5 0.6 1.8s0.5 1.1 0.6 1.8 0.4 1.5 0.7 1.7 0.5 0.6 0.5 0.9 0.4 1.2 0.8 2c0.9 1.7 1.1 3.5 0.3 3.5-0.3 0-0.6-0.4-0.8-0.9s-0.5-1.1-0.6-1.4c-0.2-0.3-0.5-0.9-0.8-1.5-0.6-1.2-3.9-4.9-4.5-4.9-0.2 0-0.5 0.2-0.6 0.5-0.2 0.6 0.3 2.9 0.7 3.1 0.2 0.1 0.4 0.7 0.5 1.3s0.4 1.3 0.7 1.5c0.2 0.2 0.5 0.8 0.7 1.3 0.1 0.5 0.4 1.1 0.7 1.3s0.5 0.6 0.5 0.9 0.7 1.9 1.5 3.5c1.1 2.2 1.4 3.1 1.1 3.4-0.5 0.5-1.3 0-2.3-1.6-0.4-0.7-1.5-2.2-2.4-3.2-2.2-2.7-4-5.2-4-5.8 0-0.2-0.3-0.8-0.6-1.3-0.4-0.4-0.6-1-0.6-1.3s-0.3-0.8-0.8-1.2c-0.4-0.4-0.8-0.9-0.9-1.1-0.1-0.3-0.3-0.3-0.5-0.2-0.3 0.2-0.3 0.4 0 0.9 0.2 0.4 0.5 1.4 0.6 2.3s0.5 2.2 0.9 2.9 0.7 1.5 0.7 1.8 0.3 1.1 0.6 1.8c0.4 0.7 0.6 1.4 0.6 1.6s0.3 0.8 0.6 1.2c0.4 0.4 0.6 1.1 0.6 1.5s0.3 1 0.6 1.3c0.4 0.3 0.6 0.8 0.6 1 0 0.3 0.2 0.9 0.5 1.4s0.4 1.1 0.3 1.5c-0.2 0.5-0.3 0.5-0.9 0-0.4-0.3-1-1.1-1.4-1.8s-1.1-1.5-1.5-1.9-1.4-1.6-2.2-2.6c-0.8-1.1-1.7-1.9-1.9-1.9-0.7 0-0.8 1.7-0.2 2.4 0.3 0.3 0.6 1.4 0.8 2.3 0.1 0.9 0.5 2.2 0.8 2.7 0.3 0.6 0.5 1.2 0.5 1.5 0 0.5-1.2 0.7-1.3 0.2-0.1-0.2-1-1.3-2.1-2.5-1.3-1.4-2.2-2.2-2.5-2.1-0.6 0.2-0.6 3 0 5.1 0.3 0.9 0.5 2.7 0.5 4 0 2.9-0.8 4.8-2.5 5.8-0.8 0.5-1.1 0.9-1.1 1.5 0 0.5-0.3 1.7-0.6 2.7-0.4 1.2-0.6 2.6-0.6 4.3 0 1.4-0.2 3.3-0.5 4.2-0.6 2-2.1 3.8-3.2 3.8-0.8 0-2.7 2-2.7 2.9 0 0.3-0.3 1.1-0.6 1.7-0.4 0.6-0.6 1.6-0.6 2.2s-0.2 1.7-0.5 2.4c-0.5 1.1-0.5 1.3 0 2.5 0.3 0.7 0.6 1.8 0.7 2.3 0.1 0.6 0.4 1.2 0.7 1.4s0.5 0.7 0.5 1c0 0.6 1.3 2.2 1.9 2.2 0.2 0 0.6-0.5 1-1.1s1.3-1.6 2.2-2.2c2-1.4 3.5-1.5 5.3-0.3 1.2 0.8 1.2 0.9 1.2 2.7 0 1.6-0.1 2-1.1 3.3-1.2 1.5-1.4 1.6-4.1 1.9-0.9 0.1-1.7 0.3-1.8 0.4-0.5 0.3-0.3 1.9 0.2 2.4 0.3 0.2 0.5 0.6 0.5 1s0.3 0.9 0.6 1.3 1 1.4 1.5 2.3c0.5 0.8 1.1 1.5 1.4 1.5s1.3-0.8 2.2-1.7c1.4-1.4 2-1.8 3.2-2 2.1-0.3 3.5 0 4.5 1.2s1 1.2 0.2 2.4c-0.3 0.5-0.6 1.2-0.6 1.6 0 0.7-1.8 2.4-2.5 2.4-1.5 0-1.7 1.7-0.4 2.9 1.6 1.5 1.8 1.4 4.2-0.9 1.9-1.8 2.4-2.1 3.4-2.1 0.7 0 1.5-0.2 1.9-0.5 0.9-0.7 1.9-0.6 3 0.3 1.3 1.1 2 2.5 1.6 3.2-0.6 1.1-3.4 2.9-5 3.3-2 0.4-1.9 2.3 0.2 2.6 0.6 0.1 1.5 0.4 2 0.7s1.5 0.5 2.3 0.5c1.2 0 1.6-0.2 2.2-0.9 0.4-0.5 0.9-1.3 1-1.7 0.1-0.5 0.9-1.5 1.7-2.3 1.5-1.5 2-1.7 4.6-1.6 1 0 2.5 2.1 2.5 3.6 0 1.1-1.1 3.5-1.8 3.9-0.2 0.1-0.4 0.5-0.4 0.9 0 0.6 0.3 0.6 6.7 0.6 3.4 0.8 4.8 0.7 5.3 0.3zm-22.7-86c-0.1-0.3-0.2-0.7 0-0.8 0.3-0.3 0.6 0.1 0.4 0.8-0.2 0.5-0.2 0.5-0.4 0zm-3.9-219.4c0.3-0.5 0.8-1.5 1.1-2.2s0.8-1.4 1-1.5c0.5-0.3 0.4-1.9-0.2-2.8-0.3-0.4-0.7-1.1-0.8-1.5s-0.4-0.7-0.5-0.7c-0.2 0-0.5-0.5-0.7-1.1-0.6-1.6-1.5-1.7-3.1-0.4-1.4 1.1-1.6 1.9-0.8 2.6 0.8 0.6 1.4 2.3 1.4 3.7 0 0.7 0.2 1.4 0.5 1.6s0.5 0.9 0.5 1.6c-0.1 1.9 0.8 2.2 1.6 0.7z"/>
                        </g>

                    </svg>
                </h3>
                <i><?php printf(esc_html__('Actualized for WooCommerce v.%s', 'woo-bulk-editor'), esc_html(WOOCOMMERCE_VERSION)) ?></i><br />


            </div>
            <?php if ($show_notes): ?>
                <?php if (time() < 1695544622): ?>
                    <div>
                        <br>
                            <a href="https://bulk-editor.com/downloads" target="_blank">
                                <img src="https://pluginus.net/wp-content/uploads/2023/09/33-percents-discount-24th-sep-2023.png" width="120" alt="33% discount until 24th september 2023" />
                            </a>
                    </div>
                <?php else: ?>
                    <div>
                        <a href="https://codecanyon.pluginus.net/item/woobe-woocommerce-bulk-editor-professional/21779835" target="_blank" class="woobe-button button"><span class="icon-upload"></span><?php esc_html_e("Upgrade", 'woo-bulk-editor') ?></a>
                    </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>



        <input type="hidden" name="woobe_settings" value="" />

        <?php if (version_compare(WOOCOMMERCE_VERSION, WOOBE_MIN_WOOCOMMERCE_VERSION, '<')): ?>

            <div id="message" class="error fade"><p><strong><?php esc_html_e("ATTENTION! Your version of the woocommerce plugin is too obsolete. There is no warranty of normal working with the plugin!!", 'woo-bulk-editor') ?></strong></p></div>

        <?php endif; ?>


        <?php //echo do_shortcode('[woobe_demo_notice]') ?>

        <div id="tabs" class="woobe-tabs woobe-tabs-style-shape">

            <nav>
                <ul>
                    <li class="tab-current">
                        <a href="#tabs-products" onclick="return woobe_init_js_intab('tabs-products')">
                            <span class="icon-book"></span>
                            <span><?php esc_html_e("Products Editor", 'woo-bulk-editor') ?></span>
                        </a>
                    </li>
                    <?php if (apply_filters('woobe_show_tabs', true, 'settings')): ?>
                        <li>
                            <a href="#tabs-settings" onclick="return woobe_init_js_intab('tabs-settings')">
                                <span class="icon-cog"></span>
                                <span><?php esc_html_e("Settings", 'woo-bulk-editor') ?></span>
                            </a>
                        </li>
                    <?php endif; ?>
                    <?php do_action('woobe_ext_panel_tabs'); //including extensions scripts        ?>

                </ul>
            </nav>

            <div class="content-wrap">

                <section id="tabs-products" class="content-current" style="/*overflow-x: scroll;*/">

                    <?php
                    $table_labels = array();
                    $edit_views = array();
                    $edit_sanitize = array();
                    $fields_types = array();
                    if (!empty($active_fields)) {
                        foreach ($active_fields as $key => $f) {
                            $title = $f['title'];
                            if (isset($f['title_static']) AND $f['title_static']) {
                                $title = $settings_fields[$key]['title'];
                            }
                            $table_labels[] = array('title' => $title, 'desc' => isset($f['desc']) ? $f['desc'] : '');
                            $edit_views[] = $f['edit_view'];
                            $edit_sanitize[] = isset($f['sanitize']) ? $f['sanitize'] : 'no';
                        }
                    }
                    $fk = $settings_fields_keys;

//***

                    if (empty($edit_views)) {
                        echo '<strong class="woobe_set_attention">' . esc_html__('Select some columns in tab "Settings"', 'woo-bulk-editor') . '</strong><br /><br />';
                    }

                    $table_labels[] = array('title' => esc_html__('Actions', 'woo-bulk-editor'), 'desc' => '');
                    WOOBE_HELPER::render_html_e(WOOBE_PATH . 'views/parts/advanced-table.php', array(
                        'table_data' => array(
                            'editable' => implode(',', $editable),
                            'default-sort-by' => $default_sortby_col_num,
                            'sort' => $default_sort,
                            'no-order' => implode(',', $no_order),
                            'per-page' => $per_page,
                            'extend_per_page' => $extend_per_page,
                            'additional' => '',
                            'start-page' => isset($_GET['start_page']) ? intval($_GET['start_page']) : 0,
                            'fields' => implode(',', $fk),
                            'edit_views' => (!empty($edit_views) ? implode(',', $edit_views) : ''),
                            'edit_sanitize' => (!empty($edit_sanitize) ? implode(',', $edit_sanitize) : ''),
                        ),
                        'table_labels' => $table_labels
                    ));
                    ?>


                    <?php if (!empty($tax_keys)): ?>
                        <div id="taxonomies_popup" style="display: none;">

                            <div class="woobe-modal woobe-modal2 woobe-style" style="z-index: 15002; width: 80%;">
                                <div class="woobe-modal-inner">
                                    <div class="woobe-modal-inner-header">
                                        <h3 class="woobe-modal-title" style="font-size: 17px;">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="woobe-modal-close woobe-modal-close1"></a>
                                    </div>
                                    <div class="woobe-modal-inner-content">
                                        <div class="woobe-form-element-container">
                                            <div class="woobe-name-description">
                                                <strong><?php echo esc_html__('Quick search', 'woo-bulk-editor') ?></strong>
                                                <span><?php echo esc_html__('Quick terms search by its name', 'woo-bulk-editor') ?></span>
                                            </div>
                                            <div class="woobe-form-element">
                                                <input type="text" class="woobe_popup_option" id="term_quick_search" value="" /><br />
                                                <a href="#" class="woobe_create_new_term button"><?php esc_html_e('create new term', 'woo-bulk-editor') ?></a>&nbsp;|&nbsp;
                                                <input type="checkbox" id="taxonomies_popup_list_checked_only" value="0" /><label for="taxonomies_popup_list_checked_only"><?php esc_html_e('selected only', 'woo-bulk-editor') ?></label>
                                                <input type="checkbox" id="taxonomies_popup_select_all_terms" value="0" /><label for="taxonomies_popup_select_all_terms"><?php esc_html_e('Select all terms', 'woo-bulk-editor') ?></label>

                                            </div>
                                        </div>

                                        <div class="woobe-form-element-container">
                                            <ul id="taxonomies_popup_list"></ul>
                                        </div>
                                    </div>
                                    <div class="woobe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="woobe-modal-close1 button button-primary button-large button-large-2"><?php echo esc_html__('Cancel', 'woo-bulk-editor') ?></a>
                                        <a href="javascript:void(0)" class="woobe-modal-save1 button button-primary button-large button-large-1"><?php echo esc_html__('Apply', 'woo-bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="woobe-modal-backdrop" style="z-index: 15001;"></div>

                        </div>
                    <?php endif; ?>

                    <?php if ($is_popupeditor): ?>
                        <div id="popupeditor_popup" style="display: none;">
                            <div class="woobe-modal woobe-modal2 woobe-style" style="z-index: 15002; width: 80%;">
                                <div class="woobe-modal-inner">
                                    <div class="woobe-modal-inner-header">
                                        <h3 class="woobe-modal-title">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="woobe-modal-close woobe-modal-close2"></a>
                                    </div>
                                    <div class="woobe-modal-inner-content">
                                        <div class="woobe-form-element-container">
                                            <div id="woobe-modal-content-popupeditor">
                                                <div class="woobe-form-element-container" style="padding: 0;">
                                                    <?php
                                                    wp_editor('', 'popupeditor', array(
                                                        'editor_height' => 325
                                                    ));
                                                    ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="woobe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="woobe-modal-close2 button button-primary button-large button-large-2"><?php echo esc_html__('Cancel', 'woo-bulk-editor') ?></a>
                                        <a href="javascript:void(0)" class="woobe-modal-save2 button button-primary button-large button-large-1"><?php echo esc_html__('Apply', 'woo-bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="woobe-modal-backdrop" style="z-index: 15001;"></div>

                        </div>
                    <?php endif; ?>

                    <?php if ($is_downloads): ?>
                        <div id="downloads_popup_editor" style="display: none;">
                            <div class="woobe-modal woobe-modal2 woobe-style" style="z-index: 15002; width: 80%;">
                                <div class="woobe-modal-inner">
                                    <div class="woobe-modal-inner-header">
                                        <h3 class="woobe-modal-title">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="woobe-modal-close woobe-modal-close3"></a>
                                    </div>
                                    <div class="woobe-modal-inner-content">
                                        <div class="woobe-form-element-container">
                                            <div id="woobe-modal-content-popupeditor">
                                                <div class="woobe-form-element-container" style="padding: 0;">
                                                    <a href="#" class="woobe-button woobe_insert_download_file" data-place="top"><?php echo esc_html__('Add File', 'woo-bulk-editor') ?></a><br />
                                                    <br />
                                                    <i><?php echo esc_html__('Files should has an allowed file type!', 'woo-bulk-editor') ?></i><br />


                                                    <div id="woobe_downloads_bulk_operations">
                                                        <div class="col-lg-12">

                                                            <select id="woobe_downloads_operations">
                                                                <option value="new"><?php esc_html_e('Replace all downloads by the selected ones', 'woo-bulk-editor') ?></option>
                                                                <option value="add"><?php esc_html_e('Add selected downloads to the already existed ones', 'woo-bulk-editor') ?></option>
                                                                <option value="delete"><?php esc_html_e('Remove selected downloads', 'woo-bulk-editor') ?></option>
                                                            </select>


                                                        </div>

                                                        <i><?php esc_html_e('For [Remove selected downloads] - enter links to downloads which should be removed.', 'woo-bulk-editor') ?></i><br />

                                                        <div class="clear"></div>
                                                    </div>

                                                    <form method="post" action="" id="products_downloads_form"></form>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="woobe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="woobe-modal-close3 button button-primary button-large button-large-2"><?php echo esc_html__('Cancel', 'woo-bulk-editor') ?></a>
                                        <a href="javascript:void(0)" class="woobe-modal-save3 button button-primary button-large button-large-1"><?php echo esc_html__('Apply', 'woo-bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="woobe-modal-backdrop" style="z-index: 15001;"></div>

                        </div>


                        <div style="display: none" id="woobe_download_file_tpl">
                            <li class="woobe_options_li">
                                <table style="width: 100%;">
                                    <tr>
                                        <td class="sort" width="1%"><div style="margin: -4px 3px 0 0; line-height: 0;"><a href="#" class="help_tip woobe_drag_and_drope" title="<?php echo esc_html__('drag and drop', 'woo-bulk-editor') ?>"><img style="vertical-align: middle;" src="<?php echo esc_attr(WOOBE_ASSETS_LINK) ?>images/move.png" alt="<?php echo esc_html__('move', 'woo-bulk-editor') ?>" /></a></div></td>
                                        <td class="file_name">
                                            <input type="text" class="input_text" placeholder="<?php esc_attr_e('File name', 'woo-bulk-editor'); ?>" name="_wc_file_names[]" value="__TITLE__" />
                                            <input type="hidden" name="_wc_file_hashes[]" value="__HASH__" />
                                        </td>
                                        <td class="file_url"><input type="text" class="input_text woobe_down_file_url" placeholder="http://product-link/" name="_wc_file_urls[]" value="__FILE_URL__" /></td>
                                        <td class="file_url_choose" width="1%"><a href="#" class="woobe-button woobe_upload_file_button" data-choose="<?php esc_attr_e('Choose file', 'woo-bulk-editor'); ?>" data-update="<?php esc_attr_e('Insert file URL', 'woo-bulk-editor'); ?>"><?php echo  esc_html__('Choose file', 'woo-bulk-editor'); ?></a></td>
                                        <td width="1%"><a href="#" class="woobe_down_file_delete woobe-button">X</a></td>
                                    </tr>
                                </table>
                            </li>
                        </div>

                    <?php endif; ?>

                    <?php if ($is_gallery): ?>
                        <div id="gallery_popup_editor" style="display: none;">
                            <div class="woobe-modal woobe-modal2 woobe-style" style="z-index: 15002; width: 80%;">
                                <div class="woobe-modal-inner">
                                    <div class="woobe-modal-inner-header">
                                        <h3 class="woobe-modal-title">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="woobe-modal-close woobe-modal-close4"></a>
                                    </div>
                                    <div class="woobe-modal-inner-content">
                                        <div class="woobe-form-element-container">
                                            <div id="woobe-modal-content-popupeditor">
                                                <div class="woobe-form-element-container" style="padding: 0;">
                                                    <a href="#" class="woobe-button woobe_insert_gall_file" data-place="top"><?php echo esc_html__('Add Image', 'woo-bulk-editor') ?></a><br />
                                                    <br />
                                                    <div id="woobe_gallery_bulk_operations">
                                                        <div class="col-lg-12">

                                                            <select id="woobe_gall_operations">
                                                                <option value="new"><?php esc_html_e('Replace all products images by the selected ones', 'woo-bulk-editor') ?></option>
                                                                <option value="add"><?php esc_html_e('Add selected images to the already existed ones', 'woo-bulk-editor') ?></option>
                                                                <option value="delete"><?php esc_html_e('Delete selected images from the products', 'woo-bulk-editor') ?></option>
                                                                <option value="delete_forever"><?php esc_html_e('Delete selected images from the products, also delete them from the media library forever', 'woo-bulk-editor') ?></option>
                                                            </select>


                                                        </div>

                                                        <div class="clear"></div>
                                                    </div>


                                                    <form method="post" action="" id="products_gallery_form"></form>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="woobe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="woobe-modal-close4 button button-primary button-large button-large-2"><?php echo esc_html__('Cancel', 'woo-bulk-editor') ?></a>
                                        <a href="javascript:void(0)" class="woobe-modal-save4 button button-primary button-large button-large-1"><?php echo esc_html__('Apply', 'woo-bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="woobe-modal-backdrop" style="z-index: 15001;"></div>

                        </div>

                        <template style="display: none;" id="woobe_gallery_li_tpl">
                            <li>
                                <img src="__IMG_URL__" alt="" class="woobe_gal_img_block" />
                                <a href="#" class="woobe_gall_file_delete"><span class="icon-trash button"></span></a>
                                <input type="hidden" name="woobe_gallery_images[]" value="__ATTACHMENT_ID__" />
                            </li>
                        </template>

                    <?php endif; ?>

                    <?php if ($is_upsells): ?>
                        <div id="upsells_popup_editor" style="display: none;">
                            <div class="woobe-modal woobe-modal2 woobe-style" style="z-index: 15002; width: 80%;">
                                <div class="woobe-modal-inner">
                                    <div class="woobe-modal-inner-header">
                                        <h3 class="woobe-modal-title">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="woobe-modal-close woobe-modal-close5"></a>
                                    </div>
                                    <div class="woobe-modal-inner-content">

                                        <div class="woobe-form-element-container">
                                            <div class="woobe-name-description">
                                                <strong><?php echo esc_html__('Search', 'woo-bulk-editor') ?></strong>
                                                <span><?php echo esc_html__('Search products by its name', 'woo-bulk-editor') ?></span>
                                            </div>
                                            <div class="woobe-form-element">
                                                <div class="products_search_container">
                                                    <input type="text" class="woobe_popup_option" id="upsells_products_search" value="" />
                                                    <div class="cssload-container" style="display: none;">
                                                        <div class="cssload-whirlpool"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="woobe-form-element-container">


                                            <br />
                                            <div id="woobe_upsells_bulk_operations">
                                                <div class="col-lg-12">

                                                    <select id="woobe_upsells_operations">
                                                        <option value="new"><?php esc_html_e('Replace all products by the selected ones', 'woo-bulk-editor') ?></option>
                                                        <option value="add"><?php esc_html_e('Add selected products to the already existed ones', 'woo-bulk-editor') ?></option>
                                                        <option value="delete"><?php esc_html_e('Remove selected products', 'woo-bulk-editor') ?></option>
                                                    </select>


                                                </div>

                                                <div class="clear"></div>
                                            </div>


                                            <form method="post" action="" id="products_upsells_form"></form>
                                        </div>
                                    </div>
                                    <div class="woobe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="woobe-modal-close5 button button-primary button-large button-large-2"><?php echo esc_html__('Cancel', 'woo-bulk-editor') ?></a>
                                        <a href="javascript:void(0)" class="woobe-modal-save5 button button-primary button-large button-large-1"><?php echo esc_html__('Apply', 'woo-bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="woobe-modal-backdrop" style="z-index: 15001;"></div>

                        </div>


                    <?php endif; ?>

                    <?php if ($is_cross_sells): ?>
                        <div id="cross_sells_popup_editor" style="display: none;">
                            <div class="woobe-modal woobe-modal2 woobe-style" style="z-index: 15002; width: 80%;">
                                <div class="woobe-modal-inner">
                                    <div class="woobe-modal-inner-header">
                                        <h3 class="woobe-modal-title">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="woobe-modal-close woobe-modal-close6"></a>
                                    </div>
                                    <div class="woobe-modal-inner-content">

                                        <div class="woobe-form-element-container">
                                            <div class="woobe-name-description">
                                                <strong><?php echo esc_html__('Search', 'woo-bulk-editor') ?></strong>
                                                <span><?php echo esc_html__('Search products by its name', 'woo-bulk-editor') ?></span>
                                            </div>
                                            <div class="woobe-form-element">
                                                <div class="products_search_container">
                                                    <input type="text" class="woobe_popup_option" id="cross_sells_products_search" value="" />
                                                    <div class="cssload-container" style="display: none;">
                                                        <div class="cssload-whirlpool"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="woobe-form-element-container">

                                            <br />
                                            <div id="woobe_crossels_bulk_operations">
                                                <div class="col-lg-12">

                                                    <select id="woobe_crossels_operations">
                                                        <option value="new"><?php esc_html_e('Replace all products by the selected ones', 'woo-bulk-editor') ?></option>
                                                        <option value="add"><?php esc_html_e('Add selected products to the already existed ones', 'woo-bulk-editor') ?></option>
                                                        <option value="delete"><?php esc_html_e('Remove selected products', 'woo-bulk-editor') ?></option>
                                                    </select>


                                                </div>

                                                <div class="clear"></div>
                                            </div>

                                            <form method="post" action="" id="products_cross_sells_form"></form>
                                        </div>
                                    </div>
                                    <div class="woobe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="woobe-modal-close6 button button-primary button-large button-large-2"><?php echo esc_html__('Cancel', 'woo-bulk-editor') ?></a>
                                        <a href="javascript:void(0)" class="woobe-modal-save6 button button-primary button-large button-large-1"><?php echo esc_html__('Apply', 'woo-bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="woobe-modal-backdrop" style="z-index: 15001;"></div>

                        </div>

                    <?php endif; ?>

                    <?php $meta_popup_editor = TRUE; //for bulk edit  ?>
                    <?php if ($meta_popup_editor): ?>
                        <div id="meta_popup_editor" style="display: none;">
                            <div class="woobe-modal woobe-modal2 woobe-style" style="z-index: 15002; width: 80%;">
                                <div class="woobe-modal-inner">
                                    <div class="woobe-modal-inner-header">
                                        <h3 class="woobe-modal-title">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="woobe-modal-close woobe-modal-close10"></a>
                                    </div>
                                    <div class="woobe-modal-inner-content">

                                        <div class="woobe-form-element-container">
                                            <div class="row" style="margin-bottom: 9px;">
                                                <div class="col-lg-10">
                                                    <div class="woobe_alert"><?php esc_html_e('REMEMBER: sequence of data maybe have sense (and maybe not), so be attentive! Do not mix in the same popup window data of array and object data!', 'woo-bulk-editor') ?></div>
                                                </div>
                                                <div class="col-lg-2">
                                                    &nbsp;<a href="https://bulk-editor.com/document/bulk-edit-of-serialized-jsoned-woocommerce-products-meta-data/" target="_blank" class="button button-primary woobe_btn_order"><span class="icon-book"></span>&nbsp;<?php echo esc_html__('Documentation', 'woo-bulk-editor') ?></a>
                                                </div>
                                            </div>

                                            <div class="clear"></div>

                                            <a href="#" class="woobe-button meta_popup_editor_insert_new" data-place="top"><?php echo esc_html__('Prepend array key/value', 'woo-bulk-editor') ?></a>&nbsp;
                                            <a href="#" class="woobe-button meta_popup_editor_insert_new_o" data-place="top"><?php echo esc_html__('Prepend object set', 'woo-bulk-editor') ?></a><br />

                                            <form method="post" action="" id="meta_popup_editor_form"></form>

                                            <a href="#" class="woobe-button meta_popup_editor_insert_new" data-place="bottom"><?php echo esc_html__('Append array key/value', 'woo-bulk-editor') ?></a>&nbsp;
                                            <a href="#" class="woobe-button meta_popup_editor_insert_new_o" data-place="bottom"><?php echo esc_html__('Append object set', 'woo-bulk-editor') ?></a><br />

                                        </div>
                                    </div>
                                    <div class="woobe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="woobe-modal-close10 button button-primary button-large button-large-2"><?php echo esc_html__('Cancel', 'woo-bulk-editor') ?></a>
                                        <a href="javascript:void(0)" class="woobe-modal-save10 button button-primary button-large button-large-1"><?php echo esc_html__('Apply', 'woo-bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="woobe-modal-backdrop" style="z-index: 15001;"></div>

                        </div>


                        <template style="display: none; padding: 7px;" id="meta_popup_editor_li">
                            <li class="woobe_options_li">
                                <a href="#" class="help_tip woobe_drag_and_drope" style="top: -14px; left: 0;" title="<?php echo esc_html__('drag and drop', 'woo-bulk-editor') ?>"><img src="<?php echo esc_attr(WOOBE_ASSETS_LINK) ?>images/move.png" alt="<?php echo esc_html__('move', 'woo-bulk-editor') ?>" /></a>
                                <small><?php esc_html_e('key', 'woo-bulk-editor') ?>:</small><input type="text" value="__KEY__" class="meta_popup_editor_li_key" name="keys[]" /><br />
                                <small><?php esc_html_e('value', 'woo-bulk-editor') ?>:</small><input type="text" value="__VALUE__" class="meta_popup_editor_li_value" name="values[]" />
                                <a href="#" class="woobe_prod_delete" style="top: 0; right: 0;"><span class="icon-trash button"></span></a>
                                __CHILD_LIST__
                            </li>
                        </template>

                        <template style="display: none; padding: 7px;" id="meta_popup_editor_li_o">
                            <li class="woobe_options_li">
                                <a href="#" class="help_tip woobe_drag_and_drope" style="top: -14px; left: 0;" title="<?php echo esc_html__('drag and drop', 'woo-bulk-editor') ?>"><img src="<?php echo esc_attr(WOOBE_ASSETS_LINK) ?>images/move.png" alt="<?php echo esc_html__('move', 'woo-bulk-editor') ?>" /></a>
                                <small><?php esc_html_e('key', 'woo-bulk-editor') ?>:</small><input type="text" value="__KEY__" class="meta_popup_editor_li_key" name="keys[]" /><br />
                                <a href="#" class="woobe_prod_delete" style="top: 0; right: 0;"><span class="icon-trash button"></span></a>
                                __CHILD_LIST__
                            </li>
                        </template>

                        <template style="display: none; padding: 7px;" id="meta_popup_editor_li_object">
                            <li class="woobe_options_li">
                                <small><?php esc_html_e('key', 'woo-bulk-editor') ?>:</small><br /><input type="text" value="__KEY__" class="meta_popup_editor_li_key meta_popup_editor_li_key2" name="keys2[]" /><br />
                                <small><?php esc_html_e('value', 'woo-bulk-editor') ?>:</small><br /><textarea style="height: 60px;" class="meta_popup_editor_li_value meta_popup_editor_li_value2" name="values2[]">__VALUE__</textarea>
                                <a href="#" class="woobe_prod_delete" style="top: 0; right: 0;"><span class="icon-trash button"></span></a>
                            </li>
                        </template>

                    <?php endif; ?>



                    <?php if ($is_grouped): ?>
                        <div id="grouped_popup_editor" style="display: none;">
                            <div class="woobe-modal woobe-modal2 woobe-style" style="z-index: 15002; width: 80%;">
                                <div class="woobe-modal-inner">
                                    <div class="woobe-modal-inner-header">
                                        <h3 class="woobe-modal-title">&nbsp;</h3>
                                        <a href="javascript:void(0)" class="woobe-modal-close woobe-modal-close7"></a>
                                    </div>
                                    <div class="woobe-modal-inner-content">

                                        <div class="woobe-form-element-container">
                                            <div class="woobe-name-description">
                                                <strong><?php echo esc_html__('Search', 'woo-bulk-editor') ?></strong>
                                                <span><?php echo esc_html__('Search products by its name', 'woo-bulk-editor') ?></span>
                                            </div>
                                            <div class="woobe-form-element">
                                                <div class="products_search_container">
                                                    <input type="text" class="woobe_popup_option" id="grouped_products_search" value="" />
                                                    <div class="cssload-container" style="display: none;">
                                                        <div class="cssload-whirlpool"></div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>

                                        <div class="woobe-form-element-container">

                                            <br />
                                            <div id="woobe_grouped_bulk_operations">
                                                <div class="col-lg-12">

                                                    <select id="woobe_grouped_operations">
                                                        <option value="new"><?php esc_html_e('Replace all products by the selected ones', 'woo-bulk-editor') ?></option>
                                                        <option value="add"><?php esc_html_e('Add selected products to the already existed ones', 'woo-bulk-editor') ?></option>
                                                        <option value="delete"><?php esc_html_e('Remove selected products', 'woo-bulk-editor') ?></option>
                                                    </select>


                                                </div>

                                                <div class="clear"></div>
                                            </div>


                                            <form method="post" action="" id="products_grouped_form"></form>
                                        </div>
                                    </div>
                                    <div class="woobe-modal-inner-footer">
                                        <a href="javascript:void(0)" class="woobe-modal-close7 button button-primary button-large button-large-2"><?php echo esc_html__('Cancel', 'woo-bulk-editor') ?></a>
                                        <a href="javascript:void(0)" class="woobe-modal-save7 button button-primary button-large button-large-1"><?php echo esc_html__('Apply', 'woo-bulk-editor') ?></a>
                                    </div>
                                </div>
                            </div>

                            <div class="woobe-modal-backdrop" style="z-index: 15001;"></div>

                        </div>

                    <?php endif; ?>

                    <?php if ($is_upsells OR $is_cross_sells OR $is_grouped): ?>
                        <template style="display: none;" id="woobe_product_li_tpl">
                            <li class="woobe_options_li">
                                <a href="#" class="help_tip woobe_drag_and_drope" title="<?php echo esc_html__('drag and drop', 'woo-bulk-editor') ?>"><img src="<?php echo esc_attr(WOOBE_ASSETS_LINK) ?>images/move.png" alt="<?php echo esc_html__('move', 'woo-bulk-editor') ?>" /></a>
                                <img src="__IMG_URL__" alt="" class="woobe_gal_img_block" />&nbsp;
                                <a href="__PERMALINK__" target="_blank"><label>__TITLE__</label></a>
                                <a href="#" class="woobe_prod_delete"><span class="icon-trash button"></span></a>
                                <input type="hidden" name="woobe_prod_ids[]" value="__ID__" />
                            </li>
                        </template>
                    <?php endif; ?>

                    <div class="row woobe-footer">
                        <div class="col-lg-3">
                            <a href="https://bulk-editor.com/document/woocommerce-products-editor/" target="_blank" class="button button-primary woobe_btn_order"><span class="icon-book"></span>&nbsp;<?php esc_html_e('Documentation', 'woo-bulk-editor') ?></a><br />
                        </div>

                        <div class="col-lg-9 tar">
                            <!-- <small><b class="red">*</b> <i class="woobe_set_attention"><?php echo esc_html__('Note: if horizontal scroll disappeared when it must be visible, click on tab Products Editor to make it visible', 'woo-bulk-editor') ?></i></small><br /> -->
                        </div>

                    </div>
                    <br />


                </section>

                <section id="tabs-settings">
                    <form id="mainform" method="post" action="">
                        <table style="width: 100%;">
                            <tr>
                                <td style="width: 65%; vertical-align: top;">
                                    <?php
                                    $fields_all = $settings_fields;
                                    $fields_all_checked = array();
                                    $fields_all_unchecked = array();

                                    foreach ($fields_all as $key => $f) {
                                        if (intval($f['show']) === 1) {
                                            $fields_all_checked[$key] = $f;
                                        } else {
                                            $fields_all_unchecked[$key] = $f;
                                        }
                                    }
                                    ?>
                                    <h4><?php printf(esc_html__('Columns settings%s, columns enabled %s', 'woo-bulk-editor'), ($show_notes ? '' : ' ' . (count($fields_all) - 1)), count($fields_all_checked) - 1) ?></h4>
                                    <ul class="woobe_fields">
                                        <li class="unsortable">
                                            <input type="text" value="" style="width: 100%;" placeholder="<?php esc_html_e('columns finder ...', 'woo-bulk-editor') ?>" id="woobe_columns_finder" /><br />
                                        </li>
                                        <?php
                                        //***
                                        //lets show selected columns on the top
                                        $columns_colors = array();
                                        foreach (array($fields_all_checked, $fields_all_unchecked) as $counter => $ff):

                                            if ($counter > 0 AND!empty($fields_all_unchecked)):
                                                ?>
                                                <li class="woobe_options_li">
                                                    <a href="#" id="show_all_columns" class="button button-primary"><?php esc_html_e('Show all columns', 'woo-bulk-editor') ?></a>
                                                </li>
                                                <?php
                                            endif;
                                            if (!empty($ff)):
                                                foreach ($ff as $key => $f) :
                                                    if (!$f['direct']) {
                                                        //continue;//fix 13-11-2020 to avoid columns hiding in free version
                                                    }
                                                    ?>
                                                    <?php if (!empty($f['title'])): ?>
                                                        <li class="woobe_options_li <?php if (isset($f['move'])): ?>unsortable<?php endif; ?>" <?php if ($counter > 0): ?>style="display: none;"<?php endif; ?>>

                                                            <div class="col-lg-6">
                                                                <div style="height: 7px;"></div>

                                                                <?php if (!isset($f['move'])): ?>
                                                                    <a href="#" class="help_tip woobe_drag_and_drope" title="<?php echo esc_html__('drag and drop', 'woo-bulk-editor') ?><?php echo ($show_notes ? ' - ' . esc_html__('premium version', 'woo-bulk-editor') : '') ?>"><img src="<?php echo esc_attr(WOOBE_ASSETS_LINK) ?>images/move.png" alt="<?php echo esc_html__('move', 'woo-bulk-editor') ?>" /></a>
                                                                <?php endif; ?>

                                                                <?php if ($f['field_type'] !== 'none'): ?>
                                                                    <?php if (isset($f['title_static']) AND $f['title_static']): ?>
                                                                        <input type="text" name="woobe_options[fields][<?php echo esc_attr($key) ?>][title]" value="<?php echo esc_html($settings_fields[$key]['title']) ?>" readonly="" class="woobe_column_li_option" /><br />
                                                                    <?php else: ?>
                                                                        <input type="text" name="woobe_options[fields][<?php echo esc_attr($key) ?>][title]" value="<?php echo esc_html($f['title'] )?>" class="woobe_column_li_option" /><br />
                                                                    <?php endif; ?>
                                                                <?php else: ?>
                                                                    <?php echo wp_kses_post($f['desc']) ?><br />
                                                                    <input type="hidden" name="woobe_options[fields][<?php echo esc_attr($key) ?>][title]" value="" /><br />
                                                                    <div style="height: 10px;"></div>
                                                                <?php endif; ?>

                                                                <br />

                                                                <?php if (!in_array($key, array('__checker', 'ID')) AND in_array($current_user_role, apply_filters('woobe_permit_special_roles', ['administrator']))): ?>
                                                                    <?php if ($show_notes): ?>
                                                                        <input type="checkbox" value="1" checked="" disabled="" class="shop_manager_visibility" data-key="<?php echo esc_attr($key) ?>" readonly="" />&nbsp;<label><?php esc_html_e('visible for the shop manager', 'woo-bulk-editor') ?></label>
                                                                        <input type="hidden" name="woobe_options[fields][<?php echo esc_attr($key) ?>][shop_manager_visibility]" value="1" />
                                                                        <br /><small class="woobe-free-version">(<?php esc_html_e('premium version', 'woo-bulk-editor') ?>)</small>
                                                                    <?php else: ?>                                                                           

                                                                        <input type="checkbox" value="1" <?php checked($f['shop_manager_visibility']) ?> class="shop_manager_visibility" data-key="<?php echo esc_attr($key) ?>" id="shop_manager_visibility_<?php echo esc_attr($key) ?>" />&nbsp;
																		<label for="shop_manager_visibility_<?php echo esc_attr($key) ?>">
																			<?php esc_html_e('visible for the shop manager', 'woo-bulk-editor') ?>
																		</label>
                                                                        <input type="hidden" name="woobe_options[fields][<?php echo esc_attr($key) ?>][shop_manager_visibility]" value="<?php echo esc_attr($f['shop_manager_visibility']) ?>" />
																		
                                                                    <?php endif; ?>

                                                                    <br />
                                                                <?php endif; ?>
                                                            </div>


                                                            <div class="col-lg-3">

                                                                <?php
                                                                $col_color = '';
                                                                $txt_color = '';
                                                                $font_size = 14;

                                                                if (isset($options['fields'][$key]['col_color'])) {
                                                                    $col_color = $options['fields'][$key]['col_color'];
                                                                }

                                                                if (isset($options['fields'][$key]['txt_color'])) {
                                                                    $txt_color = $options['fields'][$key]['txt_color'];
                                                                }

                                                                if (isset($options['fields'][$key]['font_size'])) {
                                                                    $font_size = $options['fields'][$key]['font_size'];
                                                                }

                                                                $columns_colors[$key] = array(
                                                                    'col_color' => $col_color,
                                                                    'txt_color' => $txt_color,
                                                                    'font_size' => $font_size
                                                                );
                                                                ?>
                                                                <div class="woobe_column_color_pickers">
                                                                    <input type="text" name="woobe_options[fields][<?php echo esc_attr($key) ?>][col_color]" value="<?php echo esc_html($col_color) ?>" class="woobe-color-picker" />
                                                                    <input type="text" name="woobe_options[fields][<?php echo esc_attr($key) ?>][txt_color]" value="<?php echo esc_html($txt_color) ?>" class="woobe-color-picker" />
                                                                    <input type="number" name="woobe_options[fields][<?php echo esc_attr($key) ?>][font_size]" placeholder="<?php esc_html_e('cell text or number size', 'woo-bulk-editor') ?>" value="<?php echo esc_html($font_size) ?>" />
                                                                </div>


                                                            </div>

                                                            <?php if (isset($f['move'])): ?>
                                                                <!-------------------- always visible and not switchable ----------------------------->
                                                                <input type="hidden" value="1" name="woobe_options[fields][<?php echo esc_attr($key) ?>][show]" />
                                                            <?php else: ?>
                                                                <div class="col-lg-2 tar">

                                                                    <?php WOOBE_HELPER::draw_advanced_switcher_e(intval(isset($active_fields[$key])), $key, 'woobe_options[fields][' . $key . '][show]', array('true' => '', 'false' => ''), array('true' => 1, 'false' => 0), 'woobe_fshow_' . $key); ?>

                                                                </div>
                                                            <?php endif; ?>



                                                            <div class="col-lg-1 tar">
                                                                <?php if (isset($f['desc'])/* AND $f['field_type'] !== 'none' */): ?>
                                                                    <div class="woobe_options_li_desc">
                                                                        <br />
                                                                        <div class="settings-icon"><?php WOOBE_HELPER::draw_tooltip($f['desc']); ?></div>
                                                                    </div>
                                                                <?php endif; ?>
                                                            </div>

                                                            <div class="clear"></div>

                                                        </li>
                                                    <?php endif; ?>
                                                <?php endforeach; ?>
                                            <?php endif; ?>


                                        <?php endforeach; ?>


                                    </ul>


                                    <br />

                                    <input type="submit" class="button button-primary button-primary" value="<?php echo esc_html__('Save all settings', 'woo-bulk-editor') ?>" />


                                </td>
                                <td style="width: 35%; vertical-align: top; padding-left: 7px;">
                                    <h4 class="woobe-documentation"><a href="https://bulk-editor.com/document/settings/" target="_blank" class="button button-primary"><span class="icon-book"></span></a>&nbsp;<?php esc_html_e('General settings', 'woo-bulk-editor') ?></h4>
									<?php
									$admin_settings = array('sync_profiles', 'vendor_roles'); 
									?>
                                    <?php foreach ($total_settings as $k => $o) : ?>
                                        <?php
                                        if (in_array($k, $admin_settings) && !in_array($current_user_role, apply_filters('woobe_permit_special_roles', ['administrator']))) {
                                            continue;
                                        }
                                        ?>
                                        <div class="woobe-control-section">
                                            <h5><?php echo esc_html($o['title']) ?></h5>
                                            <div class="woobe-control-container">
                                                <div class="woobe-control" style="width: 80%;">

                                                    <?php
                                                    switch ($o['type']) {
                                                        case 'select':
                                                            ?>
                                                            <div class="select-wrap">
                                                                <select name="woobe_options[options][<?php echo esc_attr($k) ?>]">
                                                                    <?php foreach ($o['select_options'] as $kk => $vv) : ?>
                                                                        <option <?php selected($kk == $o['value']) ?> value="<?php echo esc_attr($kk) ?>"><?php echo esc_html($vv['title']) ?></option>
                                                                    <?php endforeach; ?>
                                                                </select>
                                                            </div>
                                                            <?php
                                                            break;

                                                        case 'number':
                                                            ?>


                                                            <?php if ($show_notes): ?>
                                                                <input type="number" readonly="" value="<?php echo esc_html($o['value']) ?>" />
                                                                <br /><small class="woobe-free-version">(<?php esc_html_e('premium version', 'woo-bulk-editor') ?>)</small>
                                                            <?php else: ?>
                                                                <input type="number" name="woobe_options[options][<?php echo esc_attr($k) ?>]" value="<?php echo esc_html($o['value']) ?>" />
                                                            <?php endif; ?>
                                                            <?php
                                                            break;

                                                        default:
                                                            //textinput
                                                            ?>
                                                            <input type="text" name="woobe_options[options][<?php echo esc_attr($k) ?>]" value="<?php echo esc_html($o['value']) ?>" />
                                                            <?php
                                                            break;
                                                    }
                                                    ?>

                                                </div>
                                                <div class="woobe-description" style="width: auto; float: left;">
                                                    <p class="description"><?php WOOBE_HELPER::draw_tooltip($o['desc']) ?></p>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>


                                    <div style="margin-left: 10px; overflow: hidden;">

                                        <div class="col-lg-6">
                                            <input type="submit" class="button button-primary button-primary" value="<?php echo esc_html__('Save all settings', 'woo-bulk-editor') ?>" />
                                        </div>
                                        <div class="col-lg-6 tar">
                                            <a href="https://bulk-editor.com/document/more-settings-implicit/" target="_blank" class="button button-primary"><?php esc_html_e('More settings (implicit)', 'woo-bulk-editor') ?></a><br />
                                        </div>

                                    </div>


                                </td>
                            </tr>
                        </table>
						<input type="hidden" id="woobe_mainform_nonce" value="<?php echo  esc_attr(wp_create_nonce( 'woobe_mainform_nonce' )); ?>">
                    </form>
                </section>


                <!--------------------------------- taxonomies terms data ---------------------------------------------->
                <div style="display: none;">
                    <div id="taxonomies_popup_list_li_tpl">
                        <li data-search-value="__SEARCH_TXT__" class="quick_search_element __TOP_LI__">
                            <div class="quick_search_element_container">
                                <input type="checkbox" __CHECK__ name="woobe_tax_terms[]" value="__TERM_ID__" id="term___TERM_ID__">&nbsp;
									<label for="term___TERM_ID__">__LABEL__</label>
									<span class="dashicons dashicons-trash delete_tax_terms" data-term_id="__TERM_ID__"></span>
									<span class="edit_tax_terms" data-term_id="__TERM_ID__">
										<?php esc_html_e('Edit', 'woo-bulk-editor'); ?>															
									</span>
									
									<br>
                                        </div>
                                        __CHILDS__
                                        </li>
                                        </div>
                                        </div>



                                        <script>
                                            var taxonomies_terms = {};

<?php if (!empty($tax_keys)): ?>
    <?php foreach ($tax_keys as $tax_key) : ?>

                                                    taxonomies_terms['<?php echo esc_attr($tax_key) ?>'] =<?php echo json_encode(WOOBE_HELPER::get_taxonomies_terms_hierarchy($tax_key)) ?>;

    <?php endforeach; ?>
<?php endif; ?>



<?php if (!empty($attribute_keys)): ?>
    <?php foreach ($attribute_keys as $tax_key) : ?>

                                                    taxonomies_terms['<?php echo esc_attr($tax_key) ?>'] =<?php echo json_encode(WOOBE_HELPER::get_taxonomies_terms_hierarchy($tax_key)) ?>;

    <?php endforeach; ?>
<?php endif; ?>


                                            var woobe_active_fields =<?php echo json_encode($settings_fields_full) ?>;
                                        </script>



                                        <?php do_action('woobe_ext_panel_tabs_content'); //including extensions scripts         ?>


                                        <div class="clear"></div>

                                        </div>

                                        </div>


                                        </section><!--/ .woobe-section-->
                                        <div class="made_by">
                                            <br>
                                            <a href="https://pluginus.net/" target="_blank">Created by PluginUs.NET</a><br />
                                            <br>
                                        </div>
                                        <div class="clear"></div>

                                        <div id="woobe_buffer" style="display: none;"></div>

                                        <div id="woobe_html_buffer" class="woobe_info_popup" style="display: none;"></div>


                                        <!-------------------------------- advanced panel popups ------------------------------------------->

                                        <div id="woobe_tools_panel_profile_popup" style="display: none;">
                                            <div class="woobe-modal woobe-modal2 woobe-style" style="z-index: 15002; width: 80%; height: 320px;">
                                                <div class="woobe-modal-inner">
                                                    <div class="woobe-modal-inner-header">
                                                        <h3 class="woobe-modal-title"><?php esc_html_e('Columns profile', 'woo-bulk-editor') ?></h3>
                                                        <a href="javascript:void(0)" class="woobe-modal-close woobe-modal-close8"></a>
                                                    </div>
                                                    <div class="woobe-modal-inner-content">

                                                        <div class="woobe-form-element-container">
                                                            <div class="woobe-name-description">
                                                                <strong><?php echo esc_html__('Columns profiles', 'woo-bulk-editor') ?></strong>
                                                                <span><?php echo esc_html__('Here you can load previously saved columns profile. After pressing on the load button, page reloading will start immediately!', 'woo-bulk-editor') ?></span>

                                                                <?php if (isset($current_profile['title'])): ?>
                                                                    <span class="current_profile_disclaimer"><?php
																	    esc_html_e('Current profile is:', 'woo-bulk-editor');
																		echo esc_html( " " . $current_profile['title']);
                                                                        WOOBE_HELPER::draw_link_e(array(
                                                                                    'href' => $current_profile['key'],
                                                                                    'title' => WOOBE_HELPER::draw_image(WOOBE_ASSETS_LINK . 'images/delete.png', '', '', 15),
                                                                                    'class' => 'woobe_delete_profile',
                                                                                    'title_attr' => esc_html__('remove current columns profile', 'woo-bulk-editor')
                                                                                ))
                                                                        ?>
																	</span>
                                                                <?php endif; ?>

                                                            </div>
                                                            <div class="woobe-form-element">
                                                                <div class="products_search_container">
                                                                    <select id="woobe_load_profile">
                                                                        <option value="0"><?php esc_html_e('Select profile to load', 'woo-bulk-editor') ?></option>
                                                                        <?php foreach ($profiles as $pkey => $pvalue) : ?>
                                                                            <option <?php selected((isset($current_profile['key']) ? $current_profile['key'] === trim($pkey) : false)) ?> value="<?php echo esc_attr($pkey) ?>"><?php echo esc_html($pvalue['title']) ?></option>
                                                                        <?php endforeach; ?>
                                                                    </select>
                                                                    <div class="cssload-container" style="display: none;">
                                                                        <div class="cssload-whirlpool"></div>
                                                                    </div><br />

                                                                    <div style="display: none;"  id="woobe_load_profile_actions">
                                                                        <a href="javascript:void(0)" class="button button-primary button" id="woobe_load_profile_btn"><?php esc_html_e('load', 'woo-bulk-editor') ?></a>&nbsp;
                                                                        <a href="#" class="button button-primary button woobe_delete_profile"><?php esc_html_e('remove', 'woo-bulk-editor') ?></a>
                                                                    </div>

                                                                </div>
                                                            </div>
                                                        </div>

                                                        <div class="woobe-form-element-container">
                                                            <div class="woobe-name-description">
                                                                <strong><?php echo esc_html__('New Profile', 'woo-bulk-editor') ?></strong>
                                                                <span><?php echo esc_html__('Here you can type any title and save current columns set and their order. Type here any title and then press Save button OR press Enter button on your keyboard!', 'woo-bulk-editor') ?></span>
                                                            </div>
                                                            <div class="woobe-form-element">
                                                                <div class="products_search_container">
                                                                    <input type="text" value="" id="woobe_new_profile" />
                                                                </div>
                                                            </div>
                                                        </div>

                                                        <!-- <div class="woobe-form-element-container"></div> -->
                                                    </div>
                                                    <div class="woobe-modal-inner-footer">
                                                        <a href="javascript:void(0)" class="button button-primary button-large button-large-1"  id="woobe_new_profile_btn"><?php echo esc_html__('Create', 'woo-bulk-editor') ?></a>
                                                        <a href="javascript:void(0)" class="woobe-modal-close8 button button-primary button-large button-large-2"><?php echo esc_html__('Close', 'woo-bulk-editor') ?></a>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="woobe-modal-backdrop" style="z-index: 15001;"></div>

                                        </div>


                                        <div id="woobe_new_term_popup" style="display: none;">
                                            <div class="woobe-modal woobe-modal2 woobe-style" style="z-index: 16004 !important; width: 80%; height: 320px; overflow: visible;">
                                                <div class="woobe-modal-inner">
                                                    <div class="woobe-modal-inner-header">
                                                        <h3 class="woobe-modal-title" style="font-size: 19px;"><?php printf(esc_html__('Term new/update for [%s]', 'woo-bulk-editor'), '<span></span>') ?></h3>
                                                        <a href="javascript:void(0)" class="woobe-modal-close woobe-modal-close9"></a>
                                                    </div>
                                                    <div class="woobe-modal-inner-content" style="overflow: visible;">

                                                        <div class="woobe-form-element-container">
                                                            <div class="woobe-name-description">
                                                                <strong><?php echo esc_html__('New Term(s)', 'woo-bulk-editor') ?></strong>
                                                                <span><?php echo esc_html__('Here you can write title for the new term. Use comma to create some new tags on the same time! New terms with already existed names will not be created!', 'woo-bulk-editor') ?></span>
                                                            </div>
                                                            <div class="woobe-form-element">
                                                                <input type="text" value="" id="woobe_new_term_title" style="width: 100%;" />
                                                            </div>
                                                        </div>


                                                        <div class="woobe-form-element-container">
                                                            <div class="woobe-name-description">
                                                                <strong><?php echo esc_html__('Slug(s) of the new term', 'woo-bulk-editor') ?></strong>
                                                                <span><?php echo esc_html__('Here you can write slug for the the new term (optionally). Use comma for slug(s) when you create some on the same time terms, or leave slug field empty to create slug(s) automatically', 'woo-bulk-editor') ?></span>
                                                            </div>
                                                            <div class="woobe-form-element">
                                                                <input type="text" value="" id="woobe_new_term_slug" style="width: 100%;" />
                                                            </div>
                                                        </div>

                                                        <div class="woobe-form-element-container">
                                                            <div class="woobe-name-description">
                                                                <strong><?php echo esc_html__('Description', 'woo-bulk-editor') ?></strong>
                                                                <span><?php echo esc_html__('The description is not prominent by default; however, some themes may show it.', 'woo-bulk-editor') ?></span>
                                                            </div>
                                                            <div class="woobe-form-element">
                                                                <textarea  id="woobe_new_term_description" style="width: 100%;" /></textarea>
                                                            </div>
                                                        </div>

                                                        <div class="woobe-form-element-container">
                                                            <div class="woobe-name-description">
                                                                <strong><?php echo esc_html__('Parent of the new term(s)', 'woo-bulk-editor') ?></strong>
                                                                <span><?php echo esc_html__('Here you can select parent for the the new term (optionally)', 'woo-bulk-editor') ?></span>
                                                            </div>
                                                            <div class="woobe-form-element">
                                                                <select id="woobe_new_term_parent"></select>
                                                            </div>
                                                        </div>

                                                    </div>
                                                    <div class="woobe-modal-inner-footer">
                                                        <a href="#" class="button button-primary button-large button-large-1" id="woobe_new_term_create"><?php echo esc_html__('Create', 'woo-bulk-editor') ?>/<?php echo esc_html__('Update', 'woo-bulk-editor') ?></a>
                                                        <a href="javascript:void(0)" class="woobe-modal-close9 button button-primary button-large button-large-2"><?php echo esc_html__('Cancel', 'woo-bulk-editor') ?></a>
                                                    </div>
                                                </div>
                                            </div>

                                            <div class="woobe-modal-backdrop" style="z-index: 16003;"></div>

                                        </div>

                                        <?php do_action('woobe_page_end') ?>


                                        <div class="external-scroll_wrapper">
                                            <div class="external-scroll_x">
                                                <div class="scroll-element_outer">
                                                    <div class="scroll-element_size"></div>
                                                    <div class="scroll-element_track"></div>
                                                    <div class="scroll-bar"></div>
                                                </div>
                                            </div>
                                        </div>

                                        </div>



                                        <?php if ($show_notes): ?>
                                            <hr />

                                            <table style="width: 100%;">
                                                <tr>

                                                    <td style="width: 25%;">
                                                        <h4 style="color: tomato;"><?php esc_html_e("UPGRADE TO FULL VERSION", 'woo-bulk-editor') ?>:</h4>
                                                        <a href="https://bulk-editor.com/a/buy" target="_blank"><img src="<?php echo esc_attr(WOOBE_LINK) ?>assets/images/bear_banner.png" style="width: 100%" alt="<?php esc_html_e("BEAR - WooCommerce Bulk Editor Professional", 'woo-bulk-editor'); ?>" /></a>
                                                    </td>

                                                    <td style="width: 25%;">
                                                        <h4 style="color: tomato;"><?php esc_html_e("WPBE - WordPress Posts Bulk Editor", 'woo-bulk-editor') ?></h4>
                                                        <a href="https://codecanyon.pluginus.net/item/wordpress-posts-bulk-editor-professional/24376112" target="_blank"><img src="<?php echo esc_attr(WOOBE_LINK) ?>assets/images/wpbe_banner.png" style="width: 100%" alt="<?php esc_html_e("WPBE - WordPress Posts Bulk Editor Professional", 'woo-bulk-editor'); ?>" /></a>
                                                    </td>

                                                    <td style="width: 25%;">
                                                        <h4><?php esc_html_e("WooCommerce Currency Switcher", 'woo-bulk-editor') ?></h4>
                                                        <a href="https://codecanyon.pluginus.net/item/woocommerce-currency-switcher/8085217" target="_blank"><img style="width: 100%" src="<?php echo esc_attr(WOOBE_LINK) ?>assets/images/woocs_banner.png" alt="<?php esc_html_e("WooCommerce Currency Switcher", 'woo-bulk-editor'); ?>" /></a>
                                                    </td>

                                                    <td style="width: 25%;">
                                                        <h4><?php esc_html_e("WooCommerce Products Filter", 'woo-bulk-editor') ?></h4>
                                                        <a href="https://codecanyon.pluginus.net/item/woof-woocommerce-products-filter" target="_blank"><img style="width: 100%" src="<?php echo esc_attr(WOOBE_LINK) ?>assets/images/woof_banner.png" alt="<?php esc_html_e("WOOF - WooCommerce Products Filter", 'woo-bulk-editor'); ?>" /></a>
                                                    </td>

                                                </tr>
                                            </table>
                                        <?php endif; ?>



                                        <?php if (!empty($columns_colors)): ?>

                                            <style type="text/css">

                                                <?php foreach ($columns_colors as $key => $colors) : ?>

                                                    <?php if (!empty($colors['col_color'])): ?>
                                                        td[data-field="<?php echo esc_attr($key) ?>"] {
                                                            background-color: <?php echo esc_attr($colors['col_color']) ?>;
                                                        }
                                                    <?php endif; ?>


                                                    <?php if (!empty($colors['txt_color'])): ?>
                                                        td[data-field="<?php echo esc_attr($key) ?>"] {
                                                            color: <?php echo esc_attr($colors['txt_color']) ?> !important;
                                                        }

                                                        td[data-field="<?php echo esc_attr($key) ?>"] select,
                                                        td[data-field="<?php echo esc_attr($key) ?>"] li.search-choice span,
                                                        td[data-field="<?php echo esc_attr($key) ?>"] li.woobe_li_tag,
                                                        td[data-field="<?php echo esc_attr($key) ?>"] .woobe-button,
                                                        td[data-field="<?php echo esc_attr($key) ?>"] input.woobe_calendar,
                                                        td[data-field="<?php echo esc_attr($key) ?>"] .woobe_btn_gal_block{
                                                            color: <?php echo esc_attr($colors['txt_color']) ?> !important;
                                                        }
                                                    <?php endif; ?>


                                                    <?php if (!empty($colors['font_size'])): ?>
                                                        td[data-field="<?php echo esc_attr($key) ?>"] {
                                                            font-size: <?php echo esc_attr($colors['font_size']) ?>px !important;
                                                        }
                                                    <?php endif; ?>

                                                <?php endforeach; ?>

                                            </style>

                                            <?php
                                        endif;
                                        ?>