<?php

/**
 * The interface for the ID column.
 *
 * @since 3.0.0
 *
 * @package \TEC\Common\StellarWP\Schema\Columns
 */
declare (strict_types=1);
namespace TEC\Common\StellarWP\Schema\Columns;

/**
 * Class ID
 *
 * @since 3.0.0
 *
 * @package \TEC\Common\StellarWP\Schema\Columns
 */
class ID extends Integer_Column
{
    /**
     * Whether the column is signed.
     *
     * @var bool
     */
    protected bool $signed = false;
    /**
     * Whether the column is auto increment.
     *
     * @var bool
     */
    protected bool $auto_increment = true;
    /**
     * Whether the column is a primary key.
     *
     * @var bool
     */
    protected bool $is_primary_key = true;
}