<?php

function iq_team_widgets()
{
	register_widget('Iqonic_team');
}
add_action('widgets_init', 'iq_team_widgets');

/*-------------------------------------------
		iqonic Team 
--------------------------------------------*/
class Iqonic_team extends WP_Widget
{
	function __construct()
	{
		parent::__construct(

			// Base ID of your widget
			'Iqonic_Team',

			// Widget name will appear in UI
			esc_html('Iqonic Team', 'iqonic-extension'),

			// Widget description
			array('description' => esc_html('Team members ', 'iqonic-extension'),)

		);
		//Add styles
		wp_enqueue_style('iq-owl-carousel', IQONIC_EXTENSION_PLUGIN_URL . 'includes/assets/css/owl.carousel.min.css');

		//Register scripts. this sample depends on jquery
		wp_enqueue_script('iq-owl-carousel', IQONIC_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/js/owl.carousel.min.js', array('jquery'), true);
		wp_enqueue_script('iq-widget-custom', IQONIC_EXTENSION_PLUGIN_URL . 'includes/assets/js/custom.js', array('jquery'), true);
	}
	// Creating widget front-end
	public function widget($args, $instance)
	{
		if (!isset($args['widget_id'])) {
			$args['widget_id'] = $this->id;
		}

		$title  = (!empty($instance['title'])) ? $instance['title'] : esc_html('Team', 'iqonic-extension');
		$title  = apply_filters('widget_title', $title, $instance, $this->id_base);
		$number = (!empty($instance['number'])) ? absint($instance['number']) : 5;
		if (!$number) {
			$number = 5;
		}

		$title_tag = empty($instance['title_tag']) ? 'h6' : $instance['title_tag'];;
		$show_image = isset($instance['show_image']) ? $instance['show_image'] : false;
		$show_name = isset($instance['show_name']) ? $instance['show_name'] : false;
		$show_slider = isset($instance['show_slider']) ? $instance['show_slider'] : false;
		$iq_image = isset($instance['powerhour-image']) ? $instance['powerhour-image'] : '';
        ?>

		<div class="powerhour-widget-menu powerhour-team-slider powerhour-team-sidebar widget ">
			<div class="list-inline powerhour-widget-menu">
				<div class="owl-carousel powerhour-post">
					<?php
					$args = array('post_type' => 'team', 'posts_per_page' => $number,);
					$loop = new WP_Query($args);
					while ($loop->have_posts()) : $loop->the_post();
					   ?>
							<div class="post-img">
									<div class="post-img-holder">
										<img class="img-fluid" src="<?php echo get_the_post_thumbnail_url($loop->ID); ?>" alt="Team-Member">
									</div>
								<div class="post-blog">
									<div class="blog-box">
											<h5 class="powerhour_post_title">
												<?php the_title(); ?>
											</h5>
								    </div>
									<div class="designation">
										<?php echo get_field('iqonic_designation');?>
									</div>
							    </div>
						    </div>
					    <?php
					endwhile;
					wp_reset_postdata();
					?>
				</div>
			</div>
		</div>
	<?php
	}

	// Widget Backend
	public function form($instance)
	{
		$title     = isset($instance['title']) ? esc_attr($instance['title']) : '';
		$number    = isset($instance['number']) ? absint($instance['number']) : 5;
		$title_tag = $instance['title_tag'];
		$show_image= isset($instance['show_date']) ? (bool) $instance['show_date'] : false;
		$show_name = isset($instance['show_name']) ? (bool) $instance['show_name'] : false;
		$show_slider = isset($instance['show_slider']) ? (bool) $instance['show_slider'] : false;

		if (isset($instance['powerhour-image'])) {
			$iq_image = $instance['powerhour-image'];
				if ($iq_image == "image") {
					$ch_image = "checked";
				}
		}
	?>
		
<?php
	}
	// Updating widget replacing old instances with new
	public function update($new_instance, $old_instance)
	{
		$instance = array();
		$instance['title'] = sanitize_text_field($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];

		$instance['title_tag'] = $new_instance['title_tag'];
		$instance['show_image'] = isset($new_instance['show_image']) ? (bool) $new_instance['show_image'] : false;
		$instance['show_name'] = isset($new_instance['show_name']) ? (bool) $new_instance['show_name'] : false;
		$instance['show_slider'] = isset($new_instance['show_slider']) ? (bool) $new_instance['show_slider'] : false;
		$instance['powerhour-image'] = isset($new_instance['powerhour-image']) ? (bool) $new_instance['powerhour-image'] : false;
		return $instance;
	}
}
/*---------------------------------------
		Class wpb_widget ends here
----------------------------------------*/
