<?php

function iq_recent_posts_widgets()
{
	register_widget('Iqonic_Recent_Posts');
}
add_action('widgets_init', 'iq_recent_posts_widgets');

/*-------------------------------------------
		iqonic Recent Post 
--------------------------------------------*/
class Iqonic_Recent_Posts extends WP_Widget
{

	function __construct()
	{
		parent::__construct(

			// Base ID of your widget
			'Iqonic_Recent_Posts',

			// Widget name will appear in UI
			esc_html('Iqonic Recent Post', 'iqonic-extension'),

			// Widget description
			array('description' => esc_html('Most recent Posts. ', 'iqonic-extension'),)

		);
		//Add styles
		wp_enqueue_style('iq-owl-carousel', IQONIC_EXTENSION_PLUGIN_URL . 'includes/assets/css/owl.carousel.min.css');
		

		//Register scripts. this sample depends on jquery
		wp_enqueue_script('iq-owl-carousel', IQONIC_EXTENSION_PLUGIN_URL . 'includes/Elementor/assets/js/owl.carousel.min.js', array('jquery'), true);
		wp_enqueue_script('iq-widget-custom', IQONIC_EXTENSION_PLUGIN_URL . 'includes/assets/js/custom.js', array('jquery'), true);
	}

	// Creating widget front-end

	public function widget($args, $instance)
	{
		if (!isset($args['widget_id'])) {
			$args['widget_id'] = $this->id;
		}

		$title = (!empty($instance['title'])) ? $instance['title'] : esc_html('Recent Post', 'iqonic-extension');
		$title = apply_filters('widget_title', $title, $instance, $this->id_base);
		$number = (!empty($instance['number'])) ? absint($instance['number']) : 5;
		if (!$number) {
			$number = 5; 
		}

		$title_tag = empty($instance['title_tag']) ? 'h6' : $instance['title_tag'];;
		$show_date = isset($instance['show_date']) ? $instance['show_date'] : false;
		$show_name = isset($instance['show_name']) ? $instance['show_name'] : false;
		$show_slider = isset($instance['show_slider']) ? $instance['show_slider'] : false;
		$iq_image = isset($instance['powerhour-image']) ? $instance['powerhour-image'] : '';
            ?>

		<div class="powerhour-widget-menu powerhour-recent-post widget">
			<?php
			if ($title) {
				echo ($args['before_title'] . $title . $args['after_title']);
			} ?>
			<div class="list-inline powerhour-widget-menu">
				<ul class="<?php if ($show_slider) : echo esc_html('owl-carousel', 'iqonic-extension');
							endif; ?> powerhour-post">
					<?php
					$args = array('post_type' => 'post', 'posts_per_page' => $number,);
					$loop = new WP_Query($args);
					while ($loop->have_posts()) : $loop->the_post();
					   ?>
						<li>
							<div class="post-img">
								<?php
								if ($iq_image) {
								   ?>
									<div class="post-img-holder">
										<a href="<?php echo esc_url(get_permalink($loop->ID)); ?>" style="background-image:url('<?php echo get_the_post_thumbnail_url($loop->ID); ?>')">
										</a>
									</div>
								   <?php
								}
								  ?>
								<div class="post-blog">
									<div class="blog-box">
										<a class="new-link" href="<?php echo esc_url(get_permalink($loop->ID)); ?>">
											<<?php echo $title_tag;  ?> class="powerhour_post_title">
												<?php the_title(); ?>
											</<?php echo $title_tag; ?>>
										</a>
										<ul class="list-inline">
											  <?php
											if ($show_date) : ?>
												<li class="list-inline-item date  mr-3"><a href="<?php echo esc_url(get_permalink($loop->ID)); ?>"><?php echo get_the_date('d.m.Y');  ?></a></li>
											   <?php 
											endif; ?>
										</ul>
								    </div>
							    </div>
						    </div>
					    </li>
					    <?php
					endwhile;
					wp_reset_postdata();
					?>
				</ul>
			</div>
		</div>
	<?php
	}

	// Widget Backend
	public function form($instance)
	{
		$title     = isset($instance['title']) ? esc_attr($instance['title']) : '';
		$number    = isset($instance['number']) ? absint($instance['number']) : 5;
		$title_tag = $instance['title_tag'];
		$show_date = isset($instance['show_date']) ? (bool) $instance['show_date'] : false;
		$show_name = isset($instance['show_name']) ? (bool) $instance['show_name'] : false;
		$show_slider = isset($instance['show_slider']) ? (bool) $instance['show_slider'] : false;

		if (isset($instance['powerhour-image'])) {
			$iq_image = $instance['powerhour-image'];

				if ($iq_image == "image") {
					$ch_image = "checked";
				}
		}

	?>

		<p><label for="<?php echo esc_html($this->get_field_id('title', 'iqonic-extension')); ?>"><?php esc_html_e('Title:', 'iqonic-extension'); ?></label>
			<input class="widefat" id="<?php echo esc_html($this->get_field_id('title', 'iqonic-extension')); ?>" name="<?php echo esc_html($this->get_field_name('title', 'iqonic-extension')); ?>" type="text" value="<?php echo esc_html($title, 'iqonic-extension'); ?>" />
		</p>

		<p><label for="<?php echo esc_html($this->get_field_id('number', 'iqonic-extension')); ?>"><?php esc_html_e('Number of posts to show:', 'iqonic-extension'); ?></label>
			<input class="tiny-text" id="<?php echo esc_html($this->get_field_id('number', 'iqonic-extension')); ?>" name="<?php echo esc_html($this->get_field_name('number', 'iqonic-extension')); ?>" type="number" step="1" min="1" value="<?php echo esc_html($number, 'iqonic-extension'); ?>" size="3" />
		</p>

		<p><label for="<?php echo esc_html($this->get_field_id('title_tag', 'iqonic-extension')); ?>"><?php esc_html_e('Select Title Tag:', 'iqonic-extension'); ?></label>
			<select id="<?php echo $this->get_field_id('title_tag'); ?>" name="<?php echo $this->get_field_name('title_tag'); ?>" class="widefat">
				<option <?php if ('h1' == $title_tag) echo 'selected="selected"'; ?> value="h1">H1</option>
				<option <?php if ('h2' == $title_tag) echo 'selected="selected"'; ?> value="h2">H2</option>
				<option <?php if ('h3' == $title_tag) echo 'selected="selected"'; ?> value="h3">H3</option>
				<option <?php if ('h4' == $title_tag) echo 'selected="selected"'; ?> value="h4">H4</option>
				<option <?php if ('h5' == $title_tag) echo 'selected="selected"'; ?> value="h5">H5</option>
				<option <?php if ('h6' == $title_tag) echo 'selected="selected"'; ?> value="h6">H6</option>
			</select>
		</p>

		<p><input class="checkbox" type="checkbox" <?php checked($show_date); ?> id="<?php echo esc_html($this->get_field_id('show_date', 'iqonic-extension')); ?>" name="<?php echo esc_html($this->get_field_name('show_date', 'iqonic-extension')); ?>" />
			<label for="<?php echo esc_html($this->get_field_id('show_date', 'iqonic-extension')); ?>"><?php esc_html_e('Display post Date?', 'iqonic-extension'); ?></label>
		</p>

		<p><input class="checkbox" type="checkbox" <?php checked($show_name); ?> id="<?php echo esc_html($this->get_field_id('show_name', 'iqonic-extension')); ?>" name="<?php echo esc_html($this->get_field_name('show_name', 'iqonic-extension')); ?>" />
			<label for="<?php echo esc_html($this->get_field_id('show_name', 'iqonic-extension')); ?>"><?php esc_html_e('Display post Author Name?', 'iqonic-extension'); ?></label>
		</p>

		<p><input class="checkbox" type="checkbox" <?php checked($show_slider); ?> id="<?php echo esc_html($this->get_field_id('show_slider', 'iqonic-extension')); ?>" name="<?php echo esc_html($this->get_field_name('show_slider', 'iqonic-extension')); ?>" />
			<label for="<?php echo esc_html($this->get_field_id('show_slider', 'iqonic-extension')); ?>"><?php esc_html_e('Display post Slider?', 'iqonic-extension'); ?></label>
		</p>

		<p>
			<input type="checkbox" id="<?php echo esc_attr($this->get_field_id('powerhour-image', 'iqonic-extension')); ?>" name="<?php echo esc_html($this->get_field_name('powerhour-image[]', 'iqonic-extension')); ?>" value="image" <?php if (isset($ch_image)) echo esc_html($ch_image, 'iqonic-extension'); ?>>
			<label for="<?php echo esc_html($this->get_field_id('title', 'iqonic-extension')); ?>"><?php echo esc_html('Image', 'iqonic-extension'); ?></label></br />
		</p>
<?php

	}

	// Updating widget replacing old instances with new
	public function update($new_instance, $old_instance)
	{
		$instance = array();
		$instance['title'] = sanitize_text_field($new_instance['title']);
		$instance['number'] = (int) $new_instance['number'];

		$instance['title_tag'] = $new_instance['title_tag'];
		$instance['show_date'] = isset($new_instance['show_date']) ? (bool) $new_instance['show_date'] : false;
		$instance['show_name'] = isset($new_instance['show_name']) ? (bool) $new_instance['show_name'] : false;
		$instance['show_slider'] = isset($new_instance['show_slider']) ? (bool) $new_instance['show_slider'] : false;
		$instance['powerhour-image'] = isset($new_instance['powerhour-image']) ? (bool) $new_instance['powerhour-image'] : false;
		return $instance;
	}
}
/*---------------------------------------
		Class wpb_widget ends here
----------------------------------------*/
