<?php

function iqonic_contact_info()
{
	register_widget('iq_contact');
}
add_action('widgets_init', 'iqonic_contact_info');

/*-------------------------------------------
		iq Contact Information widget 
--------------------------------------------*/
class iq_contact extends WP_Widget
{

	function __construct()
	{
		parent::__construct(

			// Base ID of your widget
			'iq_contact',

			// Widget name will appear in UI
			esc_html('iqonic Contact', 'iqonic-extension'),

			// Widget description
			array('description' => esc_html('iq Contact. ', 'iqonic-extension'),)
		);
	}

	// Creating widget front-end

	public function widget($args, $instance)
	{

		global $wp_registered_sidebars;
		$iq_option = get_option('power-hour-options');

		if (!isset($args['widget_id'])) {
			$args['widget_id'] = $this->id;
		}

		echo $args['before_widget'];

		$title = (!empty($instance['title'])) ? $instance['title'] : false;
		$title = apply_filters('widget_title', $title, $instance, $this->id_base);
		$phone = isset($instance['phone']) ? $instance['phone'] : false;
		$email = isset($instance['email']) ? $instance['email'] : false;
		$address = isset($instance['address']) ? $instance['address'] : false;

		/* here add extra display item  */
?>
		<div class="widget">
			<?php if ($title) { ?>
				<h4 class="footer-title contact-info iq-heading-title">
				<span class="title"><?php echo $title ?></span>
				<span class="line wow"></span>
				</h4>
			<?php } ?>

			<div class="row">
				<div class="col-sm-12">
					<ul class="iq-contact">
						<?php
						if ($address) : ?>
							<li>
								<a>									
									<span><?php $address = $iq_option['address'];
									echo esc_attr($address); ?></span>
								</a>
							</li>
						<?php
						endif; ?>
						<?php
						if ($email) :  ?>
							<li>
								<a href="mailto:<?php echo esc_html($iq_option['email']); ?>">
									 <?php
										if ($iq_option['email']) { ?>
										<span><?php echo esc_attr($iq_option['email']); ?></span> <?php
									} ?>
								</a>
							</li>
						<?php						
						endif; ?>
						<?php
						if ($phone) : ?>
							<li>
								<a href="tel:<?php echo str_replace(str_split('(),-" '), '', $iq_option['phone']); ?>">
									<?php
										if ($iq_option['phone']) { ?>
										<span><?php echo wp_kses($iq_option['phone'], array('br' => true)); ?></span> <?php
									} ?>
								</a>
							</li>
						<?php
						endif; ?>
					</ul>
				</div>
			</div>
		</div>
	<?php
		echo $args['after_widget'];
	}

	// Widget Backend 
	public function form($instance)
	{
		$title = isset($instance['title']) ? esc_attr($instance['title']) : '';
		$phone = isset($instance['phone']) ? (bool) $instance['phone'] : false;
		$email = isset($instance['email']) ? (bool) $instance['email'] : false;
		$address = isset($instance['address']) ? (bool) $instance['address'] : false;
	?>

		<p><label for="<?php echo esc_html($this->get_field_id('title', 'iqonic-extension')); ?>"><?php esc_html_e('Title:', 'iqonic-extension'); ?></label>
			<input class="widefat" id="<?php echo esc_html($this->get_field_id('title', 'iqonic-extension')); ?>" name="<?php echo esc_html($this->get_field_name('title', 'iqonic-extension')); ?>" type="text" value="<?php echo esc_html($title, 'iqonic-extension'); ?>" />
		</p>

		<p><input class="checkbox" type="checkbox" <?php checked($phone); ?> id="<?php echo esc_html($this->get_field_id('phone', 'iqonic-extension')); ?>" name="<?php echo esc_html($this->get_field_name('phone', 'iqonic-extension')); ?>" />
			<label for="<?php echo esc_html($this->get_field_id('phone', 'iqonic-extension')); ?>"><?php esc_html_e('Display Phone Number?', 'iqonic-extension'); ?></label>
		</p>

		<p><input class="checkbox" type="checkbox" <?php checked($email); ?> id="<?php echo esc_html($this->get_field_id('email', 'iqonic-extension')); ?>" name="<?php echo esc_html($this->get_field_name('email', 'iqonic-extension')); ?>" />
			<label for="<?php echo esc_html($this->get_field_id('email', 'iqonic-extension')); ?>"><?php esc_html_e('Display Email?', 'iqonic-extension'); ?></label>
		</p>

		<p><input class="checkbox" type="checkbox" <?php checked($address); ?> id="<?php echo esc_html($this->get_field_id('address', 'iqonic-extension')); ?>" name="<?php echo esc_html($this->get_field_name('address', 'iqonic-extension')); ?>" />
			<label for="<?php echo esc_html($this->get_field_id('address', 'iqonic-extension')); ?>"><?php esc_html_e('Display Address?', 'iqonic-extension'); ?></label>
		</p>

<?php
	}

	// Updating widget replacing old instances with new
	public function update($new_instance, $old_instance)
	{
		$instance = array();
		$instance['title'] = sanitize_text_field($new_instance['title']);
		$instance['phone'] = isset($new_instance['phone']) ? (bool) $new_instance['phone'] : false;
		$instance['email'] = isset($new_instance['email']) ? (bool) $new_instance['email'] : false;
		$instance['address'] = isset($new_instance['address']) ? (bool) $new_instance['address'] : false;
		$instance['iq-contact'] = $new_instance['iq-contact'];
		return $instance;
	}
} 
/*---------------------------------------
		Class wpb_widget ends here
----------------------------------------*/
