<?php
if (class_exists('WooCommerce')) {
    return;
}

add_action('wp_ajax_loadmore_product_widget', 'powerhour_loadmore_product_widget_ajax_handler'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_loadmore_product_widget', 'powerhour_loadmore_product_widget_ajax_handler'); // wp_ajax_nopriv_{action}
if (!function_exists('powerhour_loadmore_product_widget_ajax_handler')) {
    function powerhour_loadmore_product_widget_ajax_handler()
    {
        $args = isset($_POST['query']) ? (array)json_decode(str_replace("\\", "", $_POST['query'])) : false;
        $args['paged'] = isset($_POST['current_page']) ? (int) $_POST['current_page'] + 1 : 1;
        $woo_column = isset($_POST['woo_grid']) ? $_POST['woo_grid'] : '';

        $wp_query = new WP_Query($args);
        if ($wp_query->have_posts()) {
            ob_start();
            while ($wp_query->have_posts()) {
                $wp_query->the_post();
                if ($woo_column == 'list') {
                    locate_template('/template-parts/wocommerce/entry-listing.php', true, false, $args = array('id' => get_the_ID()));
                } else {
                    locate_template('/template-parts/wocommerce/entry.php', true, false, $args = array('id' => get_the_ID()));
                }
            }
            $data = ob_get_clean();
            wp_send_json_success($data, 200);
            wp_reset_postdata();
        } else {
            wp_send_json_error("No Found", 404);
        }

        die;
    }
}

// Wooocmerce add to cart popup
add_action('wp_ajax_powerhour_ajax_add_to_cart', 'powerhour_ajax_add_to_cart');
add_action('wp_ajax_nopriv_powerhour_ajax_add_to_cart', 'powerhour_ajax_add_to_cart');
function powerhour_ajax_add_to_cart()
{
    $product_id  = $_POST['product_id'];
    global $woocommerce;
    $woocommerce->cart->add_to_cart($product_id);
    die();
}

//you have to change according to above mini cart shortcode function.
add_filter('woocommerce_add_to_cart_fragments', function ($fragments) {
    ob_start();
?>
    <a href="#" class="dropdown-back" data-toggle="dropdown">
        <i class="fas fa-shopping-cart"></i>
        <div class="basket-item-count" style="display: inline;">
            <span class="cart-items-count count">
                <?php echo WC()->cart->get_cart_contents_count(); ?>
            </span>
        </div>
    </a>
<?php $fragments['a.dropdown-back'] = ob_get_clean();
    return $fragments;
});

add_filter('woocommerce_add_to_cart_fragments', function ($fragments) {
    ob_start();
?>
    <div class="dropdown-menu-mini-cart">
        <div class="widget_shopping_cart_content">
            <?php woocommerce_mini_cart(); ?>
        </div>
    </div>
<?php $fragments['ul.dropdown-menu'] = ob_get_clean();
    return $fragments;
});


/* woocommerce register shortcode */
add_shortcode('iqonic-signup-form', 'iqonic_woocommerce_registration');
function iqonic_woocommerce_registration($attr)
{
    if (is_admin()) return;
    if (is_user_logged_in()) return;
    ob_start();

    $args = shortcode_atts( array(
        'btn_text_string' => '',
        'button_text' => 'Sign Up',
        'url' => '#',
    ), $attr );

    do_action('woocommerce_before_customer_login_form'); ?>
    <form id="register-form" method="post" class="woocommerce-form woocommerce-form-register register" <?php do_action('woocommerce_register_form_tag'); ?>>

        <?php do_action('woocommerce_register_form_start'); ?>

        <?php if ('no' === get_option('woocommerce_registration_generate_username')) : ?>

            <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                <label for="reg_username"><?php esc_html_e( 'Username', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
                <input required type="text" class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="reg_username" autocomplete="username" placeholder="<?php echo esc_attr('Enter Your Username *', 'iqonic-extension'); ?>" value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" />
            </p>

        <?php endif; ?>

        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
            <label for="reg_email"><?php esc_html_e( 'Email address', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
            <input required type="email" class="woocommerce-Input woocommerce-Input--text input-text" name="email" id="reg_email" autocomplete="email" placeholder="<?php echo esc_attr('Your email id *', 'iqonic-extension'); ?>" value="<?php echo (!empty($_POST['email'])) ? esc_attr(wp_unslash($_POST['email'])) : ''; ?>" />
        </p>

        <?php if ('no' === get_option('woocommerce_registration_generate_password')) : ?>

            <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
                <label for="reg_password"><?php esc_html_e( 'Password', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label> 
                <input required type="password" class="woocommerce-Input woocommerce-Input--text input-text" name="password" id="reg_password" autocomplete="new-password" placeholder="<?php echo esc_attr('Enter Your Password *', 'iqonic-extension'); ?>" />
            </p>

        <?php endif; ?>

        <?php if (wc_get_page_id('terms') > 0) {
        ?>
            <div class="form-row terms wc-terms-and-conditions powerhour-check">
                <label class="woocommerce-form__label woocommerce-form__label-for-checkbox checkbox">
                    <input required type="checkbox" required class="woocommerce-form__input woocommerce-form__input-checkbox input-checkbox" name="terms" <?php checked(apply_filters('woocommerce_terms_is_checked_default', isset($_POST['terms'])), true); ?> id="terms" /> <span class="text-check"><?php printf(__('By creating an account, you agree to the <a href="%s" target="_blank" class="woocommerce-terms-and-conditions-link">Terms and Conditions</a>', 'iqonic-extension'), esc_url(wc_get_page_permalink('terms'))); ?></span> <span class="required">*</span><span class="checkmark"></span>
                </label>
                <input required type="hidden" name="terms-field" value="1" />
            </div>
        <?php }  ?>

        <?php do_action('woocommerce_register_form'); ?>

        <p class="woocommerce-FormRow form-row sign-up-btn">
            <?php wp_nonce_field('woocommerce-register', 'woocommerce-register-nonce'); ?>
            <!-- register button  -->
            <button type="submit" class="powerhour-button woocommerce-Button" name="register" value="<?php esc_attr_e('Register', 'iqonic-extension'); ?>">
                <span class="text-btn"><?php esc_html_e('Register', 'iqonic-extension'); ?></span>
            </button>
        </p>

        <div class="woocommerce-sign-in-btn">
            <p class="btn-text-string"><?php echo esc_html($args['btn_text_string']); ?></p>
            <p class="sign_in_text mb-0 ml-2">
                <a href="<?php echo esc_url($args['url']); ?>"><?php echo esc_html( $args['button_text'] );  ?></a>
            </p>
        </div>

        <?php do_action('woocommerce_register_form_end'); ?>

    </form>
    <?php
    return ob_get_clean();
}

/* woocommerce login shortcode */
add_shortcode('iqonic-login-form', 'iqonic_woocommerce_login_form');
function iqonic_woocommerce_login_form($attr)
{
    if (is_admin()) return;
    if (is_user_logged_in()) return;
    ob_start();
    $args = shortcode_atts(array(
        'btn_text_string' => '',
        'button_text' => 'Sign Up',
        'url' => '#',
        'lost_password_string' => 'Forgot Password?',
        'lost_password_url' => '#',
    ), $attr); ?>
    <form class="woocommerce-form woocommerce-form-login login" method="post">

        <?php do_action('woocommerce_login_form_start'); ?>

        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
            <label for="username"><?php esc_html_e( 'Username or email address', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
            <input type="text" required class="woocommerce-Input woocommerce-Input--text input-text" name="username" id="username" autocomplete="username" placeholder="<?php echo esc_attr('Enter Username or Email Address*', 'iqonic-extension'); ?>" value="<?php echo (!empty($_POST['username'])) ? esc_attr(wp_unslash($_POST['username'])) : ''; ?>" />
        </p>
        <p class="woocommerce-form-row woocommerce-form-row--wide form-row form-row-wide">
            <label for="password"><?php esc_html_e( 'Password', 'woocommerce' ); ?>&nbsp;<span class="required">*</span></label>
            <input class="woocommerce-Input woocommerce-Input--text input-text" placeholder="<?php echo esc_attr('Enter Password*', 'iqonic-extension'); ?>" type="password" required name="password" id="password" autocomplete="current-password" />
        </p>

        <?php do_action('woocommerce_login_form'); ?>

        <div class="login-inner">
            <div class="powerhour-check">
                <label class="woocommerce-form__label woocommerce-form__label-for-checkbox inline">
                    <input class="woocommerce-form__input woocommerce-form__input-checkbox" name="rememberme" type="checkbox" id="rememberme" value="forever" /><span class="checkmark"></span>
                    <span class="text-check"><?php esc_html_e('Remember me', 'iqonic-extension'); ?></span>
                </label>
            </div>

            <p class="woocommerce-LostPassword lost_password">
                <a href="<?php echo esc_url($args['lost_password_url']); ?>">
                    <?php echo esc_html($args['lost_password_string']); ?>
                </a>
            </p>
        </div>

        <p class="form-row form-submit-btn">
            <?php wp_nonce_field('woocommerce-login', 'woocommerce-login-nonce'); ?>
            <!-- login button -->
            <button type="submit" class="powerhour-button woocommerce-Button" name="login" value="<?php esc_attr_e('Log in', 'iqonic-extension'); ?>">
                <span class="text-btn"><?php esc_html_e('Log in', 'iqonic-extension'); ?></span>
            </button>
        </p>

        <div class="sign-link d-flex align-items-center">
            <p class="my-0"><?php echo esc_html($args['btn_text_string']); ?></p>
            <h5 class="sign_up_text mb-0 ml-2"><a href="<?php echo esc_url($args['url']); ?>"><?php echo esc_html($args['button_text']);  ?></a></h5>
        </div>

        <?php do_action('woocommerce_login_form_end'); ?>

    </form>
    <?php
    return ob_get_clean();
}

/* woocommerce lost password form */

add_shortcode( 'iqonic-lost-password-form', 'iqonic_woocommerce_lost_password_form' );
  
function iqonic_woocommerce_lost_password_form() {

    if ( is_admin() ) return;
    if ( is_user_logged_in() ) return; 
    ob_start();
        ?>

    <form method="post" class="woocommerce-ResetPassword lost_reset_password">

        <p><?php echo apply_filters( 'woocommerce_lost_password_message', esc_html__( 'Lost your password? Please enter your username or email address. You will receive a link to create a new password via email.', 'power-hour' ) ); ?>
        </p><?php // @codingStandardsIgnoreLine ?>

        <p class="woocommerce-form-row woocommerce-form-row--first form-row form-row-first">
            <label for="user_login"><?php esc_html_e( 'Username or email', 'power-hour' ); ?><span class="required">*</span></label>
            <input class="woocommerce-Input woocommerce-Input--text input-text" type="text" required name="user_login"
                id="user_login" autocomplete="username" />
        </p>

        <div class="clear"></div>

        <?php do_action( 'woocommerce_lostpassword_form' ); ?>

        <p class="woocommerce-form-row form-row">
            <input type="hidden" name="wc_reset_password" value="true" />
            <!-- reset password button -->
            <button type="submit" class="powerhour-button woocommerce-Button" value="<?php esc_attr_e( 'Reset password', 'power-hour' ); ?>">
                <?php esc_html_e( 'Reset password', 'power-hour' ); ?>
            </button>
        </p>

        <?php wp_nonce_field( 'lost_password', 'woocommerce-lost-password-nonce' ); ?>

    </form>
    <?php

    return ob_get_clean();
    
}