<?php

use Elementor\Plugin;

function get_iqonic_config()
{
    return $GLOBALS['iqonic_config']['Elements'];
}

if (!function_exists('iqonic_blog_time_link')) :
    /**
     * Gets a nicely formatted string for the published date.
     */
    function iqonic_blog_time_link()
    {
        $time_string = '<time class="entry-date published updated" datetime="%1$s">%2$s</time>';

        $time_string = sprintf(
            $time_string,
            get_the_date(DATE_W3C),
            get_the_date('d.m.Y'),
            get_the_modified_date(DATE_W3C),
            get_the_modified_date('d.m.Y')
        );

        // Wrap the time string in a link, and preface it with 'Posted on'.
        return sprintf(
            /* translators: %s: post date */
            __('<span class="screen-reader-text">Posted on</span> %s', 'iqonic-extension'),
            '<a href="' . esc_url(get_permalink()) . '" rel="bookmark">' . $time_string . '</a>'
        );
    }
endif;

if (!function_exists('powerhour_get_post_format_dynamic')) {
    function powerhour_get_post_format_dynamic()
    {
        if (current_theme_supports('post-formats')) {
            $get_post_formats_slug = get_post_format_slugs();
            foreach ($get_post_formats_slug as $name => $slug) {
                $post_format_list[$name] = $slug;
            }
            return $post_format_list;
        }
    }
}

// return posts array
if (!function_exists('iqonic_get_posts')) {
    function iqonic_get_posts($post_type = "post", $post_status = "publish")
    {
        $args = array(
            'post_type'         => $post_type,
            'post_status'       => $post_status,
            'posts_per_page'    => -1
        );
        $post_query = get_posts($args);
        $iqonic_posts = [];

        if ($post_query) {
            foreach ($post_query as $post) {
                $iqonic_posts[$post->post_name] = get_the_title($post->ID);
            }
            return $iqonic_posts;
        }
        wp_reset_postdata();
    }
}


if (!function_exists('iqonic_get_taxonomies')) {
    function iqonic_get_taxonomies($taxo = '')
    {
        if (empty($taxo)) {
            return;
        }
        $show_count = 0; // 1 for yes, 0 for no
        $pad_counts = 0; // 1 for yes, 0 for no
        $hierarchical = 1; // 1 for yes, 0 for no
        $title = '';
        $empty = 0;
        $array = array();
        $args = array(
            'taxonomy' => $taxo,
            'show_count' => $show_count,
            'pad_counts' => $pad_counts,
            'hierarchical' => $hierarchical,
            'hide_empty' => true,
            'parent' => 0
        );
        $wp_object =  get_categories($args);

        if (!empty($wp_object)) {
            foreach ($wp_object as $val) {
                $array[$val->slug] = $val->name;
            }
        }
        return $array;
    }
}

if (!function_exists('iqonic_random_strings')) {
    function iqonic_random_strings($random = '')
    {

        // String of all alphanumeric character 
        $str_result = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz' . $random;

        // Shufle the $str_result and returns substring 
        // of specified length 
        return substr(str_shuffle($str_result), 0, 5);
    }
}

// get Blog Category
if (!function_exists('iqonic_by_blog_cat')) {
    function iqonic_by_blog_cat($taxo = '')
    {

        $taxonomy = 'category';
        $iqonic_blog_cat = array();
        $terms = get_terms($taxonomy);

        foreach ($terms as $term) {
            $iqonic_blog_cat[$term->slug] = $term->name;
        }
        return $iqonic_blog_cat;
    }
}

if (!function_exists('iq_custom_post_data')) {
    function iq_custom_post_data($post_type = '', $post_return_key = true, $show_item_badges = false)
    {
        $args = array(
            'post_type'         => $post_type,
            'post_status'       => array('publish', 'private'),
            'posts_per_page' => -1
        );
        $wp_query = get_posts($args);
        $iqonic_blog_list = [];
        if ($wp_query) {
            if ($post_return_key) {
                foreach ($wp_query as $post) {
                    $show_item_badges = $show_item_badges ? ' - ' . get_post_type($post->ID) : '';
                    $iqonic_blog_list[$post->post_name] = get_the_title($post->ID) . $show_item_badges;
                }
            } else {
                foreach ($wp_query as $post) {
                    $show_item_badges = $show_item_badges ? ' - ' . get_post_type($post->ID) : '';
                    $iqonic_blog_list[$post->ID] = get_the_title($post->ID)  . $show_item_badges;
                }
            }
        }
        return $iqonic_blog_list;
    }
}

if (!function_exists('iqonic_get_post')) {
    function iqonic_get_post($post_type = "", $post_status = "publish")
    {
        $args = array(
            'post_type'         => $post_type,
            'post_status'       => $post_status,
            'posts_per_page'    => -1
        );
        $wp_query_post = get_posts($args);
        $iqonic_blog_list = [];

        if ($wp_query_post) {
            foreach ($wp_query_post as $post) {
                $iqonic_blog_list[$post->post_name] = get_the_title($post->ID);
            }
            return $iqonic_blog_list;
        }
        wp_reset_postdata();
    }
}

if (!function_exists('iqonic_get_custom_taxonomy')) {
    function iqonic_get_custom_taxonomy($taxo = '')
    {
        if (empty($taxo)) {
            return;
        }

        $show_count = 0; // 1 for yes, 0 for no
        $pad_counts = 0; // 1 for yes, 0 for no
        $hierarchical = 1; // 1 for yes, 0 for no
        $title = '';
        $empty = 0;
        $array = array();
        $args = array(
            'taxonomy' => $taxo,
            'show_count' => $show_count,
            'pad_counts' => $pad_counts,
            'hierarchical' => $hierarchical,
            'hide_empty' => true,
            'parent' => 0
        );
        $wp_object =  get_categories($args);

        if (!empty($wp_object)) {
            foreach ($wp_object as $val) {
                $array[$val->slug] = $val->name;
            }
        }

        return $array;
    }
}

if (!function_exists('iqonic_all_team_cat')) {

    function iqonic_all_team_cat()
    {
        $iqonic_blog_cat = array();
        $args = array(
            'taxonomy' => 'team-categories',
            'orderby' => 'name',
            'order' => 'ASC',
            'hide_empty' => false,
        );

        $cats = get_categories($args);

        foreach ($cats as $cat) {
            $iqonic_blog_cat[$cat->term_id] = $cat->name;
        }

        return $iqonic_blog_cat;
    }
}
if (!function_exists('iqonic_by_team_cat')) {
    function iqonic_by_team_cat($id)
    {
        $cat_name = '';
        $category = get_the_terms($id, 'team-categories');

        if (!empty($category)) {
            foreach ($category as $cat) {
                $cat_name .= $cat->name . ",";
            }
        }
        return rtrim($cat_name, ',');
    }
}

if (!function_exists('iqonic_all_service_cat')) {
    function iqonic_all_service_cat()
    {
        $iqonic_blog_cat = array();
        $args = array(
            'taxonomy' => 'service-categories',
            'orderby' => 'name',
            'order' => 'ASC',
            'hide_empty' => false,
        );
        $cats = get_categories($args);
        foreach ($cats as $cat) {
            $iqonic_blog_cat[$cat->term_id] = $cat->name;
        }
        return $iqonic_blog_cat;
    }
}

if (!function_exists('iqonic_by_service_cat')) {
    function iqonic_by_service_cat($id)
    {
        $cat_name = '';
        $category = get_the_terms($id, 'service-categories');

        foreach ($category as $cat) {
            $cat_name .= $cat->name . ",";
        }
        return rtrim($cat_name, ',');
    }
}

// Add standard elements option in the existing controls Columns
if (!function_exists('iqonic_addons_column_layouts_elementor_added_elements')) {
    add_action('elementor/element/before_section_end', 'iqonic_addons_column_layouts_elementor_added_elements', 10, 3);
    function iqonic_addons_column_layouts_elementor_added_elements($element, $section_id)
    {
        if (!is_object($element)) return;

        if (in_array($element->get_name(), array('column')) && $section_id == 'layout') {
            $element->add_control(
                'iqonic_column_wrapper',
                [
                    'label' => __('Add column wrapper', 'iqonic-extension'),
                    'type' => \Elementor\Controls_Manager::SWITCHER,
                    'yes' => __('Yes', 'iqonic-extension'),
                    'no' => __('No', 'iqonic-extension'),
                    'default' => 'no',
                ]
            );
            $element->add_control(
                'position',
                [
                    'label' => __('Position', 'iqonic-extension'),
                    'type' => \Elementor\Controls_Manager::CHOOSE,
                    'default' => 'left',
                    'options' => [
                        'left' => [
                            'title' => __('Left', 'iqonic-extension'),
                            'icon' => 'eicon-h-align-left',
                        ],
                        'right' => [
                            'title' => __('Right', 'iqonic-extension'),
                            'icon' => 'eicon-h-align-right',
                        ],
                    ],
                    'condition' => [
                        'iqonic_column_wrapper' => 'yes',
                    ],
                ]
            );

            $element->add_control(
                'wrapper_box_bg',
                [
                    'label' => __('Background Color', 'iqonic-extension'),
                    'type' => \Elementor\Controls_Manager::COLOR,
                    'condition' => [
                        'iqonic_column_wrapper' => 'yes',
                    ],
                ]
            );

            $element->add_control(
                'wrapper_width',
                [
                    'label' => __('Width (%)', 'iqonic-extension'),
                    'type' =>  \Elementor\Controls_Manager::SLIDER,
                    'range' => [
                        '%' => [
                            'min' => 0,
                            'max' => 100,
                        ],
                    ],
                    'condition' => [
                        'iqonic_column_wrapper' => 'yes',
                    ],
                ]
            );
        }
    }
}

// Add class to the wrapper of the row
if (!function_exists('iqonic_addons_elementor_add_layout_class')) {
    add_action('elementor/frontend/before_render',  'iqonic_addons_elementor_add_wrapper_before', 10, 1);
    function iqonic_addons_elementor_add_wrapper_before($element)
    {
        if (!is_object($element)) return;

        if (in_array($element->get_name(), array('column'))) {
            $sec_settings = $element->get_settings();
            $sec_position = $sec_settings['position'];
            $id = $element->get_id();
            if ($sec_settings['iqonic_column_wrapper'] === 'yes') {
                if (isset($sec_settings['wrapper_box_bg'])) {
                    if (!empty($sec_settings['wrapper_box_bg'])) {
                        $bg_color = $sec_settings['wrapper_box_bg'];
                    } else {
                        $bg_color = 'var(--global-body-lightcolor)';
                    }
                    if (!empty($sec_settings['wrapper_width']['size'])) {
                        $bg_width = $sec_settings['wrapper_width']['size'] . '%';
                    } else {
                        $bg_width =  '92%';
                    }
                    $option = ["
                .iqonic-inner-section.wrapper-$id::before {
                        background : $bg_color !important;
                        width: $bg_width !important;
                } 
                "];
                    if (get_option('_iqonic_column_option') && !empty(get_option('_iqonic_column_option'))) {
                        $option = array_merge(get_option('_iqonic_column_option'), $option);
                    }
                    update_option('_iqonic_column_option', $option);
                }
                echo "<div class='iqonic-inner-section wrapper-responsive wrapper-$id $sec_position'>";
            }
        }
    }

    add_action('elementor/frontend/after_render',  'iqonic_addons_elementor_add_wrapper_after', 10, 1);
    function iqonic_addons_elementor_add_wrapper_after($element)
    {
        if (!is_object($element)) return;
        if (in_array($element->get_name(), array('column'))) {
            $sec_settings = $element->get_settings();
            if ($sec_settings['iqonic_column_wrapper'] === 'yes') {
                echo "</div>";
            }
        }
    }
}
add_action('wp_enqueue_scripts',  function () {
    if (get_option('_iqonic_column_option') && !empty(get_option('_iqonic_column_option'))) {
        $style_array = get_option('_iqonic_column_option');
        $style = implode(" ", $style_array);
        wp_register_style('iqonic-column-wrap', false);
        wp_enqueue_style('iqonic-column-wrap');
        wp_add_inline_style('iqonic-column-wrap', $style);
    }
    update_option('_iqonic_column_option', '');
}, 10, 5);

//loadmore function
function iqonic_scripts()
{
    global $wp_query;
    wp_register_script('iqonic_ajax', false);
    wp_localize_script('iqonic_ajax', 'iqonic_loadmore_params', array(
        'ajaxurl'       => site_url() . '/wp-admin/admin-ajax.php', // WordPress AJAX
        'posts'         => json_encode($wp_query->query_vars), // everything about your loop is here
        'current_page'  => get_query_var('paged') ? get_query_var('paged') : 1,
        'max_page'      => $wp_query->max_num_pages
    ));

    wp_enqueue_script('iqonic_ajax');
}
add_action('wp_enqueue_scripts', 'iqonic_scripts', 15);

function iqonic_portfolio_ajax_data()
{
    $col = isset($_POST['col']) ? $_POST['col'] : "";

    if (gettype($_POST['settings']) === 'string') {
        $settings = json_decode(str_replace("'", "\"", stripslashes($_POST['settings'])), true);
    }
    $cat = '';
    if (isset($settings['portfolio_cat']) && !empty($settings['portfolio_cat'])) {
        $cat = implode(',', $settings['portfolio_cat']);
    }
    $args = array(
        'post_type'         => 'portfolio',
        'post_status'       => 'publish',
        'category_name'     => $cat,
        'order'             => $settings['order'],
        'offset'            => $_POST['portfolio_per_page'],
        'suppress_filters'  => 0,
        'posts_per_page'    => $settings['posts_per_load']
    );
    $args['paged'] = $_POST['page'] + 1;
    query_posts($args);

    if (have_posts()) :

        // run the loop
        while (have_posts()) : the_post();
            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full"); ?>
            <div class="<?php echo esc_attr($col); ?>">
                <div class="powerhour-portfolio-box">
                    <?php if (has_post_thumbnail()) {
                        echo sprintf('<img class="portfolio-image" src="%1$s" alt="iqonic-portfolio"/>', esc_url($full_image[0], 'iqonic-extension'));
                    ?>
                    <?php } ?>

                    <div class="powerhour-portfolio-overlay">
                        <div class="portfolio-content">
                            <div class="portfolio-meta">
                                <span class="iqonic-portfolio-author-name">
                                    <?php
                                    echo '- ';
                                    the_author();
                                    ?>
                                </span>

                                <<?php echo esc_html__($settings['title_tag']) ?> class="iqonic-portfolio-name">
                                    <?php echo sprintf("%s", esc_html__(get_the_title(), 'iqonic-extension')); ?>
                                </<?php echo esc_html__($settings['title_tag']) ?>>
                            </div>
                            <?php

                            //button
                            if (!empty($settings['button_text'])) {
                                $link_class = '';
                                $html = '';
                                if ($settings['button_type'] === "default") {

                                    $link_class .= 'powerhour-button';
                                    $html .= '<span class="powerhour-text">' . esc_html($settings['button_text']) . '<span class="powerhour-strip"></span></span>';
                                } elseif ($settings['button_type'] === "linked") {
                                    $link_class .= 'powerhour-btn-link';
                                    $html .= '<span class="text-btn">' . esc_html($settings['button_text']) . '</span>';
                                }
                            ?>
                                <div class="powerhour-btn-container">
                                    <a class="<?php echo esc_attr($link_class); ?>" href="<?php the_permalink(); ?>">
                                        <?php echo wp_kses_post($html); ?>
                                    </a>
                                </div>
                            <?php } ?>
                        </div>
                    </div>
                </div>
            </div>
<?php
        endwhile;
    endif;
    die; // here we exit the script and even no wp_reset_query() required!
}

// ** search load more *//
add_action('wp_ajax_iqonic_portfolio_action', 'iqonic_portfolio_ajax_data'); // wp_ajax_{action}
add_action('wp_ajax_nopriv_iqonic_portfolio_action', 'iqonic_portfolio_ajax_data');
