(function (jQuery) {
    "use strict";
    jQuery(document).ready(function () {
        jQuery('.owl-carousel').each(function () {
            var jQuerycarousel = jQuery(this);
            jQuerycarousel.owlCarousel({
                items: jQuerycarousel.data("items"),
                loop: jQuerycarousel.data("loop"),
                margin: jQuerycarousel.data("margin"),
                nav: jQuerycarousel.data("nav"),
                dots: jQuerycarousel.data("dots"),
                autoplay: jQuerycarousel.data("autoplay"),
                autoplayTimeout: jQuerycarousel.data("autoplay-timeout"),
                navText: [
                    '<div class="powerhour-leftarrow"> <svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M2.42249 8.15674V11.4263H20.7507V8.15674H2.42249Z" fill="#222222"/>  <path d="M11.1515 16.8491L4.63528 9.79116L11.1494 2.73326L8.78609 0.503418L1.23916 8.67733C0.656973 9.30509 0.656973 10.2794 1.23916 10.9072L8.78609 19.0811L11.1515 16.8491Z" fill="#222222"/></svg><div class="circle-box"><div class="sub-circle"><span class="text-btn-line-holder"><span class="text-btn-line-top"></span><span class="text-btn-line"></span><span class="text-btn-line-bottom"></span></span></div></div></div>',
                    '<div class="powerhour-rightarrow"><svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">  <path d="M18.5775 8.15674V11.4263L0.249262 11.4263V8.15674L18.5775 8.15674Z" fill="#222222"/> <path d="M9.84852 16.8491L16.3647 9.79116L9.85067 2.73326L12.2139 0.503418L19.7609 8.67733C20.3431 9.30509 20.3431 10.2794 19.7609 10.9072L12.2139 19.0811L9.84852 16.8491Z" fill="#222222"/></svg><div class="circle-box"><div class="circle-box"><div class="sub-circle"><span class="text-btn-line-holder"><span class="text-btn-line-top"></span><span class="text-btn-line"></span><span class="text-btn-line-bottom"></span></span></div></div></div>'
                ],
                responsiveClass: true,
                responsive: {
                    // breakpoint from 0 up
                    0: {
                        items: jQuerycarousel.data("items-mobile-sm"),
                        nav: false,
                        dots: true
                    },
                    // breakpoint from 480 up
                    480: {
                        items: jQuerycarousel.data("items-mobile"),
                        nav: false,
                        dots: true
                    },
                    // breakpoint from 786 up
                    786: {
                        items: jQuerycarousel.data("items-tab"),
                        nav: false,
                        dots: true
                    },
                    // breakpoint from 1023 up
                    1023: {
                        items: jQuerycarousel.data("items-laptop"),
                        nav: false,
                        dots: true
                    },
                    1100: {
                        items: jQuerycarousel.data("items-large"),
                    },
                    1299: {
                        items: jQuerycarousel.data("items"),
                    }
                }
            });
        });
		window.dispatchEvent(new Event('resize'));
    });
})(jQuery);