(function (jQuery) {
    "use strict";
    jQuery(window).ready(function () {
        /*------------------------
                Masonry
        --------------------------*/
        callSwiper();
    });
})(jQuery);

function callSwiper() {
    if (jQuery(document).find('.swiper').length > 0) {

        jQuery(document).find('.swiper').each(function () {
            let slider = jQuery(this);

            let sliderAutoplay = slider.data('autoplay')
            if (sliderAutoplay) {
                sliderAutoplay = {
                    delay: slider.data('autoplay-delay')
                };
            }
            let iqonicPagination = {
                el: ".swiper-pagination",
                clickable: true,
            };

            if (slider.data('effect')) {
                iqonicPagination = {
                    el: ".swiper-pagination",
                    clickable: true,
                    renderBullet: function (index, className) {
                        let indexNum = index + 1;
                        return '<span class="' + className + '">' + ('0' + indexNum).slice(-2) + "</span>";
                    },
                };
            }

            let breakpoint = {}
            if (slider.data('style') == 'style-three') {
                breakpoint = {
                    // when window width is >= 320px
                    320: {
                        slidesPerView: 1,
                        spaceBetween: 30
                    },
                    // when window width is >= 767px
                    767: {
                        slidesPerView: 2,
                        spaceBetween: 30
                    },
                    // when window width is >= 992px
                    992: {
                        slidesPerView: 2,
                        spaceBetween: 30
                    },
                    // when window width is >= 1024px
                    1024: {
                        slidesPerView: 3,
                        spaceBetween: 30
                    },
                    // when window width is >= 1199px
                    1400: {
                        slidesPerView: 4,
                        spaceBetween: 30
                    }
                }
            }
            if (slider.data('style') == 'style-two') {
                breakpoint = {
                    // when window width is >= 320px
                    320: {
                        slidesPerView: 1,
                        grabCursor: true,
                        allowTouchMove: true,
                        centeredSlides: false,
                        spaceBetween: 30
                    },
                    // when window width is >= 767px
                    767: {
                        slidesPerView: 2,
                        grabCursor: true,
                        allowTouchMove: true,
                        centeredSlides: false,
                        spaceBetween: 30
                    },
                    // when window width is >= 992px
                    992: {
                        slidesPerView: 2,
                        grabCursor: true,
                        allowTouchMove: true,
                        centeredSlides: false,
                        spaceBetween: 30
                    },
                    // when window width is >= 1024px
                    1024: {
                        slidesPerView: 2,
                        grabCursor: false,
                        allowTouchMove: false,
                        centeredSlides: true,
                        spaceBetween: 30
                    }
                }
            }
            let config = {
                grabCursor: slider.data('cursor'),
                centeredSlides: slider.data('center'),
                loop: slider.data('loop'),
                allowTouchMove: slider.data('touch-move'),
                autoplay: sliderAutoplay,
                effect: (slider.data('effect')) ? slider.data('effect') : '',
                speed: slider.data('speed'),
                // loopedSlides: (slider.find('.swiper-slide').length * 3),
                spaceBetween: slider.data('space-between'),
                slidesPerView: slider.data('slides'),
                slideToClickedSlide: (slider.data('effect')) ? false : true,
                navigation: {
                    nextEl: '.swiper-button-next',
                    prevEl: '.swiper-button-prev',
                },
                coverflowEffect: {
                    rotate: 70,
                    stretch: 0,
                    depth: 100,
                    modifier: 1,
                    slideShadows: true,
                },
                pagination: iqonicPagination,
                breakpoints: breakpoint
            };
            let swiper = new Swiper(slider[0], config);
            if (jQuery('.portfolio-container.style-two')) {
                swiper.on('transitionStart', function () {
                    if (jQuery(window).width() > 1023) {
                        let boxWidth = jQuery('.portfolio-container.style-two .swiper-slide').width();
                        jQuery('.portfolio-container.style-two .swiper-slide.swiper-slide-active').animate({
                            "width": 800
                        });
                        jQuery('.portfolio-container.style-two .swiper-slide:not(.swiper-slide-active)').animate({
                            "width": boxWidth
                        });
                    }
                });
                swiper.on('resize', function () {
                    if (jQuery(window).width() > 1023) {
                        jQuery('.portfolio-container.style-two .swiper-slide').css({
                            'width': 566
                        });
                        jQuery('.portfolio-container.style-two .swiper-slide.swiper-slide-active').css({
                            'width': 800
                        });
                    }
                });
            }
        });
        if (jQuery('.portfolio-container.style-two').length > 0) {
            jQuery('.portfolio-container.style-two .swiper-slide').css({
                'max-width': 800
            });
        }

    }
}

jQuery(function () {
    if (jQuery('.box').length > 0) {
        jQuery('.box').hoverDirection();
    }
});