jQuery(document).ready(function ($) {
    jQuery('.portfolio-load-btn').each(function (element) {
        $(this).attr('loadmore-page-no', 1);
    });
    $('.portfolio-load-btn').click(function () {
        var button = $(this),
            buttonTxt = button.text(),
            maxPage = button.parent().find('.portfolio-max-page').val(),
            portfolio_current_page = button.attr('loadmore-page-no'),
            portfolio_per_page = button.parent().find('.portfolio-per-page').val(),
            portfolio_per_load = button.parent().find('.portfolio-per-load').val(),
            data = {
                'action': 'iqonic_portfolio_action',
                'query': iqonic_loadmore_params.posts,
                'page': portfolio_current_page,
                'col': button.parent().find('.portfolio-col').val(),
                'settings': button.parent().find('.portfolio-settings').val(),
                'portfolio_per_page': portfolio_per_page,
            };

        $.ajax({
            url: iqonic_loadmore_params.ajaxurl, // AJAX handler
            data: data,
            type: 'POST',
            beforeSend: function (xhr) {
                button.text('Loading...'); // change the button text, you can also add a preloader image
            },

            success: function (data) {
                if (data) {
                    button.parent().prev('.powerhour-portfolio-item').find('.load-with-ajax').append(data); // insert new posts
					button.attr('loadmore-page-no', parseInt(portfolio_current_page) + 1);
                    button.html('<a class="powerhour-box-shadow powerhour-button"> <span class="btn__text text-btn">' + buttonTxt + '</span> </a>');
                    button.parent().find('.portfolio-per-page').val(parseInt(portfolio_per_page) + parseInt(portfolio_per_load))
                    var portfolio_current_page_max = parseInt(portfolio_current_page) + 1;
                    if (portfolio_current_page_max == maxPage)
                        button.remove();
                } else {
                    button.remove(); // if no data, remove the button as well
                }
            }
        });
    });
});
