<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();
$user_login = false;

if (is_user_logged_in()) {
    $user_login = true;
}

// This Condition For User Preview
if (Plugin::$instance->editor->is_edit_mode()) {
    $user_login = $settings['user_login'];
}

if ($user_login) {
    $current_user = wp_get_current_user();
    $get_avatar = get_the_author_meta('powerhour_profile_image', $current_user->ID);
    if (empty($get_avatar)) {
        $get_avatar = get_avatar_url($current_user->ID);
    }
}
?>

<div class="powerhour-users-settings user-btn nav-item nav-icon header-user-rights powerhour-usermenu-dropdown">
    <div class="nav-item nav-icon header-user-rights dropdown-hover">
        <a href="javascript:void(0);" class=" nav-link dropdown-toggle p-0 d-flex">

            <?php
            if (!$user_login || $settings['user_avatar_fix']) {
                echo '<span class="powerhour-avatar">';
                Icons_Manager::render_icon($settings['user_avatar'], ['aria-hidden' => 'true', 'alt' => 'user']);
                echo '</span>';
            } else {
                ?>
                <img src="<?php echo esc_url($get_avatar) ?>" class="img-fluid avatar-40 rounded-circle" alt="<?php esc_attr_e('user','iqonic-extension') ?>">
                <?php
            }
            ?>
        </a>
        <?php
        if (!$user_login) { ?>

            <div class="powerhour-sub-dropdown powerhour-user-dropdown dropdown-menu">
                <div class="powerhour-card shadow-none m-0">
                    <div class="powerhour-card-body p-0">
                        <?php
                        if ($settings['list_user_non_login']) {
                            foreach ($settings['list_user_non_login'] as $item) {
                                ?> 
                                <a href="<?php echo  esc_url(home_url($item['list_page_link'])) ?>" class="powerhour-list-link powerhour-sub-card">

                                    <div class="media align-items-center">

                                        <?php if(!empty($item['list_icon']['value'])){ ?>
                                            <div class="right-icon">
                                                <?php Icons_Manager::render_icon($item['list_icon'], ['aria-hidden' => 'true', 'class' => 'powerhour-user-list-icon']); ?>
                                            </div>
                                        <?php } ?>

                                        <div class="media-body">
                                            <span class="m-0 ">
                                                <?php

                                                echo esc_html($item['list_title']);
                                                ?>
                                            </span>
                                        </div>
                                    </div>
                                </a>
                                  <?php
                            }
                        }
                          ?>

                    </div>
                </div>
            </div>
              <?php

        } else { ?>

            <div class="powerhour-sub-dropdown powerhour-user-dropdown dropdown-menu">
                <div class="powerhour-card shadow-none m-0">
                    <div class="powerhour-user-list-item powerhour-card-body p-0">
                        <?php
                        if ($settings['list_user']) {
                            foreach ($settings['list_user'] as $item) {
                               ?>
                                <a href="<?php echo $item['is_logout'] != 'yes' ? esc_url(home_url($item['list_page_link'])) : wp_logout_url(home_url()) ?>" class="powerhour-list-link  powerhour-sub-card">

                                    <div class="media align-items-center">
                                    
                                        <?php if(!empty($item['list_icon']['value'])){ ?>
                                            <div class="right-icon">
                                                <?php Icons_Manager::render_icon($item['list_icon'], ['aria-hidden' => 'true', 'class' => 'powerhour-user-list-icon']); ?>
                                            </div>
                                        <?php } ?>

                                        <div class="media-body">
                                            <span class="m-0 ">
                                                <?php

                                                echo esc_html($item['list_title']);
                                                ?>
                                            </span>
                                        </div>
                                    </div>
                                </a>
                            <?php
                            }
                        }
                          ?>
                    </div>
                </div>
            </div>
        <?php
        } ?>
    </div>
</div>
