<?php

namespace Iqonic\Elementor\Elements\WoocommerceUser;

use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Repeater;
if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic_woocommerce_user', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Woocommerce User', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-user-circle-o';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_sc_layouts_user_button',
            [
                'label' => esc_html__('Layouts: User Button', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'user_login',
            [
                'label' => esc_html__('User Login?', 'iqonic-extension'),
                'description' => esc_html('This is Option is only for Preview','iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'true' => esc_html__('Yes', 'iqonic-extension'),
                'false' => esc_html__('No', 'iqonic-extension'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'user_avatar_fix',
            [
                'label' => esc_html__('Fixed User Avatar', 'iqonic-extension'),
                'description' => esc_html('option use for fixed for login and logout user same avatar','iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'true' => esc_html__('Yes', 'iqonic-extension'),
                'false' => esc_html__('No', 'iqonic-extension'),
                'default' => 'yes',
            ]
        );

       
        $this->add_control(
            'user_avatar',
            [
                'label' => esc_html__('User Avatar icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
                'default' => [
					'value' => 'fas fa-user',
					'library' => 'Font Awesome 5 Free',
				],
                
            ]
        );

        $this->add_control(
            'icon-color',
            [
                'label'     => esc_html__('Icon Color','iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .nav-item .powerhour-avatar i'=>'color:{{VALUE}}'
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Icon Size', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px','em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .nav-item .powerhour-avatar i,{{WRAPPER}} .nav-item .powerhour-avatar svg' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


       

        $this->add_responsive_control(
            'icon_height',
            [
                'label' => __('Height', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px','em', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-avatar svg,{{WRAPPER}} .powerhour-avatar i, {{WRAPPER}} .powerhour-avatar svg' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

       
        $this->end_controls_section();


        $this->start_controls_section(
            'section_sc_layouts_user',
            [
                'label' => esc_html__('Layouts: Login User Link', 'iqonic-extension'),
            ]
        );

      

        $repeater = new Repeater();

        $repeater->add_control(
            'list_title',
            [
                'label' => esc_html__('Title', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('User', 'iqonic-extension'),
                'label_block' => true,
            ]
        );



        $repeater->add_control(
            'list_icon',
            [
                'label' => esc_html__('Select Icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
            ]
        );
        $repeater->add_control(
            'is_logout',
            [
                'label' => esc_html__('Is Logout Button?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'no' => esc_html__('No', 'iqonic-extension'),
                'yes' => esc_html__('Yes', 'iqonic-extension'),
            ]
        );
        $repeater->add_control(
            'list_page_link',
            [
                'label' => esc_html('Select Page ', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'options' => iqonic_get_posts('page', array(), 'id'),
                'label_block' => true,
                'condition' => ['is_logout!' => 'yes']
            ]
        );

        $this->add_control(
            'list_user',
            [
                'label' => esc_html__('Login User Settings', 'iqonic-extension'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => esc_html__('Account', 'iqonic-extension'),
                        'list_icon' => esc_html__('fa fa-start', 'iqonic-extension'),

                    ],
                    [
                        'list_title' => esc_html__('Logout', 'iqonic-extension'),
                        'list_icon' => esc_html__('fa fa-start', 'iqonic-extension'),

                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_sc_layouts_user_non_login',
            [
                'label' => esc_html__('Layouts: Non Login User Link', 'iqonic-extension'),
            ]
        );

      

        $repeater = new Repeater();

        $repeater->add_control(
            'list_title',
            [
                'label' => esc_html__('Title', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('User', 'iqonic-extension'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'list_icon',
            [
                'label' => esc_html__('Select Icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
            ]
        );
      
        $repeater->add_control(
            'list_page_link',
            [
                'label' => esc_html('Select Page ', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'options' => iqonic_get_posts('page', array(), 'id'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'list_user_non_login',
            [
                'label' => esc_html__('Non Login User Settings', 'iqonic-extension'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'list_title' => esc_html__('Sign in', 'iqonic-extension'),
                        'list_icon' => esc_html__('fa fa-start', 'iqonic-extension'),
                    ],
                    [
                        'list_title' => esc_html__('Sign Up', 'iqonic-extension'),
                        'list_icon' => esc_html__('fa fa-start', 'iqonic-extension'),
                    ],
                ],
                'title_field' => '{{{ list_title }}}',
            ]
        );

        $this->end_controls_section();
     
     }

    protected function render()
    {
        require 'render.php';
    }
}
