<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


$settings = $this->get_settings();
?>

<div class="powerhour-woocommerce-custom-form">
    <?php
        if($settings['powerhour_has_logo'] == 'yes'){ ?>
            <div class="powerhour-form-logo">
                <a class="form-logo" href="<?php echo esc_url(home_url('/')); ?>">
                    <?php
                    if (function_exists('get_field') || class_exists('ReduxFramework')) {
                        global $powerhour_options;
                        $is_yes = function_exists('get_field') ? get_field('acf_key_header_switch') : '';
                        $acf_logo = function_exists('get_field') ? get_field('header_logo') : '';

                        if ($is_yes === 'yes' && !empty($acf_logo['url'])) {
                            $options = $acf_logo['url'];
                        } else if (isset($powerhour_options['header_radio'])) {
                            if ($powerhour_options['header_radio'] == 1) {
                                $logo_text = $powerhour_options['header_text'];
                                echo esc_html($logo_text);
                            }
                            if ($powerhour_options['header_radio'] == 2) {
                                $options = $powerhour_options['powerhour_logo']['url'];
                            }
                        }

                        if (isset($options) && !empty($options)) {
                            echo '<img class="img-fluid logo" src="' . esc_url($options) . '" alt="' . esc_attr('power-hour', 'iqonic-extension') . '">';
                        }
                    } elseif (has_header_image()) {
                        $image = wp_get_attachment_image_src(get_theme_mod('custom_logo'), 'full');
                        if (has_custom_logo()) {
                            echo '<img class="img-fluid logo" src="' . esc_url($image) . '" alt="' . esc_attr('power-hour', 'iqonic-extension') . '">';
                        } else {
                            bloginfo('name');
                        }
                    } else {
                        $logo_url = get_template_directory_uri() . '/assets/images/logo.svg';
                        echo '<img class="img-fluid logo" src="' . esc_url($logo_url) . '" alt="' . esc_attr('power-hour', 'iqonic-extension') . '">';
                    } ?>
                </a> 
            </div>
        <?php }



        if( $settings['woocommerce_login_form'] == 'signup-form' ) { /* signup form */

            if ($settings['signin_link_type'] == 'dynamic') {
                $url = get_permalink(get_page_by_path($settings['signin_dynamic_link']));
                $this->add_render_attribute('powerhour_class', 'href', esc_url($url));
            } else {
                if ($settings['signin_link']['url']) {
                    $url = $settings['signin_link']['url'];
                    $this->add_render_attribute('powerhour_class', 'href', esc_url($url));
            
                    if ($settings['signin_link']['is_external']) {
                        $this->add_render_attribute('powerhour_class', 'target', '_blank');
                    }
            
                    if ($settings['signin_link']['nofollow']) {
                        $this->add_render_attribute('powerhour_class', 'rel', 'nofollow');
                    }
                }
            }

            $text_string = $settings['signin_text_string'];
            $button_text = $settings['signin_button_text'];

            if( !is_user_logged_in() ){

                echo do_shortcode( '[iqonic-signup-form btn_text_string="'.$text_string.'" button_text="'.$button_text.'" url="'.$url.'" ]' );

            } else { ?>

                <p class="logged-in"> <?php esc_html_e('Note: You are already logged in to your account','iqonic-extension'); ?> </p>
                <?php
            }

        } elseif( $settings['woocommerce_login_form'] == 'login-form' ) { /* login form */

        if ($settings['link_type'] == 'dynamic') {
            $url = get_permalink(get_page_by_path($settings['dynamic_link']));
            $this->add_render_attribute('powerhour_class', 'href', esc_url($url));
        } else {
            if ($settings['link']['url']) {
                $url = $settings['link']['url'];
                $this->add_render_attribute('powerhour_class', 'href', esc_url($url));
        
                if ($settings['link']['is_external']) {
                    $this->add_render_attribute('powerhour_class', 'target', '_blank');
                }
        
                if ($settings['link']['nofollow']) {
                    $this->add_render_attribute('powerhour_class', 'rel', 'nofollow');
                }
            }
        }

        $text_string = $settings['button_text_string'];
        $button_text = $settings['button_text'];

        $forgot_password_string = $settings['forgot_password_text'];

        if ($settings['forgot_password_link_type'] == 'dynamic') {
            $forgot_password_url = get_permalink(get_page_by_path($settings['forgot_password_dynamic_link']));
            $this->add_render_attribute('powerhour_class', 'href', esc_url($forgot_password_url));
        } else {
            if ($settings['forgot_password_link']['url']) {
                $forgot_password_url = $settings['forgot_password_link']['url'];
                $this->add_render_attribute('powerhour_class', 'href', esc_url($forgot_password_url));
        
                if ($settings['forgot_password_link']['is_external']) {
                    $this->add_render_attribute('powerhour_class', 'target', '_blank');
                }
        
                if ($settings['forgot_password_link']['nofollow']) {
                    $this->add_render_attribute('powerhour_class', 'rel', 'nofollow');
                }
            }
        }

        if( !is_user_logged_in() ){

            echo do_shortcode( '[iqonic-login-form btn_text_string="'.$text_string.'" button_text="'.$button_text.'" url="'.$url.'" lost_password_string="'.$forgot_password_string.'" lost_password_url="'.$forgot_password_url.'" ]' );
        
        } else { ?>
            <p class="logged-in"> <?php esc_html_e('Note: You are already logged in to your account','iqonic-extension'); ?> </p>
            <?php
        }

    } elseif( $settings['woocommerce_login_form'] == 'order-tracking' ){

        echo do_shortcode( '[woocommerce_order_tracking]' );

    } elseif( $settings['woocommerce_login_form'] == 'lost-password' ) {

        if( ! is_user_logged_in() ){

            echo do_shortcode( '[iqonic-lost-password-form]' );

        } else { ?>
            <p class="logged-in"> <?php esc_html_e('Note: You are already logged in to your account','iqonic-extension'); ?> </p>
            <?php
        }

    }

?>

</div>