<?php

namespace Iqonic\Elementor\Elements\WoocommerceLogin;

use Elementor\Group_Control_Background;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Typography;
if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return 'iqonic_woocommerce_login';
    }

    public function get_title()
    {
        return __('Iqonic Woocommerce Login', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-site-title';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_woocommerce_login',
            [
                'label' => esc_html__('Woocommerce Login', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'woocommerce_login_form',
            [
                'label'      => __('Select option', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'signup-form',
                'options'    => [
                    'signup-form'     => __('Signup Form', 'iqonic-extension'),
                    'login-form'      => __('Login Form', 'iqonic-extension'),
                    'lost-password'      => __('Lost Password', 'iqonic-extension'),
                    'order-tracking'  => __('Order tracking', 'iqonic-extension'),
                ],
            ]
        );

        $this->end_controls_section();

        /* Start logo */

        $this->start_controls_section(
            'section_woocommerce_logo',
            [
                'label' => esc_html__('Logo', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'powerhour_has_logo',
            [
                'label' => __('Display Logo?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'iqonic-extension'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'condition' => ['powerhour_has_logo' => 'yes'],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .powerhour-form-logo' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /* End start logo */

        /* Start Sign In form URL */

        $this->start_controls_section(
            'section_woocommerce_signin',
            [
                'label' => esc_html__('Sign In URL', 'iqonic-extension'),
                'condition' => ['woocommerce_login_form' => 'signup-form']
            ]
        );

        $this->add_control(
            'signin_text_string',
            [
                'label' => __('Label string', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __("Don't have an account yet?", 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'signin_button_text',
            [
                'label' => __('Button Text', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('Sign Up', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'signin_link_type',
            [
                'label' => __('Link Type', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'dynamic',
                'options' => [
                    'dynamic' => __('Dynamic', 'iqonic-extension'),
                    'custom' => __('Custom', 'iqonic-extension'),
                ],
            ]
        );
        
        $this->add_control(
            'signin_dynamic_link',
            [
                'label' => esc_html__('Select Page', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'return_value' => 'true',
                'multiple' => true,
                'condition' => [
                    'signin_link_type' => 'dynamic',
                ],
                'options' => iqonic_get_posts("page"),
            ]
        );
        
        
        $this->add_control(
            'signin_link',
            [
                'label' => __('Link', 'iqonic-extension'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __('https://your-link.com', 'iqonic-extension'),
                'default' => [
                    'url' => '#',
                ],
                'condition' => [
                    'signin_link_type' => 'custom',
                ]
            ]
        );

        $this->end_controls_section();

        /* End Sign In form URL */

        $this->start_controls_section(
            'section_woocommerce_signup',
            [
                'label' => esc_html__('Signup URL', 'iqonic-extension'),
                'condition' => ['woocommerce_login_form' => 'login-form']
            ]
        );

        $this->add_control(
            'button_text_string',
            [
                'label' => __('Label string', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __("Don't have an account yet?", 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'button_text',
            [
                'label' => __('Button Text', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('Sign Up', 'iqonic-extension'),
            ]
        );


        $this->add_control(
            'link_type',
            [
                'label' => __('Link Type', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'dynamic',
                'options' => [
                    'dynamic' => __('Dynamic', 'iqonic-extension'),
                    'custom' => __('Custom', 'iqonic-extension'),
                ],
            ]
        );
        
        $this->add_control(
            'dynamic_link',
            [
                'label' => esc_html__('Select Page', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'return_value' => 'true',
                'multiple' => true,
                'condition' => [
                    'link_type' => 'dynamic',
                ],
                'options' => iq_custom_post_data("page"),
            ]
        );
        
        
        $this->add_control(
            'link',
            [
                'label' => __('Link', 'iqonic-extension'),
                'type' => Controls_Manager::URL,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __('https://your-link.com', 'iqonic-extension'),
                'default' => [
                    'url' => '#',
                ],
                'condition' => [
                    'link_type' => 'custom',
                ]
            ]
        );

        $this->end_controls_section();

            /* Start Forgot Password URL */

            $this->start_controls_section(
                'section_woocommerce_forgot_password',
                [
                    'label' => esc_html__('Forgot Password URL', 'iqonic-extension'),
                    'condition' => ['woocommerce_login_form' => 'login-form']
                ]
            );
    
            $this->add_control(
                'forgot_password_text',
                [
                    'label' => __('Text', 'iqonic-extension'),
                    'type' => Controls_Manager::TEXT,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'label_block' => true,
                    'default' => __('Forgot Password?', 'iqonic-extension'),
                ]
            );
    
    
            $this->add_control(
                'forgot_password_link_type',
                [
                    'label' => __('Link Type', 'iqonic-extension'),
                    'type' => Controls_Manager::SELECT,
                    'default' => 'dynamic',
                    'options' => [
                        'dynamic' => __('Dynamic', 'iqonic-extension'),
                        'custom' => __('Custom', 'iqonic-extension'),
                    ],
                ]
            );
            
            $this->add_control(
                'forgot_password_dynamic_link',
                [
                    'label' => esc_html__('Select Page', 'iqonic-extension'),
                    'type' => Controls_Manager::SELECT,
                    'return_value' => 'true',
                    'multiple' => true,
                    'condition' => [
                        'link_type' => 'dynamic',
                    ],
                    'options' => iqonic_get_posts("page"),
                ]
            );
            
            
            $this->add_control(
                'forgot_password_link',
                [
                    'label' => __('Link', 'iqonic-extension'),
                    'type' => Controls_Manager::URL,
                    'dynamic' => [
                        'active' => true,
                    ],
                    'placeholder' => __('https://your-link.com', 'iqonic-extension'),
                    'default' => [
                        'url' => '#',
                    ],
                    'condition' => [
                        'link_type' => 'custom',
                    ]
                ]
            );
    
            $this->end_controls_section();
    
            /* End Forgot Password URL */

        /* form */
        $this->start_controls_section(
            'section_form',
            [
                'label' => __('Form', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
            
        );    

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'form_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-woocommerce-custom-form',

            ]
        );

        $this->end_controls_section();

        /* form */
        $this->start_controls_section(
            'section_form_logo',
            [
                'label' => __('Form Logo', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
            
        );    

        $this->add_responsive_control(
            'form_logo_height',
            [
                'label' => __('Max height', 'iqonic-layouts'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'size' => 80,
                    'unit' => 'px'
                ],
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 20
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-woocommerce-custom-form .form-logo .logo' => 'height: {{SIZE}}{{UNIT}};max-height: {{SIZE}}{{UNIT}};',
                ]
            ]
        );

        $this->add_responsive_control(
            'form_logo_width',
            [
                'label' => __('Width', 'iqonic-layouts'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', 'em'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 200
                    ],
                    'em' => [
                        'min' => 0,
                        'max' => 20
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-woocommerce-custom-form .form-logo .logo' => 'width: {{SIZE}}{{UNIT}};',
                ]
            ]
        );

        $this->end_controls_section();

        /* Start Order tracking */

        $this->start_controls_section(
            'section_order_tracking',
            [
                'label' => __('Form Attributes', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
			'heading_input_field',
			[
				'label' => esc_html__( 'Input field', 'iqonic-extension' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'order_tracking_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selectors' => ['{{WRAPPER}}.woocommerce-form .woocommerce-form-track-order .track_order p input::placeholder,
                            {{WRAPPER}} .powerhour-woocommerce-custom-form input'
                ],
            ]
        );

        $this->add_control(
            'order_tracking_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    ' {{WRAPPER}} .woocommerce-form-track-order ,
                    {{WRAPPER}} .powerhour-woocommerce-custom-form input ,
                    {{WRAPPER}} .powerhour-woocommerce-custom-form input::placeholder' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
			'heading_input_label',
			[
				'label' => esc_html__( 'Label', 'iqonic-extension' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'form_label',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-woocommerce-custom-form label',
            ]
        );

        $this->add_control(
            'form_label_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    ' {{WRAPPER}} .powerhour-woocommerce-custom-form label' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
			'heading_button',
			[
				'label' => esc_html__( 'Button', 'iqonic-extension' ),
				'type' => Controls_Manager::HEADING,
				'separator' => 'before',
			]
		);

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'order_button_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .woocommerce-form-track-order button.button , {{WRAPPER}} .powerhour-button',
            ]
        );

        $this->add_control(
            'order_button_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-form-track-order button.button .powerhour-btn-text  , {{WRAPPER}} .powerhour-button' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'order_button_background',
            [
                'label' => __('Background Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .woocommerce-form-track-order button.buttons  , {{WRAPPER}} .powerhour-button ' => 'background-color: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();

        /* End Order tracking */
     
    }

    protected function render()
    {
        require 'render.php';
    }
}
