<?php

namespace Iqonic\Elementor\Elements\VideoPopup;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Css_Filter;
use Elementor\Group_Control_Border;
use Elementor\Plugin;
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic-VideoPopup', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Popup Video', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-video-camera';
    }


    protected function register_controls()
    {
        $this->start_controls_section(
            'section_video_style',
            [
                'label' => __('Video Style', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label' => __('Style','iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'style1' => 'Style 1',
                    'style2' => 'Style 2',
                    'style3' => 'Style 3',
                ],
                'default' => 'style1',
                'description' => __('This is description', 'iqonic-extension')
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'section',
            [
                'label' => __('Popup Video', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'video_type',
            [
                'label' => __('Source', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'youtube',
                'options' => [
                    'video_link' => __('Link', 'iqonic-extension'),
                    'hosted' => __('Self Hosted', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'hosted_url',
            [
                'label' => __('Choose File', 'iqonic-extension'),
                'type' => Controls_Manager::MEDIA,

                'media_type' => 'video',
                'condition' => [
                    'video_type' => 'hosted',
                ],
            ]
        );

        $this->add_control(
            'link_url',
            [
                'label' => __('Link', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'placeholder' => __('Enter your URL', 'iqonic-extension'),
                'default' => 'https://www.youtube.com/watch?v=XHOmBV4js_E',
                'label_block' => true,
                'condition' => [
                    'video_type' => 'video_link',
                ],
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => __('Video Text', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('Video', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'media_style',
            [
                'label'      => __('Select Style', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'none',
                'options'    => [

                    'icon'          => __('Icon', 'iqonic-extension'),
                    'image'          => __('Image', 'iqonic-extension'),
                    'none'          => __('none', 'iqonic-extension'),

                ],
            ]
        );

        $this->add_control(
            'image_icon',
            [
                'label' => __('Choose Image', 'iqonic-extension'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'media_style' => 'image',
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label' => __('Play Icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star',
                    'library' => 'solid',
                ],
                'skin' => 'inline',
                'label_block' => false,
                'condition' => [
                    'media_style' => 'icon',
                ],
            ]
        );

        $this->add_control(
            'iqonic_has_box_shadow',
            [
                'label' => __('Box Shadow?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );


        $this->end_controls_section();
        $this->start_controls_section(
            'section_NZk6cbrofHfRt2C5bJS9',
            [
                'label' => __('Icon', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_back_color',
            [
                'label' => __('Icon Box Background Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'alpha' => true,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video .powerhour-video-icon .powerhour-video,.powerhour-popup-video .powerhour-video-icon .powerhour-waves .waves' => 'background: {{VALUE}};',
                ],

            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('Icon Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video .powerhour-video-icon i,.powerhour-popup-video .powerhour-video-icon svg, {{WRAPPER}} .powerhour-popup-video.powerhour-popup-video_Style_2 .powerhour-video svg' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-popup-video .powerhour-video-icon svg path, {{WRAPPER}} .powerhour-popup-video.powerhour-popup-video_Style_2 .powerhour-video svg path' => 'fill: {{VALUE}};',
                ],
                'condition' => ['media_style' => 'icon']
            ]
        );

        $this->add_control(
            'has_border',
            [
                'label' => __('Use Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'label_off',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'powerhour_icon_border_color',
            [
                'label' => __('Icon Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video .powerhour-video-icon .powerhour-video' => 'border-color: {{VALUE}};',
                ],
                'condition' => ['has_border' => 'yes']
            ]
        );

        $this->add_control(
            'powerhour_icon_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video .powerhour-video-icon .powerhour-video' => 'border-style: {{VALUE}};',

                ],
                'condition' => ['has_border' => 'yes']
            ]
        );

        $this->add_control(
            'powerhour_icon_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video .powerhour-video-icon .powerhour-video' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['has_border' => 'yes']

            ]
        );

        $this->add_control(
            'powerhour_icon_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video .powerhour-video-icon .powerhour-video' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['has_border' => 'yes']
            ]
        );

        $this->add_control(
            'powerhour_icon_size',
            [
                'label' => __('Icon Size', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'default' => [
                    'unit' => 'px',
                    'size' => 45,
                ],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-video svg' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'powerhour_icon_width',
            [
                'label' => __('Width', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-video' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'powerhour_icon_height',
            [
                'label' => __('Height', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-video' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'powerhour_video_icon_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video .powerhour-video-icon .powerhour-video' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'powerhour_video_icon_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video .powerhour-video-icon .powerhour-video' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'section_NZk6cbrofHt2C5bJS9',
            [
                'label' => __('Image', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['media_style' => 'image'],
            ]
        );

        $this->start_controls_tabs('image_effects');

        $this->start_controls_tab(
            'normal',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'opacity',
            [
                'label' => __('Opacity', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters',
                'selector' => '{{WRAPPER}} .powerhour-popup-video img',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'hover',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'opacity_hover',
            [
                'label' => __('Opacity', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 1,
                        'min' => 0.10,
                        'step' => 0.01,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video:hover img' => 'opacity: {{SIZE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Css_Filter::get_type(),
            [
                'name' => 'css_filters_hover',
                'selector' => '{{WRAPPER}} .powerhour-popup-video:hover img',
            ]
        );

        $this->add_control(
            'background_hover_transition',
            [
                'label' => __('Transition Duration', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'max' => 3,
                        'step' => 0.1,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video img' => 'transition-duration: {{SIZE}}s',
                ],
            ]
        );

        $this->add_control(
            'hover_animation',
            [
                'label' => __('Hover Animation', 'iqonic-extension'),
                'type' => Controls_Manager::HOVER_ANIMATION,
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'selector' => '{{WRAPPER}} .powerhour-popup-video img',
                'separator' => 'before',
            ]
        );

        $this->add_responsive_control(
            'image_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'image_box_shadow',
                'exclude' => [
                    'box_shadow_position',
                ],
                'selector' => '{{WRAPPER}} .powerhour-popup-video img',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_caption',
            [
                'label' => __('Caption', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => ['media_style' => 'image'],
            ]
        );

        $this->add_control(
            'caption_align',
            [
                'label' => __('Alignment', 'iqonic-extension'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => __('Justified', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video' => 'text-align: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();

        $this->start_controls_section(
            'section_video_text_caption',
            [
                'label' => __('Text', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_video_text_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-popup-video .powerhour-video-text',
            ]
        );
        $this->add_control(
            'video_text',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-popup-video .powerhour-video-text' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/VideoPopup/render.php';
    }
}
