<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;


$settings = $this->get_settings();

$image_html = '';

$align = $settings['align'] ?? '';
if (empty($align)) {
	$align .= ' text-left';
}
if ($settings['iqonic_has_box_shadow'] == 'yes') {
	$align .= ' powerhour-box-shadow';
}

$this->add_render_attribute('powerhour-section', 'class', $align);
$this->add_render_attribute('powerhour-section', 'class', 'powerhour-title-box');

if ($settings['media_style'] == 'image') {
	if (!empty($settings['image']['url'])) {
		$this->add_render_attribute('image', 'src', $settings['image']['url']);
		$this->add_render_attribute('image', 'srcset', $settings['image']['url']);
		$this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($settings['image']));
		$this->add_render_attribute('image', 'title', Control_Media::get_image_title($settings['image']));
		$image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
	}
}
	$this->add_render_attribute('powerhour-section', 'class', 'powerhour-title-box-1');
	 ?>
	<div <?php echo $this->get_render_attribute_string('powerhour-section'); ?>>
		<?php if ($settings['position'] == 'top') { ?>
			<div class="powerhour-title-icon">
				<?php
				echo $image_html;
				if ($settings['media_style'] == 'icon') {
					Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']);
				}
				?>
			</div>
		<?php } ?>
		<?php if ($settings['sub_title_position'] == 'before') {
			if ($settings['position'] == 'left') { ?>
				<div class="d-flex">
					<div class="powerhour-title-icon">
						<?php
						echo $image_html;
						if ($settings['media_style'] == 'icon') {
							Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']);
						}
						?>
					</div>
					<?php
					if (!empty($settings['sub_title']) && $settings['sub_title_position'] == 'before') {
						echo sprintf('<span class="powerhour-subtitle">%1$s</span>', esc_html($settings['sub_title']));
					}
					?>
				</div>
			<?php } else { ?>
				<?php
				if (!empty($settings['sub_title']) && $settings['sub_title_position'] == 'before') {
					echo sprintf('<span class="powerhour-subtitle">%1$s</span>', esc_html($settings['sub_title']));
				}
				?>
		<?php } } ?>
		
			<?php if (!empty($settings['section_title'])) { ?>
        <<?php echo esc_attr($settings['title_tag']);  ?> class="powerhour-title powerhour-heading-title">
            <?php
			$section_title = explode(' ', $settings['section_title']);
			$style = $settings['hightlight_style'];
			$title = '';
			$position= [];
			if(!empty($settings['word_position'])){
				$position[] = $settings['word_position'] -1; //for style 1,2
				$start = $settings['word_position'] -1; //for style 3
			}
			if(!empty($settings['hightlight_style']=='2' && !empty($settings['2nd_word_position']))){
				$position[] = $settings['2nd_word_position'] -1;
			}
			if($settings['hightlight_style'] == '3'){
			if(!empty($settings['select_range'])){
				$highlited ='';
				$range = $settings['select_range'] -1;
			}}
			foreach ($section_title as $pos => $word){
				switch($style){
					case 1:
					case 2:
						if(in_array($pos ,$position)){
							$title .= " "."<span class='highlighted-text-wrap'><span class='highlighted-text'>" . $word . "</span></span>";	}
						else{ $title .= " " . $word;	}
						break;
					case 3:
						if($start <= $pos && $range >=$pos){
							$highlited .= " ".$word;
							if($pos == $range){
							$title .= " "."<span class='highlighted-text-wrap'><span class='highlighted-text'>" .  $highlited . "</span></span>";}
						}else{
							$title .= " " . $word;
						}
						break;
					default:
						echo " ".$word;					
				}
			}
            ?>
            <?php echo wp_kses($title, array('span' => array("class" => true), 'br' => true)); ?>
        </<?php echo esc_attr($settings['title_tag']); ?>>
    <?php } ?>
			
		<?php if ($settings['sub_title_position'] == 'after') {
			if ($settings['position'] == 'left') { ?>
				<div class="powerhour-title-icon">
					<?php
					echo $image_html;
					if ($settings['media_style'] == 'icon') {
						Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']);
					}
					?>
				</div>
				<?php
				if (!empty($settings['sub_title']) && $settings['sub_title_position'] == 'after') {
					echo sprintf('<span class="powerhour-subtitle">%1$s</span>', esc_html($settings['sub_title']));
				}
				?>
			<?php } else { ?>
		<?php
				if (!empty($settings['sub_title']) && $settings['sub_title_position'] == 'after') {
					echo sprintf('<span class="powerhour-subtitle">%1$s</span>', esc_html($settings['sub_title']));
				}
			}
		}
		?>
		<?php
		if (!empty($settings['description']) && $settings['has_description'] == 'yes') {
			echo sprintf('<div class="powerhour-title-desc">%1$s</div>', $this->parse_text_editor($settings['description']));
		}
		?>
	</div> 
