<?php

namespace Iqonic\Elementor\Elements\Title;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Utils;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic_title', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Section Title', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-site-title';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section',
            [
                'label' => __('Section Title', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'section_title',
            [
                'label'      => __('Section Title', 'iqonic-extension'),
                'type'       => Controls_Manager::TEXT,
                'dynamic'    => [
                    'active' => true,
                ],
                'label_block'=> true,
                'default'    => __('Section Title', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'hightlight_style',
            [
                'label' => __('Hightlight Style','iqonic-extension'),
                'type'  => Controls_Manager::SELECT,
                'options'   => [
                    '1'=> __('One Word','iqonic-extension'),
                    '2'=> __('Two Word','iqonic-extension'),
                    '3'=> __('Select Range','iqonic-extension'),
                    '4'=> __('none','iqonic-extension'),
                ],
                'default'   => '1'
            ]
        );

        $this->add_control(
            'word_position',
            [
                'label'         => __('Word Position', 'iqonic-extension'),
                'description'   => __('Enter position of the word to heighlight.', 'iqonic-extension'),
                'type'          => Controls_Manager::NUMBER,
                'min'           => 0,
                'max'           => 30,
                'step'          => 1,
                'default'       => 0,
                'condition'     => ['hightlight_style!' => '4' ]
            ]
        );

        $this->add_control(
            '2nd_word_position',
            [
                'label'         => __('2nd Word Position', 'iqonic-extension'),
                'description'   => __('Enter position of the 2nd word to heighlight.', 'iqonic-extension'),
                'type'          => Controls_Manager::NUMBER,
                'min'           => 0,
                'max'           => 30,
                'step'          => 1,
                'default'       => 0,
                'condition'     => ['hightlight_style' => '2']
            ]
        );

        $this->add_control(
            'select_range',
            [
                'label'    => __('Range','iqonic-extension'),
                'type'     => Controls_Manager::NUMBER,
                'min'      => 0,
                'max'      => 30,
                'step'     => 1,
                'default'  => 1,
                'condition'=> ['hightlight_style'=>'3'] 
            ]
        );

        $this->add_control(
            'sub_title',
            [
                'label'      => __('Section Sub Title', 'iqonic-extension'),
                'type'       => Controls_Manager::TEXT,
                'dynamic'    => [
                    'active' => true,
                ],
                'label_block'=> true,
                'default'    => __('Section Sub Title', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'sub_title_position',
            [
                'label'      => __('Sub Title Position', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'after',
                'options'    => [
                    'before' => __('Before Title', 'iqonic-extension'),
                    'after'  => __('After Title', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'has_description',
            [
                'label'     => __('Has Description?', 'iqonic-extension'),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'no',
                'yes'       => __('yes', 'iqonic-extension'),
                'no'        => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'description',
            [
                'label'         => __('Description', 'iqonic-extension'),
                'type'          => Controls_Manager::TEXTAREA,
                'dynamic'       => [
                    'active'    => true,
                ],
                'placeholder'   => __('Enter Title Description', 'iqonic-extension'),
                'default'       => __('Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'iqonic-extension'),
                'condition'     => ['has_description' => 'yes']
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'      => __('Title Tag', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'h2',
                'options'    => [
                    'h1'     => __('h1', 'iqonic-extension'),
                    'h2'     => __('h2', 'iqonic-extension'),
                    'h3'     => __('h3', 'iqonic-extension'),
                    'h4'     => __('h4', 'iqonic-extension'),
                    'h5'     => __('h5', 'iqonic-extension'),
                    'h6'     => __('h6', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'iqonic_has_box_shadow',
            [
                'label' => __('Box Shadow?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'iqonic-extension'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'section_cf6i4c8e7lf4ocrcLUGa',
            [
                'label' => __('Icon/Image', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'media_style',
            [
                'label'      => __('Icon / Image', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'none',
                'options'    => [
                    'icon'          => __('Icon', 'iqonic-extension'),
                    'image'          => __('Image', 'iqonic-extension'),
                    'none'          => __('None', 'iqonic-extension'),
                ],
            ]
        );
        $this->add_control(
            'position',
            [
                'label' => __('Position', 'iqonic-extension'),
                'type'  => Controls_Manager::CHOOSE,
                'default' => 'top',
                'options' => [
                    'top' => [
                        'title' => __('Top', 'iqonic-extension'),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'left' => [
                        'title' => __('Left', 'iqonic-extension'),
                        'icon' => 'eicon-h-align-left',
                    ],
                ],
                'condition' => [
                    'media_style!' => 'none',
                ],
                'prefix_class' => 'image-position-'
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label' => __('Icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'condition' => [
                    'media_style' => 'icon',
                ],
                'default' => [
                    'value' => 'fas fa-star'
                ],
                'skin' => 'inline',
                'label_block' => false,
                'show_label' => true
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __('Choose Image', 'iqonic-extension'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'media_style' => 'image',
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();
        // Container Style Section End

        $this->start_controls_section(
            'section_NIfezt7YM7feDaT9vP8J',
            [
                'label' => __('Title Box', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('titlebox_tabs');
        $this->start_controls_tab(
            'tabs_c8fpaelTGDkf951QeYf2',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'titlebox_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-title-box ',
            ]
        );

        $this->add_control(
            'titlebox_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'titlebox_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'condition' => [
                    'titlebox_has_border' => 'yes',
                ],
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box' => 'border-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'titlebox_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'titlebox_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'titlebox_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'titlebox_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'titlebox_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'titlebox_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_49pcfagYof19beG4w8Ee',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'titlebox_hover_background',
                'label' => __('Hover Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-title-box:hover ',
            ]
        );


        $this->add_control(
            'titlebox_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'titlebox_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'condition' => [
                    'titlebox_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box:hover' => 'border-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'titlebox_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'titlebox_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'titlebox_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'titlebox_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'titlebox_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'titlebox_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'titlebox_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-title-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'titlebox_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-title-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->end_controls_section();
        /* title box End*/

        // Title Style Section
        $this->start_controls_section(
            'section_f4aS9uHc50Of5eNP8jbc',
            [
                'label' => __('Title', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


		$this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'content_typography',
                'label' => __('Highlighted Text Typo', 'iqonic-extension'),
				'selector' => '{{WRAPPER}} .powerhour-title-box.powerhour-title-box-1 .powerhour-heading-title .highlighted-text-wrap .highlighted-text',
			]
		);

        $this->add_control(
            'highlighted_text_color',
            [
                'label' => __('Highlighted Text','iqonic-extension'),
                'type'  => Controls_Manager::COLOR,
                'default'=> '#005550',
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box.powerhour-title-box-1 .powerhour-heading-title .highlighted-text-wrap .highlighted-text' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-title-box.powerhour-title-box-1 .powerhour-heading-title .highlighted-text-wrap .highlighted-text:after'=> 'background : {{VALUE}} !important'
                ]
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'mobile_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-title-box  .powerhour-heading-title,{{WRAPPER}} .powerhour-title-box  .powerhour-heading-title .left-text',
            ]
        );

        $this->start_controls_tabs('title_tabs');

        $this->start_controls_tab(
            'title_color_tab_normal',
            [
                'label' => __('normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'title_normal_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box  .powerhour-heading-title' => 'color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'title2_normal_color',
            [
                'label' => __('Title2 Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'condition' => ['design_style' => '2'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box  .powerhour-heading-title .left-text' => 'color: {{VALUE}}; important',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'title_back_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-title-box  .powerhour-heading-title',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_color_tab_hover',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box.powerhour-title-box-1:hover .powerhour-heading-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'title_hover_back_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-title-box:hover  .powerhour-heading-title',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box  .powerhour-heading-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box  .powerhour-heading-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_section();
        // Title Style Section End

        // Sub Title Style Section
        $this->start_controls_section(
            'section_2DfcMGaqcAClSRKbf9e3',
            [
                'label' => __('Sub Title', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );


        $this->start_controls_tabs('sub_title_tabs');


        $this->start_controls_tab(
            'sub_title_color_tab_normal',
            [
                'label' => __('normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'sub_title_normal_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box .powerhour-subtitle' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'sub_title_back_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-title-box .powerhour-subtitle',
            ]
        );
        
        $this->end_controls_tab();

        $this->start_controls_tab(
            'sub_title_color_tab_hover',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'sub_title_hover_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box:hover .powerhour-subtitle' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'sub_title_hover_back_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-title-box:hover .powerhour-subtitle',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_control(
            'sub_title_line',
            [
                'label' => __('Line', 'iqonic-extension'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'line_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box .powerhour-subtitle' => 'background-image: {{VALUE}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'line_width',
            [
                'label' => __('Width', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box .powerhour-subtitle::before' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'line_height',
            [
                'label' => __('Height', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box .powerhour-subtitle::before' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );



        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'sub_title_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-title-box .powerhour-subtitle',
            ]
        );


        $this->add_responsive_control(
            'sub_title_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box .powerhour-subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'sub_title_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box .powerhour-subtitle' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_section();
        // Sub Title Style Section End

        // Description Style Section
        $this->start_controls_section(
            'section_ZcASngaa14lc8er55aND',
            [
                'label' => __('Description', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['has_description' => 'yes']
            ]
        );

        $this->add_control(
            'description_heading_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );


        $this->start_controls_tabs('description_tabs');


        $this->start_controls_tab(
            'description_color_tab_normal',
            [
                'label' => __('normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'description_normal_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box  .powerhour-title-desc' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'description_color_tab_hover',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'description_hover_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box  .powerhour-title-desc:hover' => 'color: {{VALUE}};',
                ],

            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'description_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-title-box  .powerhour-title-desc',
            ]
        );

        $this->add_responsive_control(
            'desciption_marging',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box  .powerhour-title-desc' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'desciption_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box  .powerhour-title-desc' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_section();
        // Descrition Style Section End

        //Icon/Image

        $this->start_controls_section(
            'section_icon_style',
            [
                'label' => __('Icon', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'media_style!' => 'none',
                ],
            ]
        );


        $this->start_controls_tabs('icon_tabs');
        $this->start_controls_tab(
            'tabs_jeBef122kCfHObvih40638',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );


        $this->add_control(
            'icon_color',
            [
                'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-icon svg,{{WRAPPER}} .powerhour-title-icon i,{{WRAPPER}} .powerhour-title-icon svg path' => 'fill: {{VALUE}}; color: {{VALUE}};'
                ],
                'condition' => [
                    'media_style' => 'icon',
                ],

            ]

        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'powerhour_icon_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-icon svg,{{WRAPPER}} .powerhour-title-icon i, {{WRAPPER}} .powerhour-icon-box.powerhour-icon-box-style-7 .img-bg',
            ]
        );


        $this->add_control(
            'powerhour_icon_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'powerhour_icon_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'condition' => ['powerhour_icon_has_border' => ['yes']],
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-icon svg,{{WRAPPER}} .powerhour-title-icon i' => 'border-style:{{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'powerhour_icon_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => ['powerhour_icon_has_border' => ['yes']],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-icon svg,{{WRAPPER}} .powerhour-title-icon i' => 'border-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'powerhour_icon_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => ['powerhour_icon_has_border' => ['yes']],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-icon svg,{{WRAPPER}} .powerhour-title-icon i' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'powerhour_icon_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => ['powerhour_icon_has_border' => ['yes']],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-icon svg,{{WRAPPER}} .powerhour-title-icon i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_aJ0C3kdUtggtL5G4tW12awyR',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box:hover .powerhour-title-icon svg,{{WRAPPER}} .powerhour-title-box:hover .powerhour-title-icon svg path,{{WRAPPER}} .powerhour-title-box:hover .powerhour-title-icon i' => 'fill: {{VALUE}}; color: {{VALUE}};',
                ],
                'condition' => [
                    'media_style' => 'icon',
                ],

            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'powerhour_icon_hover_background',
                'label' => __('Hover Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-title-box:hover .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-box:hover .powerhour-title-icon svg ,{{WRAPPER}} .powerhour-title-box.active .powerhour-title-icon svg,{{WRAPPER}} .powerhour-title-box:hover .powerhour-title-icon i',
            ]
        );

        $this->add_control(
            'powerhour_icon_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'powerhour_icon_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],
                'condition' => ['powerhour_icon_hover_has_border' => ['yes']],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box:hover .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-box:hover svg ,{{WRAPPER}} .powerhour-title-box:hover i' => 'border-style:{{VALUE}};',


                ],
            ]
        );

        $this->add_control(
            'powerhour_icon_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'condition' => ['powerhour_icon_hover_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box:hover .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-box:hover svg ,{{WRAPPER}} .powerhour-title-box:hover i' => 'border-color: {{VALUE}};',
                ],


            ]
        );


        $this->add_control(
            'powerhour_icon_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition' => ['powerhour_icon_hover_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box:hover .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-box:hover svg ,{{WRAPPER}}.powerhour-title-box:hover i' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'powerhour_icon_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition' => ['powerhour_icon_hover_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-box:hover .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-box:hover svg ,{{WRAPPER}} .powerhour-title-box:hover i' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Icon Size', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-icon i,{{WRAPPER}} .powerhour-title-icon svg' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => [
                    'media_style' => 'icon',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_width',
            [
                'label' => __('Width', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-icon svg,{{WRAPPER}} .powerhour-title-icon i' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_height',
            [
                'label' => __('Height', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-icon svg,{{WRAPPER}} .powerhour-title-icon i' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );


        $this->add_responsive_control(
            'powerhour_icon_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-icon svg,{{WRAPPER}} .powerhour-title-icon i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'powerhour_icon_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-title-icon img,{{WRAPPER}} .powerhour-title-icon svg,{{WRAPPER}} .powerhour-title-icon i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Title/render.php';
    }
}
