<?php
namespace Elementor;
use Elementor\Plugin;

if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();
$align = $settings['align'] ?? '';

if ($settings['iqonic_has_box_shadow'] == 'yes') {
  $align .= ' powerhour-box-shadow';
}
$args = array(
  'post_type'         => 'testimonial',
  'post_status'       => 'publish',
  'suppress_filters'  => 0,
  'posts_per_page'    => -1,
);

$wp_query = new \WP_Query($args);

$out = '';

global $post;

$desk = $settings['desk_number'];
$lap = $settings['lap_number'];
$tab = $settings['tab_number'];
$mob = $settings['mob_number'];
	$this->add_render_attribute( 'slider', 'data-items', $settings['desk_number'] );
	$this->add_render_attribute( 'slider', 'data-items-laptop', $settings['lap_number'] );
	$this->add_render_attribute( 'slider', 'data-items-tab', $settings['tab_number'] );
	$this->add_render_attribute( 'slider', 'data-items-mobile', $settings['mob_number'] );
	$this->add_render_attribute( 'slider', 'data-items-mobile-sm', $settings['mob_number'] );
	$this->add_render_attribute( 'slider', 'data-autoplay', $settings['autoplay'] );
	$this->add_render_attribute( 'slider', 'data-loop', $settings['loop'] );
    $this->add_render_attribute( 'slider', 'data-dots', $settings['dots'] );
	$this->add_render_attribute( 'slider', 'data-nav', $settings['nav-arrow'] );

remove_filter('the_content', 'wpautop');  
 
?>
<!-- Style 1 --> 
<?php 
if ($settings['design_style'] == "style_1")  {
     ?>
    <div class="container powerhour-testimonial-style-1 powerhour-testimonial">
        <div class="testimonial-sliders owl-carousel center" <?php echo $this->get_render_attribute_string( 'slider' ); ?>> <?php
            if ($wp_query->have_posts()) {
                while ($wp_query->have_posts()) {
                    $wp_query->the_post();
                    $key =  get_field('key_pjros12', get_the_ID());
                    $rating = !empty($key['star_select']) ? $key['star_select'] : 0;
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($wp_query->ID), "full");
                      ?>
                <div class="powerhour-slider item">                        
                    <div class="powerhour-main-slider">
                     <div class="powerhour-slider_left">
                        <?php echo sprintf('<div class="testimonial-slider-img">  <img src="%1$s"  alt="iqonic-user"/></div>', esc_url($full_image[0], 'iqonic-extension')); ?>
                        <div class="powerhour-lead">
                        <<?php echo $settings['title_tag'];?> class="author-name"><?php the_title($wp_query->ID); ?></<?php echo $settings['title_tag'];?>>
                        <?php if($settings['show_rating'] == 'yes'){ ?>
                            <div class="powerhour-slider_top">
                                <div class="powerhour-post-ratings">
                                    <?php
                                    for ($i = 1; $i < 6; $i++) {
                                        if ($i > $rating) {
                                            ?>
                                            
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M19.5 9.07117C19.5 13.3012 12.476 18.6245 12.476 18.6245C12.3587 18.7545 12.1893 18.8325 12 18.8325C11.8107 18.8325 11.6413 18.7545 11.524 18.6245C11.524 18.6245 4.5 13.3012 4.5 9.07117C4.5 6.91717 6.25467 5.1665 8.41333 5.1665C10.018 5.1665 11.4 6.12984 12 7.50917C12.6 6.12917 13.9827 5.1665 15.5867 5.1665C17.7453 5.1665 19.5 6.91717 19.5 9.07117Z" fill="#BCEBE9"/>
                                            <path d="M6 9.07117C6 7.17917 7.35333 5.59984 9.14533 5.2425C8.90733 5.19784 8.664 5.1665 8.41333 5.1665C6.25467 5.1665 4.5 6.91717 4.5 9.07117C4.5 13.3012 11.524 18.6252 11.524 18.6252C11.6413 18.7552 11.8107 18.8332 12 18.8332C12.1893 18.8332 12.3587 18.7552 12.476 18.6252C12.476 18.6252 12.5767 18.5485 12.75 18.4105C11.4587 17.3792 6 12.8012 6 9.07117Z" fill="#005550"/>
                                            <path d="M20.6665 6.33325C20.1151 6.33325 19.6665 5.88458 19.6665 5.33325C19.6665 4.78192 20.1151 4.33325 20.6665 4.33325C21.2178 4.33325 21.6665 4.78192 21.6665 5.33325C21.6665 5.88458 21.2178 6.33325 20.6665 6.33325ZM20.6665 4.99992C20.4825 4.99992 20.3331 5.14925 20.3331 5.33325C20.3331 5.51725 20.4825 5.66658 20.6665 5.66658C20.8505 5.66658 20.9998 5.51725 20.9998 5.33325C20.9998 5.14925 20.8505 4.99992 20.6665 4.99992Z" fill="#005550"/>
                                            <path d="M2.49408 17.9077L2.96548 17.4363L3.90829 18.3791L3.43689 18.8505L2.49408 17.9077Z" fill="#005550"/>
                                            <path d="M5.20425 20.6182L5.67566 20.1468L6.61846 21.0896L6.14706 21.561L5.20425 20.6182Z" fill="#005550"/>
                                            <path d="M2.3757 21.0896L3.31851 20.1468L3.78992 20.6182L2.84711 21.561L2.3757 21.0896Z" fill="#005550"/>
                                            <path d="M5.0864 18.3794L6.02921 17.4366L6.50061 17.908L5.5578 18.8508L5.0864 18.3794Z" fill="#005550"/>
                                            <path d="M11.9999 19.3334C11.6933 19.3334 11.4006 19.2121 11.1893 18.9987C10.9739 18.8334 9.78994 17.9094 8.43061 16.5747L9.13127 15.8614C10.5573 17.2614 11.8133 18.2174 11.8259 18.2267C11.8513 18.2461 11.8746 18.2674 11.8953 18.2907C11.9453 18.3474 12.0533 18.3474 12.1033 18.2907C12.1246 18.2674 12.1479 18.2461 12.1726 18.2267C12.2419 18.1747 18.9999 13.0041 18.9999 9.07141C18.9999 7.19408 17.4686 5.66675 15.5866 5.66675C14.2253 5.66675 12.9979 6.46875 12.4586 7.70875C12.2999 8.07341 11.6999 8.07341 11.5413 7.70875C11.0019 6.46875 9.77394 5.66675 8.41327 5.66675C6.53127 5.66675 4.99994 7.19408 4.99994 9.07141C4.99994 10.5954 6.06727 12.5694 8.08594 14.7801L7.34794 15.4547C5.12594 13.0221 3.99994 10.8747 3.99994 9.07141C3.99994 6.64275 5.97994 4.66675 8.41327 4.66675C9.85661 4.66675 11.1839 5.36475 11.9999 6.50208C12.8159 5.36475 14.1439 4.66675 15.5866 4.66675C18.0199 4.66675 19.9999 6.64275 19.9999 9.07141C19.9999 13.3921 13.4033 18.5441 12.8106 18.9987C12.5986 19.2121 12.3066 19.3334 11.9999 19.3334Z" fill="#222222"/>
                                            </svg>

                                           <?php
                                        } else {
                                           ?>
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M19.5 9.07117C19.5 13.3012 12.476 18.6245 12.476 18.6245C12.3587 18.7545 12.1893 18.8325 12 18.8325C11.8107 18.8325 11.6413 18.7545 11.524 18.6245C11.524 18.6245 4.5 13.3012 4.5 9.07117C4.5 6.91717 6.25467 5.1665 8.41333 5.1665C10.018 5.1665 11.4 6.12984 12 7.50917C12.6 6.12917 13.9827 5.1665 15.5867 5.1665C17.7453 5.1665 19.5 6.91717 19.5 9.07117Z" fill="#BCEBE9"/>
                                            <path d="M6 9.07117C6 7.17917 7.35333 5.59984 9.14533 5.2425C8.90733 5.19784 8.664 5.1665 8.41333 5.1665C6.25467 5.1665 4.5 6.91717 4.5 9.07117C4.5 13.3012 11.524 18.6252 11.524 18.6252C11.6413 18.7552 11.8107 18.8332 12 18.8332C12.1893 18.8332 12.3587 18.7552 12.476 18.6252C12.476 18.6252 12.5767 18.5485 12.75 18.4105C11.4587 17.3792 6 12.8012 6 9.07117Z" fill="#005550"/>
                                            <path d="M20.6665 6.33325C20.1151 6.33325 19.6665 5.88458 19.6665 5.33325C19.6665 4.78192 20.1151 4.33325 20.6665 4.33325C21.2178 4.33325 21.6665 4.78192 21.6665 5.33325C21.6665 5.88458 21.2178 6.33325 20.6665 6.33325ZM20.6665 4.99992C20.4825 4.99992 20.3331 5.14925 20.3331 5.33325C20.3331 5.51725 20.4825 5.66658 20.6665 5.66658C20.8505 5.66658 20.9998 5.51725 20.9998 5.33325C20.9998 5.14925 20.8505 4.99992 20.6665 4.99992Z" fill="#005550"/>
                                            <path d="M2.49408 17.9077L2.96548 17.4363L3.90829 18.3791L3.43689 18.8505L2.49408 17.9077Z" fill="#005550"/>
                                            <path d="M5.20425 20.6182L5.67566 20.1468L6.61846 21.0896L6.14706 21.561L5.20425 20.6182Z" fill="#005550"/>
                                            <path d="M2.3757 21.0896L3.31851 20.1468L3.78992 20.6182L2.84711 21.561L2.3757 21.0896Z" fill="#005550"/>
                                            <path d="M5.0864 18.3794L6.02921 17.4366L6.50061 17.908L5.5578 18.8508L5.0864 18.3794Z" fill="#005550"/>
                                            <path d="M11.9999 19.3334C11.6933 19.3334 11.4006 19.2121 11.1893 18.9987C10.9739 18.8334 9.78994 17.9094 8.43061 16.5747L9.13127 15.8614C10.5573 17.2614 11.8133 18.2174 11.8259 18.2267C11.8513 18.2461 11.8746 18.2674 11.8953 18.2907C11.9453 18.3474 12.0533 18.3474 12.1033 18.2907C12.1246 18.2674 12.1479 18.2461 12.1726 18.2267C12.2419 18.1747 18.9999 13.0041 18.9999 9.07141C18.9999 7.19408 17.4686 5.66675 15.5866 5.66675C14.2253 5.66675 12.9979 6.46875 12.4586 7.70875C12.2999 8.07341 11.6999 8.07341 11.5413 7.70875C11.0019 6.46875 9.77394 5.66675 8.41327 5.66675C6.53127 5.66675 4.99994 7.19408 4.99994 9.07141C4.99994 10.5954 6.06727 12.5694 8.08594 14.7801L7.34794 15.4547C5.12594 13.0221 3.99994 10.8747 3.99994 9.07141C3.99994 6.64275 5.97994 4.66675 8.41327 4.66675C9.85661 4.66675 11.1839 5.36475 11.9999 6.50208C12.8159 5.36475 14.1439 4.66675 15.5866 4.66675C18.0199 4.66675 19.9999 6.64275 19.9999 9.07141C19.9999 13.3921 13.4033 18.5441 12.8106 18.9987C12.5986 19.2121 12.3066 19.3334 11.9999 19.3334Z" fill="#222222"/>
                                            </svg>
                                           <?php
                                        }
                                    }
                                      ?>
                            </div>
                        </div>
                     <?php } ?>
                     </div>
                    </div>
                            <div class="powerhour-testimonial-content">
                            <?php if(!empty($settings['start_quote_image']['url'])){?>
                                <div class="quote-icon-left">
                                <!-- Quote Icon -->
                                <!-- Quote Image -->
                                <img src="<?php echo $settings['start_quote_image']['url'];?>" alt="Quote Image">
                                </div><?php } ?>
                                <div class="text-dec ">
                                     <p><?php echo sprintf("%s", get_the_content($wp_query->ID)); ?></p>
                                </div>
                                <?php if(!empty($settings['end_quote_image']['url'])){?>
                                <div class="quote-icon-right">
                                <!-- Quote Icon -->
                                <!-- Quote Image -->
                                <img src="<?php echo $settings['end_quote_image']['url'];?>" alt="Quote Image">
                                </div><?php } ?>
                            </div>
                        </div>
                    </div>
                   <?php
               }
            }
             ?>
        </div>
    </div>
    <!-- style 2 -->
        <?php  
} else if ($settings['design_style'] == "style_2") { ?>
    <div class="powerhour-testimonial-style-2 powerhour-testimonial">
        <div class="testimonial-sliders owl-carousel center" <?php echo $this->get_render_attribute_string( 'slider' ); ?>> <?php
            if ($wp_query->have_posts()) {
                while ($wp_query->have_posts()) {
                    $wp_query->the_post();
                    $key = get_field('key_pjros12',get_the_ID());
                    $key_social = get_field('key_tesimonialpjros1245', get_the_ID());
                    $facebook = $key_social['iqonic_tesimonial_facebook'];
                    $twitter = $key_social['iqonic_tesimonial_twitter'];
                    $google = $key_social['iqonic_tesimonial_google'];
                    $github = $key_social['iqonic_tesimonial_github'];
                    $insta = $key_social['iqonic_tesimonial_insta'];
                    $li = '';
                    $rating = !empty($key['star_select']) ? $key['star_select'] : 0;
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($wp_query->ID), "full");


                    if (!empty($twitter)) {
                        $li .= sprintf('<li><a href="%s">
                         <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-twitter-x" viewBox="0 0 16 16"><path d="M12.6.75h2.454l-5.36 6.142L16 15.25h-4.937l-3.867-5.07-4.425 5.07H.316l5.733-6.57L0 .75h5.063l3.495 4.633L12.601.75Zm-.86 13.028h1.36L4.323 2.145H2.865z"/></svg>
                        </a></li>', esc_url($twitter));
                    }


                    if (!empty($github)) {
                        $li .= sprintf('<li><a href="%s">
                        <svg width="22" height="22" viewBox="0 0 22 22" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M16.5 7.49891C15.6047 7.49853 14.7233 7.71997 13.9346 8.14344C13.8626 7.95387 13.7346 7.79068 13.5677 7.67555C13.4008 7.56043 13.2028 7.49882 13 7.49891H8.99999C8.86865 7.49884 8.73858 7.52465 8.61722 7.57488C8.49586 7.62511 8.38559 7.69876 8.29272 7.79164C8.19985 7.88451 8.12619 7.99478 8.07596 8.11614C8.02573 8.2375 7.99992 8.36757 7.99999 8.49891V20.4989C7.99992 20.6303 8.02573 20.7603 8.07596 20.8817C8.12619 21.003 8.19984 21.1133 8.29272 21.2062C8.38559 21.2991 8.49586 21.3727 8.61722 21.4229C8.73858 21.4732 8.86865 21.499 8.99999 21.4989H13C13.1313 21.499 13.2614 21.4732 13.3828 21.4229C13.5041 21.3727 13.6144 21.2991 13.7073 21.2062C13.8001 21.1133 13.8738 21.003 13.924 20.8817C13.9743 20.7603 14.0001 20.6303 14 20.4989V14.9989C14 14.7337 14.1054 14.4793 14.2929 14.2918C14.4804 14.1043 14.7348 13.9989 15 13.9989C15.2652 13.9989 15.5196 14.1043 15.7071 14.2918C15.8946 14.4793 16 14.7337 16 14.9989V20.4989C15.9999 20.6303 16.0257 20.7603 16.076 20.8817C16.1262 21.003 16.1998 21.1133 16.2927 21.2062C16.3856 21.2991 16.4959 21.3727 16.6172 21.4229C16.7386 21.4732 16.8687 21.499 17 21.4989H21C21.1313 21.499 21.2614 21.4732 21.3828 21.4229C21.5041 21.3727 21.6144 21.2991 21.7073 21.2062C21.8001 21.1133 21.8738 21.003 21.924 20.8817C21.9743 20.7603 22.0001 20.6303 22 20.4989V12.9989C21.9982 11.5408 21.4181 10.1429 20.3871 9.11182C19.356 8.08077 17.9581 7.50072 16.5 7.49891ZM20 19.4989H18V14.9989C18 14.2033 17.6839 13.4402 17.1213 12.8776C16.5587 12.315 15.7956 11.9989 15 11.9989C14.2043 11.9989 13.4413 12.315 12.8787 12.8776C12.3161 13.4402 12 14.2033 12 14.9989V19.4989H9.99999V9.49891H12V10.202C12.0001 10.4092 12.0646 10.6113 12.1844 10.7803C12.3043 10.9493 12.4737 11.0769 12.6692 11.1455C12.8647 11.2141 13.0767 11.2203 13.2759 11.1633C13.4751 11.1062 13.6517 10.9887 13.7812 10.827C14.23 10.2571 14.8456 9.84148 15.542 9.63828C16.2384 9.43508 16.9808 9.45443 17.6657 9.69362C18.3506 9.93281 18.9437 10.3799 19.3622 10.9725C19.7806 11.565 20.0036 12.2735 20 12.9989V19.4989ZM5.99999 7.49891H1.99999C1.86865 7.49884 1.73858 7.52465 1.61722 7.57488C1.49586 7.62511 1.38559 7.69876 1.29272 7.79164C1.19985 7.88451 1.12619 7.99478 1.07596 8.11614C1.02573 8.2375 0.999919 8.36757 0.999994 8.49891V20.4989C0.999918 20.6303 1.02573 20.7603 1.07596 20.8817C1.12619 21.003 1.19984 21.1133 1.29272 21.2062C1.38559 21.2991 1.49586 21.3727 1.61722 21.4229C1.73858 21.4732 1.86865 21.499 1.99999 21.4989H5.99999C6.13134 21.499 6.26141 21.4732 6.38277 21.4229C6.50413 21.3727 6.6144 21.2991 6.70727 21.2062C6.80014 21.1133 6.8738 21.003 6.92403 20.8817C6.97426 20.7603 7.00007 20.6303 6.99999 20.4989V8.49891C7.00007 8.36757 6.97425 8.2375 6.92403 8.11614C6.8738 7.99478 6.80014 7.88451 6.70727 7.79164C6.61439 7.69876 6.50413 7.62511 6.38277 7.57488C6.26141 7.52465 6.13134 7.49884 5.99999 7.49891ZM4.99999 19.4989H2.99999V9.49891H4.99999V19.4989ZM4.01464 0.0419093C3.577 0.0157127 3.13861 0.0788065 2.72612 0.227354C2.31363 0.375901 1.93567 0.606798 1.61521 0.906002C1.29476 1.20521 1.03851 1.56646 0.862052 1.96781C0.685595 2.36915 0.592617 2.8022 0.58877 3.2406C0.584924 3.67901 0.670291 4.11361 0.839678 4.51799C1.00907 4.92237 1.25894 5.28807 1.57409 5.59285C1.88925 5.89763 2.2631 6.13512 2.67292 6.29089C3.08274 6.44665 3.51996 6.51742 3.95799 6.49891H3.98631C4.42511 6.52497 4.86461 6.46129 5.27797 6.31176C5.69132 6.16223 6.06985 5.92998 6.39041 5.62922C6.71098 5.32845 6.96685 4.96548 7.1424 4.56249C7.31795 4.15949 7.40948 3.72494 7.41141 3.28537C7.41334 2.8458 7.32562 2.41046 7.15361 2.00594C6.98161 1.60142 6.72893 1.23622 6.41101 0.932655C6.0931 0.62909 5.71662 0.393534 5.3046 0.240381C4.89257 0.0872287 4.45364 0.0196959 4.01463 0.0419093H4.01464ZM3.98632 4.49891H3.95799C3.78506 4.51991 3.60964 4.50369 3.44348 4.45134C3.27733 4.39899 3.1243 4.31172 2.99464 4.19537C2.86498 4.07903 2.76169 3.93631 2.69171 3.77679C2.62172 3.61726 2.58666 3.44461 2.58886 3.27042C2.58886 2.52432 3.14843 2.0419 4.01464 2.0419C4.18934 2.01861 4.367 2.03303 4.53566 2.08418C4.70432 2.13534 4.86005 2.22204 4.99238 2.33845C5.12471 2.45486 5.23055 2.59828 5.30278 2.75904C5.37501 2.9198 5.41196 3.09418 5.41112 3.27042C5.41112 4.01651 4.85155 4.49891 3.98632 4.49891Z" fill="#005550"/>
                        </svg>
                        </a></li>', esc_url($github));
                    }

                    if (!empty($insta)) {
                        $li .= sprintf('<li><a href="%s">                     
                            <svg width="20" height="21" viewBox="0 0 20 21" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M15.34 3.96C15.1027 3.96 14.8707 4.03038 14.6733 4.16224C14.476 4.29409 14.3222 4.48151 14.2313 4.70078C14.1405 4.92005 14.1168 5.16133 14.1631 5.39411C14.2094 5.62689 14.3236 5.84071 14.4915 6.00853C14.6593 6.17635 14.8731 6.29064 15.1059 6.33694C15.3387 6.38324 15.5799 6.35948 15.7992 6.26866C16.0185 6.17783 16.2059 6.02402 16.3378 5.82668C16.4696 5.62935 16.54 5.39734 16.54 5.16C16.54 4.84174 16.4136 4.53652 16.1885 4.31147C15.9635 4.08643 15.6583 3.96 15.34 3.96ZM19.94 6.38C19.9206 5.5503 19.7652 4.7294 19.48 3.95C19.2257 3.28313 18.83 2.67928 18.32 2.18C17.8248 1.66743 17.2196 1.27418 16.55 1.03C15.7727 0.736161 14.9508 0.57721 14.12 0.56C13.06 0.5 12.72 0.5 10 0.5C7.28 0.5 6.94 0.5 5.88 0.56C5.04915 0.57721 4.22734 0.736161 3.45 1.03C2.78168 1.27665 2.17693 1.66956 1.68 2.18C1.16743 2.67518 0.774176 3.28044 0.53 3.95C0.236161 4.72734 0.07721 5.54915 0.0599999 6.38C-5.58794e-08 7.44 0 7.78 0 10.5C0 13.22 -5.58794e-08 13.56 0.0599999 14.62C0.07721 15.4508 0.236161 16.2727 0.53 17.05C0.774176 17.7196 1.16743 18.3248 1.68 18.82C2.17693 19.3304 2.78168 19.7234 3.45 19.97C4.22734 20.2638 5.04915 20.4228 5.88 20.44C6.94 20.5 7.28 20.5 10 20.5C12.72 20.5 13.06 20.5 14.12 20.44C14.9508 20.4228 15.7727 20.2638 16.55 19.97C17.2196 19.7258 17.8248 19.3326 18.32 18.82C18.8322 18.3226 19.2283 17.7182 19.48 17.05C19.7652 16.2706 19.9206 15.4497 19.94 14.62C19.94 13.56 20 13.22 20 10.5C20 7.78 20 7.44 19.94 6.38ZM18.14 14.5C18.1327 15.1348 18.0178 15.7637 17.8 16.36C17.6403 16.7952 17.3839 17.1884 17.05 17.51C16.7256 17.8405 16.3332 18.0964 15.9 18.26C15.3037 18.4778 14.6748 18.5927 14.04 18.6C13.04 18.65 12.67 18.66 10.04 18.66C7.41 18.66 7.04 18.66 6.04 18.6C5.38089 18.6123 4.72459 18.5109 4.1 18.3C3.68578 18.1281 3.31136 17.8728 3 17.55C2.66809 17.2287 2.41484 16.8352 2.26 16.4C2.01586 15.7952 1.88044 15.1519 1.86 14.5C1.86 13.5 1.8 13.13 1.8 10.5C1.8 7.87 1.8 7.5 1.86 6.5C1.86448 5.85106 1.98295 5.20795 2.21 4.6C2.38605 4.17791 2.65627 3.80166 3 3.5C3.30381 3.15617 3.67929 2.8831 4.1 2.7C4.70955 2.48004 5.352 2.36508 6 2.36C7 2.36 7.37 2.3 10 2.3C12.63 2.3 13 2.3 14 2.36C14.6348 2.36728 15.2637 2.48225 15.86 2.7C16.3144 2.86865 16.7223 3.14285 17.05 3.5C17.3777 3.80718 17.6338 4.18273 17.8 4.6C18.0223 5.20893 18.1373 5.85178 18.14 6.5C18.19 7.5 18.2 7.87 18.2 10.5C18.2 13.13 18.19 13.5 18.14 14.5ZM10 5.37C8.98581 5.37198 7.99496 5.67453 7.15265 6.23942C6.31035 6.80431 5.65438 7.6062 5.26763 8.54375C4.88089 9.48131 4.78072 10.5125 4.97979 11.5069C5.17886 12.5014 5.66824 13.4145 6.38608 14.131C7.10392 14.8474 8.01801 15.335 9.01286 15.5321C10.0077 15.7293 11.0387 15.6271 11.9755 15.2385C12.9123 14.85 13.7129 14.1924 14.2761 13.349C14.8394 12.5056 15.14 11.5142 15.14 10.5C15.1413 9.8251 15.0092 9.15661 14.7512 8.53296C14.4933 7.90931 14.1146 7.34281 13.6369 6.86605C13.1592 6.38929 12.5919 6.01168 11.9678 5.75493C11.3436 5.49818 10.6749 5.36736 10 5.37ZM10 13.83C9.34139 13.83 8.69757 13.6347 8.14995 13.2688C7.60234 12.9029 7.17552 12.3828 6.92348 11.7743C6.67144 11.1659 6.6055 10.4963 6.73398 9.85035C6.86247 9.20439 7.17963 8.61104 7.64533 8.14533C8.11104 7.67963 8.70439 7.36247 9.35035 7.23398C9.99631 7.1055 10.6659 7.17144 11.2743 7.42348C11.8828 7.67552 12.4029 8.10234 12.7688 8.64995C13.1347 9.19757 13.33 9.84139 13.33 10.5C13.33 10.9373 13.2439 11.3703 13.0765 11.7743C12.9092 12.1784 12.6639 12.5454 12.3547 12.8547C12.0454 13.1639 11.6784 13.4092 11.2743 13.5765C10.8703 13.7439 10.4373 13.83 10 13.83Z" fill="#005550"/>
                            </svg>
                        </a></li>', esc_url($insta));
                    } 

                    if (!empty($google)) {
                        $li .= sprintf('<li><a href="%s"><i class="fab fa-google"></i></a></li>', esc_url($google));
                    }
                      ?>
                    <div class="powerhour-slider item">
                        <div class="powerhour-main-slider">
                            
                        <?php echo sprintf('<div class="testimonial-slider-img">  <img src="%1$s"  alt="iqonic-user"/></div>', esc_url($full_image[0], 'iqonic-extension')); ?>

                        <div class="powerhour-slider_top">
                            <!-- Strat Quote Image -->
                            <?php if(!empty(['start_quote_image'])){ ?>
                                <div class="quote-icon-left">
                                    <img src="<?php echo $settings['start_quote_image']['url'];?>" alt="Quote Image">
                                </div>
                            <?php } ?>

                            <div class="powerhour-lead">
                                <<?php echo $settings['title_tag'];?> class="author-name"><?php the_title($wp_query->ID); ?></<?php echo $settings['title_tag'];?>>
                            </div>

                            <?php if($settings['show_rating'] == 'yes') { ?>

                                <div class="powerhour-post-ratings">
                                    <?php
                                    for ($i = 1; $i < 6; $i++) {
                                        if ($i > $rating) {
                                            ?>
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M19.5 9.07117C19.5 13.3012 12.476 18.6245 12.476 18.6245C12.3587 18.7545 12.1893 18.8325 12 18.8325C11.8107 18.8325 11.6413 18.7545 11.524 18.6245C11.524 18.6245 4.5 13.3012 4.5 9.07117C4.5 6.91717 6.25467 5.1665 8.41333 5.1665C10.018 5.1665 11.4 6.12984 12 7.50917C12.6 6.12917 13.9827 5.1665 15.5867 5.1665C17.7453 5.1665 19.5 6.91717 19.5 9.07117Z" fill="#BCEBE9"/>
                                            <path d="M6 9.07117C6 7.17917 7.35333 5.59984 9.14533 5.2425C8.90733 5.19784 8.664 5.1665 8.41333 5.1665C6.25467 5.1665 4.5 6.91717 4.5 9.07117C4.5 13.3012 11.524 18.6252 11.524 18.6252C11.6413 18.7552 11.8107 18.8332 12 18.8332C12.1893 18.8332 12.3587 18.7552 12.476 18.6252C12.476 18.6252 12.5767 18.5485 12.75 18.4105C11.4587 17.3792 6 12.8012 6 9.07117Z" fill="#005550"/>
                                            <path d="M20.6665 6.33325C20.1151 6.33325 19.6665 5.88458 19.6665 5.33325C19.6665 4.78192 20.1151 4.33325 20.6665 4.33325C21.2178 4.33325 21.6665 4.78192 21.6665 5.33325C21.6665 5.88458 21.2178 6.33325 20.6665 6.33325ZM20.6665 4.99992C20.4825 4.99992 20.3331 5.14925 20.3331 5.33325C20.3331 5.51725 20.4825 5.66658 20.6665 5.66658C20.8505 5.66658 20.9998 5.51725 20.9998 5.33325C20.9998 5.14925 20.8505 4.99992 20.6665 4.99992Z" fill="#005550"/>
                                            <path d="M2.49408 17.9077L2.96548 17.4363L3.90829 18.3791L3.43689 18.8505L2.49408 17.9077Z" fill="#005550"/>
                                            <path d="M5.20425 20.6182L5.67566 20.1468L6.61846 21.0896L6.14706 21.561L5.20425 20.6182Z" fill="#005550"/>
                                            <path d="M2.3757 21.0896L3.31851 20.1468L3.78992 20.6182L2.84711 21.561L2.3757 21.0896Z" fill="#005550"/>
                                            <path d="M5.0864 18.3794L6.02921 17.4366L6.50061 17.908L5.5578 18.8508L5.0864 18.3794Z" fill="#005550"/>
                                            <path d="M11.9999 19.3334C11.6933 19.3334 11.4006 19.2121 11.1893 18.9987C10.9739 18.8334 9.78994 17.9094 8.43061 16.5747L9.13127 15.8614C10.5573 17.2614 11.8133 18.2174 11.8259 18.2267C11.8513 18.2461 11.8746 18.2674 11.8953 18.2907C11.9453 18.3474 12.0533 18.3474 12.1033 18.2907C12.1246 18.2674 12.1479 18.2461 12.1726 18.2267C12.2419 18.1747 18.9999 13.0041 18.9999 9.07141C18.9999 7.19408 17.4686 5.66675 15.5866 5.66675C14.2253 5.66675 12.9979 6.46875 12.4586 7.70875C12.2999 8.07341 11.6999 8.07341 11.5413 7.70875C11.0019 6.46875 9.77394 5.66675 8.41327 5.66675C6.53127 5.66675 4.99994 7.19408 4.99994 9.07141C4.99994 10.5954 6.06727 12.5694 8.08594 14.7801L7.34794 15.4547C5.12594 13.0221 3.99994 10.8747 3.99994 9.07141C3.99994 6.64275 5.97994 4.66675 8.41327 4.66675C9.85661 4.66675 11.1839 5.36475 11.9999 6.50208C12.8159 5.36475 14.1439 4.66675 15.5866 4.66675C18.0199 4.66675 19.9999 6.64275 19.9999 9.07141C19.9999 13.3921 13.4033 18.5441 12.8106 18.9987C12.5986 19.2121 12.3066 19.3334 11.9999 19.3334Z" fill="#222222"/>
                                            </svg>
                                           <?php
                                        } else {
                                           ?>
                                            <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M19.5 9.07117C19.5 13.3012 12.476 18.6245 12.476 18.6245C12.3587 18.7545 12.1893 18.8325 12 18.8325C11.8107 18.8325 11.6413 18.7545 11.524 18.6245C11.524 18.6245 4.5 13.3012 4.5 9.07117C4.5 6.91717 6.25467 5.1665 8.41333 5.1665C10.018 5.1665 11.4 6.12984 12 7.50917C12.6 6.12917 13.9827 5.1665 15.5867 5.1665C17.7453 5.1665 19.5 6.91717 19.5 9.07117Z" fill="#BCEBE9"/>
                                            <path d="M6 9.07117C6 7.17917 7.35333 5.59984 9.14533 5.2425C8.90733 5.19784 8.664 5.1665 8.41333 5.1665C6.25467 5.1665 4.5 6.91717 4.5 9.07117C4.5 13.3012 11.524 18.6252 11.524 18.6252C11.6413 18.7552 11.8107 18.8332 12 18.8332C12.1893 18.8332 12.3587 18.7552 12.476 18.6252C12.476 18.6252 12.5767 18.5485 12.75 18.4105C11.4587 17.3792 6 12.8012 6 9.07117Z" fill="#005550"/>
                                            <path d="M20.6665 6.33325C20.1151 6.33325 19.6665 5.88458 19.6665 5.33325C19.6665 4.78192 20.1151 4.33325 20.6665 4.33325C21.2178 4.33325 21.6665 4.78192 21.6665 5.33325C21.6665 5.88458 21.2178 6.33325 20.6665 6.33325ZM20.6665 4.99992C20.4825 4.99992 20.3331 5.14925 20.3331 5.33325C20.3331 5.51725 20.4825 5.66658 20.6665 5.66658C20.8505 5.66658 20.9998 5.51725 20.9998 5.33325C20.9998 5.14925 20.8505 4.99992 20.6665 4.99992Z" fill="#005550"/>
                                            <path d="M2.49408 17.9077L2.96548 17.4363L3.90829 18.3791L3.43689 18.8505L2.49408 17.9077Z" fill="#005550"/>
                                            <path d="M5.20425 20.6182L5.67566 20.1468L6.61846 21.0896L6.14706 21.561L5.20425 20.6182Z" fill="#005550"/>
                                            <path d="M2.3757 21.0896L3.31851 20.1468L3.78992 20.6182L2.84711 21.561L2.3757 21.0896Z" fill="#005550"/>
                                            <path d="M5.0864 18.3794L6.02921 17.4366L6.50061 17.908L5.5578 18.8508L5.0864 18.3794Z" fill="#005550"/>
                                            <path d="M11.9999 19.3334C11.6933 19.3334 11.4006 19.2121 11.1893 18.9987C10.9739 18.8334 9.78994 17.9094 8.43061 16.5747L9.13127 15.8614C10.5573 17.2614 11.8133 18.2174 11.8259 18.2267C11.8513 18.2461 11.8746 18.2674 11.8953 18.2907C11.9453 18.3474 12.0533 18.3474 12.1033 18.2907C12.1246 18.2674 12.1479 18.2461 12.1726 18.2267C12.2419 18.1747 18.9999 13.0041 18.9999 9.07141C18.9999 7.19408 17.4686 5.66675 15.5866 5.66675C14.2253 5.66675 12.9979 6.46875 12.4586 7.70875C12.2999 8.07341 11.6999 8.07341 11.5413 7.70875C11.0019 6.46875 9.77394 5.66675 8.41327 5.66675C6.53127 5.66675 4.99994 7.19408 4.99994 9.07141C4.99994 10.5954 6.06727 12.5694 8.08594 14.7801L7.34794 15.4547C5.12594 13.0221 3.99994 10.8747 3.99994 9.07141C3.99994 6.64275 5.97994 4.66675 8.41327 4.66675C9.85661 4.66675 11.1839 5.36475 11.9999 6.50208C12.8159 5.36475 14.1439 4.66675 15.5866 4.66675C18.0199 4.66675 19.9999 6.64275 19.9999 9.07141C19.9999 13.3921 13.4033 18.5441 12.8106 18.9987C12.5986 19.2121 12.3066 19.3334 11.9999 19.3334Z" fill="#222222"/>
                                            </svg>
                                           <?php
                                        }
                                    }
                                      ?>
                                </div><?php } ?>

                                <div class="text-dec powerhour-testimonial-content">
                                    <p><?php echo sprintf("%s", get_the_content($wp_query->ID)); ?></p>
                                </div>

                                <div class="powerhour-testimonial-social">
                                    <div class="iconswrapper">
                                        <ul>
                                            <?php echo $li; ?>
                                        </ul>
                                    </div>
				                </div>
                                <!-- end Quote Image -->
                                <div class="quote-icon-right">
                                    <?php if(!empty(['end_quote_image'])){ ?>
                                        <img src="<?php echo $settings['end_quote_image']['url'];?>" alt="Quote Image">
                                    <?php } ?>
                                </div>
                            </div>
                    </div>
                    </div>
                   <?php
               }
            }
             ?>
        </div>
    </div>
    <!-- Add Pagination -->
    <?php 
}