<?php

namespace Iqonic\Elementor\Elements\Testimonial;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin;
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic_Testimonial', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Testimonial', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-testimonial-carousel';
    }
    protected function register_controls()
    {
        $this->start_controls_section(
            'section_testimonial',
            [
                'label' => __('Testimonial Style', 'iqonic-extension'),
            ]
        );

        $this->add_control(
			'design_style',
			[
				'label'         => __( 'Design Style', 'iqonic-extension' ),
				'type'          => \Elementor\Controls_Manager::SELECT,
				'default'       => 'style_1',
				'options'       => [
					'style_1'   => __( 'Style 1', 'iqonic-extension' ),
                    'style_2'   => __( 'Style 2', 'iqonic-extension' ),
				],
			]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            'section_Team',
            [
                'label' => __('Testimonial Post', 'iqonic-extension'),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label'         => esc_html__('Alignment', 'iqonic-extension'),
                'type'          => Controls_Manager::CHOOSE,
                'options'       => [
                    'left'      => [
                        'title' => esc_html__('Left', 'iqonic-extension'),
                        'icon'  => 'eicon-text-align-left',
                    ],
                    'center'    => [
                        'title' => esc_html__('Center', 'iqonic-extension'),
                        'icon'  => 'eicon-text-align-center',
                    ],
                    'right'     => [
                        'title' => esc_html__('Right', 'iqonic-extension'),
                        'icon'  => 'eicon-text-align-right',
                    ]
                ],
                'default'       => 'left',
                'selectors'     => [
                    '{{WRAPPER}}'=> 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'show_rating',
            [
                'label'         => esc_html__('Show Rating ?', 'iqonic-extension'),
                'type'          => \Elementor\Controls_Manager::SELECT,
                'default'       => 'yes',
                'options'       => [
                    'yes'       => esc_html__('yes', 'iqonic-extension'),
                    'no'        => esc_html__('no', 'iqonic-extension')
                ],
            ]
        );

        

        $this->add_control(
            'iqonic_has_box_shadow',
            [
                'label'     => esc_html__('Box Shadow?', 'iqonic-extension'),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'no',
                'yes'       => esc_html__('yes', 'iqonic-extension'),
                'no'        => esc_html__('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'   => esc_html__('Title Tag', 'iqonic-extension'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'h3',
                'options' => [
                    'h1'  => esc_html__('h1', 'iqonic-extension'),
                    'h2'  => esc_html__('h2', 'iqonic-extension'),
                    'h3'  => esc_html__('h3', 'iqonic-extension'),
                    'h4'  => esc_html__('h4', 'iqonic-extension'),
                    'h5'  => esc_html__('h5', 'iqonic-extension'),
                    'h6'  => esc_html__('h6', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'start_quote_image',
            [
                'label' => esc_html__('Strating Quote Image','iqonic-extension'),
                'type'  => Controls_Manager::MEDIA,
                'default'           => [
                    'url'           => Utils::get_placeholder_image_src(),
                ],
            ]   
        );
        $this->add_control(
            'end_quote_image',
            [
                'label' => esc_html__('Ending Quote Image','iqonic-extension'),
                'type'  => Controls_Manager::MEDIA,
                'default'           => [
                    'url'           => Utils::get_placeholder_image_src(),
                ],
            ]   
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'owl_control_section',
            [
                'label' => esc_html__('Slider Control', 'iqonic-extension'),    
            ]
        );

        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/slick-control.php';

        $this->end_controls_section();
        /* Testimonial content start*/

        $this->start_controls_section(
            'section_fTi9d90YQL50K7GB',
            [
                'label' => esc_html__('Testimonial Box', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('testimonial_body_tabs');
        $this->start_controls_tab(
            'tabs_C3P7D90JarMz1c5nduaV',
            [
                'label' => esc_html__('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'       => 'quote_back_color',
                'types'      => ['classic', 'gradient'],
                'selector'   => '{{WRAPPER}} .powerhour-testimonial .powerhour-main-slider',
            ]
        );

        $this->add_control(
            'powerhour_testimonial_block_has_border',
            [
                'label'     => esc_html__('Set Custom Border?', 'iqonic-extension'),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'no',
                'yes'       => esc_html__('yes', 'iqonic-extension'),
                'no'        => esc_html__('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'content_border_style',
            [
                'label'      => esc_html__('Border Style', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'none',
                'options'    => [
                    'solid'  => esc_html__('Solid', 'iqonic-extension'),
                    'dashed' => esc_html__('Dashed', 'iqonic-extension'),
                    'dotted' => esc_html__('Dotted', 'iqonic-extension'),
                    'double' => esc_html__('Double', 'iqonic-extension'),
                    'outset' => esc_html__('outset', 'iqonic-extension'),
                    'groove' => esc_html__('groove', 'iqonic-extension'),
                    'ridge'  => esc_html__('ridge', 'iqonic-extension'),
                    'inset'  => esc_html__('inset', 'iqonic-extension'),
                    'hidden' => esc_html__('hidden', 'iqonic-extension'),
                    'none'   => esc_html__('none', 'iqonic-extension'),
                ],
                'condition'  => ['powerhour_testimonial_block_has_border' => ['yes']],
                'selector' => '{{WRAPPER}} .powerhour-testimonial .powerhour-main-slider',
            ]
        );

        $this->add_control(
            'content_border_color',
            [
                'label'     => esc_html__('Border Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'condition' => ['powerhour_testimonial_block_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-testimonial .powerhour-main-slider' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'content_border_width',
            [
                'label'     => esc_html__('Border Width', 'iqonic-extension'),
                'type'      => Controls_Manager::DIMENSIONS,
                'size_units'=> ['px', '%'],
                'condition' => ['powerhour_testimonial_block_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-testimonial' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-main-slider' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'iqonic-extension'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition'  => ['powerhour_testimonial_block_has_border' => ['yes']],
                'selectors'  => [
                    '{{WRAPPER}} .powerhour-testimonial' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-main-slider' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label'     => esc_html__('Padding', 'iqonic-extension'),
                'type'      => Controls_Manager::DIMENSIONS,
                'size_units'=> ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-testimonial' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-main-slider' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_margin',
            [
                'label'      => esc_html__('Margin', 'iqonic-extension'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .powerhour-testimonial' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-main-slider' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_ba4cBNdeMno5053j6395',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'quote_hover_back_color',
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-testimonial:hover',

            ]
        );

        $this->add_control(
            'powerhour_testimonial_hover_block_has_border',
            [
                'label'     => esc_html__('Set Custom Border?', 'iqonic-extension'),
                'type'      => Controls_Manager::SWITCHER,
                'default'   => 'no',
                'yes'       => esc_html__('yes', 'iqonic-extension'),
                'no'        => esc_html__('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'content_hover_border_style',
            [
                'label'     => esc_html__('Border Style', 'iqonic-extension'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'none',
                'condition' => ['powerhour_testimonial_hover_block_has_border' => ['yes']],
                'options'   => [
                    'solid' => esc_html__('Solid', 'iqonic-extension'),
                    'dashed'=> esc_html__('Dashed', 'iqonic-extension'),
                    'dotted'=> esc_html__('Dotted', 'iqonic-extension'),
                    'double'=> esc_html__('Double', 'iqonic-extension'),
                    'outset'=> esc_html__('outset', 'iqonic-extension'),
                    'groove'=> esc_html__('groove', 'iqonic-extension'),
                    'ridge' => esc_html__('ridge', 'iqonic-extension'),
                    'inset' => esc_html__('inset', 'iqonic-extension'),
                    'hidden'=> esc_html__('hidden', 'iqonic-extension'),
                    'none'  => esc_html__('none', 'iqonic-extension'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-testimonial:hover' => 'border-style: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-testimonial:hover .powerhour-main-slider' => 'border-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'content_hover_border_color',
            [
                'label'     => esc_html__('Border Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'condition' => ['powerhour_testimonial_hover_block_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-testimonial:hover ' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-testimonial:hover .powerhour-main-slider' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'content_hover_border_width',
            [
                'label'     => esc_html__('Border Width', 'iqonic-extension'),
                'type'      => Controls_Manager::DIMENSIONS,
                'size_units'=> ['px', '%'],
                'condition' => ['powerhour_testimonial_hover_block_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-testimonial:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-testimonial:hover .powerhour-main-slider' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_hover_border_radius',
            [
                'label'     => esc_html__('Border Radius', 'iqonic-extension'),
                'type'      => Controls_Manager::DIMENSIONS,
                'size_units'=> ['px', '%'],
                'condition' => ['powerhour_testimonial_hover_block_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-testimonial:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-testimonial:hover .powerhour-main-slider' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_hover_padding',
            [
                'label'     => esc_html__('Padding', 'iqonic-extension'),
                'type'      => Controls_Manager::DIMENSIONS,
                'size_units'=> ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-testimonial:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-testimonial:hover .powerhour-main-slider' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_hover_margin',
            [
                'label'     => esc_html__('Margin', 'iqonic-extension'),
                'type'      => Controls_Manager::DIMENSIONS,
                'size_units'=> ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-testimonial:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-testimonial:hover .powerhour-main-slider' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        /* Testimonial Body end*/
        
   /* Testimonial content start*/

   $this->start_controls_section(
    'section_U4o0fTi9d90YQL50K7GB',
    [
        'label' => esc_html__('Content', 'iqonic-extension'),
        'tab'   => Controls_Manager::TAB_STYLE,
    ]
);

$this->add_group_control(
    Group_Control_Typography::get_type(),
    [
        'name'      => 'content_text_typography',
        'label'     => esc_html__('Typography', 'iqonic-extension'),
        'selector'  => '{{WRAPPER}} .powerhour-testimonial-style-1 .text-dec p',
    ]
);

$this->start_controls_tabs('testimonial_content_tabs');
$this->start_controls_tab(
    'tabs_C3P7D901c5nduaV',
    [
        'label' => esc_html__('Normal', 'iqonic-extension'),
    ]
);

$this->add_control(
    'content_text_color',
    [
        'label'     => esc_html__('Color', 'iqonic-extension'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .text-dec p' => 'color: {{VALUE}};',
        ],
    ]
);

$this->add_control(
    'content_text_bg_color',
    [
        'label'     => esc_html__('Background', 'iqonic-extension'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-testimonial-style-1 .text-dec' => 'background-color: {{VALUE}};',
        ],

    ]
);

$this->end_controls_tab();
$this->start_controls_tab(
    'tabs_badeMno5053j6395',
    [
        'label' => __('Hover', 'iqonic-extension'),
    ]
);
$this->add_control(
    'content_hover_text_color',
    [
        'label'     => esc_html__('Color', 'iqonic-extension'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-testimonial-content:hover .text-dec p' => 'color: {{VALUE}};',
        ],
    ]
);
$this->add_control(
    'content_text_bg_hover_color',
    [
        'label'     => esc_html__('Background', 'iqonic-extension'),
        'type'      => Controls_Manager::COLOR,
        'selectors' => [
            '{{WRAPPER}} .powerhour-testimonial-style-1 .text-dec:hover' => 'background-color: {{VALUE}};',
        ],
    ]
);

$this->end_controls_tab();
$this->end_controls_tabs();

$this->add_responsive_control(
    'content_inner_padding',
    [
        'label'     => esc_html__('Padding', 'iqonic-extension'),
        'type'      => Controls_Manager::DIMENSIONS,
        'size_units'=> ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .powerhour-testimonial-style-1 .text-dec' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);

$this->add_responsive_control(
    'content_inner_margin',
    [
        'label'     => esc_html__('Margin', 'iqonic-extension'),
        'type'      => Controls_Manager::DIMENSIONS,
        'size_units'=> ['px', '%'],
        'selectors' => [
            '{{WRAPPER}} .powerhour-testimonial-style-1 .text-dec' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
        ],
    ]
);


$this->end_controls_section();

/* Testimonial content end*/
  
        /* Author Image Start*/

        $this->start_controls_section(
            'section_6Ok0qBAc5URV0M9JWXdw',
            [
                'label' => esc_html__('Author Image', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('auth_img_tabs');
        $this->start_controls_tab(
            'tabs_ams3cek58jnOT0Ux0CFa',
            [
                'label' => esc_html__('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'           => 'auth_back_color',
                'label'          => esc_html__('Author Image Background', 'iqonic-extension'),
                'types'          => ['classic', 'gradient'],
                'selector'       => '{{WRAPPER}} .testimonial-slider-img',
                'fields_options' => [
                    'background' => [
                        'frontend_available' => true,
                    ],
                ],
            ]
        );

        $this->add_control(
            'auth_img_border_radius',
            [
                'label'     => esc_html__('Border Radius', 'iqonic-extension'),
                'type'      => Controls_Manager::DIMENSIONS,
                'size_units'=> ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slider-img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_0d0B0IDN5T9GutacSU7i',
            [
                'label' => esc_html__('Hover', 'iqonic-extension'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'           => 'auth_hover_back_color',
                'label'          => esc_html__('Author Image Background', 'iqonic-extension'),
                'types'          => ['classic', 'gradient'],
                'selector'       => '{{WRAPPER}} .testimonial-slider-img:hover',
                'fields_options' => [
                    'background' => [
                        'frontend_available' => true,
                    ],
                ],
            ]
        );

        $this->add_control(
            'auth_hover_img_border_radius',
            [
                'label'      => esc_html__('Border Radius', 'iqonic-extension'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .testimonial-slider-img:hover ' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'auth_img_width',
            [
                'label'       => esc_html__('Author Image Width', 'iqonic-extension'),
                'type'        => Controls_Manager::SLIDER,
                'size_units'  => ['px', '%'],
                'range'       => [
                    'px'      => [
                        'min' => 0,
                        'max' => 1000,
                        'step'=> 5,
                    ],
                    '%'       => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'   => [
                    '{{WRAPPER}} .testimonial-slider-img' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'auth_img_height',
            [
                'label'       => esc_html__('Author Image Height', 'iqonic-extension'),
                'type'        => Controls_Manager::SLIDER,
                'size_units'  => ['px', '%'],
                'range'       => [
                    'px'      => [
                        'min' => 0,
                        'max' => 1000,
                        'step'=> 5,
                    ],
                    '%'       => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors'   => [
                    '{{WRAPPER}} .testimonial-slider-img' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'auth_img_padding',
            [
                'label'     => esc_html__('Padding', 'iqonic-extension'),
                'type'      => Controls_Manager::DIMENSIONS,
                'size_units'=> ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slider-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'auth_img_margin',
            [
                'label'     => esc_html__('Margin', 'iqonic-extension'),
                'type'      => Controls_Manager::DIMENSIONS,
                'size_units'=> ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial-slider-img' => 'margin: {{TOP}}{{UNIT}}  {{BOTTOM}}{{UNIT}} ;',
                ],
            ]
        );

        $this->end_controls_section();

        /* Author Image End*/

        /* Author Name Start*/

        $this->start_controls_section(
            'section_jaSF5vQVDeG70e6H39e7',
            [
                'label' => __('Author Title', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'author_text_typography',
                'label'    => esc_html__('Author Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}}  .author-name',
            ]
        );

        $this->start_controls_tabs('auther_text_tabs');
        $this->start_controls_tab(
            'tabs_ayOB60g3uX0C27UdaanS',
            [
                'label' => esc_html__('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'author_text_color',
            [
                'label'     => esc_html__('Author Text Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .author-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_ydJ0bNC6788H90mOr7ga',
            [
                'label' => esc_html__('Hover', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'author_hover_text_color',
            [
                'label' => __('Author Text Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .author-name:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'post_meta_padding',
            [
                'label'     => __('Padding', 'iqonic-extension'),
                'type'      => Controls_Manager::DIMENSIONS,
                'size_units'=> ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .author-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'post_meta_margin',
            [
                'label'     => __('Margin', 'iqonic-extension'),
                'type'      => Controls_Manager::DIMENSIONS,
                'size_units'=> ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .author-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_section();

        /* Author Name End*/

         /* Rating Start*/

         $this->start_controls_section(
            'section_U27ec1SYp8z8679L00WE',
            [
                'label' => __('Rating', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,

                'condition' => ['show_rating' => 'block'],
            ]
        );

        $this->add_control(
            'rating_icon_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-post-ratings' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-post-ratings svg path' => 'fill: {{VALUE}};',

                ],

            ]
        );
        $this->end_controls_section();

        /* Rating End*/
        $this->start_controls_section(
            'section_285gUPrCuoL6e62Mhf7m',
            [
                'label' => __('Quote', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 
                    'has_icon' => 'yes',
                    'design_style'=> 'style_2'
                ],
            ]
        );

        $this->start_controls_tabs('quote_icon_tabs');
        $this->start_controls_tab(
            'tabs_jeBef2kCfHObvih40638',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'php_preifx_icon_color',
            [
                'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'fill: {{VALUE}}; color: {{VALUE}};'
                ],
                'condition' => [
                    'media_style!' => 'image',
                ],
            ]

        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'powerhour_quote_icon_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .quote-icon',
            ]
        );


        $this->add_control(
            'powerhour_iconbox_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'powerhour_quote_icon_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'condition' => ['powerhour_iconbox_has_border' => ['yes']],
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'border-style:{{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'powerhour_quote_icon_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => ['powerhour_iconbox_has_border' => ['yes']],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'border-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'powerhour_quote_icon_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => ['powerhour_iconbox_has_border' => ['yes']],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'powerhour_quote_icon_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => ['powerhour_iconbox_has_border' => ['yes']],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_aJ0C3kdUL5G4tW12awyR',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                'type'  => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .quote-icon:hover' => 'fill: {{VALUE}}; color: {{VALUE}};',
                ],
                'condition' => [
                    'media_style!' => 'image',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'powerhour_quote_icon_hover_background',
                'label' => __('Hover Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .quote-icon:hover',
            ]
        );

        $this->add_control(
            'powerhour_iconbox_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'powerhour_quote_icon_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],
                'condition' => ['powerhour_iconbox_hover_has_border' => ['yes']],

                'selectors' => [
                    '{{WRAPPER}} .quote-icon:hover' => 'border-style:{{VALUE}};',


                ],
            ]
        );

        $this->add_control(
            'powerhour_quote_icon_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'condition' => ['powerhour_iconbox_hover_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}} .quote-icon:hover' => 'border-color: {{VALUE}};',
                ],


            ]
        );


        $this->add_control(
            'powerhour_quote_icon_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition' => ['powerhour_iconbox_hover_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}} .quote-icon:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'powerhour_quote_icon_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition' => ['powerhour_iconbox_hover_has_border' => ['yes']],
                'selectors' => [
                    '{{WRAPPER}} .quote-icon:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Icon Size', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'condition' => ['media_style' => ['icon']],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_width',
            [
                'label' => __('Width', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'icon_height',
            [
                'label' => __('Height', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'line-height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'powerhour_quote_icon_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'powerhour_quote_icon_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .quote-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Testimonial/render.php';
    }
}