<?php

namespace Iqonic\Elementor\Elements\Team;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic-Team', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Team', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-person';
    }

    protected function register_controls()
    {
       $this->start_controls_section(
            'section_Team',
            [
                'label' => __('Team Post', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'design-style',
            [
                'label'      => __('Team Style', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'slider',
                'options'    => [
                    'none'   => __('None', 'iqonic-extension'),
                    'slider' => __('Team Slider', 'iqonic-extension'),
                    'grid'   => __('Team Grid', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'team_grid_style',
            [
                'label'      => __('Team Grid', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => '1',
                'options'    => [
                    '1'      => __('One', 'iqonic-extension'),
                    '2'      => __('Two', 'iqonic-extension'),
                    '3'      => __('Three', 'iqonic-extension'),
                    '4'      => __('Four', 'iqonic-extension'),
                ],
                'condition'  => ['design-style' => 'grid']
            ]
        );
        $this->add_control(
            'pagination',
            [
                'label'     => __('Show Pagination', 'iqonic-extension'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'no',
                'options'   => [
                    'yes'   => esc_html__('yes', 'iqonic-extension'),
                    'no'    => esc_html__('no', 'iqonic-extension')
                ],
                'condition' => ['design-style' => 'grid']

            ]
        );

        $this->add_control(
            'dis_number',
            [
                'label'         => __('Enter Number Of Team view', 'iqonic-extension'),
                'type'          => Controls_Manager::TEXT,
                'default'       => '-1',
                'dynamic'       => [
                    'active'    => true,
                ],

                'label_block'   => true,
            ]
        );


        $this->add_control(
            'order',
            [
                'label'    => __('Order By', 'iqonic-extension'),
                'type'     => Controls_Manager::SELECT,
                'default'  => 'ASC',
                'options'  => [
                    'DESC' => esc_html__('Descending', 'iqonic-extension'),
                    'ASC'  => esc_html__('Ascending', 'iqonic-extension')
                ],
            ]
        );

        $this->add_control(
            'iqonic_has_box_shadow',
            [
                'label' => __('Box Shadow?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'iqonic_show_content',
            [
                'label' => __('Show Content?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension')
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'owl_control_section',
            [
                'label' => __('Slider Control', 'iqonic-extension'),        
                'condition' => ['design-style' => ['slider']],

            ]
        );

        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/owl-control.php';


        $this->end_controls_section();


        /* Team start */

        $this->start_controls_section(
            'section_kA7uL7eHU0wfNt124e2g',
            [
                'label' => __('Team', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('team_tabs');
        $this->start_controls_tab(
            'tabs_qNU781zj1ck660yd2vn7',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'team_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-team',

            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'team_box_shadow',
                'label' => __('Box Shadow', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-team',
            ]
        );
        $this->add_control(
            'team_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'team_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'condition' => [
                    'team_has_border' => 'yes',
                ],
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),
                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-team' => 'border-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'team_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'team_has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team' => 'border-color: {{VALUE}};',
                ]
            ]
        );

        $this->add_control(
            'team_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition' => [
                    'team_has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'team_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition' => [
                    'team_has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_rKkxfU2on94gt7b3FyCS',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'team_hover_back_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-team:hover',

            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'team_hover_box_shadow',
                'label' => __('Box Shadow', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-team:hover',
            ]
        );

        $this->add_control(
            'team_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );


        $this->add_control(
            'team_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'condition' => [
                    'team_hover_has_border' => 'yes',
                ],
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}}  .powerhour-team:hover' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'team_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'team_hover_has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-team:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'team_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [
                    'team_hover_has_border' => 'yes',
                ],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-team:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'team_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [
                    'team_hover_has_border' => 'yes',
                ],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'team_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-team' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'team_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_section();

        /*team End*/


        /* team info start*/

        $this->start_controls_section(
            'section_Ja72qNLpe2h7tlV1598b',
            [
                'label' => __('Team Info', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('team_info_tabs');
        $this->start_controls_tab(
            'tabs_NJ5v9R21We1wEbhK12yb',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'team_info_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-team-blog .powerhour-team-info ',

            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'team_info_box_shadow',
                'label' => __('Box Shadow', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-team-blog .powerhour-team-info',
            ]
        );
        $this->add_control(
            'team_info_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );




        $this->add_control(
            'team_info_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'condition' => [
                    'team_info_has_border' => 'yes',
                ],
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-team-blog .powerhour-team-info' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'team_info_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'team_info_has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team-blog .powerhour-team-info' => 'border-color: {{VALUE}};',

                ],


            ]
        );

        $this->add_control(
            'team_info_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition' => [
                    'team_info_has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team .powerhour-team-blog .powerhour-team-info' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'team_info_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition' => [
                    'team_info_has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team .powerhour-team-blog .powerhour-team-info' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_301xXls5AF5eJem2beQ6',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'team_info_hover_back_color',
                'types'     => ['classic', 'gradient'],
                'selector'  => '{{WRAPPER}} .powerhour-team:hover .powerhour-team-blog .powerhour-team-info',

            ]
        );


        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'team_info_hover_box_shadow',
                'label' => __('Box Shadow', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-team:hover .powerhour-team-blog .powerhour-team-info',
            ]
        );

        $this->add_control(
            'team_info_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );


        $this->add_control(
            'team_info_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'condition' => [
                    'team_info_hover_has_border' => 'yes',
                ],
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}}  .powerhour-team:hover .powerhour-team-blog .powerhour-team-info' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'team_info_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'team_info_hover_has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-team:hover .powerhour-team-blog .powerhour-team-info' => 'border-color: {{VALUE}};',

                ],


            ]
        );

        $this->add_control(
            'team_info_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [
                    'team_info_hover_has_border' => 'yes',
                ],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-team:hover .powerhour-team-blog .powerhour-team-info' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'team_info_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [
                    'team_info_hover_has_border' => 'yes',
                ],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team:hover .powerhour-team-blog .powerhour-team-info' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'team_info_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team .powerhour-team-info' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'team_info_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team .powerhour-team-info' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_section();

        /*team End*/



        /* Team Image start*/

        $this->start_controls_section(
            'section_c2ZGc6820Ja02vsM2Arx',
            [
                'label' => __('Team Image', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('team_image_tabs');
        $this->start_controls_tab(
            'tabs_0bBTZl2C2Ri5yqe4dP69',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'team_image_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-team-blog .powerhour-team-img',

            ]
        );



        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'team_image_box_shadow',
                'label' => __('Box Shadow', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-team-blog .powerhour-team-img',
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_rePeJ7y0c26LF2M5U25Q',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'team_image_hover_back_color',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-team:hover .powerhour-team-blog .powerhour-team-img',

            ]
        );


        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'team_image_hover_box_shadow',
                'label' => __('Box Shadow', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-team:hover .powerhour-team-blog .powerhour-team-img',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_control(
            'team_image_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        
        $this->add_responsive_control(
            'team_image_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-team-blog .powerhour-team-img' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'team_image_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team-blog .powerhour-team-img' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_section();

        /*team  Image End*/


        /* Author Name  Start*/

        $this->start_controls_section(
            'section_3001b3d2SJ2q2t2eQpZ0',
            [
                'label' => __('Author Title', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,

            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'author_text_typography',
                'label' => __('Author Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-team-blog .powerhour-team-info .member-text',
            ]
        );

        $this->start_controls_tabs('auther_text_tabs');
        $this->start_controls_tab(
            'tabs_50PBuiNQ6t2eAe3q83f4',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'author_text_color',
            [
                'label' => __('Author Text Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-team-blog .powerhour-team-info .member-text' => 'color: {{VALUE}};',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_Sl0cVY2qv5F5035M4be7',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'author_hover_text_color',
            [
                'label' => __('Author Text Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team-blog .powerhour-team-info:hover .member-text' => 'color: {{VALUE}};',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->add_responsive_control(
            'post_meta_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-team-blog .powerhour-team-info .member-text' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'post_meta_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team-blog .powerhour-team-info .member-text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_section();

        /* Author Name */



        /*  Designation Start*/

        $this->start_controls_section(
            'section_h8XA016qebeQ7aWb7xgC',
            [
                'label' => __('Author Designation', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,

            ]
        );


        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'desig_text_typography',
                'label' => __('Designation Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-team-info .powerhour-team-author-detail .powerhour_designation',
            ]
        );


        $this->start_controls_tabs('auther_designationt_tabs');
        $this->start_controls_tab(
            'tabs_62jiY5Ub1Av280f5dP73',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'desig_text_color',
            [
                'label' => __('Designation Text Color', 'iqonic-extension'),
                'type'  => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team-info .powerhour-team-author-detail .powerhour_designation' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_n2Le1sN1r2PuD2oj5l6d',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'desig_hover_text_color',
            [
                'label' => __('Designation Text Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team:hover .powerhour-team-info .powerhour-team-author-detail .powerhour_designation' => 'color: {{VALUE}};',

                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

       $this->end_controls_section();

        /* Author Name and Designation End*/

      /*  Content Start*/

      $this->start_controls_section(
        'section_XA016qebeQ7aWb7xgC',
        [
            'label' => __('Team Content', 'iqonic-extension'),
            'tab' => Controls_Manager::TAB_STYLE, 
            'condition' => [
                'iqonic_show_content' => 'yes',
            ],
        ]
    );

    $this->add_group_control(
        Group_Control_Typography::get_type(),
        [
            'name' => 'desig_tcontent_typography',
            'label' => __('Content Typography', 'iqonic-extension'),
            'selector' => '{{WRAPPER}} .powerhour-team-info .powerhour-team-author-detail .powerhour-description',
        ]
    );


    $this->start_controls_tabs('auther_content_tabs');
    $this->start_controls_tab(
        'tabs_62jiY5Ub1Av280dP73',
        [
            'label' => __('Normal', 'iqonic-extension'),
        ]
    );
    $this->add_control(
        'desig_content_color',
        [
            'label' => __('Content Text Color', 'iqonic-extension'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .powerhour-team-info .powerhour-team-author-detail .powerhour-description' => 'color: {{VALUE}};',

            ],

        ]
    );

    $this->end_controls_tab();
    $this->start_controls_tab(
        'tabs_n2Le1sN1r2PuD2oj5l',
        [
            'label' => __('Hover', 'iqonic-extension'),
        ]
    );
    $this->add_control(
        'desig_hover_content_color',
        [
            'label' => __('Content Text Color', 'iqonic-extension'),
            'type' => Controls_Manager::COLOR,
            'selectors' => [
                '{{WRAPPER}} .powerhour-team:hover .powerhour-team-info .powerhour-team-author-detail .powerhour-description' => 'color: {{VALUE}};',

            ],

        ]
    );
    $this->end_controls_tab();
    $this->end_controls_tabs();

   $this->end_controls_section();

        /* Icon Icon start*/

        $this->start_controls_section(
            'section_fWfDo2d5TaiyzmcaU6f6',
            [
                'label' => __('Social Icon', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['design-style' => 'slider']
            ]
        );
        $this->add_control(
            'social-icon-size',
            [
                'label' => __('Size','iqonic-extension'),
                'type'  => Controls_Manager::SLIDER,
                'selectors' => ['{{WRAPPER}} .powerhour-team-info .powerhour-team-social .iconswrapper ul li a svg'=> 'height:{{SIZE}}{{UNIT}}; width:{{SIZE}}{{UNIT}};']
            ]
        );

        


        $this->start_controls_tabs('Iconbox_icon_tabs');
        $this->start_controls_tab(
            'tabs_Nz2MVxYKZe02c1Tb3Oa0',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );


        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'social_back_color',
                'label'    => __('Icon Background', 'iqonic-extension'),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}}  .powerhour-team-info .powerhour-team-social .iconswrapper ul li a',
            ]
        );

        $this->add_control(
            'icon_color_2323',
            [
                'label'     => __('Icon Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team .powerhour-team-social ul li a' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-team-info .powerhour-team-social .iconswrapper ul li a svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_2VTw7g6fE2Dhzma2M12F',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'social_icon_hover_back_color',
                'label'    => __('Icon Hover Background', 'iqonic-extension'),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-team:hover .powerhour-team-info .powerhour-team-social .iconswrapper ul li a',
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label'     => __('Choose Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team-info:hover .powerhour-team-social .iconswrapper ul li a svg path' => 'fill: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'powerhour_iconbox_icon_padding',
            [
                'label'      => __('Padding', 'iqonic-extension'),
                'type'       => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors'  => [
                    '{{WRAPPER}} .powerhour-team-info .powerhour-team-social .iconswrapper ul li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'powerhour_iconbox_icon_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-team-info .powerhour-team-social .iconswrapper ul li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
        /* Icon Box  icon*/
    }

    protected function render()
    {
        $settings = $this->get_settings();
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Team/render.php';
    }
}
