<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;
$settings = $this->get_settings_for_display();
$fallback_defaults = [
    'fa fa-facebook',
    'fa fa-twitter',
    'fa fa-google-plus',
];

$class_animation = '';

if (!empty($settings['hover_animation'])) {
    $class_animation = ' elementor-animation-' . $settings['hover_animation'];
}
$align = 'powerhour-socials-share';
if ($settings['layout'] == 'names') {
    $align .= ' powerhour-social-names';
} else if ($settings['layout'] == 'icons_names') {
    $align .= ' powerhour-social-icons-names';
} else {
    $align .= ' powerhour-social-icons';
}
$migration_allowed = Icons_Manager::is_migration_allowed();

?>
<div class="<?php echo esc_attr($align); ?>">
    <?php
    foreach ($settings['social_icon_list'] as $index => $item) {
        $migrated = isset($item['__fa4_migrated']['social_icon']);
        $is_new = empty($item['social']) && $migration_allowed;

        $social = '';

        // add old default
        if (empty($item['social']) && !$migration_allowed) {
            $item['social'] = isset($fallback_defaults[$index]) ? $fallback_defaults[$index] : 'fa fa-wordpress';
        }

        if (!empty($item['social'])) {
            $social = str_replace('fa fa-', '', $item['social']);
        }

        if (($is_new || $migrated) && 'svg' !== $item['social_icon']['library']) {
            $social = explode(' ', $item['social_icon']['value'], 2);
            if (empty($social[1])) {
                $social = '';
            } else {
                $social = str_replace('fa-', '', $social[1]);
            }
        }
        if ('svg' === $item['social_icon']['library']) {
            $social = get_post_meta($item['social_icon']['value']['id'], '_wp_attachment_image_alt', true);
        }

        $link_key = 'link_' . $index;

        $this->add_render_attribute($link_key, 'class', [
            'powerhour-share',
            'elementor-social-icon-' . $social . $class_animation,
        ]);
        $this->add_link_attributes($link_key, $item['link']);
    ?>
        <div class="powerhour-social-item">
            <a <?php echo $this->get_render_attribute_string($link_key); ?>>
                <?php
                if ($settings['layout'] != 'names') {
                    if ($is_new || $migrated) {

                        if( $item['social_icon']['value']  == 'fab fa-twitter' ){
                            echo '<svg xmlns="http://www.w3.org/2000/svg" x="0px" y="0px" fill="#fff" stroke="#fff" width="24" height="24" viewBox="0 0 50 50" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><path d="M 5.9199219 6 L 20.582031 27.375 L 6.2304688 44 L 9.4101562 44 L 21.986328 29.421875 L 31.986328 44 L 44 44 L 28.681641 21.669922 L 42.199219 6 L 39.029297 6 L 27.275391 19.617188 L 17.933594 6 L 5.9199219 6 z M 9.7167969 8 L 16.880859 8 L 40.203125 42 L 33.039062 42 L 9.7167969 8 z"></path></svg>';
                        } else {
                            Icons_Manager::render_icon($item['social_icon']);
                        }

                    } else { ?>
                        <i class="<?php echo esc_attr($item['social']); ?>"></i>
                <?php }
                } ?>
                <?php if ($settings['layout'] != 'default') { ?>
                    <?php echo esc_html($item['social_text']); ?>
                <?php }  ?>
            </a>
        </div>
    <?php } ?>
</div>