<?php

namespace Iqonic\Elementor\Elements\SocialMedia;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin;
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic-SocialMedia', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('iqonic SocialMedia', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-testimonial-carousel';
    }
    protected function register_controls()
    {
        $this->start_controls_section(
            'social-media-section',
            [
                'label'     => esc_html__('Data Controls','iqonic-extension')
            ]
        );

        $this->add_control(
            'social-media-style',
            [
                'label'       => esc_html__('Style','iqonic-extension'),
                'type'        => Controls_Manager::SELECT,
                'default'     => 'style1',
				'options'     => [
					'style1'  => esc_html__( 'Style1', 'iqonic-extension' ),
					'style2'  => esc_html__( 'Style2', 'iqonic-extension' ),
				],
            ]
        );
        $this->add_control(
            'social-media-title',
            [
                'label'     => esc_html__('Title','iqonic-extension'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('Lets Connect through social media','iqonic-extension'),
                'condition' => ['social-media-style' => 'style1']
            ]
        );
        $this->add_control(
            'show-label',
            [
                'label'        => esc_html__('Show label','iqonic-extension'),
                'type'         => Controls_Manager::SWITCHER,
                'label_on'     => esc_html__( 'Show', 'iqonic-extension' ),
				'label_off'    => esc_html__( 'Hide', 'iqonic-extension' ),
				'return_value' => 'yes',
				'default'      => 'yes',
            ]
        );

        $this->add_control(
            'social-media-label',
            [
                'label'     => esc_html__('Label','iqonic-extension'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('Share : ','iqonic-extension'),
                'condition' => [
                    'show-label'=> 'yes'
                ]
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'social-media-type',
            [
                'label'     => esc_html__('Social Type','iqonic-extension'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
					'icon'  => esc_html__( 'Icon', 'iqonic-extension' ),
					'text'  => esc_html__( 'Text', 'iqonic-extension' ),
        		],
                    'default'   => 'text'
            ]
        );
        $repeater->add_control(
            'social-media-text',
            [
                'label'     => esc_html__('Social Media Text','iqonic-extension'),
                'type'      => Controls_Manager::TEXT,
                'default'   => esc_html__('FB','iqonic-extension'),
                'condition' => [
                    'social-media-type' => 'text'
                ]
            ]
        );
        $repeater->add_control(
            'social-media-icon',
            [
                'label'         => esc_html__('Social Media Icon','iqonic-extension'),
                'type'          => Controls_Manager::ICONS,
                'default'       => [
					'value'     => 'fa fa-facebook',
					'library'   => 'solid',
				],
                'condition'     => [
                    'social-media-type' => 'icon'
                ]
            ]
        );
        $repeater->add_control(
            'social-link',
            [
                'label'         => esc_html__('Social Media Link','iqonic-extension'),
                'type'          => Controls_Manager::URL,
                'placeholder'   => esc_html__( 'https://www.link.com/', 'iqonic-extension' ),
				   'show_external' => true,
				   'default'       => [
				   'url'           => 'https://www.link.com/',
				   'is_external'   => true,
				   'nofollow'      => true,
                ],
                ]
        );
        
        $this->add_control(
            'social-media-list',
            [
                'label'     => esc_html__('Social Media','iqonic-extension'),
                'type'      => Controls_Manager::REPEATER,
                'fields'    => $repeater->get_controls(),
                'default'   => [
                    [
                        'social-media-text' => esc_html__('FB','iqonic-extension'),
                        'social-link'       => esc_html__( 'https://www.facebook.com/', 'iqonic-extension' )
                    ],
                    [
                        'social-media-text' => esc_html__('TW','iqonic-extension'),
                        'social-link'       => esc_html__( 'https://www.tweeter.com/', 'iqonic-extension' )
                    ],
                    [
                        'social-media-text' => esc_html__('INSTA','iqonic-extension'),
                        'social-link'       => esc_html__( 'https://www.instagram.com/', 'iqonic-extension' )
                    ],
                ]
            ]
        );

        $repeat = new \Elementor\Repeater();
        $repeat->add_control(
            'social-media-category',
            [
                'label'     => esc_html__('Category','iqonic-extension'),
                'type'      => Controls_Manager::TEXT
            ]
        );
        $this->add_control(
            'social-media-cat-list',
            [
                'label'     => esc_html__('Category','iqonic-extension'),
                'type'      => Controls_Manager::REPEATER,
                'condition' => ['social-media-style' => 'style2'],
                'fields'    => $repeat->get_controls(),
                'default'   => [
                    ['social-media-category' => esc_html__('Animal','iqonic-extension')],
                    ['social-media-category' => esc_html__('Birds','iqonic-extension')],
                    ['social-media-category' => esc_html__('Trees','iqonic-extension')]
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'social-media-style-tab',
            [
                'label'     => esc_html__('Style','iqonic-extension'),
                'tab'       => Controls_Manager::TAB_STYLE
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name'      => 'social-media-background',
				'label'     => esc_html__( 'Background', 'iqonic-extension' ),
				'types'     => [ 'classic', 'gradient', 'video' ],
				'selector'  => '{{WRAPPER}} .social-data-container',
            ]
        );

        $this->start_controls_tabs(
			'style_tabs'
		);

		$this->start_controls_tab(
			'style_normal_tab',
			[
				'label' => __( 'Normal', 'iqonic-extension' ),
			]
		);

		$this->add_control(
            'title-style-normal',
            [
                'label'     => esc_html__('Title','iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'condition' => ['social-media-style' => 'style1'],
                'selectors' => [
					'{{WRAPPER}} .title' => 'color: {{VALUE}}',
				],
            ]
        );

		$this->add_control(
            'label-style-normal',
            [
                'label'     => esc_html__('Label','iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .label' => 'color: {{VALUE}}',
				],
            ]
        );

		$this->add_control(
            'icon-style-normal',
            [
                'label'     => esc_html__('Icon/Text','iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .social-media-text' => 'color: {{VALUE}}',
					'{{WRAPPER}} .social-media-icon' => 'color: {{VALUE}}',
				],
            ]
        );

		$this->end_controls_tab();

		$this->start_controls_tab(
			'style_hover_tab',
			[
				'label' => __( 'Hover', 'iqonic-extension' ),
			]
		);

		$this->add_control(
            'title-style-hover',
            [
                'label'     => esc_html__('Title','iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'condition' => ['social-media-style' => 'style1'],
                'selectors' => [
					'{{WRAPPER}} .title:hover' => 'color: {{VALUE}}',
				],
            ]
        );

		$this->add_control(
            'label-style-hover',
            [
                'label'     => esc_html__('Label','iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
					'{{WRAPPER}} .label:hover' => 'color: {{VALUE}}',
				],
            ]
        );

		$this->add_control(
            'icon-style-hover',
            [
                'label'     => esc_html__('Icon/Text','iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .social-media-text:hover' => 'color: {{VALUE}}',
					'{{WRAPPER}} .social-media-icon:hover' => 'color: {{VALUE}}',
				],
            ]
        );
		$this->end_controls_tab();

		$this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/SocialMedia/render.php';
    }
}