<?php

namespace Iqonic\Elementor\Elements\ServiceBox;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Css_Filter;
use Elementor\Plugin;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic_ServiceBox', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Service Box', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-icon-box';
    }
    protected function register_controls()
    {
        $this->start_controls_section(
            'section_3hF8a35YJWo8kiTD',
            [
                'label' => __('Service Style', 'iqonic-extension'),
            ]
        );
        $this->add_control(
			'design_style',
			[
				'label'   => __( 'Design Style', 'iqonic-extension' ),
				'type'    => \Elementor\Controls_Manager::SELECT,
				'default' => 'style_1',
				'options' => [
					'style_1'  => __( 'Style 1', 'iqonic-extension' ),
                    'style_2'  => __( 'Style 2', 'iqonic-extension' ),
                    'style_3'  => __( 'Style 3', 'iqonic-extension' ),
				],
			]
        );

        $this->add_control(
            'data_type',
            [
                'label'     => __('Data Type','iqonic-extension'),
                'type'      => \Elementor\Controls_Manager::SELECT,
				'default'   => 'dynamic',
				'options'   => [
					'static'  => __( 'Static', 'iqonic-extension' ),
                    'dynamic' => __( 'Dynamic', 'iqonic-extension' ),
				],
            ]
        );

        $this->end_controls_section();

        /*Service Box start*/
        $this->start_controls_section(
            'section_NELc08X86U438J8ZmnxQ',
            [
                'label' => __('Service Box', 'iqonic-extension'),
            ]
        );
        
        
        $this->add_control(
            'order',
            [
                'label'    => __('Order By', 'iqonic-extension'),
                'type'     => Controls_Manager::SELECT,
                'default'  => 'ASC',
                'options'  => [
                    'DESC' => esc_html__('Descending', 'iqonic-extension'),
                    'ASC'  => esc_html__('Ascending', 'iqonic-extension')
                ],
                'condition'     => ['design_style' => 'style_1']
            ]
        );

        $this->add_control(
            'get_service',
            [
                'label'    => __('Service', 'iqonic-extension'),
                'type'     => Controls_Manager::SELECT,
                'default'  => 'couple-councelling',
                'options'  => iqonic_get_post("Service"),
                'condition'     => ['design_style' => 'style_2','data_type' => 'dynamic']
            ]
        );
        
        
        $this->add_control(
            'get_title', [
				'label' => __( 'Title', 'iqonic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'iqonic-extension' ),
                'label_block' => true,
                'condition'     => ['design_style' => 'style_2','data_type' => 'static']
			]
        );
        $this->add_control(
            'get_icon', [
				'label' => __( 'Icon', 'iqonic-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
                'label_block' => true,
                'condition'     => ['design_style' => 'style_2','data_type' => 'static']
			]
        );
        $this->add_control(
            'get_button', [
				'label' => __( 'Button Text', 'iqonic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default'=> __('Read More','iqonic-extension'),
                'label_block' => true,
                'condition'     => ['design_style' => 'style_2','data_type' => 'static']
			]
        );
        $this->add_control(
            'get_button_type',
            [
                'label'    => __('Button Type', 'iqonic-extension'),
                'type'     => Controls_Manager::SELECT,
                'default'  => 'dynamic',
                'options'  => [
                    'custom'    => __('Custom','iqonic-extension'),
                    'dynamic'    => __('Dynamic','iqonic-extension')
                ],
                'condition'     => ['design_style' => 'style_2','data_type' => 'static']
            ]
        );
        
        $this->add_control(
            'get_link',
            [
                'label'         => esc_html__('Button Link', 'iqonic-extension'),
                'type'          => Controls_Manager::URL,
                'return_value'  => 'true',
                'multiple'      => true,
                'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
                'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
                ],
                'condition'     => [
                    'design_style' => 'style_2',
                    'data_type' => 'static',
                    'get_button_type'=> 'custom']
            ]
        );
        $this->add_control(
            'get_dynamic_btn_link',
            [
                'label'    => __('Service', 'iqonic-extension'),
                'type'     => Controls_Manager::SELECT,
                'default'  => 'couple-councelling',
                'options'  => iqonic_get_post("Service"),
                'condition'     => [
                    'design_style' => 'style_2',
                    'data_type' => 'static',
                    'get_button_type'=>'dynamic']
            ]
        );
        $repeater = new \Elementor\Repeater();
        $repeater->add_control(
            'list_title', [
				'label' => __( 'Title', 'iqonic-extension' ),
				'type' => \Elementor\Controls_Manager::TEXT,
				'default' => __( 'List Title' , 'iqonic-extension' ),
				'label_block' => true,
			]
        );
        $repeater->add_control(
            'list_icon', [
				'label' => __( 'Icon', 'iqonic-extension' ),
				'type' => \Elementor\Controls_Manager::ICONS,
				'label_block' => true,
			]
        );
        $repeater->add_control(
            'list_button', [
				'label' => __( 'Button Text', 'iqonic-extension' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default'=> __('Read More','iqonic-extension'),
				'label_block' => true,
			]
        );
        $repeater->add_control(
            'get_button_type',
            [
                'label'    => __('Button Type', 'iqonic-extension'),
                'type'     => Controls_Manager::SELECT,
                'default'  => 'dynamic',
                'options'  => [
                    'custom'    => __('Custom','iqonic-extension'),
                    'dynamic'    => __('Dynamic','iqonic-extension')
                ],
                
            ]
        );
        $repeater->add_control(
            'list_link',
            [
                'label'         => esc_html__('Button Link', 'iqonic-extension'),
                'type'          => Controls_Manager::URL,
                'return_value'  => 'true',
                'multiple'      => true,
                'placeholder' => __( 'https://your-link.com', 'plugin-domain' ),
                'show_external' => true,
				'default' => [
					'url' => '',
					'is_external' => true,
					'nofollow' => true,
                ],
                'condition' => [
                    'get_button_type' => 'custom'
                ]
            ]
        );
        $repeater->add_control(
            'get_dynamic_btn_link',
            [
                'label'    => __('Service', 'iqonic-extension'),
                'type'     => Controls_Manager::SELECT,
                'default'  => 'couple-councelling',
                'options'  => iqonic_get_post("Service"),
                'condition'     => [
                    'get_button_type'=>'dynamic']
            ]
        );
        

        $this->add_control(
			'service-list',
			[
				'label' => __( 'Repeater List', 'iqonic-extension' ),
				'type' => \Elementor\Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
                'title_field' => '{{{ list_title }}}',
                'condition' => ['design_style'=> 'style_3','data_type' => 'static']
			]
		);
        
        
        
        
        $this->add_responsive_control(
            'posts_per_page',
            [
                'label' => __('Posts Per Page', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'default' => [
                    'unit' => '%',
                    'size' => 3,
                ],
                'condition' => ['data_type' => 'dynamic']
            ]
        );
        

        $this->end_controls_section();
        /**
         * 
         * Slider Control
         * 
         */
        $this->start_controls_section(
            'owl_control_section',
            [
                'label'     => __('Slider Control', 'iqonic-extension'),    
                'condition' =>    ['design_style'=> 'style_1']
            ]
        );
        
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/owl-control.php';

        $this->end_controls_section();

        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/iqonic-blog-btn-controls.php';

        /** Service style strat */
        $this->start_controls_section(
            'section_sdfdfxdfdxfc',
            [
                'label' => __('Service', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'content-align',
            [
                'label' => __('Alignment', 'iqonic-extension'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->start_controls_tabs('service_tabs');
        $this->start_controls_tab(
            'tabs_qNU781zj1ck660yd2vn7',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'service_color',
                'types'     => ['classic', 'gradient'],
                'selector'  => '{{WRAPPER}} .powerhour-service-box ',
                'condition' => ['design_style!'=> 'style_3']
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'service_color1',
                'label' => __( 'Background 1', 'iqonic-extension' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-service-even ',
                'condition' => ['design_style'=> 'style_3']
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'service_color2',
                'label' => __( 'Background 2', 'iqonic-extension' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-service-odd',
                'condition' => ['design_style'=> 'style_3']
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'service_box_shadow',
                'label' => __('Box Shadow', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-service-box ',
            ]
        );
        $this->add_control(
            'service_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
       

       $this->add_control(
            'service_box_margin',
            [
                'label' => __('Margin','iqonic-extension'),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .powerhour-service-box-style-1' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
            ]
        );
        $this->add_control(
            'service_box_padding',
            [
                'label' => __('Padding','iqonic-extension'),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .powerhour-service-box-style-1' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
            ]
        );
        

        $this->add_control(
            'service_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'condition' => [
                    'service_has_border' => 'yes',
                ],
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-service-box ' => 'border-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'service_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'service_has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-service-box ' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'service_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition' => [
                    'service_has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-service-box ' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'service_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'condition' => [
                    'service_has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-service-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_rKkxfU2on94gt7b3FyCS',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );
        
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'service_color-hover',
                'types'     => ['classic', 'gradient'],
                'selector'  => '{{WRAPPER}} .powerhour-service-box:hover ',
                'condition' => ['design_style!'=> 'style_3']
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'service_color1-hover',
                'label' => __( 'Background 1', 'iqonic-extension' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-service-even:hover ',
                'condition' => ['design_style'=> 'style_3']
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'service_color2-hover',
                'label' => __( 'Background 2', 'iqonic-extension' ),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-service-odd:hover',
                'condition' => ['design_style'=> 'style_3']
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'service_hover_box_shadow',
                'label' => __('Box Shadow', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-service-box:hover',
            ]
        );

        $this->add_control(
            'service_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );


        $this->add_control(
            'service_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'condition' => [
                    'service_hover_has_border' => 'yes',
                ],
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}}  .powerhour-service-box:hover' => 'border-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'service_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'service_hover_has_border' => 'yes',
                ],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-service-box:hover' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'service_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [
                    'service_hover_has_border' => 'yes',
                ],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-service-box:hover' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'service_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => [
                    'service_hover_has_border' => 'yes',
                ],
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-service-box:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        
        /**Service style end */

        
        /**
         *  service title style start 
         */

        $this->start_controls_section(
            'section_ujfvjh',
            [
            'label'    => __('Service Title','iqonic-extension'),
            'tab'      => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_group_control(
			\Elementor\Group_Control_Typography::get_type(),
			[
				'name' => 'title_typography',
				'label' => __( 'Typography', 'plugin-domain' ),
				'selector' => '{{WRAPPER}} .powerhour-heading-title',
			]
		);

        $this->start_controls_tabs(
            'tab_gijgjh'
        );
        $this->start_controls_tab(
            'section_normal_tab',
            [
                'label'    => __('Normal','iqonic-extension')
            ]
        );

        $this->add_control(
            'title-color',
            [
                'label'    => __('Color','iqonic-extension'),
                'type'     => Controls_Manager::COLOR,
                'selectors'=> ['{{WRAPPER}} .powerhour-heading-title'=>'color:{{VALUE}}']
            ]
        );
       

         $this->end_controls_tab();
         $this->start_controls_tab(
            'section_hover_tab',
            [
                'label'    => __('Hover','iqonic-extension')
            ]
        );

        $this->add_control(
            'title-color_hover',
            [
                'label'    => __('Color','iqonic-extension'),
                'type'     => Controls_Manager::COLOR,
                'selectors'=> ['{{WRAPPER}} .powerhour-service-box:hover .powerhour-heading-title'=>'color:{{VALUE}}']
            ]
        );

         $this->end_controls_tab();

         $this->end_controls_tabs();

         $this->end_controls_section();

         /**
         *  service title style end 
         */

        /**
         *  service Icon style start 
         */

        $this->start_controls_section(
            'section_ugdgdjfvjh',
            [
               'label'    => __('Icon','iqonic-extension'),
               'tab'      => Controls_Manager::TAB_STYLE
            ]
        );
        $this->add_control(
            'icon_size',
            [
                'label' => __('Icon Size','iqonic-extension'),
                'type'   => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 80,
				],
				'selectors' => [
					'{{WRAPPER}} .powerhour-service-box-style-1 .service-box svg' => 'width: {{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}',
				],
            ]
        );
        $this->add_control(
            'icon_bg_size',
            [
                'label' => __('Background Size','iqonic-extension'),
                'type'   => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 130,
				],
				'selectors' => [
					'{{WRAPPER}} .powerhour-service-box-style-1 .service-box' => 'width: {{SIZE}}{{UNIT}}; height:{{SIZE}}{{UNIT}}',
				],
            ]
        );
        $this->add_control(
            'icon-marign',
            [
                'label' => __('Margin','iqonic-extension'),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .powerhour-service-box-style-1 .service-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
            ]
        );
        $this->add_control(
            'icon-padding',
            [
                'label' => __('Padding','iqonic-extension'),
                'type'  => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .powerhour-service-box-style-1 .service-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
            ]
        );
        $this->start_controls_tabs(
            'tab_gijgjhjfgjhfgjh'
        );
       $this->start_controls_tab(
           'section_icon_normal_tab',
           [
               'label'    => __('Normal','iqonic-extension')
           ]
       );

       $this->add_control(
           'icon-color',
           [
               'label'    => __('Icon','iqonic-extension'),
               'type'     => Controls_Manager::COLOR,
               'selectors'=> ['{{WRAPPER}} .powerhour-icon .service-box .icon svg path'=>'fill:{{VALUE}}']
           ]
       );
       $this->add_control(
        'icon-bg-color',
        [
            'label'    => __('Background','iqonic-extension'),
            'type'     => Controls_Manager::COLOR,
            'selectors'=> ['{{WRAPPER}} .powerhour-service-box-style-1 .service-box'=>'background-color:{{VALUE}}']
        ]
    );
        $this->end_controls_tab();
        $this->start_controls_tab(
           'section_icon_hover_tab',
           [
               'label'    => __('Hover','iqonic-extension')
           ]
       );

       $this->add_control(
           'icon-color_hover',
           [
               'label'    => __('Icon','iqonic-extension'),
               'type'     => Controls_Manager::COLOR,
               'selectors'=> ['{{WRAPPER}} .powerhour-service-box:hover .powerhour-icon .service-box .icon svg path'=>'fill:{{VALUE}}']
           ]
       );
       $this->add_control(
        'icon-bg-hover-color',
        [
            'label'    => __('Background','iqonic-extension'),
            'type'     => Controls_Manager::COLOR,
            'selectors'=> ['{{WRAPPER}} .powerhour-service-box-style-1:hover .service-box'=>'background-color:{{VALUE}}']
        ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        /**
        *  service Icon style end 
        */
         /**
         *  service content style start 
         */

        $this->start_controls_section(
            'section_dfgbdfgbdfb',
            [
               'label'    => __('Service Content','iqonic-extension'),
               'tab'      => Controls_Manager::TAB_STYLE,
               'condition'=> ['has_desc'=> 'yes','design_style'=>'style_2']
            ]
        );
        $this->add_group_control(
           \Elementor\Group_Control_Typography::get_type(),
           [
               'name'     => 'content_typography',
               'label'    => __( 'Typography', 'plugin-domain' ),
               'selector' => '{{WRAPPER}} .service-box-content .service-box-desc',
           ]
       );

        $this->start_controls_tabs(
            'tab_trhrth'
        );
       $this->start_controls_tab(
           'section_normal_tab_content',
           [
               'label'    => __('Normal','iqonic-extension')
           ]
       );

       $this->add_control(
           'content-color',
           [
               'label'    => __('Color','iqonic-extension'),
               'type'     => Controls_Manager::COLOR,
               'selectors'=> ['{{WRAPPER}} .service-box-content .service-box-desc'=>'color:{{VALUE}}']
           ]
       );

        $this->end_controls_tab();
        $this->start_controls_tab(
           'section_hover_tab_content',
           [
               'label'    => __('Hover','iqonic-extension')
           ]
       );

       $this->add_control(
           'content-color-hover',
           [
               'label'    => __('Color','iqonic-extension'),
               'type'     => Controls_Manager::COLOR,
               'selectors'=> ['{{WRAPPER}} .powerhour-service-box:hover .service-box-content .service-box-desc'=>'color:{{VALUE}}']
           ]
       );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();
        /**
        *  service desc style end 
        */
        
    }

    protected function render()
    {
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/ServiceBox/render.php';
    }
}