<?php

namespace Iqonic\Elementor\Elements\Progress;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
	public function get_name()
	{
		return __('iqonic_Progressbar', 'iqonic-extension');
	}

	public function get_title()
	{
		return __('Iqonic Progress Bar', 'iqonic-extension');
	}
	public function get_categories()
	{
		return ['iqonic-extension'];
	}

	public function get_icon()
	{
		return 'eicon-skill-bar';
	}


	protected function register_controls()
	{

		$this->start_controls_section(
			'section_progress',
			[
				'label' => __('Progress Style', 'iqonic-extension'),
			]
		);

		$this->add_control(
			'progress_style',
			[
				'label' => __( 'Progress Style', 'iqonic-extension' ),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'style_1',
				'options' => [
					'style_1'  => __( 'Style 1', 'iqonic-extension' ),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section',
			[
				'label' => __('Progressbar', 'iqonic-extension'),
			]
		);

		$repeater = new Repeater();
		$repeater->add_control(
			'section_title',
			[
				'label' => __('Title', 'iqonic-extension'),
				'type' => Controls_Manager::TEXT,
				'dynamic' => [
					'active' => true,
				],
				'label_block' => true,
				'default' => __('Add Your Title Text Here', 'iqonic-extension'),
			]
		);

		$repeater->add_control(
			'tab_score',
			[
				'label' => __('Score out of 100', 'iqonic-extension'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%', '$'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 50,
				],

			]
		);
		$this->add_control(
			'progress_bar',
			[
				'label' => __('Add Progress Bar', 'iqonic-extension'),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'section_title' => __('List Items', 'iqonic-extension'),
						'tab_score' => __('50', 'iqonic-extension'),

					]

				],
				'title_field' => '{{{ section_title }}}',
				'figure_field' => '{{{ tab_score }}}',
			]
		);

		$this->add_control(
			'iqonic_has_box_shadow',
			[
				'label' => __('Box Shaow?', 'iqonic-extension'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'no',
				'yes' => __('yes', 'iqonic-extension'),
				'no' => __('no', 'iqonic-extension'),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'section_progress_style',
			[
				'label' => __('Progress Bar Style', 'iqonic-extension'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'progress_color',
			[
				'label' => __('Progress Color', 'iqonic-extension'),
				'type'  => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .powerhour-progress-bar>span' => 'background: {{VALUE}};',
					'{{WRAPPER}} .powerhour-progressbar-style-2 .powerhour-progressbar-content .powerhour-progress-bar .show-progress::after' => 'background: {{VALUE}};'
				],
			]
		);

		$this->add_control(
			'progress_back_color',
			[
				'label' => __('Progress Background Color', 'iqonic-extension'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .powerhour-progressbar-style-2 .powerhour-progressbar-content .powerhour-progress-bar' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'progress_front_color',
			[
				'label' => __('Progress Box front Background Color', 'iqonic-extension'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .powerhour-progress-bar > span ' => 'background: {{VALUE}};',
					'{{WRAPPER}} .powerhour-progressbar-content' => 'background-color: {{VALUE}};',

				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'title_text_typography',
				'label' => __('Title Typography', 'iqonic-extension'),
				'selector' => '{{WRAPPER}} .powerhour-progressbar-box .progress-title',
							  '{{WRAPPER}} .powerhour-progressbar-style-2 .powerhour-progressbar-content span.progress-title'
			]
		);

		$this->add_control(
			'title_color',
			[
				'label' => __('Title Color', 'iqonic-extension'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .powerhour-progressbar-box .progress-title' => 'color: {{VALUE}};',
					'{{WRAPPER}} .powerhour-progressbar-style-2 .powerhour-progressbar-content .progress-title' => 'color:{{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'number_text_typography',
				'label' => __('Number Typography', 'iqonic-extension'),
				'selector' => '{{WRAPPER}} .powerhour-progressbar-box .progress-value',
			]
		);

		$this->add_control(
			'number_color',
			[
				'label' => __('Number Color', 'iqonic-extension'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .powerhour-progressbar-box .progress-value' => 'color: {{VALUE}};'
				],
			]
		);

		$this->add_control(
			'flip_back_back',
			[
				'label' => __('Number background Color', 'iqonic-extension'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .powerhour-progressbar-box .show-progress ,{{WRAPPER}}  .powerhour-progressbar-style-3 .progress-value' => 'background: {{VALUE}};',
					'{{WRAPPER}} .powerhour-progressbar-style-2 .powerhour-progressbar-content .progress-value' => 'background-color: {{VALUE}};',

				],
			]
		);

		$this->add_responsive_control(
			'progressbar_height',
			[
				'label' => __('Height', 'iqonic-extension'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .powerhour-progress-bar' => 'height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}};',
					'{{WRAPPER}} .powerhour-progressbar-style-3 .progress-value' => 'margin-top: -{{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'progressbar_border_radius',
			[
				'label' => __('Border Radius', 'iqonic-extension'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .powerhour-progress-bar,{{WRAPPER}} .powerhour-progress-bar>span' => 'border-radius: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'progress_margin',
			[
				'label' => __( 'Margin', 'iqonic-extension' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .powerhour-progressbar-box .powerhour-progressbar-content' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

        $this->add_control(
			'progress_padding',
			[
				'label' => __( 'Padding', 'iqonic-extension' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%', 'em' ],
				'selectors' => [
					'{{WRAPPER}} .powerhour-progressbar-box .powerhour-progressbar-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}
	
	protected function render()
	{
		$settings = $this->get_settings();
		require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Progress/render.php';
	}
}
