<?php

namespace Elementor;

use WP_Query;

if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();

$category = '';
if (!empty($settings['woo_category'])) {
	foreach ($settings['woo_category'] as $element) {
		$category .= $element . ",";
	}
	$category = "category=" . '"' . rtrim($category, ",") . '"';
}

if ($settings['show_pagination'] == 'yes') {
	$pagination = 'paginate="true"';
} else {
	$pagination = 'paginate="false"';
}

if (!$settings['show_catalog']) {

	remove_action('woocommerce_before_shop_loop', 'woocommerce_catalog_ordering', 30);
	add_action('woocommerce_before_shop_loop', function () {
		echo "</div>";
	}, 999);
}

remove_filter('wc_get_template_part', 'powerhour_wc_template_part', 99);
add_filter(
	'wc_get_template_part',
	function ($template, $slug, $name) {
		if ($this->get_settings()['woo_column'] == 'list') {
			$template = trailingslashit(get_stylesheet_directory()) . 'template-parts/wocommerce/entry-listing.php';
		} else {
			$template = trailingslashit(get_stylesheet_directory()) . 'template-parts/wocommerce/entry.php';
		}
		return $template;
	},
	10,
	3
);

remove_all_actions('woocommerce_after_shop_loop');
add_action('woocommerce_after_shop_loop',  array($this, 'powerhour_widget_loadmore'));
add_filter('woocommerce_shortcode_products_query', function ($args) {
	$this->product_query = $args;
	$this->max_page = (new WP_Query($this->product_query))->max_num_pages;
	$args["paged"] = get_query_var("paged");
	wp_reset_postdata();

	return $args;
});


remove_all_actions('woocommerce_shortcode_before_' . $settings['product_type'] . '_loop');

if ($this->get_settings()['view_all_switch'] === 'yes' || !empty($this->get_settings()['product_grid_title'])) {

	add_action(
		'woocommerce_shortcode_before_' . $settings['product_type'] . '_loop',
		function () {
			if ($this->get_settings()['view_all_switch'] === 'yes') {
				$view_all = '';

				$this->add_render_attribute('iq_class', 'class', 'iq-view-all');
				if ($this->get_settings()['use_custom_link_viewall'] == 'yes') {
					if ($this->get_settings()['view_all_custom_link']['url']) {
						$url = $this->get_settings()['view_all_custom_link']['url'];
						$this->add_render_attribute('iq_class', 'href', esc_url($url));

						if ($this->get_settings()['view_all_custom_link']['is_external']) {
							$this->add_render_attribute('iq_class', 'target', '_blank');
						}

						if ($this->get_settings()['view_all_custom_link']['nofollow']) {
							$this->add_render_attribute('iq_class', 'rel', 'nofollow');
						}
						$url = '';
					}
					$view_all_text = esc_html($this->get_settings()['use_custom_link_text']);
					$view_all = '<a ' . $this->get_render_attribute_string('iq_class') . '">' . $view_all_text . '</a>';
				} else {
					$cat = '';
					if (!empty($this->get_settings()['woo_category'])) {
						$cat = '&cat=' . implode(',', $this->get_settings()['woo_category']);
					}
					$view_all = '<a class="iq-view-all" href="#?type=product&p_type=' . esc_html($this->get_settings()['product_type'] . '&title=' . esc_html($this->get_settings()['product_grid_title']) . $cat) . '">' . esc_html('Want More?', "iqonic-extension") . '</a>';
				}
			} ?>
			
			<div class="iq-main-header d-flex align-items-center justify-content-between">
				<h4 class="main-title">
					<?php
					echo $this->get_settings()['product_grid_title'];
					?>
				</h4>
				<?php
				echo  isset($view_all) ? wp_kses_post($view_all) : '';
				?>
			</div><?php
		},
		999
	);
}

$class = $settings['woo_column'] == 'list' ?  'product-list-style' : 'product-grid-style'; ?>

<div class="woocommerce iq-woocommerce woocommerce-widget">
	<div class="woof_results_by_ajax" data-shortcode="woof_products is_ajax=1">
		<?php
		echo do_shortcode('[' . $settings['product_type'] . ' per_page="' . $settings['woo_per_page'] . '" columns="' . $settings['woo_column'] . '" ' . $category . ' order="' . $settings['woo_order'] . '" ' . $pagination . ' class="' . $class . '" is_ajax=1 ]');
		?>
	</div>
</div>