<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;
$html = '';

$settings = $this->get_settings();

$tabs = $this->get_settings_for_display('tabs');
$align = $settings['align'] ?? '';

if ($settings['iqonic_has_box_shadow'] == 'yes') {

    $align .= ' powerhour-box-shadow';
}

$active = $settings['active'];
if ($active === "yes") {
    $align .= ' active';
}

//price header render attribute
$this->add_render_attribute('powerhour-price-header', 'class', 'powerhour-price-header');

if ($settings['has_price_shadow'] == 'yes') {
    $this->add_render_attribute('powerhour_price_class', 'class', 'powerhour-price-shadow');
    $align .= ' powerhour-box-shadow';
}
if ($settings['pricing_style'] == 'style1') {
?>

    <!-- Style 1 -->
    <div class="powerhour-price-container powerhour-price-table-1 <?php echo esc_attr($align); ?> powerhour-outerbox">
        <div class="powerhour-inner-box">
            <div class="powerhour-main-price-box">
                <?php
                if ($settings['use_media_style'] == 'yes') {
                    echo '<div class="box-img">';
                    if ($settings['media_style'] == 'image') {
                        if (!empty($settings['image']['url'])) {
                            $this->add_render_attribute('image', 'src', $settings['image']['url']);
                            $this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($settings['image']));
                            $this->add_render_attribute('image', 'title', Control_Media::get_image_title($settings['image']));
                            $image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
                        }
                        echo $image_html;
                    }
                    if ($settings['media_style'] == 'icon') {
                        Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']);
                    }
                    echo '</div>';
                }
                ?>
                <div <?php echo $this->get_render_attribute_string('powerhour-price-header'); ?>>
                    <<?php echo $settings['label_tag']; ?> class="powerhour-price-label">
                        <?php echo esc_html($settings['price_label']); ?></<?php echo $settings['label_tag']; ?>>
                    <?php
                    $ex = explode(' ', $settings['currency_symbol']);
                    ?>
                    <<?php echo $settings['title_tag']; ?> class="powerhour-price">
                        <small><?php echo $ex[0]; ?></small><?php echo esc_html($settings['price']); ?>
                    </<?php echo $settings['title_tag']; ?>>
                </div>
            </div>
            <?php
            if (!empty($settings['description'])) {
                echo '<p class="powerhour-price-description">' . esc_html($settings['description']) . '</p>';
            }
            ?>
            <div class="powerhour-price-body">
                <ul class="powerhour-price-service">
                    <?php
                    foreach ($tabs as $index => $item) {
                        if ($item['has_service_active'] == 'yes') {
                            $class = 'active';
                        } else {
                            $class = 'inactive';
                        }
                    ?>
                        <li class="<?php echo esc_attr($class); ?>">
                            <?php
                            Icons_Manager::render_icon($item['service_icon'], ['aria-hidden' => 'true']);
                            ?>
                            <?php if ($item['want_dal_tag'] == 'yes') {
                            ?>
                                <del><span><?php echo esc_html($item['tab_title']) ?></span></del>
                            <?php } else { ?>
                                <span><?php echo esc_html($item['tab_title']) ?></span>
                            <?php } ?>
                        </li>
                    <?php
                    }
                    ?>
                </ul>
            </div>
            <div class="powerhour-price-footer">
                <?php if (!empty($settings['button_text']) && $settings['link']) {
                    require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Button/render.php';
                } ?>
            </div>
        </div>
    </div>
<?php } else if ($settings['pricing_style'] == 'style2') { ?>
    <!-- Style 2 -->
    <div class="powerhour-price-container powerhour-price-table-2">
        <div class="row align-items-center">
            <div class="col-md-8">
                <div <?php echo $this->get_render_attribute_string('powerhour-price-header'); ?>>
                    <<?php echo $settings['label_tag']; ?> class="powerhour-price-label">
                        <?php echo esc_html($settings['price_label']); ?></<?php echo $settings['label_tag']; ?>>
                </div>
                <?php
                if (!empty($settings['description'])) {
                    echo '<p class="powerhour-price-description">' . esc_html($settings['description']) . '</p>';
                } ?>
                <div class="session-time">
                    <?php if (!empty($settings['session-icon'])) { ?>
                        <div class="session-icon"><?php \Elementor\Icons_Manager::render_icon($settings['session-icon'], ['aria-hidden' => 'true']); ?></div>
                        <?php
                    }
                if (!empty($settings['session-text'])) { ?>
                    <div class="session-text">
                        <?php echo $settings['session-text']; ?>
                    </div>
                <?php } ?>
                </div>
                <?php $ex = explode(' ', $settings['currency_symbol']);
                ?>
                <div class="powerhour-price-footer">
                    <?php if (!empty($settings['button_text']) && $settings['link']) {
                        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Button/render.php';
                    } ?>
                </div>
                <<?php echo $settings['title_tag']; ?> class="powerhour-price">
                    <small><?php echo $ex[0]; ?></small><?php echo esc_html($settings['price']); ?>
                </<?php echo $settings['title_tag']; ?>>
            </div>
            <div class="col-md-4">
                <?php
                if ($settings['use_media_style'] == 'yes') {
                    echo '<div class="box-img">';
                    if ($settings['media_style'] == 'image') {
                        if (!empty($settings['image']['url'])) {
                            $this->add_render_attribute('image', 'src', $settings['image']['url']);
                            $this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($settings['image']));
                            $this->add_render_attribute('image', 'title', Control_Media::get_image_title($settings['image']));
                            $image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
                        }
                        echo $image_html;
                    }
                    if ($settings['media_style'] == 'icon') {
                        Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']);
                    }
                    echo '</div>';
                }
                ?>
            </div>
        </div>
    </div>
<?php } ?>