<?php

namespace Iqonic\Elementor\Elements\Price;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin;
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Repeater;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic-Price', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Price', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-price-table';
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section',
            [
                'label' => __('Pricing Plan', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'pricing_style',
            [
                'label'  => __('Style','iqonic-extension'),
                'type'   => Controls_Manager::SELECT,
                'options'=> [
                    'style1'    => __('Style 1','iqonic-extension'),
                    'style2'    => __('Style 2','iqonic-extension'),
                ],
                'default'=> 'style1'   
            ]
        );

        $this->add_control(
            'price',
            [
                'label' => __('Price', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('10', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'price_label',
            [
                'label' => __('Label', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('starter', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'description',
            [
                'label' => __('Description', 'iqonic-extension'),
                'type' => Controls_Manager::TEXTAREA,
                'dynamic' => [
                    'active' => true,
                ],
                'placeholder' => __('Enter Description', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'session-icon',
            [
                'label' => __('Session Icon','iqonic-extension'),
                'type'  => Controls_Manager::ICONS,
                'condition' => ['pricing_style'=>'style2'],
                'default' => [
					'value' => 'fas fa-star',
					'library' => 'solid',
				],
            ]
        );
        $this->add_control(
            'session-text',
            [
                'label' => __('Session text','iqonic-extension'),
                'type'  => Controls_Manager::TEXT,
                'condition' => ['pricing_style'=>'style2'],
                'default'   => __('50 min session','iqonic-extension')
            ]
        );

        $this->add_control(
            'use_media_style',
            [
                'label'      => __('Use Icon Header ? ', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'yes',
                'options'    => [

                    'yes'          => __('Yes', 'iqonic-extension'),
                    'no'          => __('No', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'media_style',
            [
                'label'      => __('Icon / Image', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'icon',
                'options'    => [
                    'icon'          => __('Icon', 'iqonic-extension'),
                    'image'          => __('Image', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label' => __('Icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'condition' => [
                    'media_style' => 'icon',
                ],
                'default' => [
                    'value' => 'fas fa-star'
                ],
            ]
        );

        $this->add_control(
            'image',
            [
                'label' => __('Choose Image', 'iqonic-extension'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'media_style' => 'image',
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $resultarr = [];
        $currrency = $this->get_currency_symbol();
        foreach ($currrency as $key => $value) {
            $resultarr[$value . ' ' . iqonic_random_strings(strtotime('now'))] = $value . ' ' . $key;
        }

        $this->add_control(
            'currency_symbol',
            [
                'label' => __('Currency Symbol', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT2,

                'options' => $resultarr,
            ]
        );

        $this->add_control(
            'active',
            [
                'label' => __('Is Active?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'label_off',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
                'condition' => ['pricing_style'=> 'style1']
            ]
        );

        $this->add_control(
            'has_price_shadow',
            [
                'label' => __('Use Box Shadow', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'label_off',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $repeater = new Repeater();
        $repeater->add_control(
            'tab_title',
            [
                'label' => __('Plan info List', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'default' => __('Service Item', 'iqonic-extension'),
                'placeholder' => __('Service Item', 'iqonic-extension'),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'has_service_active',
            [
                'label' => __('Active?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'label_off',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $repeater->add_control(
            'has_service_icon',
            [
                'label' => __('Use Icon?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'label_off',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $repeater->add_control(
            'want_dal_tag',
            [
                'label' => __('Want Del Tag?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'label_off',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $repeater->add_control(
            'service_icon',
            [
                'label' => __('Service Icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-star'

                ],
                'condition' => [
                    'has_service_icon' => 'yes',
                ],
                'label_block' => false,
                'skin' => 'inline',
            ]
        );

        $this->add_control(
            'tabs',
            [
                'label' => __('List Items', 'iqonic-extension'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'condition' => ['pricing_style'=>'style1'],
                'default' => [
                    [
                        'tab_title' => __('Service Item', 'iqonic-extension'),
                    ]
                ],
                'title_field' => '{{{ tab_title }}}',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label'      => __('Price Tag', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'h4',
                'options'    => [

                    'h1'          => __('h1', 'iqonic-extension'),
                    'h2'          => __('h2', 'iqonic-extension'),
                    'h3'          => __('h3', 'iqonic-extension'),
                    'h4'          => __('h4', 'iqonic-extension'),
                    'h5'          => __('h5', 'iqonic-extension'),
                    'h6'          => __('h6', 'iqonic-extension'),
                ],
            ]
        );
        $this->add_control(
            'label_tag',
            [
                'label'      => __('Price Label Tag', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'h4',
                'options'    => [

                    'h1'          => __('h1', 'iqonic-extension'),
                    'h2'          => __('h2', 'iqonic-extension'),
                    'h3'          => __('h3', 'iqonic-extension'),
                    'h4'          => __('h4', 'iqonic-extension'),
                    'h5'          => __('h5', 'iqonic-extension'),
                    'h6'          => __('h6', 'iqonic-extension'),
                ],
            ]
        );
        $this->add_control(
            'iqonic_has_box_shadow',
            [
                'label' => __('Box Shadow?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'iqonic-extension'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
            ]
        );


        $this->end_controls_section();

        /*Button Start*/
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/iqonic-btn-controls.php';
        /*Button End*/

        /* Price Table Start*/

        $this->start_controls_section(
            'section_fyWdp0abeSvr3Mi44LVm',
            [
                'label' => __('Price Table', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'active_price_background',
            [
                'label'     => __('Active Price Background','iqonic-extension'),
                'type'      => Controls_Manager::HEADING,
                'condition' => ['active'=>'yes']
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'price_table_active_background',
                'label' => __('Background', 'iqonic-extension'),
                'description' => __('This background will show up if the active mode is on','iqonic-extension'), 
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-price-table-1.active',
                'condition' => ['active'=>'yes']
            ]
        );
        $this->add_control(
			'after_active_devider',
			[
                'type' => \Elementor\Controls_Manager::DIVIDER,
                'condition' => ['active'=>'yes']
			]
		);

        $this->start_controls_tabs('price_table_tabs');
        $this->start_controls_tab(
            'tabs_yL0o668ZXM4g9zsUSjCi',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'section_vl8vK4162c',
            [
                'label' => __('Outer Background ', 'iqonic-extension'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'price_table_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-price-container',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'powerhour_price_table_box_shadow',
                'label' => __('Box Shadow', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-price-container',
            ]
        );

        $this->add_control(
            'price_table_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'price_table_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'condition' => [
                    'price_table_has_border' => 'yes',
                ],
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-container ' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'price_table_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'price_table_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-container' => 'border-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'price_table_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'price_table_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-container' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'price_table_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'price_table_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-container' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );




        $this->add_responsive_control(
            'price_table_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'price_table_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );


        
        

        

        
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_f1pW85xe0693t0fKBV1Y',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'section_COl862c',
            [
                'label' => __('Outer Hover Background ', 'iqonic-extension'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'price_table_hover_background',
                'label' => __('Hover Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-price-container:hover ,{{WRAPPER}} .powerhour-price-container.active',
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'powerhour_price_table_hover_box_shadow',
                'label' => __('Box Shadow', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-price-container:hover ,{{WRAPPER}} .powerhour-price-container.active',
            ]
        );


        $this->add_control(
            'price_table_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'price_table_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'condition' => [
                    'price_table_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-container:hover ,{{WRAPPER}} .powerhour-price-container.active' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'price_table_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'price_table_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-container:hover,{{WRAPPER}} .powerhour-price-container.active' => 'border-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'price_table_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'price_table_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-container:hover,{{WRAPPER}} .powerhour-price-container.active' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'price_table_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'price_table_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-container:hover,{{WRAPPER}} .powerhour-price-container.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );




        $this->add_responsive_control(
            'price_table_hover_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'price_table_hover_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container:hover' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );



        


       

       
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        /* Price table End*/



        /* Price Header Start*/

        $this->start_controls_section(
            'section_K570f6fbXo53dcT4m2eN',
            [
                'label' => __('Price Header', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        /*currency Start*/
        $this->add_control(
            'section_mX28erE332RbyLve03nU',
            [
                'label' => __('Currency', 'iqonic-extension'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_currency_text_typography',
                'label' => __('Currency Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}}  .powerhour-price-header .powerhour-price small:first-child	',
            ]
        );

        $this->start_controls_tabs('price_currency_tabs');
        $this->start_controls_tab(
            'tabs_Lfkb48DXYs0eBP93241E',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'price_currency_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-header .powerhour-price small:first-child' => 'color: {{VALUE}};',
                ],

            ]

        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_fmjB3Off9KF4v53WZ8Xh',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'price_currency_hover_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-container:hover .powerhour-price-header .powerhour-price small:first-child,
					 {{WRAPPER}} .powerhour-price-container.active .powerhour-price-header .powerhour-price small:first-child' => 'color: {{VALUE}};',
                ],

            ]

        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'price_currency_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container .powerhour-price-header .powerhour-price small:first-child' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'price_currency_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container .powerhour-price-header .powerhour-price small:first-child' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        /*Currency End*/

        /*Price Start*/

        $this->add_control(
            'section_YxSwfrRT69442bCp',
            [
                'label' => __('Price', 'iqonic-extension'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_text_typography',
                'label' => __('Price Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-price-header .powerhour-price',
            ]
        );

        $this->start_controls_tabs('price_text_tabs');
        $this->start_controls_tab(
            'tabs_FqDe9pYKt6UXJnGh82d2',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'price_text_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-header .powerhour-price' => 'color: {{VALUE}};',
                ],

            ]

        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_B2b426p9P3hRJ8sxrUTO',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'price_text_hover_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-container:hover .powerhour-price-header .powerhour-price,
					 {{WRAPPER}} .powerhour-price-container.active .powerhour-price-header .powerhour-price' => 'color: {{VALUE}};',
                ],

            ]

        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'price_text_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container .powerhour-price-header .powerhour-price' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'price_text_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container .powerhour-price-header .powerhour-price' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        /*Price End*/
       
        /*Icon Icon start*/
        $this->add_control(
            'section_285gUPrCuoL6e62Mhf7m',
            [
                'label' => __('Icon Box Icon', 'iqonic-extension'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->start_controls_tabs('Iconbox_icon_tabs');
        $this->start_controls_tab(
            'tabs_jeBef2kCfHObvih40638',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-table-1 .box-img i,{{WRAPPER}} .powerhour-price-table-1 .box-img svg,{{WRAPPER}}  .powerhour-price-table-1 .box-img svg path' => 'fill: {{VALUE}}; color: {{VALUE}};'
                ],

            ]

        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_aJ0C3kdUL5G4tW12awyR',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-container:hover .box-img i,{{WRAPPER}} .powerhour-price-container:hover .box-img svg,{{WRAPPER}} .powerhour-price-container:hover .box-img svg path,{{WRAPPER}} .powerhour-price-container.active .box-img i,{{WRAPPER}} .powerhour-price-container.active .box-img svg path' => 'fill:{{VALUE}}; color: {{VALUE}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        /*Title Start*/

        $this->add_control(
            'section_TnSdjH5Zb7wEm8sxQVuG',
            [
                'label' => __('Title', 'iqonic-extension'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'price_title_text_typography',
                'label' => __('Title Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-price-table-1 .powerhour-inner-box .powerhour-price-label',
            ]
        );



        $this->start_controls_tabs('price_title_tabs');
        $this->start_controls_tab(
            'tabs_09OPJST046UeIAYb1Kba',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'price_title_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1 .powerhour-inner-box .powerhour-price-label' => 'color: {{VALUE}};',
                ],

            ]

        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'price_title_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-price-table-1 .powerhour-inner-box .powerhour-price-label',
            ]
        );

        $this->add_control(
            'price_title_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'price_title_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'condition' => [
                    'price_title_has_border' => 'yes',
                ],
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-table-1 .powerhour-inner-box .powerhour-price-label' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'price_title_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'price_title_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-table-1 .powerhour-inner-box .powerhour-price-label' => 'border-color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-price-container .powerhour-price-header .powerhour-price-label:before' => 'border-top-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'price_title_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'price_title_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-table-1 .powerhour-inner-box .powerhour-price-label' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'price_title_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'price_title_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-table-1 .powerhour-inner-box .powerhour-price-label' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_cT0eg16qd070xv7muc2b',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'price_title_hover_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1.active .powerhour-inner-box .powerhour-price-label,
					 {{WRAPPER}}  .powerhour-price-table-1:hover .powerhour-inner-box .powerhour-price-label' => 'color: {{VALUE}};',
                ],

            ]

        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'price_title_hover_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-price-table-1.active .powerhour-inner-box .powerhour-price-label,
					 {{WRAPPER}}  .powerhour-price-table-1:hover .powerhour-inner-box .powerhour-price-label',
            ]
        );
        $this->add_control(
            'price_title_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'price_title_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'condition' => [
                    'price_title_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1.active .powerhour-inner-box .powerhour-price-label,
					 {{WRAPPER}}  .powerhour-price-table-1:hover .powerhour-inner-box .powerhour-price-label' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'price_title_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'price_title_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1.active .powerhour-inner-box .powerhour-price-label,
					 {{WRAPPER}}  .powerhour-price-table-1:hover .powerhour-inner-box .powerhour-price-label' => 'border-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'price_title_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'price_title_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1.active .powerhour-inner-box .powerhour-price-label,
					 {{WRAPPER}}  .powerhour-price-table-1:hover .powerhour-inner-box .powerhour-price-label' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'price_title_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'price_title_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1.active .powerhour-inner-box .powerhour-price-label,
					 {{WRAPPER}}  .powerhour-price-table-1:hover .powerhour-inner-box .powerhour-price-label' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->add_responsive_control(
            'price_title_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1 .powerhour-inner-box .powerhour-price-label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'price_title_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1 .powerhour-inner-box .powerhour-price-label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        /*Title End*/


     

        /*Header Backgrund Start*/

        $this->add_control(
            'section_O75inm3q9CVk7962gh96',
            [
                'label' => __('Pricing Header Background', 'iqonic-extension'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );
        $this->start_controls_tabs('price_header_tabs');
        $this->start_controls_tab(
            'tabs_5D6V6NS96w3QI6bdMU23',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'price_header_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-price-container .powerhour-price-header',
            ]
        );

        $this->add_control(
            'price_header_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'price_header_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'condition' => [
                    'price_header_has_border' => 'yes',
                ],
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1 .powerhour-main-price-box .powerhour-price-header,
					 {{WRAPPER}}  .powerhour-price-table-1 .powerhour-main-price-box .powerhour-price-header' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'price_header_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'price_header_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1 .powerhour-main-price-box .powerhour-price-header,
					 {{WRAPPER}}  .powerhour-price-table-1 .powerhour-main-price-box .powerhour-price-header' => 'border-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'price_header_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'price_header_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1 .powerhour-main-price-box .powerhour-price-header,
					 {{WRAPPER}}  .powerhour-price-table-1 .powerhour-main-price-box .powerhour-price-header' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'price_header_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'price_header_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1 .powerhour-main-price-box .powerhour-price-header,
					 {{WRAPPER}}  .powerhour-price-table-1 .powerhour-main-price-box .powerhour-price-header' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_rH655IP80scfKQz9Wnq6',
            [
                'label' => __('Active', 'iqonic-extension'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'price_header_hover_background',
                'label' => __('Hover Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-outerbox.powerhour-price-table-1:hover .powerhour-main-price-box .powerhour-price-header',
            ]
        );
        $this->add_control(
            'price_header_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'price_header_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'condition' => [
                    'price_header_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1.active .powerhour-main-price-box .powerhour-price-header,
					 {{WRAPPER}}  .powerhour-price-table-1:hover .powerhour-main-price-box .powerhour-price-header' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'price_header_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'price_header_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1.active .powerhour-main-price-box .powerhour-price-header,
					 {{WRAPPER}}  .powerhour-price-table-1:hover .powerhour-main-price-box .powerhour-price-header' => 'border-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'price_header_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'price_header_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1.active .powerhour-main-price-box .powerhour-price-header,
					 {{WRAPPER}}  .powerhour-price-table-1:hover .powerhour-main-price-box .powerhour-price-header' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'price_header_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'price_header_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-table-1.active .powerhour-main-price-box .powerhour-price-header,
					 {{WRAPPER}}  .powerhour-price-table-1:hover .powerhour-main-price-box .powerhour-price-header' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'price_header_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container .powerhour-price-header' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'price_header_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container .powerhour-price-header' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_section();

        /* Price Header End*/


        /*Pricing List Start*/

        /* Price Body Start*/

        $this->start_controls_section(
            'section_Odd5qY6t9Lnb095371uS',
            [
                'label' => __('Price Body', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['pricing_style' => 'style1']
            ]
        );
        $this->add_control(
            'section_95xiZHF76mKJ1bE9dS6u',
            [
                'label' => __('Pricing list', 'iqonic-extension'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'priceing_list_text_typography',
                'label' => __('Pricing List Content Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-price-container .powerhour-price-body ul li',
            ]
        );

        $this->start_controls_tabs('priceing_list_tabs');
        $this->start_controls_tab(
            'tabs_jwryR96oG27O78J6HT8b',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'priceing_active_list_color',
            [
                'label' => __('Active Icon Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-body ul li .active' => 'color: {{VALUE}};',
                ],

            ]

        );

        $this->add_control(
            'priceing_inactive_list_color',
            [
                'label' => __('Inactive Icon Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container .powerhour-price-body ul li.inactive i,{{WRAPPER}}  .powerhour-price-container .powerhour-price-body ul li.inactive svg' => 'color: {{VALUE}};',
                ],

            ]

        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_85j6g91EM579Gcdx6T6b',
            [
                'label' => __('Active', 'iqonic-extension'),
            ]
        );
        

        $this->add_control(
            'priceing_active_list_hover_color',
            [
                'label' => __('Active Icon Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-price-body:hover ul li .active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'priceing_inactive_list_hover_color',
            [
                'label' => __('Inactive Icon Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container:hover .powerhour-price-body ul li.inactive i,{{WRAPPER}}  .powerhour-price-container.active .powerhour-price-body ul li.inactive svg' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'priceing_list_padding',
            [
                'label' => __('Pricing List Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container .powerhour-price-body ul li ' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'priceing_list_margin',
            [
                'label' => __('Pricing List Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-price-container .powerhour-price-body ul li ' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );


        $this->end_controls_section();

        /* Price Body End*/

    }

    protected function render()
    {
        $settings = $this->get_settings();
        require 'render.php';
    }

    public function get_currency_symbol()
    {
        return $currency_symbols = [
            'none' => '', // ?
            'AED' => '&#1583;.&#1573;', // ?
            'AFN' => '&#65;&#102;',
            'ALL' => '&#76;&#101;&#107;',
            'ANG' => '&#402;',
            'AOA' => '&#75;&#122;', // ?
            'ARS' => '&#36;',
            'AUD' => '&#36;',
            'AWG' => '&#402;',
            'AZN' => '&#1084;&#1072;&#1085;',
            'BAM' => '&#75;&#77;',
            'BBD' => '&#36;',
            'BDT' => '&#2547;', // ?
            'BGN' => '&#1083;&#1074;',
            'BHD' => '.&#1583;.&#1576;', // ?
            'BIF' => '&#70;&#66;&#117;', // ?
            'BMD' => '&#36;',
            'BND' => '&#36;',
            'BOB' => '&#36;&#98;',
            'BRL' => '&#82;&#36;',
            'BSD' => '&#36;',
            'BTN' => '&#78;&#117;&#46;', // ?
            'BWP' => '&#80;',
            'BYR' => '&#112;&#46;',
            'BZD' => '&#66;&#90;&#36;',
            'CAD' => '&#36;',
            'CDF' => '&#70;&#67;',
            'CHF' => '&#67;&#72;&#70;',

            'CLP' => '&#36;',
            'CNY' => '&#165;',
            'COP' => '&#36;',
            'CRC' => '&#8353;',
            'CUP' => '&#8396;',
            'CVE' => '&#36;', // ?
            'CZK' => '&#75;&#269;',
            'DJF' => '&#70;&#100;&#106;', // ?
            'DKK' => '&#107;&#114;',
            'DOP' => '&#82;&#68;&#36;',
            'DZD' => '&#1583;&#1580;', // ?
            'EGP' => '&#163;',
            'ETB' => '&#66;&#114;',
            'EUR' => '&#8364;',
            'FJD' => '&#36;',
            'FKP' => '&#163;',
            'GBP' => '&#163;',
            'GEL' => '&#4314;', // ?
            'GHS' => '&#162;',
            'GIP' => '&#163;',
            'GMD' => '&#68;', // ?
            'GNF' => '&#70;&#71;', // ?
            'GTQ' => '&#81;',
            'GYD' => '&#36;',
            'HKD' => '&#36;',
            'HNL' => '&#76;',
            'HRK' => '&#107;&#110;',
            'HTG' => '&#71;', // ?
            'HUF' => '&#70;&#116;',
            'IDR' => '&#82;&#112;',
            'ILS' => '&#8362;',
            'INR' => '&#8377;',
            'IQD' => '&#1593;.&#1583;', // ?
            'IRR' => '&#65020;',
            'ISK' => '&#107;&#114;',
            'JEP' => '&#163;',
            'JMD' => '&#74;&#36;',
            'JOD' => '&#74;&#68;', // ?
            'JPY' => '&#165;',
            'KES' => '&#75;&#83;&#104;', // ?
            'KGS' => '&#1083;&#1074;',
            'KHR' => '&#6107;',
            'KMF' => '&#67;&#70;', // ?
            'KPW' => '&#8361;',
            'KRW' => '&#8361;',
            'KWD' => '&#1583;.&#1603;', // ?
            'KYD' => '&#36;',
            'KZT' => '&#1083;&#1074;',
            'LAK' => '&#8365;',
            'LBP' => '&#163;',
            'LKR' => '&#8360;',
            'LRD' => '&#36;',
            'LSL' => '&#76;', // ?
            'LTL' => '&#76;&#116;',
            'LVL' => '&#76;&#115;',
            'LYD' => '&#1604;.&#1583;', // ?
            'MAD' => '&#1583;.&#1605;.', //?
            'MDL' => '&#76;',
            'MGA' => '&#65;&#114;', // ?
            'MKD' => '&#1076;&#1077;&#1085;',
            'MMK' => '&#75;',
            'MNT' => '&#8366;',
            'MOP' => '&#77;&#79;&#80;&#36;', // ?
            'MRO' => '&#85;&#77;', // ?
            'MUR' => '&#8360;', // ?
            'MVR' => '.&#1923;', // ?
            'MWK' => '&#77;&#75;',
            'MXN' => '&#36;',
            'MYR' => '&#82;&#77;',
            'MZN' => '&#77;&#84;',
            'NAD' => '&#36;',
            'NGN' => '&#8358;',
            'NIO' => '&#67;&#36;',
            'NOK' => '&#107;&#114;',
            'NPR' => '&#8360;',
            'NZD' => '&#36;',
            'OMR' => '&#65020;',
            'PAB' => '&#66;&#47;&#46;',
            'PEN' => '&#83;&#47;&#46;',
            'PGK' => '&#75;', // ?
            'PHP' => '&#8369;',
            'PKR' => '&#8360;',
            'PLN' => '&#122;&#322;',
            'PYG' => '&#71;&#115;',
            'QAR' => '&#65020;',
            'RON' => '&#108;&#101;&#105;',
            'RSD' => '&#1044;&#1080;&#1085;&#46;',
            'RUB' => '&#1088;&#1091;&#1073;',
            'RWF' => '&#1585;.&#1587;',
            'SAR' => '&#65020;',
            'SBD' => '&#36;',
            'SCR' => '&#8360;',
            'SDG' => '&#163;', // ?
            'SEK' => '&#107;&#114;',
            'SGD' => '&#36;',
            'SHP' => '&#163;',
            'SLL' => '&#76;&#101;', // ?
            'SOS' => '&#83;',
            'SRD' => '&#36;',
            'STD' => '&#68;&#98;', // ?
            'SVC' => '&#36;',
            'SYP' => '&#163;',
            'SZL' => '&#76;', // ?
            'THB' => '&#3647;',
            'TJS' => '&#84;&#74;&#83;', // ? TJS (guess)
            'TMT' => '&#109;',
            'TND' => '&#1583;.&#1578;',
            'TOP' => '&#84;&#36;',
            'TRY' => '&#8356;', // New Turkey Lira (old symbol used)
            'TTD' => '&#36;',
            'TWD' => '&#78;&#84;&#36;',
            'UAH' => '&#8372;',
            'UGX' => '&#85;&#83;&#104;',
            'USD' => '&#36;',
            'UYU' => '&#36;&#85;',
            'UZS' => '&#1083;&#1074;',
            'VEF' => '&#66;&#115;',
            'VND' => '&#8363;',
            'VUV' => '&#86;&#84;',
            'WST' => '&#87;&#83;&#36;',
            'XAF' => '&#70;&#67;&#70;&#65;',
            'XCD' => '&#36;',
            'XPF' => '&#70;',
            'YER' => '&#65020;',
            'ZAR' => '&#82;',
            'ZMK' => '&#90;&#75;', // ?
            'ZWL' => '&#90;&#36;',
        ];
    }
}
