<?php

namespace Elementor;

use WP_Query;

if (!defined('ABSPATH')) exit;
$settings = $this->get_settings_for_display();

$paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
$i = 0;

$cat = '';
if (isset($settings['portfolio_cat']) && !empty($settings['portfolio_cat'])) {
    $cat = implode(',', $settings['portfolio_cat']);
}

$args = array(
    'post_type'         => 'portfolio',
    'post_status'       => 'publish',
    'paged'             => $paged,
    'category_name'     => $cat,
    'order'             => $settings['order'],
    'suppress_filters'  => 0,
    'posts_per_page'    => $settings['posts_per_page']
);

$align = $settings['align'] ?? '';
$align .= ' powerhour-portfolio-item';
global $post;
$horizontal_order = 'false';
?>

        <div class="grid-sizer"></div>
        <?php
        $wp_query = new \WP_Query($args);
        ?>

        <div class=" <?php echo esc_attr(trim($align), 'iqonic-extension') ?>">
            <?php

            echo '<div class="row load-with-ajax">';
            if ($settings['portfolio_style'] === "1") {
                $col = 'col-lg-12';
            }
            if ($settings['portfolio_style'] === "2") {
                $col = 'col-lg-6 col-md-6 ';
            }
            if ($settings['portfolio_style'] === "3") {
                $col = 'col-lg-4 col-md-6';
            }
            if($settings['portfolio_style'] === "4")
            {
                $col = 'col-lg-3 col-md-6';		
            }

            if ($wp_query->have_posts()) {
                while ($wp_query->have_posts()) {
                    $wp_query->the_post();
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id($wp_query->ID), "full"); ?>
                    <div class="<?php echo esc_attr($col); ?>">
                        <div class="powerhour-portfolio-box">
                            <?php if (has_post_thumbnail()) {
                                    echo sprintf('<img class="portfolio-image" src="%1$s" alt="iqonic-portfolio"/>', esc_url($full_image[0], 'iqonic-extension'));
                                    ?>
                            <?php } ?>

                            <div class="powerhour-portfolio-overlay">
                                <div class="portfolio-content">
                                    <div class="portfolio-meta">
                                        <span class="iqonic-portfolio-author-name">
                                            <?php
                                            echo '- ';
                                            the_author();
                                            ?>
                                        </span>

                                        <<?php echo esc_attr($settings['title_tag']) ?> class="iqonic-portfolio-name">
                                                <?php echo sprintf("%s", esc_html__(get_the_title($wp_query->ID), 'iqonic-extension')); ?>
                                            </a>
                                        </<?php echo esc_attr($settings['title_tag']) ?>>
                                    </div>
                                    <?php

                                    //button
                                    if (!empty($settings['button_text'])) { ?>
                                        <a href="<?php echo get_the_permalink(); ?>"> <?php 
                                            require  IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/iqonic-blog-btn-render-control.php'; ?>
                                        </a> 
                                        <?php } ?>
                                </div>
                            </div>
                        </div>
                    </div>
        <?php
                }
            }
            wp_reset_postdata(); 
            echo '</div>'; ?>
        </div>
<?php

    $total_pages = $wp_query->max_num_pages;
    if ($total_pages > 1) {
        $current_page = max(1, get_query_var('paged'));
        if ($settings['pagination_type'] === 'pagination') :
            echo paginate_links(array(
                'base' => get_pagenum_link(1) . '%_%',
                'format' => '/page/%#%',
                'current' => $current_page,
                'total' => $total_pages,
                'type'            => 'list',
                'prev_text'       => '<i class="fas fa-chevron-left"></i>',
                'next_text'       => '<i class="fas fa-chevron-right"></i>',
            ));
        endif;

        if ($settings['pagination_type'] === 'loadmore') : ?>
            <?php
            $portfolio_per_page_static = '';
            $max_page = $wp_query->max_num_pages;
            ?>

            <div class="loadmore-container text-center">
                <div class="portfolio-load-btn">
                    <div class="powerhour-button-container">
                        <a class="powerhour-box-shadow powerhour-button">
                            <span class="btn__text text-btn">
                                <?php echo !empty($settings['loadmore_text']) ? esc_html($settings['loadmore_text']) : '' ?>
                            </span>
                        </a>
                    </div>
                </div>
                <input type="hidden" value="<?php echo str_replace("\"", "'", json_encode($settings)); ?>" name="title"
                    class="portfolio-settings">
                <input type="hidden" value="<?php echo $col; ?>" name="col" class="portfolio-col">
                <input type="hidden" value="<?php echo $max_page; ?>" name="max_page" class="portfolio-max-page">
                <input type="hidden" value="<?php echo $settings['posts_per_page']; ?>" name="portfolio_per_page" class="portfolio-per-page">
                <input type="hidden" value="<?php echo $settings['posts_per_load']; ?>" name="portfolio_per_load" class="portfolio-per-load">
            </div>
           <?php 
        endif;
    }
