<?php

namespace Iqonic\Elementor\Elements\PortfolioGrid;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) exit;

class widget extends Widget_Base {
    public function get_name()
    {
        return __('iqonic_portfolio_grid','iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Portfolio Grid','iqonic-extension');
    }

    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-posts-grid';
    }

    protected function register_controls() {

        $this-> start_controls_section(
            'section_style' ,[
                'label' => __('Style','iqonic-extension')
            ]
        );

        $this-> add_control(
            'portfolio_style' , [
                'label' => __('Grid Columns', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => __('1 Column','iqonic-extension'),
                    '2' => __('2 Column','iqonic-extension'),
                    '3' => __('3 Column','iqonic-extension'),
                    '4' => __('4 Column','iqonic-extension'),
                ],
                'default' => '3'
            ]
        );

        $this->add_control(
            'title_tag',[
                'label' => __('Title Tag','iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => __('h1','iqonic-extension'),
                    'h2' => __('h2','iqonic-extension'),
                    'h3' => __('h3','iqonic-extension'),
                    'h4' => __('h4','iqonic-extension'),
                    'h5' => __('h5','iqonic-extension'),
                    'h6' => __('h6','iqonic-extension'),
                ],
                'default' => 'h4'
            ] 
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'iqonic-extension'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => __('Justified', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-meta' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_post_control',
            [
                'label' => __('Post Control', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'portfolio_cat',
            [
                'label' => esc_html__('Category', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT2,
                'return_value' => 'true',
                'multiple' => true,
                'options' => iqonic_get_taxonomies('portfolio_categories','slug'),
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label'     => __('Posts Per Page', 'iqonic-extension'),
                'type'         => Controls_Manager::NUMBER,
                'label_block'    => false,
                'min'         => -1,
                'max'         => 100,
                'step'         => 1,
                'default'     => 3,
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('Order By', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'DESC' => __('Descending', 'iqonic-extension'),
                    'ASC' => __('Ascending', 'iqonic-extension')
                ],

            ]
        );

        $this->add_control(
            'pagination_type',
            [
                'label' => __('Pagination Type', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'loadmore',
                'options' => [
                    'pagination'    => __('Pagination', 'iqonic-extension'),
                    'loadmore'      => __('Loadmore', 'iqonic-extension'),
                    'none'          => __('none', 'iqonic-extension')
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'posts_per_page',
                            'operator' => '>',
                            'value' => '0'
                        ],
                    ]
                ]
            ]
        );

        $this->end_controls_section();

         //loadmore
         $this->start_controls_section(
            'section_loadmore_control',
            [
                'label' => __('Load More Options', 'iqonic-extension'),
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'posts_per_page',
                            'operator' => '>',
                            'value' => '0'
                        ],
                    ]
                ]
            ]
        );

        $this->add_control(
            'loadmore_text',
            [
                'label' => __('Loadmore button text', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('Load More', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'posts_per_load',
            [
                'label'     => __('Posts per load', 'iqonic-extension'),
                'type'         => Controls_Manager::NUMBER,
                'label_block'    => false,
                'min'         => 1,
                'max'         => 10,
                'step'         => 1,
                'default'     => 3,
            ]
        );
        $this->end_controls_section();
        
         //image
         $this->start_controls_section(
            'section_c2ZGc6820sJa02vsM2Arx',
            [
                'label' => __('Image', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'image_background_color',
            [
                'name' => 'portfolio_image_background',
                'label' => __('Background Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [    
                    '{{WRAPPER}} .powerhour-portfolio-item .powerhour-portfolio-box .powerhour-portfolio-overlay' => 'background : {{VALUE}}'
                ]
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .portfolio-image' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .portfolio-image' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'box_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'     => __('Solid', 'iqonic-extension'),
                    'dashed'    => __('Dashed', 'iqonic-extension'),
                    'dotted'    => __('Dotted', 'iqonic-extension'),
                    'double'    => __('Double', 'iqonic-extension'),
                    'outset'    => __('outset', 'iqonic-extension'),
                    'groove'    => __('groove', 'iqonic-extension'),
                    'ridge'     => __('Ridge', 'iqonic-extension'),
                    'inset'     => __('Inset', 'iqonic-extension'),
                    'none'      => __('None', 'iqonic-extension'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-image' => 'border-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'box_border_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-portfolio-box .portfolio-image' => 'border-color: {{VALUE}};',
                ],
                'condition' => ['box_border_style!' => 'none']
            ]
        );

        $this->add_control(
            'box_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-image' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['box_border_style!' => 'none']
            ]
        );

        $this->add_control(
            'box_border_radius',
            [
                'label' => __('Border radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-image' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['box_border_style!' => 'none']
            ]
        );

        $this->end_controls_section();

        //meta
        $this->start_controls_section(
            'section_meta', [
                'label' => __('Meta','iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'meta_typography',
                'label' => __('Typography','iqonic-extension'),
                'selector' => '{{WRAPPER}} .iqonic-portfolio-author-name'
            ]
        );

        $this->add_responsive_control(
            'meta_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .iqonic-portfolio-author-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'meta_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .iqonic-portfolio-author-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('meta_tab');
        $this->start_controls_tab('meta_normal', [
            'label' => __('Normal','iqonic-extension')
        ]);

        $this->add_control(
            'meta_normal_color',
            [
                'label'     => __('Choose Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-content .iqonic-portfolio-author-name' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'portfolio_meta_normal_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .portfolio-content .iqonic-portfolio-author-name',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('meta_hover', [
            'label' => __('Hover','iqonic-extension')
        ]);

        $this->add_control(
            'meta_hover_color',
            [
                'label'     => __('Choose Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .iqonic-portfolio-author-name:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'portfolio_meta_hover_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .iqonic-portfolio-author-name:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        //title
        $this->start_controls_section(
            'section_title', [
                'label' => __('Title','iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'label' => __('Typography','iqonic-extension'),
                'selector' => '{{WRAPPER}} .iqonic-portfolio-name'
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .iqonic-portfolio-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .iqonic-portfolio-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        

        $this->start_controls_tabs('title_tab');
        $this->start_controls_tab('title_normal', [
            'label' => __('Normal','iqonic-extension')
        ]);

        $this->add_control(
            'title_normal_color',
            [
                'label'     => __('Choose Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-content .iqonic-portfolio-name' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'portfolio_title_normal_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .portfolio-content .iqonic-portfolio-name',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab('title_hover', [
            'label' => __('Hover','iqonic-extension')
        ]);

        $this->add_control(
            'title_hover_color',
            [
                'label'     => __('Choose Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .portfolio-content .iqonic-portfolio-name:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'portfolio_title_hover_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .portfolio-content .iqonic-portfolio-name:hover',
            ]
        );

        $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->end_controls_section();

        //button control
        
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/iqonic-blog-btn-controls.php';

    }

    protected function render() {
        require 'render.php';
        if (Plugin::$instance->editor->is_edit_mode()) { ?>
            <script>
                (function(jQuery) {
                    callGrid();
                })(jQuery);
            </script>
        <?php }
    }
}
?>