<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;
$settings = $this->get_settings_for_display();
$settings = $this->get_settings();

$paged = (get_query_var('paged')) ? get_query_var('paged') : -1;
$i = 0;

$args = array(
    'post_type'         => 'portfolio',
    'post_status'       => 'publish',
    'paged'             => $paged,
    'suppress_filters'  => 0,
    'posts_per_page'    => isset($settings['posts_per_page']) ? $settings['posts_per_page'] : -1
);

$powerhour_class = '';
$this->add_render_attribute('powerhour-section', 'class', 'powerhour-title-box');
$this->add_render_attribute('powerhour-section', 'class', 'powerhour-title-box-1');
$cat = '';

if (isset($settings['port_cat']) && !empty($settings['port_cat'])) {
    $cat = $settings['port_cat'];
}


$this->add_render_attribute('powerhour-section', 'class', 'iqonic-masonry-block iqonic-metro-block ');

if($settings['show_masonryjoined'] == 'yes'){
    $this->add_render_attribute('powerhour-section', 'class', 'masonry-joined');
} else {
    $this->add_render_attribute('powerhour-section', 'class', 'masonry-block');
}

if (!empty($cat)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'portfolio_categories',
            'field'    => 'slug',
            'terms'    => $cat,
        ),
    );
}

if (!empty($settings['post_view_type_order']) && $settings['post_view_type_order'] !== 'none') {
    if ($settings['post_view_type_order'] === 'latest') {
        $args['orderby'] = 'publish_date';
        $args['order'] = 'DESC';
    }
}

if (!empty($settings['order']) && $settings['post_view_type_order'] !== 'latest') {
    $args['order'] = $settings['order'];
}

$image_html = '';
if (isset($settings['image']['url']) && !empty($settings['image']['url'])) {
    $this->add_render_attribute('image', 'src', $settings['image']['url']);
    $this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($settings['image']));
    $this->add_render_attribute('image', 'title', Control_Media::get_image_title($settings['image']));
    $image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
}

$horizontal_order = 'false';
$gutter = '0';
    $powerhour_class = 'masonry';
?>

<div <?php echo $this->get_render_attribute_string('powerhour-section'); ?>>
<div class="iqonic-masonry-block iqonic-metro-block">
    <div class="iqonic-masonry-grid <?php echo $powerhour_class; ?>" data-horizontal-order="<?php echo esc_attr($horizontal_order); ?>" data-gutter=<?php echo esc_attr($gutter); ?>>
        <div class="grid-sizer"></div>
        <?php
        $wp_query  = new \WP_Query($args);
        if ($wp_query->have_posts()) {
            $masonary_counter = 1;

            while ($wp_query->have_posts()) {

                $wp_query->the_post();

                if ($masonary_counter === 2 || $masonary_counter === 7) {
                    $iqonic_grid = "iqonic-masonry-item s-25 square";
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "power-hour-square");
                } else {
                    $iqonic_grid = "iqonic-masonry-item s-25 portrait";
                    $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "power-hour-portrait");
                }
        
                $image_url = '';
                if (!empty($full_image[0])) {
                    $image_url = $full_image[0];
                }
                ?>
                <div class="iqonic-masonry-item s-25 square">
                    <div class="iqonic-portfolio-box">
                        <?php if (!empty($image_url)) : ?>
                            <img class="portfolio-image" src="<?php echo esc_url($image_url); ?>" alt="image" />
                        <?php endif; ?>
                        <div class="iqonic-port-overlay">
                            <div class="portfolio-content">
                                <?php
                                if (!empty($image_html)) {
                                    echo $image_html;
                                }
                                ?>
                                <span class="meta">
                                    <?php
                                    echo '- ';
                                    the_author();
                                    ?>
                                </span>
                                    <<?php echo esc_attr($settings['title_size']); ?> class="iqonic-port-name">
                                        <?php echo sprintf("%s", esc_html__(get_the_title($wp_query->ID), 'iqonic-extension')); ?>
                                    </<?php echo esc_attr($settings['title_size']); ?>>
                                <?php
                                //button
                                if ($settings['use_button'] == 'yes') { ?>
                                    <a href="<?php echo get_the_permalink(); ?>"> <?php 
                                        require  IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/iqonic-blog-btn-render-control.php'; ?>
                                    </a> 
                                    <?php } ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
               
               if ($masonary_counter === 7) {
                $masonary_counter = 1;
            } else {
                $masonary_counter++;
            }
            }
        }
        wp_reset_postdata();
        ?>
    </div>
</div>
</div>
<?php

if ($settings['pagination'] == 'yes') {
    $total_pages = $wp_query->max_num_pages;

    if ($total_pages > 1) {
        $current_page = max(1, get_query_var('paged'));
        echo paginate_links(array(
            'base' => get_pagenum_link(1) . '%_%',
            'format' => '/page/%#%',
            'current' => $current_page,
            'total' => $total_pages,
            'type'            => 'list',
            'prev_text'       => '<i class="fas fa-chevron-left"></i>',
            'next_text'       => '<i class="fas fa-chevron-right"></i>',
        ));
    }
}

?>