<?php

namespace Iqonic\Elementor\Elements\Portfolio;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base 
{
    public function get_name()
    {
        return __('iqonic_portfolio', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Portfolio','iqonic-extension');
    }

    public function get_categories()
    {
        return ['iqonic-extension'];
    }
    public function get_icon()
    {
        return 'eicon-gallery-masonry';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_portfolio',
            [
                'label' => __('Portfolio', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'port_cat',
            [
                'label' => __('Select Category', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT2,
                'return_value' => 'true',
                'multiple' => true,
                'options' => iqonic_get_taxonomies('portfolio_categories', 'slug'),
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label'     => __('Post per page', 'iqonic-extension'),
                'type'         => Controls_Manager::NUMBER,
                'label_block'    => false,
                'min'         => -1,
                'max'         => 100,
                'step'         => 1,
                'default'     => 9,
            ]
        );

        $this->add_control(
            'pagination',
            [
                'label' => __('Show Pagination', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'no',
                'options' => [
                    'yes' => esc_html__('Yes', 'iqonic-extension'),
                    'no' => esc_html__('No', 'iqonic-extension')
                ],
                'conditions' => [
                    'terms' => [
                        [
                            'name' => 'posts_per_page',
                            'operator' => '>',
                            'value' => '0'
                        ],
                    ]
                ]
            ]
        );

        $this->add_control(
            'post_view_type_order',
            [
                'label'   => __('Type', 'iqonic-extension'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none' => esc_html__('None', 'iqonic-extension'),
                    'latest' => esc_html__('Latest', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'order',
            [
                'label' => __('Order By', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'DESC' => esc_html__('Descending', 'iqonic-extension'),
                    'ASC' => esc_html__('Ascending', 'iqonic-extension')
                ],
                'condition' => ['post_view_type_order' => 'none'],
            ]
        );

        $this->add_control(
            'use_button', [
                'label' => __('Use Button','iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'options' => [
                    'label_on' => __('Yes','iqonic-extension'),
                    'label_off' => __('No','iqonic-extension')
                ],
            ]
        );

        $this->add_control(
			'show_masonryjoined',
			[
				'label' => esc_html__( 'Masonry Joined?', 'iqonic-extension' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'iqonic-extension' ),
				'label_off' => esc_html__( 'Hide', 'iqonic-extension' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

        $this->end_controls_section();

        $this->start_controls_section(
            'section_portfolio_title',
            [
                'label' => __('Portfolio Title', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'title_size',
            [
                'label' => __('HTML Tag', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                ],
                'default' => 'h5',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_image_controls',
            [
                'label' => __('Image', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'image_background_color',
            [
                'name' => 'portfolio_image_background',
                'label' => __('Background Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [    
                    '{{WRAPPER}} .iqonic-masonry-block .iqonic-port-overlay, .iqonic-masonry-block .owl-carousel .iqonic-portfolio-box .iqonic-port-overlay' => 'background : {{VALUE}}'
                ]
            ]
        );

        $this->add_control(
            'box_border_style',
            [
                'label' => __('Border Style', '-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'     => __('Solid', '-extension'),
                    'dashed'    => __('Dashed', '-extension'),
                    'dotted'    => __('Dotted', '-extension'),
                    'double'    => __('Double', '-extension'),
                    'outset'    => __('outset', '-extension'),
                    'groove'    => __('groove', '-extension'),
                    'ridge'     => __('Ridge', '-extension'),
                    'inset'     => __('Inset', '-extension'),
                    'none'      => __('None', '-extension'),
                ],
                'selectors' => [
                    '{{WRAPPER}} .iqonic-portfolio-box' => 'border-style: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'box_border_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .iqonic-portfolio-box' => 'border-color: {{VALUE}};',
                ],
                'condition' => ['box_border_style!' => 'none']
            ]
        );

        $this->add_control(
            'box_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .iqonic-portfolio-box' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['box_border_style!' => 'none']
            ]
        );

        $this->add_control(
            'box_border_radius',
            [
                'label' => __('Border radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .iqonic-portfolio-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['box_border_style!' => 'none']
            ]
        );

        $this->add_responsive_control(
            'box_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .iqonic-portfolio-box' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'box_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .iqonic-portfolio-box' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_meta_conrols',
            [
                'label' => __('Meta','iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'portfolio_meta_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .meta',
            ]
        );

        $this->add_responsive_control(
            'meta_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .meta' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'meta_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .meta' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
        
            ]
        );

        $this->start_controls_tabs('portfolio_meta_tabs');

        $this->start_controls_tab(
            'portfolio_meta_normal',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'portfolio_meta_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .meta' => 'color: {{VALUE}};',
                ],


            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'portfolio_meta_normal_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .meta',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'portfolio_meta_hover',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'portfolio_meta_hover_color',
            [
                'label' => __('Hover Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .meta:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'portfolio_meta_hover_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .meta:hover',
            ]
        );
        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();

        
        $this->start_controls_section(
            'section_title_controls',
            [
                'label' => __('Title', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'portfolio_title_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .iqonic-port-name',
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .iqonic-port-name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'title_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .iqonic-port-name' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
        
            ]
        );

        $this->start_controls_tabs('portfolio_tabs');

        $this->start_controls_tab(
            'portfolio_tab_normal',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'portfolio_title_color',
            [
                'label' => __('Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .iqonic-port-name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'portfolio_data_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .iqonic-port-name',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'portfolio_tab_hover',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'portfolio_title_hover_color',
            [
                'label' => __('Hover Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,

                'selectors' => [
                    '{{WRAPPER}} .iqonic-port-name:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'portfolio_title_hover_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .iqonic-port-name:hover',
            ]
        );

        $this->end_controls_tabs();
        $this->end_controls_tabs();

        $this->end_controls_section();

        $this->start_controls_section(
            'section_21eZ2eh1Myn3Vx5qrK29',
            [
                'label' => __('Button', 'iqonic-extension'),
                'condition' => [ 'use_button' => 'yes']
            ]
        );
        
        $this->add_control(
            'is_default_btn',
            [
                'label' => __('Iqonic Button', 'iqonic-extension'),
                'type' => Controls_Manager::HIDDEN,
                'default' => $this->get_name(),

            ]
        );
        
        $this->add_control(
            'button_type',
            [
                'label' => __('Type', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'default',
                'options' => [
                    'default' => __('Default', 'iqonic-extension'),
                    'linked' => __('Linked', 'iqonic-extension'),
                ],
            ]
        );
        
        $this->add_control(
            'button_text',
            [
                'label' => __('Text', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('Read More', 'iqonic-extension'),
        
            ]
        );
        
        $this->add_responsive_control(
            'alignment',
            [
                'label' => __('Alignment', 'iqonic-extension'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => __('Left', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-right',
                    ]
                ],
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
            ]
        );
        $this->end_controls_section();
        
        // Button Text Style
        $this->start_controls_section(
            'section_d1da6dnvYM43C71weL29',
            [
                'label' => __('Button Text', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'use_button' => 'yes']
            ]
        );
        
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'btn_text_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-button .powerhour-text ,{{WRAPPER}} .powerhour-btn-link .text-btn',
            ]
        );
        
        $this->start_controls_tabs('contact_tabs');
        $this->start_controls_tab(
            'tabs_o8I22AKRc2bJa7BgdwHW',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        
        $this->add_control(
            'text_color',
            [
                'label' => __('Choose Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-button .powerhour-text ,{{WRAPPER}} .powerhour-btn-link .text-btn ' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-btn-link:after' => 'background: {{VALUE}};'
                ],
            ]
        );
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'tabs_1322c8M564ER8L6I65U0',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );
        
        $this->add_control(
            'data_hover_text',
            [
                'label' => __('Choose Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-button:hover .powerhour-text ,{{WRAPPER}} .powerhour-btn-link:hover .text-btn ' => 'color: {{VALUE}};',
                ],
            ]
        );
        
        $this->end_controls_tab();
        $this->end_controls_tabs();
        
        $this->end_controls_section();
        // Button Text Style
        
        // Background Style Start
        
        $this->start_controls_section(
            'section_0s6Y4c68qoBcctzHf68f',
            [
                'label' => __('Button Background', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'button_type' => 'default',
                    'use_button' => 'yes'
                ],
            ]
        );
        $this->start_controls_tabs('_dr6Yu5af63L5yHm3cGc1');
        $this->start_controls_tab(
            'tabs_z5VRHMPjDcr6wJb0a4vF',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'data_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-button ',
            ]
        );
        
        $this->end_controls_tab();
        
        $this->start_controls_tab(
            'tabs_Xa27O3BGf5k23KqHfeNM',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'     => 'data_hover',
                'label'    => __('Background', 'iqonic-extension'),
                'types'    => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-button:hover',
            ]
        );
        
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->add_responsive_control(
            'powerhour_button_box_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'powerhour_button_box_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
        
            ]
        );
        
        $this->end_controls_section();
        
        
        $this->start_controls_section(
            'section_iD8bVLQc8q83f4j5cnJk',
            [
                'label' => __('Button Border', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'use_button' => 'yes']
            ]
        );
        
        $this->add_control(
            'has_custom_border',
            [
                'label' => __('Use Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid' => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),
        
                ],
                'condition' => ['has_custom_border' => 'yes'],
        
                'selectors' => [
                    '{{WRAPPER}} .powerhour-button, {{WRAPPER}} .circle-box' => 'border-style: {{VALUE}};',
        
                ],
            ]
        );
        $this->add_control(
            'data_border',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-button, {{WRAPPER}} .circle-box' => 'border-color: {{VALUE}};',
                ],
                'condition' => ['has_custom_border' => 'yes'],
        
            ]
        );
        $this->add_control(
            'data_hover_border_outline',
            [
                'label' => __('Hover Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
        
                'selectors' => [
                    '{{WRAPPER}} .powerhour-button:hover, {{WRAPPER}} .circle-box:hover' => 'border-color: {{VALUE}};',
                ],
                'condition' => ['has_custom_border' => 'yes'],
        
            ]
        );
    
        $this->add_control(
            'border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-button, {{WRAPPER}} .circle-box' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['has_custom_border' => 'yes'],
        
            ]
        );
        
        $this->add_control(
            'border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-button , {{WRAPPER}} .circle-box' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => ['has_custom_border' => 'yes'],
        
            ]
        );
        $this->end_controls_section();

    }

    protected function render()
    {
        require 'render.php';
        if (Plugin::$instance->editor->is_edit_mode()) { ?>
            <script>
                (function(jQuery) {
                    callMasonry();
                })(jQuery);
            </script>
        <?php }
    }
}
?>