<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;
$settings = $this->get_settings();
$paged = (get_query_var('paged')) ? get_query_var('paged') : -1;
$portfolio_type = '';

$args = array(
    'post_type'         => 'portfolio',
    'post_status'       => 'publish',
    'paged'             => $paged,
    'suppress_filters'  => 0,
    'posts_per_page'    => isset($settings['posts_per_page']) ? $settings['posts_per_page'] : -1
);

$powerhour_class = '';

if ($settings['show_masonryjoined'] == 'yes') {
    $powerhour_class .= 'gallery-joined';
} else {
    $powerhour_class .= 'masonry-block';
}
if (isset($settings['port_cat']) && !empty($settings['port_cat'])) {
    $cat = $settings['port_cat'];
}
if (!empty($settings['post_view_type_order']) && $settings['post_view_type_order'] !== 'none') {
    if ($settings['post_view_type_order'] === 'latest') {
        $args['orderby'] = 'publish_date';
        $args['order'] = 'DESC';
    }
}
if (!empty($settings['order']) && $settings['post_view_type_order'] !== 'latest') {
    $args['order'] = $settings['order'];
}

if (!empty($cat)) {
    $args['tax_query'] = array(
        array(
            'taxonomy' => 'portfolio_categories',
            'field'    => 'slug',
            'terms'    => $cat,
        ),
    );
}

//gradient classs
$gradient_class = '';
if ($settings['has_gradient_title'] === "yes") {
    $gradient_class = ' gradient-text-color';
}

$wp_query  = new \WP_Query($args);

if (!empty($settings['design_style'])) {
    $powerhour_class .= ' ' . $settings['design_style'];
    if ($settings['design_style'] == 'style-one') {
        $powerhour_class .= ' swiper-container-3d';
        $this->add_render_attribute('slider', 'data-effect', 'coverflow');
    }
}

if ($settings['design_style'] == "style-four") :

    $array = $settings['grid'];
    $columnClass = explode("--", $array);
    $columnClass = implode(" ", $columnClass); ?>

    <div class="portfolio-container <?php echo esc_attr($powerhour_class); ?>">
        <?php if ($settings['grid'] == 'iq-column') { ?>
            <div class="row iq-grid-five">
        <?php  } else { ?>
            <div class="row">
        <?php } ?> <?php

            if ($wp_query->have_posts()) :
                while ($wp_query->have_posts()) :
                    $wp_query->the_post();
                    $categories = wp_get_post_terms(get_the_ID(), "portfolio_categories"); ?>

                    <div class="<?php echo !empty($columnClass) ? $columnClass : 'col-lg-12' ?>">

                        <?php if ($settings['gird_style'] == "style_1") { ?>

                            <div class="portfolio-grid">
                                <div class="portfolio-img wow">
                                    <div class="portfolio-img-box">
                                        <?php if (has_post_thumbnail()) {
                                            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                                            $image_alt = get_post_meta(get_post_thumbnail_id(get_the_ID()), '_wp_attachment_image_alt', TRUE); ?>
                                            <img src="<?php echo esc_url($full_image[0]); ?>" alt="<?php echo esc_attr($image_alt); ?>">
                                        <?php } ?>
                                    </div><?php
                                    if ($categories) {
                                        foreach ($categories as $category) {
                                            echo "<a href='" . get_term_link($category->term_id) . "'><span class='portfolio-category'>$category->name</span></a>";
                                        }
                                    } ?>
                                </div>
                                <div class="portfolio-detail-main wow">
                                    <div class="portfolio-info-main">
                                        <a href="<?php echo get_permalink(); ?>">
                                            <<?php echo esc_attr($settings['title_size']); ?> class="portfolio-title<?php echo esc_attr($gradient_class); ?>">
                                                <?php echo get_the_title(); ?>
                                            </<?php echo esc_attr($settings['title_size']); ?>>
                                        </a>
                                        <a href="<?php echo get_permalink(); ?>"><svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">  <path d="M18.5775 8.15674V11.4263L0.249262 11.4263V8.15674L18.5775 8.15674Z" fill="currentColor"></path> <path d="M9.84852 16.8491L16.3647 9.79116L9.85067 2.73326L12.2139 0.503418L19.7609 8.67733C20.3431 9.30509 20.3431 10.2794 19.7609 10.9072L12.2139 19.0811L9.84852 16.8491Z" fill="currentColor"></path></svg></a>
                                    </div>
                                </div>
                            </div>

                        <?php } elseif ($settings['gird_style'] == "style_2") { ?>

                            <div class="powerhour-portfolio-style-2 ">
                                <div class="box">

                                    <!-- image start -->
                                    <?php
                                    if (has_post_thumbnail()) {
                                        $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                                        $image_alt = get_post_meta(get_post_thumbnail_id(get_the_ID()), '_wp_attachment_image_alt', TRUE);

                                        if($settings['grid'] == 'col-lg-4--col-md-6--col-xl-2' || $settings['grid'] == 'iq-column'){ ?>
                                            <img src="<?php echo esc_url($full_image[0]); ?>" class="da-image grid-style-image" alt="<?php echo esc_attr($image_alt); ?>">
                                        <?php 
                                        } else { ?>
                                            <img src="<?php echo esc_url($full_image[0]); ?>" class="da-image" alt="<?php echo esc_attr($image_alt); ?>">
                                        <?php 
                                        }

                                        } ?>
                                    <!-- image end -->

                                    <div class="inner">

                                        <!-- category start -->
                                        <?php
                                        if ($categories) {
                                            foreach ($categories as $category) {
                                                echo "<a href='" . get_term_link($category->term_id) . "'><span class='portfolio-category'>$category->name</span></a>";
                                            }
                                        } ?>
                                        <!-- category end -->

                                        <!-- title start -->
                                        <a href="<?php echo get_permalink(); ?>">
                                            <<?php echo esc_attr($settings['title_size']); ?> class="portfolio-title<?php echo esc_attr($gradient_class); ?>">
                                                <?php echo get_the_title(); ?>
                                            </<?php echo esc_attr($settings['title_size']); ?>>
                                        </a>
                                        <!-- title end -->

                                    </div>
                                </div>
                            </div>

                        <?php  } elseif ($settings['gird_style'] == "style_3") { ?>

                            <div class="powerhour-portfolio-style-3 ">
                                <div class="card -img-overlay">
                                    <div class="image-holder">
                                        <!-- image start -->
                                        <?php
                                        if (has_post_thumbnail()) {
                                            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                                            $image_alt = get_post_meta(get_post_thumbnail_id(get_the_ID()), '_wp_attachment_image_alt', TRUE);
                                        ?>
                                            <img src="<?php echo esc_url($full_image[0]); ?>" class="da-image" alt="<?php echo esc_attr($image_alt); ?>">
                                        <?php } ?>
                                        <!-- image end -->
                                    </div>
                                </div>
                                <div class="inner_style3"> 
                                    <!-- title start -->
                                    <a href="<?php echo get_permalink(); ?>">
                                        <<?php echo esc_attr($settings['title_size']); ?> class="portfolio-title<?php echo esc_attr($gradient_class); ?>">
                                            <?php echo get_the_title(); ?>
                                        </<?php echo esc_attr($settings['title_size']); ?>>
                                    </a>
                                    <!-- title end -->
                                    <!-- category start -->
                                    <?php
                                    if ($categories) {
                                        foreach ($categories as $category) {
                                            echo "<a href='" . get_term_link($category->term_id) . "'><span class='portfolio-category'>$category->name</span></a>";
                                        }
                                    } ?>
                                    <!-- category end -->
                                </div>
                            </div>

                        <?php  } ?>
                    </div> <?php
                endwhile;
                wp_reset_postdata();
            endif; ?>
        </div>
    </div> <?php

else :

    $center = ($settings['design_style'] == 'style-three') ? false : true;
    $slides = 'auto';
    $cursor = true;
    $touch_move = true;
    $space_between = 0;
    $has_breakpoint = false;
    if ($settings['design_style'] == 'style-three') {
        $slides = 4;
        $space_between = 30;
        $has_breakpoint = true;
    }

    if ($settings['design_style'] == 'style-two') {
        $cursor = false;
        $touch_move = false;
        $slides = 2;
    }

    $this->add_render_attribute('slider', 'data-style', $settings['design_style']);
    $this->add_render_attribute('slider', 'data-pagination', $settings['slider_pagination']);
    $this->add_render_attribute('slider', 'data-nav', $settings['nav_arrow']);
    $this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);
    $this->add_render_attribute('slider', 'data-autoplay-delay', $settings['autoplay_delay']);
    $this->add_render_attribute('slider', 'data-loop', $settings['loop']);
    $this->add_render_attribute('slider', 'data-center', $center);
    $this->add_render_attribute('slider', 'data-slides', $slides);
    $this->add_render_attribute('slider', 'data-cursor', $cursor);
    $this->add_render_attribute('slider', 'data-space-between', $space_between);
    $this->add_render_attribute('slider', 'data-breakpoint', $has_breakpoint);
    $this->add_render_attribute('slider', 'data-touch-move', $touch_move);
    $this->add_render_attribute('slider', 'data-speed', $settings['speed']); ?>

        
    <div class="portfolio-container swiper <?php echo esc_attr($powerhour_class); ?>" <?php echo $this->get_render_attribute_string('slider') ?>>
        <div class="swiper-wrapper">
            <?php
            if ($wp_query->have_posts()) :
                if ($settings['design_style'] == "style-two" || $settings['design_style'] == "style-three") {
                    while ($wp_query->have_posts()) :
                        $wp_query->the_post();
                        $categories = wp_get_post_terms(get_the_ID(), "portfolio_categories"); ?>

                        <div class="swiper-slide has-animate">
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="portfolio-info-box">
                                        <?php
                                        if (has_post_thumbnail()) {
                                            $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                                            $image_alt = get_post_meta(get_post_thumbnail_id(get_the_ID()), '_wp_attachment_image_alt', TRUE);
                                        ?>
                                            <img src="<?php echo esc_url($full_image[0]); ?>" alt="<?php echo esc_attr($image_alt); ?>">
                                        <?php } ?>

                                        <div class="portfolio-detail-main wow"><?php
                                                                                if ($categories) {
                                                                                    foreach ($categories as $category) {
                                                                                        echo "<a href='" . get_term_link($category->term_id) . "'><span class='portfolio-category'>$category->name</span></a>";
                                                                                    }
                                                                                }
                                                                                ?>
                                            <div class="title">
                                                <a href="<?php echo get_permalink(); ?>">
                                                    <<?php echo esc_attr($settings['title_size']); ?> class="portfolio-title<?php echo esc_attr($gradient_class); ?>">
                                                        <?php echo get_the_title(); ?>
                                                    </<?php echo esc_attr($settings['title_size']); ?>>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                            </div>
                        </div>
                    <?php
                    endwhile;
                } else {
                    while ($wp_query->have_posts()) :
                        $wp_query->the_post();
                        $categories = wp_get_post_terms(get_the_ID(), "portfolio_categories"); ?>
                        
                        <div class="swiper-slide">
                            <div class="row">
                                <div class="col-lg-2"></div>
                                <div class="col-lg-10">
                                    <?php
                                    if (has_post_thumbnail()) {
                                        $full_image = wp_get_attachment_image_src(get_post_thumbnail_id(get_the_ID()), "full");
                                        $image_alt = get_post_meta(get_post_thumbnail_id(get_the_ID()), '_wp_attachment_image_alt', TRUE);
                                    ?>
                                        <img src="<?php echo esc_url($full_image[0]); ?>" alt="<?php echo esc_attr($image_alt); ?>">
                                        <div class="portfolio-detail-main wow">
                                            <a href="<?php echo get_permalink(); ?>">
                                                <<?php echo esc_attr($settings['title_size']); ?> class="portfolio-title<?php echo esc_attr($gradient_class); ?>">
                                                    <?php echo get_the_title(); ?>
                                                </<?php echo esc_attr($settings['title_size']); ?>>
                                            </a><?php
                                                if ($categories) {
                                                    foreach ($categories as $category) {
                                                        echo "<a href='" . get_term_link($category->term_id) . "'><span class='portfolio-category'>$category->name</span></a>";
                                                    }
                                                }
                                                ?>
                                        </div>
                                    <?php } ?>
                                    <div class="row">
                                        <div class="col-lg-8">
                                            <p class="details-box portfolio-excerpt"><?php echo get_the_excerpt(); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div> <?php
                    endwhile;
                }
                wp_reset_postdata();
            endif;
            ?>
        </div>

        <!-- navigation buttons -->
        <?php if ($settings['nav_arrow'] === "true") : ?>
            <div class="iqonic-navigation">
                <div class="swiper-button-prev"><div class="powerhour-leftarrow"><svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg"> <path d="M2.42249 8.15674V11.4263H20.7507V8.15674H2.42249Z" fill="#222222"></path>  <path d="M11.1515 16.8491L4.63528 9.79116L11.1494 2.73326L8.78609 0.503418L1.23916 8.67733C0.656973 9.30509 0.656973 10.2794 1.23916 10.9072L8.78609 19.0811L11.1515 16.8491Z" fill="#222222"></path></svg>
                <div class="circle-box">
                    <div class="sub-circle">
                        <span class="text-btn-line-holder">
                            <span class="text-btn-line-top"></span>
                            <span class="text-btn-line"></span>
                            <span class="text-btn-line-bottom"></span>
                        </span>
                    </div>
                </div></div></div>
                <div class="swiper-button-next"><div class="powerhour-rightarrow"><svg width="21" height="20" viewBox="0 0 21 20" fill="none" xmlns="http://www.w3.org/2000/svg">  <path d="M18.5775 8.15674V11.4263L0.249262 11.4263V8.15674L18.5775 8.15674Z" fill="#222222"></path> <path d="M9.84852 16.8491L16.3647 9.79116L9.85067 2.73326L12.2139 0.503418L19.7609 8.67733C20.3431 9.30509 20.3431 10.2794 19.7609 10.9072L12.2139 19.0811L9.84852 16.8491Z" fill="#222222"></path></svg>
                <div class="circle-box">
                    <div class="sub-circle">
                        <span class="text-btn-line-holder">
                            <span class="text-btn-line-top"></span>
                            <span class="text-btn-line"></span>
                            <span class="text-btn-line-bottom"></span>
                        </span>
                    </div>
                </div></div></div>
            </div>
        <?php endif; ?>

        <!--  pagination -->
        <?php if ($settings['slider_pagination'] === "true") : ?>
            <div class="swiper-pagination"></div>
        <?php endif; ?>

    </div>
<?php endif; ?>