<?php


namespace Iqonic\Elementor\Elements\NewPortfolio;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Typography;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('new_iqonic_portfolio', 'iqonic');
    }


    public function get_title()
    {
        return __('New Portfolio', 'iqonic');
    }

    public function get_categories()
    {
        return ['iqonic-extension'];
    }
    public function get_icon()
    {
        return 'eicon-gallery-masonry';
    }

    protected function register_controls()
    {

        $this->start_controls_section(
            'section_portfolio',
            [
                'label' => __('New Portfolio', 'iqonic'),
            ]
        );

        $this->add_control(
            'design_style',
            [
                'label'     => __('Style', 'iqonic'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [
                    'style-one'     => __('Style 1 (Slider)', 'iqonic'),
                    'style-two'     => __('Style 2 (Slider)', 'iqonic'),
                    'style-three'   => __('Style 3 (Slider)', 'iqonic'),
                    'style-four'    => __('Style 4 (Grid)', 'iqonic'),
                ],
                'default'   => 'style-one',
            ]
        );

        $this->add_control(
            'gird_style',
            [
                'label'     => __('Grid Style', 'iqonic'),
                'type'      => Controls_Manager::SELECT,
                'condition' => ['design_style' => 'style-four'],
                'options'   => [
                    'style_1'     => __('Style 1', 'iqonic'),
                    'style_2'     => __('Style 2', 'iqonic'),
                    'style_3'     => __('Style 3', 'iqonic'),
                ],
                'default'   => 'style_1',
            ]
        );

        $this->add_control(
            'grid',
            [
                'label'     => __('Style columns', 'iqonic'),
                'type'      => Controls_Manager::SELECT,
                'options'   => [ 
                    'col-lg-12'  => __('1 column', 'iqonic'),
                    'col-lg-6--col-md-6'   => __('2 column', 'iqonic'),
                    'col-lg-4--col-md-6'   => __('3 column', 'iqonic'),
                    'col-lg-4--col-md-6--col-xl-3'   => __('4 column', 'iqonic'),
                    'iq-column'    => __('5 column', 'iqonic'),
                    'col-lg-4--col-md-6--col-xl-2'   => __('6 column', 'iqonic'),
                ],
                'condition' => ['design_style' => 'style-four'],
                'default'   => 'col-lg-12',
            ]
        );

        $this->add_control(
			'show_masonryjoined',
			[
				'label' => esc_html__( 'Gallery Joined?', 'iqonic' ),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'iqonic' ),
				'label_off' => esc_html__( 'Hide', 'iqonic' ),
				'return_value' => 'yes',
				'default' => 'yes',
                'condition' => [
                    'gird_style' => array('style_2','style_3'),
                ],
            ]
		);

        $this->add_control(
            'port_cat',
            [
                'label' => __('Select Category', 'iqonic'),
                'type' => Controls_Manager::SELECT2,
                'return_value' => 'true',
                'multiple' => true,
                'options' => iqonic_get_taxonomies('portfolio_categories', 'slug'),
            ]
        );

        $this->add_control(
            'posts_per_page',
            [
                'label'         => __('Post per page', 'iqonic'),
                'type'          => Controls_Manager::NUMBER,
                'label_block'   => false,
                'min'           => -1,
                'max'           => 100,
                'step'          => 1,
                'default'       => 9,
            ]
        );

        $this->add_control(
            'pagination',
            [
                'label' => __('Show Pagination', 'iqonic'),
                'type' => Controls_Manager::SELECT,
                'default' => 'no',
                'options' => [
                    'yes' => esc_html__('yes', 'iqonic'),
                    'no' => esc_html__('no', 'iqonic')
                ],
            ]
        );

        $this->add_control(
            'post_view_type_order',
            [
                'label'   => __('Type', 'iqonic'),
                'type'    => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'none'      => esc_html__('None', 'iqonic'),
                    'latest'    => esc_html__('Latest', 'iqonic'),
                ],

            ]
        );
        $this->add_control(
            'order',
            [
                'label' => __('Order By', 'iqonic'),
                'type' => Controls_Manager::SELECT,
                'default' => 'ASC',
                'options' => [
                    'DESC' => esc_html__('Descending', 'iqonic'),
                    'ASC' => esc_html__('Ascending', 'iqonic')
                ],
                'condition' => ['post_view_type_order' => 'none'],

            ]
        );

        $this->end_controls_section();
        $this->start_controls_section(
            'section_swiper_controls',
            [
                'label' => __('Slider Controls', 'iqonic'),
                'condition' => ['design_style!' => 'style-four'],
            ]
        );
        $this->add_control(
            'autoplay',
            [
                'label' => __('Autoplay', 'iqonic'),
                'type' => Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'true' => __('True', 'iqonic'),
                    'false' => __('False', 'iqonic'),

                ],

            ]
        );
        $this->add_control(
            'autoplay_delay',
            [
                'label' => __('Autoplay Delay', 'iqonic'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 50000,
                'step' => 100,
                'default' => 2500,
                'condition' => ['autoplay' => 'true']
            ]
        );
        
        $this->add_control(
            'loop',
            [
                'label' => __('Loop', 'iqonic'),
                'type' => Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'true' => __('True', 'iqonic'),
                    'false' => __('False', 'iqonic'),
                ],

            ]
        );

        $this->add_control(
            'speed',
            [
                'label' => __('Speed', 'iqonic'),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'max' => 50000,
                'step' => 100,
                'default' => 2500,
            ]
        );

        $this->add_control(
            'slider_pagination',
            [
                'label' => __('Pagination', 'iqonic'),
                'type' => Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'true' => __('True', 'iqonic'),
                    'false' => __('False', 'iqonic'),
                ],
            ]
        );

        $this->add_control(
            'nav_arrow',
            [
                'label' => __('Arrow', 'iqonic'),
                'type' => Controls_Manager::SELECT,
                'default' => 'true',
                'options' => [
                    'true' => __('True', 'iqonic'),
                    'false' => __('False', 'iqonic'),

                ],

            ]
        );
        
        $this->end_controls_section();

        $this->start_controls_section(
            'section_portfolio_title',
            [
                'label' => __('Portfolio Title', 'iqonic'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_size',
            [
                'label' => __('HTML Tag', 'iqonic'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                ],
                'default' => 'h5',
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'portfolio_title_typography',
                'label' => __('Typography', 'iqonic'),
                'selector' => '{{WRAPPER}} .portfolio-title',
            ]
        );
        $this->add_control(
            'has_gradient_title',
            [
                'label' => __('Use gradient color for title ?', 'iqonic'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic'),
                'no' => __('no', 'iqonic'),
               
            ]
        );
        $this->add_control(
            'title_color',
            [
                'label' => __('Title Color', 'iqonic'),
                'type' => Controls_Manager::COLOR,
                'condition' => ['has_gradient_title!' => 'yes'],
                'selectors' => ['{{WRAPPER}} .portfolio-title' => 'color:{{VALUE}};'],
                
            ]
        );
        $this->add_control(
            'title_hover_color',
            [
                'label' => __('Title Hover Color', 'iqonic'),
                'type' => Controls_Manager::COLOR,
                'condition' => ['has_gradient_title!' => 'yes'],
                'selectors' => ['{{WRAPPER}} .portfolio-title:hover' => 'color:{{VALUE}};'],
            ]
        );
        $this->add_control(
            'title_heading',
            [
                'label' => __('Title Color', 'iqonic'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => ['has_gradient_title' => 'yes'],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'title_gradient',
                'label' => __('Title Color', 'iqonic'),
                'types' => ['gradient'],
                'description' => 'Title gradient color.',
                'condition' => ['has_gradient_title' => 'yes'],
                'selector' => '{{WRAPPER}} .portfolio-title',
            ]
        );
        $this->add_control(
            'title_hover_heading',
            [
                'label' => __('Title Hover Color', 'iqonic'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
                'condition' => ['has_gradient_title' => 'yes'],
            ]
        );
        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'title_gradient_hover',
                'label' => __('Title Hover Color', 'iqonic'),
                'types' => ['gradient'],
                'description' => 'Title gradient hover color.',
                'condition' => ['has_gradient_title' => 'yes'],
                'selector' => '{{WRAPPER}} .portfolio-title:hover',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_portfolio_excerpt',
            [
                'label' => __('Portfolio Content', 'iqonic'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['gird_style!' => 'style_2'],
            ]

        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'portfolio_excerpt_typography',
                'label' => __('Typography', 'iqonic'),
                'selector' => '{{WRAPPER}} .portfolio-excerpt',
            ]
        );

        $this->add_control(
            'excerpt_color',
            [
                'label' => __('Content Color', 'iqonic'),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .portfolio-excerpt' => 'color:{{VALUE}};'],
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_portfolio_category',
            [
                'label' => __('Portfolio Category', 'iqonic'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'portfolio_category_typography',
                'label' => __('Typography', 'iqonic'),
                'selectors' => '{{WRAPPER}} .portfolio-container .portfolio-category',
            ]
        );

        $this->add_control(
            'category_color',
            [
                'label' => __('Category Color', 'iqonic'),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .portfolio-container.style-one .portfolio-detail-main .portfolio-category, {{WRAPPER}} .portfolio-container .portfolio-category, {{WRAPPER}} .portfolio-container.style-four .portfolio-grid .portfolio-img .portfolio-category' => 'color:{{VALUE}};'],
            ]
        );

        $this->add_control(
            'category_hover_color',
            [
                'label' => __('Category Hover Color', 'iqonic'),
                'type' => Controls_Manager::COLOR,
                'selectors' => ['{{WRAPPER}} .portfolio-container.style-one .portfolio-detail-main .portfolio-category:hover, {{WRAPPER}} .portfolio-container .portfolio-category:hover, {{WRAPPER}} .portfolio-container.style-four .portfolio-grid .portfolio-img .portfolio-category:hover' => 'color:{{VALUE}};'],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        require 'render.php';
        if (Plugin::$instance->editor->is_edit_mode()) { ?>
            <script>
                (function(jQuery) {
                    callSwiper();
                    jQuery('.box').hoverDirection();
                })(jQuery);
            </script> <?php
                    }
    }

}
