<?php

namespace Elementor;

use Iqonic_Layouts\Classes\Iqonic_Walker_Nav_Menu;

if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();
$id_int = rand(10, 100);
$menu = ["theme_location" => "primary"];
if ($settings['location'] === 'select' && !empty($settings['menu'])) {
    $menu = ["menu" => $settings['menu']];
} else {
    $menu = ["theme_location" => $settings['location']];
}
$powerhour_options = get_option('power-hour-options');

$vertical_menu = '';
if ($settings['layout'] === 'default' && $settings['direction'] === 'vertical') {
    $vertical_menu = ' vertical-menu-layout';
    $vertical_menu .= !empty($settings['design_style']) ? ' menu-' . $settings['design_style'] : '';
}

$align = '';
if ($settings['layout'] == 'default' && $settings['direction'] === 'horizontal') {
    $align .= 'menu-hover-' . $settings['hover_effect'];
    if ($settings['use_more'] === 'yes') {
        $align .= ' has-more-menu-attr';
        $this->add_render_attribute('more', 'data-text', $settings['more_text']);
        $this->add_render_attribute('more', 'data-items', $settings['more_item']);
    }
}
$align .= (isset($settings['menu_align']) && $settings['menu_align'] == 'center') ? ' menu-align-center' : '';

?>

<div class="widget-nav-menu <?php echo esc_attr($align); ?>">
    <?php
    if ($settings['layout'] === 'burger') {
    ?>
        <button class="navbar-toggler custom-toggler ham-toggle" type="button">
            <span class="menu-btn d-inline-block">
                <?php if ($settings['use_custom_icon'] == 'yes') {
                    Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']);
                } else { ?>
                    <span class="lines one"></span>
                    <span class="lines two"></span>
                    <span class="lines three"></span>
                <?php } ?>
            </span>
        </button>
        <div class="powerhour-mobile-menu powerhour-navigation-burger">
            <nav class="powerhour-menu-wrapper mobile-menu">
                <div class="navbar">
                    <?php
                    if (isset($powerhour_options['header_radio']) && $powerhour_options['header_radio'] == 1) { ?>
                        <a href="<?php echo esc_url(home_url('/')); ?>">
                            <?php if (!empty($powerhour_options['header_text'])) { ?>
                                <h1 class="logo-text">
                                    <?php echo esc_html($powerhour_options['header_text']); ?></h1>
                            <?php } ?>
                        </a>
                    <?php
                    } else {
                        $logo = ''; ?>
                        <a class="navbar-brand" href="<?php echo esc_url(home_url('/')); ?>">
                            <?php
                            if (function_exists('get_field') && class_exists('ReduxFramework')) {
                                $page_logo = get_field('header_logo', get_queried_object_id());
                                $is_page_header = get_field('display_header', get_queried_object_id());
                                if ($is_page_header === 'yes' && !empty($page_logo['url'])) {
                                    $logo = $page_logo['url']; ?>
                                    <img class="img-fluid logo" src="<?php echo esc_url($logo); ?>" alt="<?php esc_attr_e('iqonic-extension', 'iqonic-layouts'); ?>">
                                <?php
                                } else if (isset($powerhour_options['powerhour_mobile_logo']['url']) && !empty($powerhour_options['powerhour_mobile_logo']['url'])) {
                                    $logo = $powerhour_options['powerhour_mobile_logo']['url']; ?>
                                    <img class="img-fluid logo" src="<?php echo esc_url($logo); ?>" alt="<?php esc_attr_e('iqonic-extension', 'iqonic-layouts'); ?>">
                                <?php
                                } else { ?>
                                    <img class="img-fluid logo" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/logo-white.svg" alt="<?php esc_attr_e('iqonic-extension', 'iqonic-layouts'); ?>">
                                <?php }
                            } else { ?>
                                <img class="img-fluid logo" src="<?php echo esc_url(get_template_directory_uri()); ?>/assets/images/logo.svg" alt="<?php esc_attr_e('iqonic-extension', 'iqonic-layouts'); ?>">
                            <?php
                            } ?>
                        </a>
                    <?php
                    } ?>

                    <button class="navbar-toggler custom-toggler ham-toggle" type="button">
                        <span class="close_btn">
                            <span class="menu_close_text"><?php esc_html_e('Close', 'iqonic-extension') ?></span>
                            <span class="menu_close_icon"><i class="fa fa-times" aria-hidden="true"></i></span>
                        </span>
                    </button>
                </div>

                <div class="c-collapse">
                    <div class="menu-new-wrapper row align-items-center">
                        <div class="menu-scrollbar verticle-mn yScroller col-lg-12">
                            <div class="powerhour-full-menu">
                                <?php
                                $args = array_merge($menu, array(
                                    'menu_class' => 'navbar-nav top-menu',
                                ));
                                wp_nav_menu($args);
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </nav><!-- #site-navigation -->
        </div>
        <?php } else {
        if ($settings['direction'] === 'vertical') { ?>
            <div class="powerhour-mobile-menu powerhour-navigation-burger menu-open <?php echo esc_attr($vertical_menu); ?>">
                <nav class="powerhour-menu-wrapper mobile-menu">
                    <div class="navbar">
                        <div class="menu-new-wrapper row align-items-center">
                            <div class="menu-scrollbar verticle-mn yScroller col-lg-12">
                                <div class="powerhour-full-menu">
                                    <?php
                                    $args = array_merge($menu, array(
                                        'menu_class'    => 'navbar-nav top-menu',
                                    ));
                                    wp_nav_menu($args);
                                    ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </nav><!-- #site-navigation -->
            </div>
        <?php } else {  ?>
            <nav class="navbar deafult-header nav-widget navbar-light p-0 header-default-menu<?php echo esc_attr($vertical_menu); ?>" aria-label="<?php esc_attr_e('Widget menu', 'iqonic-layouts'); ?>" <?php echo $this->get_render_attribute_string('more'); ?>>
                <div>
                    <div class="menu-all-pages-container widget-menu-container">
                        <?php
                        $args = array_merge($menu, array(
                            'menu_class'    => 'sf-menu',
                            'walker'        => new Iqonic_Walker_Nav_Menu()
                        ));
                        wp_nav_menu($args);
                        ?>
                    </div>
                </div>
            </nav>
    <?php }
    }
    ?>
</div>
<?php
