<?php

namespace Iqonic\Elementor\Elements\Navigation;

use Elementor\Plugin;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic_navigation', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Navigation Menu', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-layouts-extension'];
    }

    public function get_icon()
    {
        return 'eicon-nav-menu';
    }
    protected function register_controls()
    {

        $this->start_controls_section(
            'section_header',
            [
                'label' => __('Navigation', 'iqonic-extension'),

            ]
        );

        $this->add_control(
            'layout',
            [
                'label'      => __('Layout', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'default',
                'options'    => [
                    'default'   => __('Default', 'iqonic-extension'),
                    'burger'    => __('Burger', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'direction',
            [
                'label'      => __('Direction', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'horizontal',
                'options'    => [
                    'horizontal'    => __('Horizontal', 'iqonic-extension'),
                    'vertical'      => __('Vertical', 'iqonic-extension'),
                ],
                'condition' => ['layout' => 'default']
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label'      => __('Hover Effect', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'style-one',
                'options'    => [
                    'style-one'       => __('Style 1', 'iqonic-extension'),
                    'style-two'    => __('Style 2', 'iqonic-extension'),
                ],
                'condition' => ['layout' => 'default', 'direction' => 'vertical']
            ]
        );
        $this->add_control(
            'location',
            [
                'label'      => __('Location', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'select',
                'options'    => layout_get_nav_menus('location'),
            ]
        );

        $this->add_control(
            'menu',
            [
                'label'     => __('Menu', 'iqonic-extension'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'select',
                'options'   => layout_get_nav_menus(),
                'condition' => ['location' => 'select']
            ]
        );

        $this->add_control(
            'hover_effect',
            [
                'label'      => __('Hover Effect', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'default',
                'options'    => [
                    'default'       => __('Style 1', 'iqonic-extension'),
                    'background'    => __('Style 2', 'iqonic-extension'),
                    'top-border'    => __('Style 3', 'iqonic-extension'),
                ],
                'condition' => ['layout' => 'default', 'direction' => 'horizontal']
            ]
        );

        $this->add_control(
            'use_more',
            [
                'label'      => __('Use More', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'yes',
                'options'    => [
                    'yes'   => __('Yes', 'iqonic-extension'),
                    'no'    => __('No', 'iqonic-extension'),
                ],
                'condition' => ['layout' => 'default', 'direction' => 'horizontal']
            ]
        );
        $this->add_control(
            'more_text',
            [
                'label' => __('More Text', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'default' => __('More', 'iqonic-extension'),
                'condition' => ['layout' => 'default', 'direction' => 'horizontal', 'use_more' => 'yes'],
            ]
        );

        $this->add_control(
            'more_item',
            [
                'label' => __('Items', 'iqonic-extension'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => [
                    'active' => true,
                ],
                'label_block' => true,
                'description' => __('Show Number of Lists use More Text', 'iqonic-extension'),
                'default' => __('5', 'iqonic-extension'),
                'condition' => ['layout' => 'default', 'direction' => 'horizontal', 'use_more' => 'yes'],
            ]
        );

        $this->add_control(
            'use_custom_icon',
            [
                'label'      => __('Use Custom Icon', 'iqonic-extension'),
                'type'       => Controls_Manager::SWITCHER,
                'label_on' => __('Yes', 'your-plugin'),
                'label_off' => __('No', 'your-plugin'),
                'return_value' => 'yes',
                'default' => 'no',
                'condition' => ['layout' => 'burger']
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label' => __('Icon', 'iqonic-extension'),
                'type' => Controls_Manager::ICONS,
                'fa4compatibility' => 'icon',
                'default' => [
                    'value' => 'fas fa-line'
                ],
                'condition' => ['layout' => 'burger', 'use_custom_icon' => 'yes'],
            ]
        );

        $this->end_controls_section();

        /* menu list End*/

        //Menu Color
        $this->start_controls_section(
            'section_menu_style',
            [
                'label' => __('Menu', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['layout' => 'default'],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'mobile_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .sf-menu > li > a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav>li>a ',
            ]
        );
        $this->add_control(
            'powerhour_menu_height',
            [
                'label' => __('Height', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%', 'vh'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                    'vh' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'condition' => ['direction' => 'vertical'],
                'selectors' => [
                    '{{WRAPPER}} .verticle-mn' => 'height: {{SIZE}}{{UNIT}};',
                ],

            ]
        );
        $this->add_responsive_control(
            'menu_align',
            [
                'label' => __('Alignment', 'iqonic-extension'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left'    => [
                        'title' => __('Left', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => __('Right', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .widget-nav-menu .menu-main-menu-container .navbar-nav' => 'text-align: {{VALUE}}',
                    '{{WRAPPER}} .powerhour-menu-wrapper.mobile-menu .navbar' => 'text-align: {{VALUE}}',
                ],
            ]
        );
        $this->start_controls_tabs('menu_tabs');
        $this->start_controls_tab(
            'tabs_menujeBef122kCfHObvih40638',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __('Choose color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sf-menu > li > a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav>li>a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li>.toggledrop i'  => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_menuaJ0C3kdUtggtL5G4tW12awyR',
            [
                'label' => __('Active/Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'text_hover_color',
            [
                'label' => __('Choose color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sf-menu li:hover > a,{{WRAPPER}} .sf-menu li.current-menu-ancestor > a,{{WRAPPER}} .sf-menu  li.current-menu-item > a ,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li.current-menu-item>.toggledrop i,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li.current-menu-item>a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li .sub-menu li:hover>a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li:hover>.toggledrop i,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li:hover>a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout ul>li.current-menu-ancestor>.toggledrop i,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout ul>li.current-menu-ancestor>a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout ul li .sub-menu li.current-menu-item>a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout ul li .sub-menu li.menu-item.current-menu-ancestor>a ,
                    {{WRAPPER}} .sf-menu li.sfHover>a' => 'color: {{VALUE}};'
                ],
            ]
        );


        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->add_responsive_control(
            'menu_parent_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .sf-menu > li, {{WRAPPER}} .powerhour-full-menu .navbar-nav > li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'menu_parent_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .sf-menu > li, {{WRAPPER}} .powerhour-full-menu .navbar-nav > li' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_section();


        // Default layout top-border
        $this->start_controls_section(
            'section_border4tW12awyR',
            [
                'label' => __('Border', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => 'default',
                    'hover_effect' => 'top-border'
                ]
            ]
        );

        $this->add_control(
            'powerhour_menu_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu-hover-top-border .sf-menu > li > a::before' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'powerhour_menu_border_width',
            [
                'label' => __('Border Height', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .menu-hover-top-border .sf-menu > li > a::before' => 'height: {{SIZE}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_section();


        // Default layout Background
        $this->start_controls_section(
            'section_background4tW12awyR',
            [
                'label' => __('Background', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => 'default',
                    'hover_effect' => 'background'
                ]
            ]
        );

        $this->add_control(
            'powerhour_menu_bg_color',
            [
                'label' => __('Background Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu-hover-background .sf-menu > li:hover > a,{{WRAPPER}} .menu-hover-background .sf-menu li.current-menu-ancestor > a,{{WRAPPER}} .menu-hover-background .sf-menu li.current-menu-item > a' => 'background: {{VALUE}} !important;',
                ],
            ]
        );

        $this->end_controls_section();

        //Sub Menu Color
        $this->start_controls_section(
            'section_submenu_style',
            [
                'label' => __('Sub Menu', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'layout' => 'default',
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'submenu_bg_background',
                'label' => __('Submenu Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .sf-menu ul.sub-menu',
            ]
        );

        $this->add_responsive_control(
            'submenu_parent_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .sf-menu ul.sub-menu' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'section_vl8vK4162c',
            [
                'label' => __('Inner Menu', 'iqonic-extension'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'submenu_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .sf-menu ul.sub-menu a ,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li .sub-menu li a',
            ]
        );

        $this->start_controls_tabs('submenu_tabs');
        $this->start_controls_tab(
            'tabs_submenujeBef1kCfHObvih40638',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'submenu_text_color',
            [
                'label' => __('Choose color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sf-menu ul.sub-menu a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li .sub-menu li a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li li>.toggledrop i'  => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'powerhour_submenu_bg_color',
            [
                'label' => __('Background Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sf-menu ul.sub-menu li' => 'background: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_submenuaJ0C3kdUtg5G4tW12awyR',
            [
                'label' => __('Active/Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'submenu_text_hover_color',
            [
                'label' => __('Choose color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sf-menu .sub-menu li.sfHover>a, {{WRAPPER}} .sf-menu  .sub-menu li:hover>a, {{WRAPPER}} .sf-menu .sub-menu li.current-menu-ancestor>a,{{WRAPPER}} .sf-menu .sub-menu li.current-menu-item>a,{{WRAPPER}} .sf-menu ul.sub-menu>li.menu-item.current-menu-parent>a,{{WRAPPER}} .sf-menu ul .sub-menu li.current-menu-parent>a,{{WRAPPER}} .sf-menu ul li .sub-menu li.current-menu-item>a ,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav  .sub-menu li.current-menu-item > .toggledrop i,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav  .sub-menu li.current-menu-item > a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li .sub-menu li:hover > a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li:hover > .toggledrop i,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li:hover > a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout ul > li.current-menu-ancestor > .toggledrop i,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout ul > li.current-menu-ancestor > a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout ul li .sub-menu li.current-menu-item > a,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout ul li .sub-menu li.menu-item.current-menu-ancestor > a' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'powerhour_submenu_hover_bg_color',
            [
                'label' => __('Background Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .sf-menu ul.sub-menu li:hover,{{WRAPPER}} .sf-menu ul.sub-menu li.current-menu-item' => 'background: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->add_responsive_control(
            'submenu_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .sf-menu ul.sub-menu li ,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li .sub-menu li a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'submenu_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .sf-menu ul.sub-menu li ,{{WRAPPER}} .powerhour-mobile-menu.vertical-menu-layout .navbar-nav li .sub-menu li a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );
        $this->end_controls_section();


        //Burger Menu Icon
        $this->start_controls_section(
            'section_icon_style',
            [
                'label' => __('Icon', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['layout' => 'burger'],
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu-btn svg ,{{WRAPPER}} .menu-btn svg path,{{WRAPPER}} .menu-btn i' => 'fill: {{VALUE}}; color: {{VALUE}};'
                ],
                'condition' => ['use_custom_icon' => 'yes'],
            ]
        );

        $this->add_control(
            'default_icon_color',
            [
                'label' => __('Choose color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .menu-btn .line' => 'background-color: {{VALUE}};'
                ],
                'condition' => ['use_custom_icon!' => 'yes'],
            ]
        );

        $this->add_responsive_control(
            'icon_size',
            [
                'label' => __('Icon Size', 'iqonic-extension'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['px', '%'],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 5,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .menu-btn svg,{{WRAPPER}} .menu-btn i' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
                'condition' => ['use_custom_icon' => 'yes'],
            ]
        );

        $this->end_controls_section();

        //Menu Color
        $this->start_controls_section(
            'section_burger_menu_style',
            [
                'label' => __('Menu', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['layout' => 'burger'],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'burger_mobile_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-mobile-menu .navbar-nav > li > a',
            ]
        );

        $this->add_control(
            'burger_text_color',
            [
                'label' => __('Menu color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-mobile-menu .navbar-nav > li > a,{{WRAPPER}} .powerhour-mobile-menu .navbar-nav li > .toggledrop i'  => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->add_control(
            'burger_text_hover_color',
            [
                'label' => __('Menu Hover color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-mobile-menu .navbar-nav li.current-menu-item > .toggledrop i,{{WRAPPER}} .powerhour-mobile-menu .navbar-nav li.current-menu-item > a,{{WRAPPER}} .powerhour-mobile-menu .navbar-nav li .sub-menu li:hover > a,{{WRAPPER}} .powerhour-mobile-menu .navbar-nav li:hover > .toggledrop i,{{WRAPPER}} .powerhour-mobile-menu .navbar-nav li:hover > a,{{WRAPPER}} .powerhour-mobile-menu ul > li.current-menu-ancestor > .toggledrop i,{{WRAPPER}} .powerhour-mobile-menu ul > li.current-menu-ancestor > a,{{WRAPPER}} .powerhour-mobile-menu ul li .sub-menu li.current-menu-item > a,{{WRAPPER}} .powerhour-mobile-menu ul li .sub-menu li.menu-item.current-menu-ancestor > a' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'section_1vK4162c',
            [
                'label' => __('Sub Menu', 'iqonic-extension'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'burger_submobile_typography',
                'label' => __('Sub Menu Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-mobile-menu .navbar-nav li .sub-menu li a',
            ]
        );

        $this->add_control(
            'burger_subenu_text_hover_color',
            [
                'label' => __('Sub Menu color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-mobile-menu .navbar-nav li .sub-menu li a ,{{WRAPPER}} .powerhour-mobile-menu .navbar-nav li .sub-menu li svg' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        require 'render.php';
        if (Plugin::$instance->editor->is_edit_mode()) {
?>
            <script>
                (function(jQuery) {
                    jQuery(document).ready(function(e) {
                        if (jQuery('.powerhour-mobile-menu').length > 0) {
                            jQuery('nav.mobile-menu .sub-menu').css('display', 'none ');
                            jQuery('nav.mobile-menu #top-menu li .dropdown').hide();
                            jQuery('nav.mobile-menu .sub-menu').prev().prev().addClass('submenu');
                            jQuery('nav.mobile-menu .sub-menu').before('<span class="toggledrop"><i class="ion ion-ios-arrow-down"></i></span>');

                            jQuery('nav.mobile-menu .widget i,nav.mobile-menu .top-menu i').on('click', function() {
                                jQuery(this).next('.children, .sub-menu').slideToggle();
                            });
                            jQuery('nav.mobile-menu #top-menu .menu-item .toggledrop').off('click');
                            jQuery('nav.mobile-menu .menu-item .toggledrop').on('click', function(e) {
                                e.preventDefault();
                                if (!jQuery(this).closest('ul').parent('li').find('.toggledrop').hasClass('active')) {
                                    jQuery('.menu-style-one nav.mobile-menu .menu-item .sub-menu,nav.mobile-menu .menu-item .children').slideUp();
                                    jQuery('.menu-style-two nav.mobile-menu .menu-item .sub-menu,nav.mobile-menu .menu-item .children').hide();
                                    jQuery('nav.mobile-menu .menu-item .toggledrop').removeClass('active');
                                }
                                jQuery(this).next('.children, .sub-menu').slideToggle();
                                jQuery(this).toggleClass('active');
                            });
                        }
                    });
                })(jQuery);
            </script>
<?php
        }
    }
}
