<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;

$tabs = $this->get_settings_for_display('tabs');
$align = $settings['align'];
$align .= ' iqonic-' . $settings['list_column'] . '-column';

if ($settings['list_style'] == 'unorder') { ?>

    <div class="iqonic-list <?php echo esc_attr($align); ?>">
        <ul class="iqonic-unoreder-list"> <?php
            foreach ($tabs as $index => $item) { ?>
                <li>
                    <?php echo esc_html($item['tab_title'], 'iqonic-extension'); ?>
                </li> <?php  
            } ?>
        </ul>
    </div> <?php 
}

if ($settings['list_style'] == 'order') { ?>

    <div class="iqonic-list <?php echo esc_attr($align); ?>">
        <ol class="iqonic-order-list"> <?php
            foreach ($tabs as $index => $item) { ?>
                <li>
                    <?php echo esc_html($item['tab_title'], 'iqonic-extension'); ?>
                </li> <?php  
            } ?>
        </ol>
    </div> <?php 

} if ($settings['list_style'] == 'icon') { ?>

    <div class="iqonic-list <?php echo esc_attr($align); ?>">
        <ul class="iqonic-list-with-icon"> <?php
            foreach ($tabs as $index => $item) { ?>
                <li> <?php
                    if (isset($settings['selected_icon'])) {
                        Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']);
                    }
                    echo esc_html($item['tab_title'], 'iqonic-extension'); ?>
                </li> <?php  
            } ?>
        </ul>
    </div> <?php 
}

if ($settings['list_style'] == 'image') { ?>

    <div class="iqonic-list <?php echo esc_attr($align); ?>">
        <ul class="iqonic-list-with-img"> <?php
            foreach ($tabs as $index => $item) { ?>
                <li>
                    <img src="<?php echo esc_url($settings['image']['url']); ?>">
                    <?php echo esc_html($item['tab_title'], 'iqonic-extension'); ?>
                </li> <?php  
            } ?>
        </ul>
    </div><?php 
}
