<?php
namespace Iqonic\Elementor\Elements\Lists;

use Elementor\Plugin;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
if ( ! defined( 'ABSPATH' ) ) exit; 

class Widget extends Widget_Base {

	public function get_name() {
		return __( 'iqonic_lists', 'iqonic-extension' );
	}

	
	public function get_title() {
		
		return __( 'Iqonic Lists', 'iqonic-extension' );
	}

	public function get_categories() {
		return ['iqonic-extension'];
	}

	/**
	 * Get widget icon.
	 *
	 * Retrieve Lists widget icon.
	 *
	 * @since 1.1.0
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'eicon-bullet-list';
	}

	

	protected function register_controls() {
		$this->start_controls_section(
			'section',
			[
				'label' => __( 'Lists', 'iqonic-extension' ),
			]
        );
        
        $this->add_control(
			'list_style',
			[
				'label'      => __( 'List Style', 'iqonic-extension' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'unorder',
				'options'    => [
					
					'order'          => __( 'Order List', 'iqonic-extension' ),
					'unorder'          => __( 'Unorder List', 'iqonic-extension' ),
                    'icon'          => __( 'icon', 'iqonic-extension' ),
                    'image'          => __( 'Image', 'iqonic-extension' ),
                    
					
				],
			]
        );
        
        $this->add_control(
			'list_style_type_ol',
			[
				'label'      => __( 'List Style', 'iqonic-extension' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'decimal',
				'options'    => [	
                    'decimal'          => __( 'Decimal', 'iqonic-extension' ),
                    'decimal-leading-zero' => __( 'Decimal Leading Zero', 'iqonic-extension' ),
                    'lower-alpha'          => __( 'Lower Alpha', 'iqonic-extension' ),
                    'lower-greek'          => __( 'Lower Greek', 'iqonic-extension' ),
                    'lower-latin'          => __( 'Lower Latin', 'iqonic-extension' ),
                    'lower-roman'          => __( 'Lower Roman', 'iqonic-extension' ),
                    'upper-alpha'          => __( 'Upper Alpha', 'iqonic-extension' ),
                    'upper-roman'          => __( 'Upper Roman', 'iqonic-extension' ),     
                ],
                'condition' => [
					'list_style' => 'order',
				],
				'selectors' => [
					'{{WRAPPER}} .iqonic-list .iqonic-order-list li' => 'list-style-type: {{VALUE}};',
				],
			]
        );
        
        $this->add_control(
			'list_style_type_ul',
			[
				'label'      => __( 'List Style', 'iqonic-extension' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'circle',
				'options'    => [	
                    'circle' => __( 'Circle', 'iqonic-extension' ),
                    'disc'   => __( 'Disc', 'iqonic-extension' ),
                    'square' => __( 'Square', 'iqonic-extension' ),
                    
                ],
                'condition' => [
					'list_style' => 'unorder',
				],
				'selectors' => [
					'{{WRAPPER}} .iqonic-list .iqonic-unoreder-list li' => 'list-style-type: {{VALUE}};',
				],
			]
		);

       	 $this->add_control(
			'list_column',
			[
				'label'      => __( 'No. Of column', 'iqonic-extension' ),
				'type'       => Controls_Manager::SELECT,
				'default'    => 'one',
				'options'    => [
					
					'one'          => __( '1 column', 'iqonic-extension' ),
					'two'          => __( '2 column', 'iqonic-extension' ),
                    'three'        => __( '3 column', 'iqonic-extension' ),
                    'four'         => __( '4 column', 'iqonic-extension' ),
                    'five' 		   => __( '5 column', 'iqonic-extension' ),
                    'six'		   => __( '6 column', 'iqonic-extension' ),
																									
				],
			]
		);
        
        $this->add_control(
			'selected_icon',
			[
				'label' => __( 'Icon', 'iqonic-extension' ),
				'type' => Controls_Manager::ICONS,
				'fa4compatibility' => 'icon',
				'default' => [
					'value' => 'fas fa-star'
					
                ],
                'condition' => [
					'list_style' => 'icon',
				],
				'selectors' => [
					'{{WRAPPER}} .iqonic-list .iqonic-list-with-icon li' => 'list-style-type: none;',
				],
			]
		);

		$this->add_control(
			'image',
			[
				'label' => __( 'Event Image', 'iqonic-extension' ),
				'type' => Controls_Manager::MEDIA,
				'dynamic' => [
					'active' => true,
				],
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'list_style' => 'image',
				],
			]
		);

		
        $repeater = new Repeater();
        $repeater->add_control(
			'tab_title',
			[
				'label' => __( 'Title & Description', 'iqonic-extension' ),
				'type' => Controls_Manager::TEXT,
				'default' => __( 'Tab Title', 'iqonic-extension' ),
				'placeholder' => __( 'Tab Title', 'iqonic-extension' ),
				'label_block' => true,
			]
        );
        
      
        $this->add_control(
			'tabs',
			[
				'label' => __( 'Lists Items', 'iqonic-extension' ),
				'type' => Controls_Manager::REPEATER,
				'fields' => $repeater->get_controls(),
				'default' => [
					[
						'tab_title' => __( 'List Items', 'iqonic-extension' ),
                        
					]
					
				],
				'title_field' => '{{{ tab_title }}}',
			]
        );
        
      $this->add_responsive_control(
			'align',
			[
				'label' => __( 'Alignment', 'iqonic-extension' ),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'text-left' => [
						'title' => __( 'Left', 'iqonic-extension' ),
						'icon' => 'eicon-text-align-left',
					],
					'text-center' => [
						'title' => __( 'Center', 'iqonic-extension' ),
						'icon' => 'eicon-text-align-center',
					],
					'text-right' => [
						'title' => __( 'Right', 'iqonic-extension' ),
						'icon' => 'eicon-text-align-right',
					]
				]
			]
		);	

        $this->end_controls_section();

        $this->start_controls_section(
			'section_6etDdWFTgLOef0R9zMse',
			[
				'label' => __( 'List', 'iqonic-extension' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'iqonic_lists_text_typography',
				'label' => __( 'Typography', 'iqonic-extension' ),				
				'selector' => '{{WRAPPER}}  .iqonic-list li',
			]
		);

        $this->start_controls_tabs( 'iqonic_lists_tabs' );
        
		$this->start_controls_tab(
            'tabs_rpv2n9KXlxDj14M0La0F',
            [
                'label' => __( 'Normal', 'iqonic-extension' ),
            ]
        );
        $this->add_control(
			'iqonic_list_color',
			[
				'label' => __( 'Color', 'iqonic-extension' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iqonic-list li' => 'color: {{VALUE}};',
		 		],
				
			]
			
		);
    
		$this->end_controls_tab();
		$this->start_controls_tab(
            'tabs_xa5Ad6Ea1dZjeSNHgYzh',
            [
                'label' => __( 'Hover', 'iqonic-extension' ),
            ]
        );
        $this->add_control(
			'iqonic_list_hover_color',
			[
				'label' => __( 'Color', 'iqonic-extension' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iqonic-list li:hover' => 'color: {{VALUE}};',
		 		],
				
			]
			
		);
		
		$this->end_controls_tab();
		$this->end_controls_tabs();



		$this->add_responsive_control(
			'iqonic_lists_padding',
			[
				'label' => __( 'Padding', 'iqonic-extension' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .iqonic-list' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_responsive_control(
			'iqonic_lists_margin',
			[
				'label' => __( 'Margin', 'iqonic-extension' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => [
					'{{WRAPPER}}  .iqonic-list' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);


		$this->end_controls_section();


		 /*Fancy Icon start*/

        $this->start_controls_section(
			'section_UxR43bcXm9c7bcjeey0V',
			[
				'label' => __( 'List Icon', 'iqonic-extension' ),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => [
					'list_style' => 'icon',
				],
			]
		);

          $this->add_control(
			'icon_size',
			[
				'label' => __( 'Icon Size', 'iqonic-extension' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],				
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
				],
				'selectors' => [
					'{{WRAPPER}} .iqonic-list li i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'icon_width',
			[
				'label' => __( 'Width', 'iqonic-extension' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => ['
				    {{WRAPPER}} .iqonic-list li i' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

        $this->add_responsive_control(
			'icon_height',
			[
				'label' => __( 'Height', 'iqonic-extension' ),
				'type' => Controls_Manager::SLIDER,
				'size_units' => [ 'px', '%' ],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'selectors' => ['
				    {{WRAPPER}} .iqonic-list li i' => 'height: {{SIZE}}{{UNIT}};',
				    '{{WRAPPER}} .iqonic-list li i' => 'line-height: {{SIZE}}{{UNIT}};',
				],
			]
		);


		$this->add_responsive_control(
			'iqonic_list_icon_padding',
			[
				'label' => __( 'Padding', 'iqonic-extension' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => ['
				    {{WRAPPER}} .iqonic-list li i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);

		$this->add_responsive_control(
			'iqonic_list_icon_margin',
			[
				'label' => __( 'Margin', 'iqonic-extension' ),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => [ 'px', '%' ],
				'selectors' => ['
				    {{WRAPPER}} .iqonic-list li i' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				
			]
		);	

		$this->start_controls_tabs( 'Fancybox_icon_tabs' );
		$this->start_controls_tab(
			'tabs_8O8eC1f3ecBWhTpj9AlJ',
			[
				'label' => __( 'Normal', 'iqonic-extension' ),
			]
		);


		$this->add_control(
			'icon_color',
			[
				'label' => __( 'Choose Color', 'iqonic-extension' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .iqonic-list li i' => 'color: {{VALUE}};',
		 		],
				
			]
			
		);
		
		$this->end_controls_tab();

		$this->start_controls_tab(
			'tabs_oQUHWq6F3sZfKh75bNzd',
			[
				'label' => __( 'Hover', 'iqonic-extension' ),
			]
		);

		$this->add_control(
			'icon_hover_color',
			[
				'label' => __( 'Choose Color', 'iqonic-extension' ),
				'type' => Controls_Manager::COLOR,
				
				'selectors' => [
					'{{WRAPPER}} .iqonic-list li:hover i' => 'color: {{VALUE}};',
		 		],
				
			]
		);	

		$this->end_controls_tab();
		$this->end_controls_tabs();

        $this->end_controls_section();

	}
	
	protected function render() {
		$settings = $this->get_settings();
		require 'render.php';
		
    }	    
		
}
