<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;
$settings = $this->get_settings_for_display();
if ($settings['img_list'] && $settings['image_style'] == "slider") {
    $nav_next  =  $nav_prev =  $pagination  = '';
    $id = rand(10, 100);
    if ($settings['want_nav'] == "true" || $settings['want_pagination'] == "true") {
        $nav_next   = 'navnext_' . $id;
        $nav_prev   = 'navprev_' . $id;
        $pagination = 'pagination_' . $id;
    }
    $this->add_render_attribute('slider', 'data-slide', $settings['sw_slide']);
    $this->add_render_attribute('slider', 'data-loop', $settings['sw_loop']);
    $this->add_render_attribute('slider', 'data-speed', $settings['sw_speed']);
    $this->add_render_attribute('slider', 'data-spacebtslide', $settings['sw_space_slide']);
    $this->add_render_attribute('slider', 'data-autoplay', $settings['sw_autoplay']);
    $this->add_render_attribute('slider', 'data-laptop', $settings['sw_laptop_no']);
    $this->add_render_attribute('slider', 'data-tab', $settings['sw_tab_no']);
    $this->add_render_attribute('slider', 'data-mobile', $settings['sw_mob_no']);
    $this->add_render_attribute('slider', 'data-navnext', $nav_next);
    $this->add_render_attribute('slider', 'data-navprev', $nav_prev);
    $this->add_render_attribute('slider', 'data-pagination', $pagination);
    $this->add_render_attribute('slider', 'data-centermode', $settings['sw_centermode']); ?>
        
    <div class="powerhour-image-box-slider">
        <div class="powerhour-image-box powerhour-image-box-<?php echo esc_attr($settings['select_style']); ?>">
            <div class="swiper powerhour-widget-swiper" <?php echo $this->get_render_attribute_string('slider') ?>>
                <ul class="list-inline m-0 swiper-wrapper">
                    <?php foreach ($settings['img_list'] as $item) {

                        $target = '';
                        $url = '';
                        $rel = '';
                        if ($item['button_action'] == 'link') {
                            if ($item['link_type'] == 'dynamic') {
                                $url .= get_permalink(get_page_by_path($item['dynamic_link']));
                                if ($item['use_new_window'] == 'yes') {
                                    $target = '_blank';
                                }
                            } else {
                                if ($item['link']['url']) {
                                    $url .= $item['link']['url'];

                                    if ($item['link']['is_external']) {
                                        $target = '_blank';
                                    }

                                    if ($item['link']['nofollow']) {
                                        $rel = 'nofollow';
                                    }
                                }
                            }
                        } ?>

                        <li class="swiper-slide">
                            <div class="<?php if ($settings['select_style'] == 'style2') { echo esc_attr('scroll-img', 'iqonic-extension'); } ?> powerhour-image-box-data">
                                <?php if (!empty($item['image']['url'])) : ?>
                                    <div class="image-box">
                                        <?php if ($item['button_action'] == 'link') { ?>
                                            <a href="<?php echo esc_url($url) ?>" target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" >
                                        <?php } ?>
                                                <img src="<?php echo esc_url($item['image']['url']); ?>" alt="<?php esc_attr_e('Image', 'iqonic-extension'); ?>" loading="lazy" />
                                        <?php if ($item['button_action'] == 'link') { ?> 
                                            </a> 
                                        <?php } ?>
                                    </div>
                                <?php endif; ?>

                                <div class="images-data-info">
                                    <?php if ($item['button_action'] == 'link') { ?> <a href="<?php echo esc_url($url) ?>" target="<?php echo esc_attr($target); ?>" rel="<?php echo esc_attr($rel); ?>" ><?php } ?><?php if (!empty($item['title_text'])) : ?><<?php echo wp_kses($settings['title_size'], 'post') ?> class="title"><?php echo esc_html($item['title_text']); ?> </<?php echo $settings['title_size'] ?>><?php endif; ?><?php if ($item['button_action'] == 'link') { ?></a><?php } ?>
                                    <?php if (!empty($item['description_text'])) : ?><p class="desc"><?php echo esc_html(sprintf(_x('%s', 'description_text', 'iqonic-extension'), $item['description_text'])); ?></p><?php endif; ?>
                                </div>
                            </div>
                        </li>
                    <?php } ?>
                </ul>
            </div>

            <?php if ($settings['want_nav'] == "true") { ?>
                <div class="iqonic-navigation">
                    <div class="swiper-button-prev" id="<?php echo esc_attr($nav_prev); ?>">
                        <span class="text-btn">
                            <i class="iconly-Arrow-Left-2 icli"></i>
                        </span>
                    </div>

                    <div class="swiper-button-next" id="<?php echo esc_attr($nav_next); ?>">
                        <span class="text-btn">
                            <i class="iconly-Arrow-Right-2 icli"></i>
                        </span>
                    </div>
                </div> <?php
            }
            if ($settings['want_pagination'] == "true") { ?>
                <div class="swiper-pagination css-prefix-pagination-align" id="<?php echo esc_attr($pagination); ?>"></div> <?php
            } ?>

        </div>
    </div> <?php
} else if ($settings['image_style'] == "box") { ?>

    <div class="powerhour-image-box powerhour-image-box-grid"> <?php
        if ($settings['button_action'] == 'link') {
            
            if ($settings['link_type'] == 'dynamic') {
                $url = get_permalink(get_page_by_path($settings['dynamic_link']));
                $this->add_render_attribute('powerhour_class', 'href', esc_url($url));
                if ($settings['use_new_window'] == 'yes') {
                    $this->add_render_attribute('powerhour_class', 'target', '_blank');
                }
            } else {
                if ($settings['link']['url']) {
                    $url = $settings['link']['url'];
                    $this->add_render_attribute('powerhour_class', 'href', esc_url($url));

                    if ($settings['link']['is_external']) {
                        $this->add_render_attribute('powerhour_class', 'target', '_blank');
                    }

                    if ($settings['link']['nofollow']) {
                        $this->add_render_attribute('powerhour_class', 'rel', 'nofollow');
                    }
                }
            }
            $url = '';
        } ?>

        <div class="powerhour-image-box-data">
            <?php if (!empty($settings['image']['url'])) : ?>
                <div class="image-box">
                    <?php if ($settings['button_action'] == 'link') { ?><a <?php echo $this->get_render_attribute_string('powerhour_class') ?>><?php } ?>
                        <img src="<?php echo esc_url($settings['image']['url']); ?>" alt="<?php esc_attr_e('Image', 'iqonic-extension'); ?>" loading="lazy" />
                        <?php if ($settings['button_action'] == 'link') { ?> </a> <?php } ?>
                </div>
            <?php endif; ?>
            <div class="images-data-info">
                <?php if ($settings['button_action'] == 'link') { ?> <a <?php echo $this->get_render_attribute_string('powerhour_class') ?>><?php } ?><?php if (!empty($settings['title_text'])) : ?><<?php echo wp_kses($settings['title_size'], 'post') ?> class="title"><?php echo esc_html($settings['title_text']); ?> </<?php echo $settings['title_size'] ?>><?php endif; ?><?php if ($settings['button_action'] == 'link') { ?></a><?php } ?>
                <?php if (!empty($settings['description_text'])) : ?><p class="desc"><?php echo esc_html(sprintf(_x('%s', 'description_text', 'iqonic-extension'), $settings['description_text'])); ?></p><?php endif; ?>
            </div>
        </div>
    </div> <?php
}
