<?php

namespace Elementor;

if (!defined('ABSPATH')) exit;
$html = '';

$settings = $this->get_settings_for_display();

$image_html = '';

if ($settings['media_style'] == 'image') {
    if (!empty($settings['image']['url'])) {
        $this->add_render_attribute('image', 'src', $settings['image']['url']);
        $this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($settings['image']));
        $this->add_render_attribute('image', 'title', Control_Media::get_image_title($settings['image']));
        $image_html = Group_Control_Image_Size::get_attachment_image_html($settings, 'thumbnail', 'image');
    }
}

// ---- STYLE 1 -------
if ($settings['design_style'] == 'style1') { ?>
    <div class="powerhour-icon-box powerhour-icon-box-style-1">
        <div class="icon-box">
            <!-- if icon  -->
            <?php if ($settings['media_style'] == 'icon') { ?>
                <div class="icon">
                    <?php \Elementor\Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']); ?>
                </div>
                <!-- if image -->
            <?php } else if ($settings['media_style'] == 'image') {
                echo '<img src="' . $settings['image']['url'] . '">';
            } ?>
        </div>
        <div class="icon-box-content">
            <!-- Text-editor (aaddress,email,mobile number etc...) -->
            <?php if (!empty($settings['section_title'])) { ?>
                <h4 class="icon-box-title powerhour-heading-title"><?php echo $settings['section_title']; ?></h4><?php }
                                                                                                                if (!empty($settings['description'])) { ?>
                <div class="icon-box-desc"><?php echo $settings['description']; ?></div><?php } ?>
        </div>
    </div>
<?php
}

// ---------- STYLE 2 ---------
if ($settings['design_style'] == 'style2') {
?>
    <div class="powerhour-icon-box powerhour-icon-box-style-2">
        <!-- img,svg-icon,icon etc.. -->
        <div class="icon-box">
            <!-- if icon  -->
            <?php if ($settings['media_style'] == 'icon') { ?>
                <div class="icon">
                    <?php \Elementor\Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']); ?>
                </div>
                <!-- if image -->
            <?php } else if ($settings['media_style'] == 'image') {
                echo '<img src="' . $settings['image']['url'] . '">';
            } ?>
        </div>
        <!-- Content -->
        <?php if (!empty($settings['description'])) { ?>
            <div class="icon-box-content icon-box-desc">
                <?php echo $settings['description']; ?>
            </div>
    </div>
<?php }
    }

    // ---- STYLE 3 -------
    if ($settings['design_style'] == 'style3') { ?>
<div class="powerhour-icon-box powerhour-icon-box-style-3">
    <div class="icon-box">
        <!-- if icon  -->
        <?php if ($settings['media_style'] == 'icon') { ?>
            <div class="icon">
                <?php \Elementor\Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']); ?>
            </div>
            <!-- if image -->
        <?php } else if ($settings['media_style'] == 'image') {
            echo '<img src="' . $settings['image']['url'] . '">';
        } ?>
    </div>
    <?php if (!empty($settings['section_title'])) { ?>
        <div class="icon-box-content">
            <h5 class="icon-box-title powerhour-heading-title"><?php echo $settings['section_title']; ?></h5>
        </div><?php } ?>
</div>
<?php
    }
    // ---- STYLE 4 -------
    if ($settings['design_style'] == 'style4') { ?>
    <div class="powerhour-icon-box powerhour-icon-box-style-4">
        <div class="icon-box">
            <!-- if icon  -->
            <?php if ($settings['media_style'] == 'icon') { ?>
                <div class="icon">
                    <?php \Elementor\Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']); ?>
                </div>
                <!-- if image -->
            <?php } else if ($settings['media_style'] == 'image') {
                echo '<img src="' . $settings['image']['url'] . '">';
            } ?>
        </div>
        <div class="icon-box-content">
            <!-- Text-editor (aaddress,email,mobile number etc...) -->
            <?php if (!empty($settings['section_title'])) { ?>
                <h4 class="icon-box-title powerhour-heading-title">
                    <?php
                    $title = $settings['section_title'];
                    if (!empty($settings['word_position'])) {
                        $title = '';
                        $section_title = explode(' ', $settings['section_title']);
                        foreach ($section_title as $pos => $word) {
                            if (!empty($settings['word_position']) && $settings['word_position'] - 1 == $pos) {
                                $title .= " " . "<span class='highlighted-text-wrap'><span class='highlighted-text'>" . $word . "</span></span>";
                            } else {
                                $title .= " " . $word;
                            }
                        }
                        print_r($title);
                    }
                    ?>
                </h4>
            <?php }
            ?>
        </div>
    </div>
<?php }
    if ($settings['design_style'] == 'style5') {
?>
    <div class="powerhour-icon-box powerhour-icon-box-style-5">
        <div class="icon-box">
            <!-- if icon  -->
            <?php if ($settings['media_style'] == 'icon') { ?>
                <div class="icon">
                    <?php \Elementor\Icons_Manager::render_icon($settings['selected_icon'], ['aria-hidden' => 'true']); ?>
                </div>
                <!-- if image -->
            <?php } else if ($settings['media_style'] == 'image') {
                echo '<img src="' . $settings['image']['url'] . '">';
            } ?>
            <div>
                <?php if (!empty($settings['section_title'])) { ?>
                    <h5 class="icon-box-title powerhour-heading-title"><?php echo $settings['section_title']; ?></h5><?php } ?>
            </div>

        </div>
        <div class="icon-box-content">
            <?php
            if (!empty($settings['description'])) { ?>
                <div class="icon-box-desc"><?php echo $settings['description']; ?></div><?php } ?>
        </div>
    </div>
<?php
    }
