<?php

namespace Iqonic\Elementor\Elements\IconBox;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin;
use Elementor\Utils;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;


if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic_iconBox', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Icon Box', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-icon-box';
    }
    protected function register_controls()
    {
        $this->start_controls_section(
            'section_3hF35YJWo8kiTD',
            [
                'label' => esc_html__('IconBox Style', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'design_style',
            [
                'label'      => esc_html__('Select Style', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'style1',
                'options'    => [
                    'style1' => esc_html__('Style 1', 'iqonic-extension'),
                    'style2' => esc_html__('Style 2', 'iqonic-extension'),
                    'style3' => esc_html__('Style 3', 'iqonic-extension'),
                    'style4' => esc_html__('Style 4', 'iqonic-extension'),
                    'style5' => esc_html__('Style 5', 'iqonic-extension')
                ],
            ]
        );
        $this->end_controls_section();
        $this->start_controls_section(
            'section',
            [
                'label' => esc_html__('Icon Box', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'section_title',
            [
                'label'       => esc_html__('Title', 'iqonic-extension'),
                'type'        => Controls_Manager::TEXT,
                'dynamic'     => [
                    'active'  => true,
                ],
                'label_block' => true,
                'default'     => esc_html__('Add Your Title Text Here', 'iqonic-extension'),
                'condition'   => ['design_style' => ['style1','style3','style4','style5']]
            ]
        );
        $this->add_control(
            'word_position',
            [
                'label'         => __('Word Position', 'iqonic-extension'),
                'description'   => __('Enter position of the word to heighlight.', 'iqonic-extension'),
                'type'          => Controls_Manager::NUMBER,
                'min'           => 0,
                'max'           => 30,
                'step'          => 1,
                'default'       => 0,
                'condition'     => ['design_style' => 'style4']
            ]
        );
       
        $this->add_control(
            'description',
            [
                'label'       => esc_html__('Description', 'iqonic-extension'),
                'type'        => Controls_Manager::WYSIWYG,
                'dynamic'     => [
                    'active'  => true,
                ],
                'placeholder' => esc_html__('Enter your Description', 'iqonic-extension'),
                'default'     => esc_html__('Lorem Ipsum is simply dummy text of the printing and typesetting industry.', 'iqonic-extension'),
                'condition'   => ['design_style' => ['style1','style2','style3','style5']]
            ]
        );
        $this->add_control(
            'digit',
            [
                'label'    => esc_html__('Digit','iqonics'),
                'type'     => Controls_Manager::TEXT,
                'default'  => esc_html__('00','iqonic-extension'),
                'condition'=> ['design_style' => 'style4']
            ]
        );

        $this->add_control(
            'media_style',
            [
                'label'      => esc_html__('Icon / Image', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'icon',
                'options'    => [
                    'icon'   => esc_html__('Icon', 'iqonic-extension'),
                    'image'  => esc_html__('Image', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'selected_icon',
            [
                'label'           => esc_html__('Icon', 'iqonic-extension'),
                'type'            => Controls_Manager::ICONS,
                'condition'       => [
                    'media_style' => 'icon',
                ],
                'default'         => [
                    'value'       => 'fas fa-star'
                ],
            ]
        );
        $this->add_control(
            'image',
            [
                'label'      => esc_html__('Choose Image', 'iqonic-extension'),
                'type'       => Controls_Manager::MEDIA,
                'dynamic'    => [
                    'active' => true,
                ],
                'condition'  => [
                    'media_style' => 'image',
                ],
                'default'    => [
                    'url'    => Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->end_controls_section();
        /*Icon Box STYLE start*/
        $this->start_controls_section(
            'section_NELc08X86U438J8ZmnxQ',
            [
                'label' => esc_html__('Icon Box', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('Iconbox_tabs');
        $this->start_controls_tab(
            'tabs_jefOdwB60gC8bAl3exvb',
            [
                'label' => esc_html__('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'powerhour_iconbox_background',
                'label'     => esc_html__('Background', 'iqonic-extension'),
                'types'     => ['classic', 'gradient'],
                'selector'  => '{{WRAPPER}} .powerhour-icon-box-style-1,{{WRAPPER}} .powerhour-icon-box-style-2,{{WRAPPER}} .powerhour-icon-box-style-3, {{WRAPPER}} .powerhour-icon-box-style-4,{{WRAPPER}} .powerhour-icon-box-style-5',
            ]
        );

        
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_YKc3bWU0OyR6287gk966',
            [
                'label' => esc_html__('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name'      => 'powerhour_iconbox_hover_background',
                'label'     => esc_html__('Hover Background', 'iqonic-extension'),
                'types'     => ['classic', 'gradient'],
                'selector'  => '{{WRAPPER}} .powerhour-icon-box-style-1:hover,{{WRAPPER}} .powerhour-icon-box-style-2:hover,{{WRAPPER}} .powerhour-icon-box-style-3:hover,{{WRAPPER}} .powerhour-icon-box-style-4:hover,{{WRAPPER}} .powerhour-icon-box-style-5:hover',
               
            ]
        );
        
        
        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /* Icon Box  End*/

        $this->start_controls_section(
            'section_285gUPrCuoL6e62Mhf7m',
            [
                'label'  => esc_html__('Icon Box Icon/Image', 'iqonic-extension'),
                'tab'    => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'icon_size',
            [
                'label'      => __('Icon Size','iqonic-extension'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
						'step' => 1,
					],
                ],
                'default' => [
					'unit' => 'px',
					'size' => 30,
				],
                'selectors'  => [
                    '{{WRAPPER}} .powerhour-icon-box-style-1 .icon-box .icon svg' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-icon-box-style-2 .icon-box .icon svg' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-icon-box-style-3 .icon-box .icon svg' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-icon-box-style-4 .icon-box .icon svg' => 'height: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-icon-box-style-5 .icon-box .icon svg' => 'height: {{SIZE}}{{UNIT}};',
				],
            ]
        );
        $this->add_control(
            'icon_bg-size',
            [
                'label'      => __('Icon background','iqonic-extension'),
                'type'       => Controls_Manager::SLIDER,
                'size_units' => [ 'px' ],
                'range' => [
					'px' => [
						'min' => 0,
						'max' => 150,
						'step' => 1,
					],
                ],  
                'default' => [
					'unit' => 'px',
					'size' => 90,
				],
                'selectors'  => [
                    '{{WRAPPER}} .powerhour-icon-box-style-1 .icon-box  ' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-icon-box-style-2 .icon-box  ' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-icon-box-style-3 .icon-box  ' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-icon-box-style-4 .icon-box  ' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .powerhour-icon-box-style-5 .icon-box ' => 'height: {{SIZE}}{{UNIT}};width: {{SIZE}}{{UNIT}};',
				],
            ]
        );
        $this->start_controls_tabs('Iconbox_icon_tabs');
        $this->start_controls_tab(
            'tabs_jeBef2kCfHObvih40638',
            [
                'label' => esc_html__('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label'     => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon-box .icon svg path' => 'fill: {{VALUE}}'
                ],
                'condition' => [
                    'media_style!' => 'image',
                ],
            ]
        );

        $this->add_control(
            'icon-bg-color',
            [
                'label'     => esc_html__('Background','iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon-box'=>'background:{{VALUE}}'
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_aJ0C3kdUL5G4tW12awyR',
            [
                'label' => esc_html__('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label'             => __('Choose color <br> <span style="color: #5bc0de"> (Note : working only for icon) </span>', 'iqonic-extension'),
                'type'              => Controls_Manager::COLOR,
                'selectors'         => [
                    '{{WRAPPER}} .icon-box:hover .icon svg path'   => 'fill: {{VALUE}}'
                ],
                'condition'         => [
                    'media_style!'  => 'image',
                ],
            ]
        );
        $this->add_control(
            'icon-bg-color-hover',
            [
                'label'     => esc_html__('Background','iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon-box:hover'=>'background:{{VALUE}}'
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /* Icon Box  icon*/

        /* Iconbox Title start*/

        $this->start_controls_section(
            'section_zq808BOa6ovm3lt2xN1E',
            [
                'label' => esc_html__('Iconbox Title', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [ 'design_style!' => 'style2']
            ]
        );
        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'  => 'highlighted_typography',
                'label' => __('Highlighted Text Typo', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-icon-box-style-4 .icon-box-content .icon-box-title .highlighted-text-wrap .highlighted-text',
                'condition' => [ 'design_style' => 'style4']
            ]
        );

        $this->add_control(
            'highlighted_text_color',
            [
                'label' => __('Highlighted Text','iqonic-extension'),
                'type'  => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-icon-box-style-4 .icon-box-content .icon-box-title .highlighted-text-wrap .highlighted-text'=> 'color : {{VALUE}}',
                    '{{WRAPPER}} .powerhour-icon-box-style-4 .icon-box-title span:before'=> 'background : {{VALUE}}',
                ],
                'condition' => [ 'design_style' => 'style4']
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'      => 'title_content_text_typography',
                'label'     => esc_html__('Title Typography', 'iqonic-extension'),
                'selector'  => '{{WRAPPER}} .powerhour-heading-title',
            ]
        );

        $this->start_controls_tabs('iconbox_title_tabs');
        $this->start_controls_tab(
            'tabs_es28o3dUL2GRtuqE5mb4',
            [
                'label' => esc_html__('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'iconbox_title_color',
            [
                'label'     => esc_html__('Title Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .icon-box-title' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-icon-box-style-1 .icon-box-title:before' => 'background: {{VALUE}};',
                ],
            ]
        );
       
        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_6alC26d6Boy9qM8e4Am3',
            [
                'label' => esc_html__('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'iconbox_title_hover_color',
            [
                'label' => __('Choose Color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-icon-box:hover .icon-box-title a, {{WRAPPER}} .powerhour-icon-box.active .icon-box-title a, {{WRAPPER}} .powerhour-icon-box-style-1:hover .powerhour-button ,{{WRAPPER}} .powerhour-icon-box-style-1:hover .powerhour-btn-link i,{{WRAPPER}} .powerhour-icon-box:hover .icon-box-content .powerhour-heading-title,{{WRAPPER}} .powerhour-icon-box.powerhour-icon-box-style-2:hover .box-descicon-box-title:hover' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .powerhour-icon-box:hover .icon-box-title:before' => 'background: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'iconbox_title2_hover_color',
            [
                'label'     => esc_html__('Title2 Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .span-text:hover' => 'color: {{VALUE}};',
                ],
                'condition' => ['has_span_title' => 'yes','design_style'=> ['style1','style5']]
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();
        /* Iconbox Title End*/

        /* Iconbox Content start*/

        $this->start_controls_section(
            'section_i4uH428mYTbPBbF6rDe1',
            [
                'label' => esc_html__('Iconbox Description', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
                'condition' => [ 'design_style!' => 'style3']
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name'     => 'desc_content_text_typography',
                'label'    => esc_html__('Title Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .powerhour-icon-box  .icon-box-desc, {{WRAPPER}} .powerhour-icon-box.powerhour-icon-box-style-2 .designation .icon-box-desc',
            ]
        );

        $this->start_controls_tabs('iconbox_desc_tabs');
        $this->start_controls_tab(
            'tabs_rT8Coe33K21a68H6Id63',
            [
                'label' => esc_html__('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'iconbox_desc_color',
            [
                'label'     => esc_html__('Choose Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-icon-box .icon-box-desc, {{WRAPPER}} .powerhour-icon-box.powerhour-icon-box-style-2 .designation .icon-box-desc:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_asSFfYDArb8dc9Rq0o36',
            [
                'label' => esc_html__('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'iconbox_desc_hover_color',
            [
                'label'     => esc_html__('Choose Color', 'iqonic-extension'),
                'type'      => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-icon-box:hover .icon-box-desc,{{WRAPPER}} .powerhour-icon-box.active .icon-box-desc, {{WRAPPER}} .powerhour-icon-box.powerhour-icon-box-style-2:hover .designation' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
        /* Iconbox Description End*/
    }

    protected function render()
    {
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/IconBox/render.php';
    }
}
