<?php

namespace Elementor;

use Elementor\Plugin;

if (!defined('ABSPATH')) exit;

$settings = $this->get_settings();
$tabs = $this->get_settings_for_display('tabs');
$col = 'powerhour-gallery-col-3';

$image_html = '';  ?>
<?php

if ($settings['gallary_style'] === "slider") { ?>
    <div class="powerhour-gallery powerhour-gallery-slider">
        <?php
        $desk = $settings['desk_number'];
        $lap = $settings['lap_number'];
        $tab = $settings['tab_number'];
        $mob = $settings['mob_number'];

        $this->add_render_attribute('slider', 'data-dots', $settings['dots']);
        $this->add_render_attribute('slider', 'data-nav', $settings['nav-arrow']);
        $this->add_render_attribute('slider', 'data-items', $settings['desk_number']);
        $this->add_render_attribute('slider', 'data-items-laptop', $settings['lap_number']);
        $this->add_render_attribute('slider', 'data-items-tab', $settings['tab_number']);
        $this->add_render_attribute('slider', 'data-items-mobile', $settings['mob_number']);
        $this->add_render_attribute('slider', 'data-items-mobile-sm', $settings['mob_number']);
        $this->add_render_attribute('slider', 'data-autoplay', $settings['autoplay']);
        $this->add_render_attribute('slider', 'data-loop', $settings['loop']);
        $this->add_render_attribute('slider', 'data-margin', $settings['margin']['size']);
        ?>

        <div class="owl-carousel " <?php echo $this->get_render_attribute_string('slider') ?>>
            <?php
            foreach ($tabs as $index => $item) {
                if (!empty($item['image']['url'])) {
                    $this->add_render_attribute('image', 'src', $item['image']['url']);
                    $this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($item['image']));
                    $this->add_render_attribute('image', 'title', Control_Media::get_image_title($item['image']));
                    $image_html = Group_Control_Image_Size::get_attachment_image_html($item, 'thumbnail', 'image');
                }
            ?>
                <div class="g-item">
                    <a class="gallery-link" href="<?php echo esc_url($item['image']['url']); ?>" data-fancybox="gallery">
                        <div class="powerhour-gallery-img">
                            <?php echo $image_html; ?>
                        </div>
                    </a>
                </div>
            <?php
            }
            ?>
        </div>
    </div>
<?php
} else if ($settings['gallary_style'] === "masonary") { ?>
    <div class="powerhour-gallery-masonary">
        <div class="grid-sizer" style="width:25%;display:block;"></div>
        <?php
        foreach ($tabs as $index => $item) {
            if (!empty($item['image']['url'])) {
                $this->add_render_attribute('image', 'src', $item['image']['url']);
                $this->add_render_attribute('image', 'alt', Control_Media::get_image_alt($item['image']));
                $this->add_render_attribute('image', 'title', Control_Media::get_image_title($item['image']));
                $image_html = Group_Control_Image_Size::get_attachment_image_html($item, 'thumbnail', 'image');
            }
        ?>
            <div class="powerhour-gallery-info grid-item">
                <a href="<?php echo $item['image']['url']; ?>"><?php echo $image_html; ?></a>
            </div>
        <?php
        }
        ?>
    </div>
<?php
}
