<?php

namespace Iqonic\Elementor\Elements\Gallery;

use Elementor\Group_Control_Background;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Plugin;
use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;

class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic_Gallery', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Gallery', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-extension'];
    }

    public function get_icon()
    {
        return 'eicon-posts-carousel';
    }

    protected function register_controls()
    {
        $this->start_controls_section(
            'section_client',
            [
                'label' => __('Gallery Post', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'gallary_style',
            [
                'label'      => __('Gallery Style', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'slider',
                'options'    => [
                    'slider' => __('Gallery Slider', 'iqonic-extension'),
                    'masonary' => __('Gallery Masonary', 'iqonic-extension'),
                ],
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'image',
            [
                'label' => __('Choose Image', 'iqonic-extension'),
                'type' => Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
            ]
        );
        $this->add_control(
            'tabs',
            [
                'label'  => __('List Items', 'iqonic-extension'),
                'type'   => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->end_controls_section();

        /* Gallery Box Start*/

        $this->start_controls_section(
            'section_jpdZo4adyfPfER8bqVQF',
            [
                'label' => __('Gallery Box', 'iqonic-extension'),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs('powerhour_client_box_tabs');
        $this->start_controls_tab(
            'tabs_Ad2RWVvjUsS088PCabdf',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'powerhour_client_box_background',
                'label' => __('Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-gallery-masonary',
            ]
        );

        $this->add_control(
            'powerhour_client_box_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'powerhour_client_box_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'condition' => [
                    'powerhour_client_box_has_border' => 'yes',
                ],
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-gallery-masonary' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'powerhour_client_box_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-gallery-masonary' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'powerhour_client_box_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-gallery-masonary' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'powerhour_client_box_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-gallery-masonary' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->start_controls_tab(
            'tabs_m3r8Z6h2ja8xSFVid4z8',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'powerhour_client_box_hover_background',
                'label' => __('Hover Background', 'iqonic-extension'),
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .powerhour-gallery-masonary:hover,{{WRAPPER}} .powerhour-gallery-masonary.active',
            ]
        );

        $this->add_control(
            'powerhour_client_box_hover_has_border',
            [
                'label' => __('Set Custom Border?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
            ]
        );
        $this->add_control(
            'powerhour_client_box_hover_border_style',
            [
                'label' => __('Border Style', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::SELECT,
                'default' => 'none',
                'options' => [
                    'solid'  => __('Solid', 'iqonic-extension'),
                    'dashed' => __('Dashed', 'iqonic-extension'),
                    'dotted' => __('Dotted', 'iqonic-extension'),
                    'double' => __('Double', 'iqonic-extension'),
                    'outset' => __('outset', 'iqonic-extension'),
                    'groove' => __('groove', 'iqonic-extension'),
                    'ridge' => __('ridge', 'iqonic-extension'),
                    'inset' => __('inset', 'iqonic-extension'),
                    'hidden' => __('hidden', 'iqonic-extension'),
                    'none' => __('none', 'iqonic-extension'),

                ],

                'selectors' => [
                    '{{WRAPPER}} .powerhour-gallery-masonary:hover,{{WRAPPER}} .powerhour-gallery-masonary.active' => 'border-style: {{VALUE}};',

                ],
            ]
        );

        $this->add_control(
            'powerhour_client_box_hover_border_color',
            [
                'label' => __('Border Color', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .powerhour-gallery-masonary:hover,{{WRAPPER}} .powerhour-gallery-masonary.active' => 'border-color: {{VALUE}};',
                ],


            ]
        );

        $this->add_control(
            'powerhour_client_box_hover_border_width',
            [
                'label' => __('Border Width', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-gallery-masonary:hover,{{WRAPPER}} .powerhour-gallery-masonary.active' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_control(
            'powerhour_client_box_hover_border_radius',
            [
                'label' => __('Border Radius', 'iqonic-extension'),
                'condition' => [
                    'powerhour_client_box_hover_has_border' => 'yes',
                ],
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .powerhour-gallery-masonary:hover,{{WRAPPER}} .powerhour-gallery-masonary.active' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();



        $this->add_responsive_control(
            'powerhour_client_box_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-gallery-masonary' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'powerhour_client_box_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .powerhour-gallery-masonary' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /* Gallery Box End*/
        $this->start_controls_section(
            'owl_control_section',
            [
                'label' => __('Slider Control', 'iqonic-extension'),
                'condition' => ['gallary_style'=> 'slider']
            ]
        );

        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Controls/owl-control.php';

        $this->end_controls_section();

       
    }

    protected function render()
    {
        $settings = $this->get_settings();
        require IQONIC_EXTENSION_PLUGIN_PATH . 'includes/Elementor/Elements/Gallery/render.php';
    }
}
