<?php

namespace Iqonic\Elementor\Elements\FooterNavigation;

use PowerHour\Utility;
use Elementor\Group_Control_Background;
use Elementor\Group_Control_Typography;
use Elementor\Controls_Manager;
use Elementor\Widget_Base;

if (!defined('ABSPATH')) exit;


class Widget extends Widget_Base
{
    public function get_name()
    {
        return __('iqonic_footer_navigation', 'iqonic-extension');
    }

    public function get_title()
    {
        return __('Iqonic Footer Navigation Menu', 'iqonic-extension');
    }
    public function get_categories()
    {
        return ['iqonic-layouts-extension'];
    }

    public function get_icon()
    {
        return 'eicon-nav-menu';
    }
    protected function register_controls()
    {

        $this->start_controls_section(
            'section_header',
            [
                'label' => __('Navigation', 'iqonic-extension'),

            ]
        );

        $this->add_control(
            'ft_nav_style',
            [
                'label'      => __('Style', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'ft-nav-style-one',
                'options'    => [
                    'ft-nav-style-one'      => __('Style 1', 'iqonic-extension'),
                    'ft-nav-style-two'      => __('Style 2', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'direction',
            [
                'label'      => __('Direction', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => 'vertical',
                'options'    => [
                    'horizontal'    => __('Horizontal', 'iqonic-extension'),
                    'vertical'      => __('Vertical', 'iqonic-extension'),
                ],
            ]
        );

        $this->add_control(
            'column_gap',
            [
                'label'      => __('Column Gap', 'iqonic-extension'),
                'type'       => Controls_Manager::SELECT,
                'default'    => '1',
                'options'    => [
                    '1'    => __('1', 'iqonic-extension'),
                    '2'      => __('2', 'iqonic-extension'),
                    '3'      => __('3', 'iqonic-extension'),
                ],
                'condition' => ['direction' => 'vertical'],
                'prefix_class' => 'iqonic-footer-gap-',
            ]
        );


        $this->add_control(
            'menu',
            [
                'label'     => __('Menu', 'iqonic-extension'),
                'type'      => Controls_Manager::SELECT,
                'default'   => 'select',
                'options'   => layout_get_nav_menus(),
            ]
        );

        $this->add_control(
            'has_icon',
            [
                'label' => __('Use Icon?', 'iqonic-extension'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'no',
                'yes' => __('yes', 'iqonic-extension'),
                'no' => __('no', 'iqonic-extension'),
                'prefix_class' => 'iqonic-footer-menu-icon-',
            ]
        );

        $this->add_responsive_control(
            'align',
            [
                'label' => __('Alignment', 'iqonic-extension'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'start'    => [
                        'title' => __('Left', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => __('Center', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'end' => [
                        'title' => __('Right', 'iqonic-extension'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .widget-nav-menu ul.layout-footer-widget' => 'text-align: {{VALUE}}',
                ],
            ]
        );

        $this->end_controls_section();

        /* menu list End*/

        //Menu Color
        $this->start_controls_section(
            'section_footrmenu_style',
            [
                'label' => __('Menu', 'iqonic-extension'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'footer_menu_typography',
                'label' => __('Typography', 'iqonic-extension'),
                'selector' => '{{WRAPPER}} .footer-menu  li  a',
            ]
        );

        $this->start_controls_tabs('menu_tabs');
        $this->start_controls_tab(
            'tabs_menujeBef122kCfHOb40638',
            [
                'label' => __('Normal', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'text_color',
            [
                'label' => __('Choose color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-menu  li  a'  => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->add_control(
            'icon_color',
            [
                'label' => __('Icon color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .iqonic-footer-menu-icon .footer-menu > li::before'  => 'color: {{VALUE}};'
                ],
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'tabs_menuaJ0C3kdUtggtL5G4tW12awyR',
            [
                'label' => __('Hover', 'iqonic-extension'),
            ]
        );

        $this->add_control(
            'text_hover_color',
            [
                'label' => __('Choose color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .footer-menu  li:hover  a' => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->add_control(
            'icon_hover_color',
            [
                'label' => __('Icon color', 'iqonic-extension'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .iqonic-footer-menu-icon .footer-menu > li:hover::before'  => 'color: {{VALUE}};'
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();


        $this->add_responsive_control(
            'menu_parent_padding',
            [
                'label' => __('Padding', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .footer-menu  li  a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->add_responsive_control(
            'menu_parent_margin',
            [
                'label' => __('Margin', 'iqonic-extension'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}}  .footer-menu  li  a' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $settings = $this->get_settings();
        require 'render.php';
    }
}
